class WidgetIuClass extends elementorModules.frontend.handlers.Base {
  getDefaultSettings() {
    return {
      selectors: {
        content: '.iu-testimonials-all-container',
      },
    };
  }

  getDefaultElements() {
    const selectors = this.getSettings('selectors');
    return {
      $content: this.$element.find(selectors.content),
    };
  }

  bindEvents() {
    this.elements.$content.on('click', this.initMasonry.bind(this));
  }

  onInit() {
    this.initMasonry();
  }

  onElementChange(propertyName) {
    this.initMasonry();
  }

  initMasonry() {
    if (document.querySelector('.iu-testimonial-masonry')) {
      const testimonialMsnry = new Masonry('.iu-testimonial-masonry', {
        itemSelector: '.iu-testimonial-masonry-item',
        columnWidth: '.iu-testimonial-masonry-sizer',
        gutter: '.iu-testimonial-masonry-sizer-gutter',
        percentPosition: true,
      });
    }
  }

}

jQuery(window).on('elementor/frontend/init', () => {
  const addHandler = ($element) => {
    elementorFrontend.elementsHandler.addHandler(WidgetIuClass, {
      $element,
    });
  };

  elementorFrontend.hooks.addAction('frontend/element_ready/iu_testimonials.default', addHandler);
});