<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function register_elementor_widgets( $widgets_manager ) {
	require_once( INSTANTUP_PATH . 'src/elementor/widgets/testimonials.php' );
	require_once( INSTANTUP_PATH . 'src/elementor/widgets/project-map.php' );

	$widgets_manager->register( new \Elementor_Testimonials_Widget() );
	$widgets_manager->register( new \Elementor_Project_Map() );

}
add_action( 'elementor/widgets/register', 'register_elementor_widgets' );


if ( ! function_exists( 'add_post_thumbs_in_post_list_table' ) && get_option( '_iu_custom_type_slug' ) ) {
	function add_post_thumbs_in_post_list_table() {
		$supports    = get_theme_support( 'post-thumbnails' );
		$ptype_names = get_option( '_iu_custom_type_slug' );

		if ( ! isset( $ptype_names ) ) {
			if ( $supports === true ) {
				$ptype_names = get_post_types( array( 'public' => true ), 'names' );
				$ptype_names = array_diff( $ptype_names, array( 'attachment' ) );
			} elseif ( is_array( $supports ) ) {
				$ptype_names = $supports[0];
			}
		}

		foreach ( $ptype_names as $ptype ) {
			add_filter( "manage_{$ptype}_posts_columns", 'add_thumb_column' );
			add_action( "manage_{$ptype}_posts_custom_column", 'add_thumb_value', 10, 2 );
		}
	}

	add_action( 'init', 'add_post_thumbs_in_post_list_table', 20 );

	// add column
	function add_thumb_column( $columns ) {
		add_action( 'admin_notices', function () {
			echo '<style>.column-thumbnail{ width:80px; text-align:center; }</style>';
		} );

		$num         = 1;
		$new_columns = array( 'thumbnail' => __( 'Thumbnail' ) );

		return array_slice( $columns, 0, $num ) + $new_columns + array_slice( $columns, $num );
	}

	// fill in the column
	function add_thumb_value( $colname, $post_id ) {
		if ( 'thumbnail' === $colname ) {
			$width = $height = 45;


			if ( $thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true ) ) {
				$thumb = wp_get_attachment_image( $thumbnail_id, array( $width, $height ), true );
			} elseif (
			$attachments = get_children( array(
				'post_parent'    => $post_id,
				'post_mime_type' => 'image',
				'post_type'      => 'attachment',
				'numberposts'    => 1,
				'order'          => 'DESC',
			) ) ) {
				$attach = array_shift( $attachments );
				$thumb  = wp_get_attachment_image( $attach->ID, array( $width, $height ), true );
			}
			echo empty( $thumb ) ? ' ' : $thumb;
		}
	}
}