<?php
$realestate_title = 'title post';
$realestate_price = '';
$realestate_beds  = '';
$realestate_baths = '';
$realestate_sqft  = '';
$full_width       = '';
$href             = $parent_post_id ? 'href="' . get_permalink() . '"' : '';
$latitude         = get_post_meta( $post->ID, $this->prefix() . 'latitude', true );
$longitude        = get_post_meta( $post->ID, $this->prefix() . 'longitude', true );
$settings_columns = $fields['iu_settings_columns'];

if ( wp_doing_ajax() ) {
	$settings_columns = get_post_meta( $parent_post_id, 'iu_settings_columns', true );
}

if ( $settings_columns === '1' ) {
	$column = 12;
} elseif ( $settings_columns === '2' ) {
	$column = 6;
} elseif ( $settings_columns === '3' ) {
	$column = 4;
} elseif ( $settings_columns === '4' ) {
	$column = 3;
} else {
	$column = 6;
}

if ( ! get_option( '_pap_google_maps_api_key' ) && get_option( '_iu_disable_maps' ) === 'yes' && ! $this->is_admin() ) {
	$column = 3;
}

?>
<div class="profolio-col-xs-12 profolio-col-md-<?php echo $column; ?> JS_profolio_project_item"
     data-latlong="<?php echo esc_attr( $latitude . ',' . $longitude ); ?>"
     data-post-id="<?php the_ID(); ?>">
	<?php
	if ( ! $imf_src = get_the_post_thumbnail_url( '', 'medium' ) ) {
		$imf_src = INSTANTUP_URL . 'data/assets/img/placeholder-cover.png';
	}

	if ( $fields['iu_set_price'] ) {
		$realestate_price = get_post_meta( $post->ID, $fields['iu_set_price'], true );
	}

	if ( $fields['iu_set_beds'] ) {
		$realestate_beds = get_post_meta( $post->ID, $fields['iu_set_beds'], true );
	}

	if ( $fields['iu_set_baths'] ) {
		$realestate_baths = get_post_meta( $post->ID, $fields['iu_set_baths'], true );
	}

	if ( $fields['iu_set_sqft'] ) {
		$realestate_sqft = get_post_meta( $post->ID, $fields['iu_set_sqft'], true );
	}


	if ( $fields['iu_set_item_title'] ) {
		if ( $fields['iu_set_item_title'] === 'title' ) {
			$realestate_title = get_the_title();
		} else {
			$realestate_title = get_post_meta( $post->ID, $fields['iu_set_item_title'], true );
		}
	}

	if ( wp_doing_ajax() ) {
		$iu_set_item_title = get_post_meta( $parent_post_id, 'iu_set_item_title', true );
		if ( $iu_set_item_title === 'title' ) {
			$realestate_title = get_the_title();
		} else {
			$realestate_title = get_post_meta( $post->ID, $iu_set_item_title, true );
		}

		if ( $iu_set_price = get_post_meta( $parent_post_id, 'iu_set_price', true ) ) {
			$realestate_price = get_post_meta( $post->ID, $iu_set_price, true );
		}

		if ( $iu_set_beds = get_post_meta( $parent_post_id, 'iu_set_beds', true ) ) {
			$realestate_beds = get_post_meta( $post->ID, $iu_set_beds, true );
		}

		if ( $iu_set_baths = get_post_meta( $parent_post_id, 'iu_set_baths', true ) ) {

			$realestate_baths = get_post_meta( $post->ID, $iu_set_baths, true );
		}

		if ( $iu_set_sqft = get_post_meta( $parent_post_id, 'iu_set_sqft', true ) ) {
			$realestate_sqft = get_post_meta( $post->ID, $iu_set_sqft, true );
		}
	}

	if ( ! $realestate_beds && ! $realestate_baths && ! $realestate_sqft ) {
		$full_width = 'style="width: 100%; flex-basis: 100%;"';
	}


	?>
    <a <?php echo $href; ?>
        class="iu_realestate-item"
        tabindex="<?php echo $kye; ?>"
        style="background-image: url('<?php echo $imf_src; ?>')">

		<?php
		$status = ucfirst( get_post_meta( $post->ID, 'iu-saleType', true ) ) ? : '';
		$status .= empty( $status ) ? '' : ' / ';
		$status .= ucfirst( get_post_meta( $post->ID, 'iu-listingStatus', true ) ) ? : '';

		echo $status ? "<div class=\"iu_realestate-item-status\">{$status}</div>" : '';
		?>

        <div class="iu_realestate-listing">

            <div class="iu_realestate-left-wrapper" <?php echo $full_width; ?>>
                <div class="iu_realestate-price">
					<?php if ( $realestate_price ) {
						echo '$' . number_format( $realestate_price, 0, ' ', ',' );
					} ?>
                </div>
                <div class="iu_realestate-title"><?php echo $realestate_title; ?></div>
            </div>

			<?php if ( $realestate_beds || $realestate_baths || $realestate_sqft ): ?>
                <div class="iu_realestate-sub-stats">

					<?php if ( $realestate_beds ): ?>
                        <div class="iu_realestate-sub-stat iu_realestate-sub-stats-beds">
							<?php echo $realestate_beds; ?>
                            <div class="iu_realestate-sub-stats-field">Beds</div>
                        </div>
					<?php endif; ?>

					<?php if ( $realestate_baths ): ?>
                        <div class="iu_realestate-sub-stat iu_realestate-sub-stats-baths">
							<?php echo $realestate_baths; ?>
                            <div class="iu_realestate-sub-stats-field">Baths</div>
                        </div>
					<?php endif; ?>

					<?php if ( $realestate_sqft ): ?>
                        <div class="iu_realestate-sub-stat iu_realestate-sub-stats-sqft">
							<?php echo $realestate_sqft ?>
                            <div class="iu_realestate-sub-stats-field">Sq. Ft.</div>
                        </div>
					<?php endif; ?>
                </div>
			<?php endif; ?>

        </div>
    </a>
</div>