<?php
/**
 * iu-testimonials.php
 * create in 08.09.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

Block::make( __( 'IU All Testimonial' ) )
     ->add_tab( __( 'Filters' ), array(
	     Field::make( 'select', 'has_video', __( 'Has Video' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          'either' => __( 'Either' ),
	          ) )
	          ->add_options( array(
		          'yes' => __( 'Yes' ),
		          'no'  => __( 'No' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'select', 'has_description', __( 'Has Description' ) )
	          ->set_options( array(
		          'either' => __( 'Either' ),
	          ) )
	          ->add_options( array(
		          'yes' => __( 'Yes' ),
		          'no'  => __( 'No' ),
	          ) )
	          ->set_width( 45 ),


	     Field::make( 'select', 'has_customer_name', __( 'Has Customer Name' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          'either' => __( 'Either' ),
	          ) )
	          ->add_options( array(
		          'yes' => __( 'Yes' ),
		          'no'  => __( 'No' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'select', 'has_customer_photo', __( 'Has Customer Photo' ) )
	          ->set_options( array(
		          'either' => __( 'Either' ),
	          ) )
	          ->add_options( array(
		          'yes' => __( 'Yes' ),
		          'no'  => __( 'No' ),
	          ) )
	          ->set_width( 45 ),


	     Field::make( 'select', 'rating_filter', __( 'Show Only:' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          '' => '',
	          ) )
	          ->add_options( array(
		          1 => __( '1 stars and up' ),
		          2 => __( '2 stars and up' ),
		          3 => __( '3 stars and up' ),
		          4 => __( '4 stars and up' ),
		          5 => __( '5 stars' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'select', 'sort_by', __( 'Sort By:' ) )
	          ->set_default_value( 'featured' )
	          ->add_options( array(
		          'featured' => __( 'Content Featured' ),
		          'date'     => __( 'Date desc' ),
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'More' ), array(
	     Field::make( 'select', 'use_template', __( 'Use Template:' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->add_options( array(
		          'masonry' => __( 'Masonry' ),
		          'default' => __( 'Dafault' ),
	          ) )
	          ->set_default_value( 'masonry' ),
	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() )
	          ->set_width( 45 ),

	     Field::make( 'text', 'posts_per_page', __( 'Posts Per Page:' ) )
	          ->set_attribute( 'placeholder', 'default 12' ),

	     Field::make( 'checkbox', 'disable_pagination', __( 'Disable Pagination' ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),
     ) )
     ->add_tab( __( 'Customer name' ), array(
	     Field::make( 'checkbox', 'show_customer_name', 'show' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'customer_name_color', __( 'color (no video block)' ) ),

	     Field::make( 'color', 'customer_name_color_video', __( 'color (video block)' ) ),

	     Field::make( 'text', 'customer_name_font_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),
     ) )
     ->add_tab( __( 'Customer title' ), array(
	     Field::make( 'checkbox', 'show_customer_title', 'show' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'customer_title_color', __( 'color (no video block)' ) ),

	     Field::make( 'color', 'customer_title_color_video', __( 'color (video block)' ) ),

	     Field::make( 'text', 'customer_title_font_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),
     ) )
     ->add_tab( __( 'Customer photo' ), array(
	     Field::make( 'checkbox', 'show_customer_photo', 'show' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'text', 'radius_customer_photo', __( 'Border Radius' ) )
	          ->set_attributes( array(
		          'placeholder' => 'default 50px',
		          'type'        => 'number',
		          'min'         => 0,
		          'max'         => 50,
	          ) ),
     ) )
     ->add_tab( __( 'Rating' ), array(
	     Field::make( 'checkbox', 'show_rating', 'show' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'color_rating', __( 'Color Rating' ) )
	          ->set_default_value( '#ff8c00' ),
     ) )
     ->add_tab( __( 'Date' ), array(
	     Field::make( 'checkbox', 'show_date', 'show' )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'date_color', __( 'color' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) ),
     ) )
     ->add_tab( __( 'Title' ), array(
	     Field::make( 'checkbox', 'show_title', 'show' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'title_color', __( 'color (no video block)' ) ),

	     Field::make( 'color', 'title_color_video', __( 'color (video block)' ) ),

	     Field::make( 'color', 'title_background', __( 'background' ) ),

	     Field::make( 'text', 'font_size_title', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_title', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Description' ), array(
	     Field::make( 'checkbox', 'show_description', 'show' )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'description_color', __( 'color (no video block)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) ),

	     Field::make( 'text', 'description_size', __( 'Font Size (px)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) ),

     ) )
     ->add_tab( __( 'Cover photo' ), array(
	     Field::make( 'checkbox', 'show_cover', 'show' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'select', 'cover_size', __( 'size image' ) )
	          ->set_default_value( 'medium' )
	          ->add_options( array(
		          'full'      => esc_html__( 'Full', 'instantup' ),
		          'large'     => esc_html__( 'Large', 'instantup' ),
		          'medium'    => esc_html__( 'Medium', 'instantup' ),
		          'thumbnail' => esc_html__( 'Thumbnail', 'instantup' ),
	          ) ),

	     Field::make( 'text', 'cover_height_video', __( 'height (for video)' ) )
	          ->set_attribute( 'placeholder', 'Default auto' ),

	     Field::make( 'text', 'cover_height_novideo', __( 'height (for no video)' ) )
	          ->set_attribute( 'placeholder', 'Default auto' ),

     ) )
     ->add_tab( __( 'Read more' ), array(
	     Field::make( 'checkbox', 'show_readmore', 'show' )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'readmore_color', __( 'color (for no video block)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( '#444' ),

	     Field::make( 'color', 'readmore_color_video', __( 'color (for video block)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( '#fff' ),

	     Field::make( 'text', 'readmore_size', __( 'Font Size (px)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),

	     Field::make( 'text', 'readmore_txt', __( 'Insert your text:' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_attribute( 'placeholder', 'read more »' ),

     ) )
     ->add_tab( __( 'Play button' ), array(
	     Field::make( 'checkbox', 'show_play_btn', 'show' )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'play_color', __( 'color' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( '#FFB902' ),

	     Field::make( 'color', 'play_hover_color', __( 'hover color' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_template',
			          'value'   => 'masonry',
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( '#32cd32' ),

     ) )
     ->add_tab( __( 'General' ), array(
	     Field::make( 'text', 'space_between_def', __( 'Space Between' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_template',
			          'value' => 'default',
		          ),
	          ) )
	          ->set_default_value( 15 )
	          ->set_attributes( array(
		          'type' => 'number',
		          'min'  => 1,
		          'max'  => 50,
		          'step' => 1,
	          ) ),

	     Field::make( 'text', 'space_between_man', __( 'Space Between' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_template',
			          'value' => 'masonry',
		          ),
	          ) )
	          ->set_default_value( 15 )
	          ->set_attributes( array(
		          'type' => 'number',
		          'min'  => 0,
		          'max'  => 35,
		          'step' => '0.5',
	          ) ),

	     Field::make( 'color', 'bg_color', __( 'Background Color (no video block)' ) ),
	     Field::make( 'color', 'bg_color_video', __( 'Background Color (video block)' ) ),
	     Field::make( 'color', 'bd_color', __( 'Border Color' ) ),

	     Field::make( 'text', 'border_size', __( 'Border Size' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type' => 'number',
		          'min'  => 0,
		          'max'  => 100,
	          ) ),

	     Field::make( 'text', 'border_radius', __( 'Border Radius' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_default_value( '7' )
	          ->set_attributes( array(
		          'type' => 'number',
		          'min'  => '0',
	          ) ),

     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     if ( $fields['select_fonts'] ) {
		     $get_font = explode( ':', $fields['select_fonts'] );
	     }

	     $template        = $fields['use_template'] ?? 'masonry';
	     $post_type       = get_option( '_iu_custom_type_slug' );
	     $testimonial_key = array_flip( $post_type )['iu_testimonial'];
	     unset( $post_type[ $testimonial_key ] );

	     $query_arr  = array(
		     'post_type'      => $post_type,
		     'posts_per_page' => (int) ( $fields['posts_per_page'] ?? 12 ),
		     'paged'          => get_query_var( 'paged' ) ? : 1,
		     'fields'         => 'ids',
	     );
	     $meta_query = array();

	     if ( $fields['rating_filter'] ) {
		     $meta_query[] = array(
			     'key'     => 'iu-testimonial_rating',
			     'value'   => (int) $fields['rating_filter'],
			     'compare' => '>=',
			     'type'    => 'NUMERIC',
		     );
	     } elseif ( ! $fields['rating_filter'] ) {
		     $meta_query[] = array(
			     'key' => 'iu-testimonial_rating',
		     );
	     }

	     if ( 'yes' === $fields['has_description'] ) {
		     $meta_query[] = array(
			     'key'     => 'iu-testimonial_des',
			     'value'   => '',
			     'compare' => '!=',
		     );
	     } elseif ( 'no' === $fields['has_description'] ) {
		     $meta_query[] = array(
			     'key'   => 'iu-testimonial_des',
			     'value' => '',
		     );
	     } elseif ( 'either' === $fields['has_description'] ) {
		     $meta_query[] = array(
			     'key' => 'iu-testimonial_des',
		     );
	     }

	     if ( 'yes' === $fields['has_customer_name'] ) {
		     $meta_query[] = array(
			     'key'     => 'iu-testimonial_customerName',
			     'value'   => '',
			     'compare' => '!=',
		     );
	     } elseif ( 'no' === $fields['has_customer_name'] ) {
		     $meta_query[] = array(
			     'key'   => 'iu-testimonial_customerName',
			     'value' => '',
		     );
	     } elseif ( 'either' === $fields['has_customer_name'] ) {
		     $meta_query[] = array(
			     'key' => 'iu-testimonial_customerName',
		     );
	     }

	     if ( 'featured' === $fields['sort_by'] ) {
		     $query_arr['orderby']                = 'meta_value';
		     $query_arr['meta_query']['relation'] = 'AND';
		     $query_arr['meta_query'][]           = array(
			     'relation' => 'OR',
			     array(
				     'key'     => 'iu-status_featured',
				     'compare' => 'NOT EXISTS',
			     ),
			     array(
				     'key'     => 'iu-status_featured',
				     'compare' => 'EXISTS',
			     ),
		     );

		     $meta_query['relation']    = 'AND';
		     $query_arr['meta_query'][] = $meta_query;

	     } else {
		     $query_arr['meta_query']['relation'] = 'AND';
		     $query_arr['meta_query']             += $meta_query;
	     }

	     if ( $fields['show_categories'] ) {
		     $query_arr['tax_query'][] = array(
			     'taxonomy' => 'iu_categories',
			     'terms'    => $fields['show_categories'],
		     );
	     }
	     if ( $fields['show_tags'] ) {
		     if ( $query_arr['tax_query'] ) {
			     $query_arr['tax_query']['relation'] = 'AND';
		     }

		     $query_arr['tax_query'][] = array(
			     'taxonomy' => 'iu_tags',
			     'terms'    => $fields['show_tags'],
		     );
	     }

	     $query_arr['meta_query'][] = array(
		     'relation' => 'OR',
		     array(
			     'key'     => 'iu-testimonial_media',
			     'compare' => 'NOT EXISTS',
		     ),
		     array(
			     'key'     => 'iu-testimonial_media',
			     'compare' => 'EXISTS',
		     ),
	     );

	     if ( 'yes' === $fields['has_video'] || 'no' === $fields['has_video'] ) {
		     $query_arr['posts_per_page'] = 200;
	     }

	     $query = new WP_Query( $query_arr );
	     ?>
         <style>
             .iu-testimonial-masonry-item.no-video .iu-testimonials-all-customer-name {
             <?php if ($fields['customer_name_color']):
                echo "color: {$fields['customer_name_color']};";
             endif;
             if ($fields['customer_name_font_size']):
                echo "font-size: {$fields['customer_name_font_size']}px;";
             endif; ?>
             }

             .iu-testimonial-masonry-item.video .iu-testimonials-all-customer-name {
             <?php if ($fields['customer_name_color_video']):
			    echo "color: {$fields['customer_name_color_video']};";
             endif; ?><?php if ($fields['customer_name_font_size']):
			    echo "font-size: {$fields['customer_name_font_size']}px;";
             endif; ?>
             }

             .iu-customer-name,
             .iu-testimonial-masonry-item.no-video .iu-testimonials-all-customer-title {
             <?php if ($fields['customer_title_color']):
			    echo "color: {$fields['customer_title_color']};";
             endif;
             if ($fields['customer_title_font_size']):
			    echo "font-size: {$fields['customer_title_font_size']}px;";
             endif; ?>
             }

             .iu-testimonial-masonry-item.video .iu-testimonials-all-customer-title {
             <?php if ($fields['customer_title_color_video']):
			    echo "color: {$fields['customer_title_color_video']};";
             endif;
             if ($fields['customer_title_font_size']):
			    echo "font-size: {$fields['customer_title_font_size']}px;";
             endif; ?>
             }

             .iu-testimonial-masonry-item .iu-testimonials-all-customer-img img {
             <?php if ((int)$fields['radius_customer_photo'] === 0 || $fields['radius_customer_photo']):
                echo "border-radius: {$fields['radius_customer_photo']}px;";
             endif;?>
             }

             .profolio-card-rating li {
             <?php if ($fields['color_rating']):
			    echo "color: {$fields['color_rating']} !important;";
             endif; ?>
             }

             .iu-testimonials-all-customer-date {
             <?php if ($fields['date_color']):
			    echo "color: {$fields['date_color']};";
             endif; ?>
             }

             .iu-testimonial-masonry-item.no-video .iu-testimonials-all-title {
             <?php if ($fields['title_color']):
			    echo "color: {$fields['title_color']};";
             endif;
             if ($fields['title_background']):
			    echo "background-color: {$fields['title_background']};";
             endif;
             if ($fields['font_size_title']):
			    echo "font-size: {$fields['font_size_title']}px;";
             endif;
             if ($fields['line_height_title']):
			    echo "line-height: {$fields['line_height_title']}px;";
             endif; ?>
             }

             .iu-testimonial-masonry-item.video .iu-testimonials-all-title {
             <?php if ($fields['title_color_video']):
			    echo "color: {$fields['title_color_video']};";
             endif; if ($fields['title_background']):
			    echo "background-color: {$fields['title_background']};";
             endif;
             if ($fields['font_size_title']):
			    echo "font-size: {$fields['font_size_title']}px;";
             endif;
             if ($fields['line_height_title']):
			    echo "line-height: {$fields['line_height_title']}px;";
             endif; ?>
             }

             .iu-testimonials-all-desc {
             <?php
             if ($fields['description_color']):
			    echo "color: {$fields['description_color']};";
             endif;
             if ($fields['description_size']):
			    echo "font-size: {$fields['description_size']}px;";
             endif;
             ?>
             }

             .iu-testimonial-masonry-item.no-video .iu-testimonials-all-more a {
             <?php if ($fields['readmore_color']):
             echo "color: {$fields['readmore_color']};";
             endif;?>
             }

             .iu-testimonial-masonry-item.video .iu-testimonials-all-more a {
             <?php if ($fields['readmore_color_video']):
                echo "color: {$fields['readmore_color_video']};";
             endif; ?>
             }

             .iu-testimonial-masonry-item.no-video {

             }

             .iu-testimonial-masonry-item.video .iu-testimonials-all-customer-wrap,
             .iu-testimonials-all-item.video {
             <?php if ($fields['bg_color_video']):
			    echo "background-color: {$fields['bg_color_video']};";
             endif; ?>
             }

             .iu-testimonial-masonry-item.no-video,
             .iu-testimonials-all-item.no-video {
             <?php if ($fields['bg_color']):
                echo "background-color: {$fields['bg_color']};";
             endif; ?>
             }

             .iu-testimonial-masonry-item,
             .iu-testimonials-all-item {
             <?php if ($fields['bd_color']):
                echo "border-color: {$fields['bd_color']};";
             endif;
             if ($fields['border_size']):
                echo "border-width: {$fields['border_size']}px;";
             endif;?>
             }

             .iu-testimonials-all-item,
             .iu-testimonial-masonry-item,
             .iu-testimonial-masonry-item.no-video .iu-testimonials-cover img {
             <?php if ($fields['border_radius']):
                echo "border-radius: {$fields['border_radius']}px;";
             endif;?>
             }
             .iu-testimonials-cover,
             .iu-testimonials-cover img {
             <?php if ($fields['border_radius']):
                echo "border-top-right-radius: {$fields['border_radius']}px";
                echo "border-top-left-radius: {$fields['border_radius']}px";
             endif;?>
             }
             .iu-testimonials-all-customer-wrap {
             <?php if ($fields['border_radius']):
                echo "border-bottom-right-radius: {$fields['border_radius']}px";
                echo "border-bottom-left-radius: {$fields['border_radius']}px";
             endif;?>
             }


             <?php if ( 'masonry' === $template ) :
                if ($fields['space_between_man']):
		            echo '.iu-testimonial-masonry-sizer-gutter {';
		            echo "width: {$fields['space_between_man']}px;";
		            echo '}';
		        endif;

                if ($fields['cover_height_video'] > 0):
		            echo '.iu-testimonial-masonry-item.video .iu-testimonials-cover {';
		            echo "height: {$fields['cover_height_video']}px;";
		            echo '}';
		        endif;

                if ($fields['cover_height_novideo'] > 0):
		            echo '.iu-testimonial-masonry-item.no-video .iu-testimonials-cover {';
		            echo "height: {$fields['cover_height_novideo']}px;";
		            echo '}';
		        endif;

                if ($fields['play_color']):
		            echo '.iu-testimonial-masonry-play svg {';
		            echo "stroke: {$fields['play_color']};";
		            echo '}';
		        endif;

                if ($fields['play_hover_color']):
		            echo '.iu-testimonials-cover:hover .iu-testimonial-masonry-play svg {';
		            echo "stroke: {$fields['play_hover_color']} !important;";
		            echo '}';
		        endif;
             endif;

              if ( 'default' === $template ) :
                if ( $fields['space_between_def'] === '0' || $fields['space_between_def'] ):
                    echo '.iu-testimonials-all-container [class*="profolio-col-"]{';
				    echo "padding-left: {$fields['space_between_def']}px !important;";
				    echo "padding-right: {$fields['space_between_def']}px !important;";
				    echo '}';
			    endif;
		     endif;

		     ?>
         </style>

         <div class="block">
             <div class="block__content profolio-container iu-testimonials-all-container">
			     <?php if ( $query->have_posts() ) : ?>
                     <div class="<?php echo 'masonry' === $template ? 'iu-testimonial-masonry' : 'profolio-row' ?> ">
					     <?php
					     $iteration = 0;
					     if ( 'masonry' === $template ) :
						     echo '<div class="iu-testimonial-masonry-sizer"></div><div class="iu-testimonial-masonry-sizer-gutter"></div>';
					     endif;

					     foreach ( $query->posts as $post_id ) :
						     $media             = get_post_meta( $post_id, 'iu-testimonial_media', true );
						     $video_id          = $media['video'] ?? '';
						     $cover_id          = $media['cover'] ?? '';
						     $customer_photo_id = $media['customerPhoto'] ?? '';

						     if ( 'yes' === $fields['has_video'] && ! $video_id ) {
							     continue;
						     }
						     if ( 'no' === $fields['has_video'] && $video_id ) {
							     continue;
						     }

						     if ( 'yes' === $fields['has_customer_photo'] && ! $customer_photo_id ) {
							     continue;
						     }
						     if ( 'no' === $fields['has_customer_photo'] && $customer_photo_id ) {
							     continue;
						     }

						     if ( (int) $fields['posts_per_page'] !== 0 && (int) $fields['posts_per_page'] === $iteration &&
						          ( $fields['has_video'] === 'yes' || $fields['has_video'] === 'no' ) ) {
							     break;
						     }

						     $title          = get_post_meta( $post_id, 'iu-testimonial_title', true );
						     $customer_name  = get_post_meta( $post_id, 'iu-testimonial_customerName', true );
						     $customer_title = get_post_meta( $post_id, 'iu-testimonial_customerTitle', true );
						     $rating         = get_post_meta( $post_id, 'iu-testimonial_rating', true );
						     $description    = get_post_meta( $post_id, 'iu-testimonial_des', true );
						     $customer_photo = $customer_photo_id ? wp_get_attachment_image_url( $media['customerPhoto'] ) : '';


						     include INSTANTUP_PATH . "data/template/blocks/testimonials/{$template}.php";
						     $iteration ++;
					     endforeach; ?>
                     </div>

				     <?php if ( ! $fields['disable_pagination'] ): ?>
                         <div class="profolio-row">
                             <div class="profolio-col-12 text-center profolio-pagination">
                                 <nav>
								     <?php echo paginate_links( array(
									     'total'     => $query->max_num_pages,
									     'current'   => max( 1, get_query_var( 'paged' ) ),
									     'show_all'  => false,
									     'type'      => 'list',
									     'end_size'  => 5,
									     'mid_size'  => 5,
									     'prev_next' => false,
								     ) ); ?>
                                 </nav>
                             </div>
                         </div>
				     <?php endif;
			     else :
				     echo '<p>Not found</p>';
			     endif;
			     wp_reset_query(); ?>
             </div>
         </div>
	     <?php
     } );