<?php
/**
 * iu-before-after.php
 * create in 23.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

Block::make( __( 'IU Before-After' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'color', 'before_after_circle', __( 'Background for Icon' ) ),
	     Field::make( 'color', 'before_after_line', __( 'Color for Line' ) )
	          ->set_alpha_enabled( true ),

	     Field::make( 'text', 'margin_top', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'btn_bdrs', __( 'Border radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 3',
	          ) ),

     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) { ?>
	     <style>
		     <?php
			 if (($fields['margin_top'] === '0' || (int)$fields['margin_top'] > 0) ||
			 ($fields['margin_bottom'] === '0' || (int)$fields['margin_bottom'] > 0) ||
			  ($fields['btn_bdrs'] === '0' || (int)$fields['btn_bdrs'] > 0)){
				 echo '.ba-slider {';

				 if ($fields['margin_top'] === '0' || (int)$fields['margin_top'] > 0){
					echo "margin-top: {$fields['margin_top']}px;";
				 }

				 if ($fields['margin_bottom'] === '0' || (int)$fields['margin_bottom'] > 0){
					echo "margin-bottom: {$fields['margin_bottom']}px;";
				 }

				 if ($fields['btn_bdrs'] === '0' || (int)$fields['btn_bdrs'] > 0){
					 echo "border-radius: {$fields['btn_bdrs']}px;";
				 }
				 echo '}';
			 }

			 if ($fields['before_after_line']){
				$rgba       = carbon_hex_to_rgba( $fields['before_after_line'] );
				$output_bgc = sprintf( 'rgba(%s, %s, %s, %s)', $rgba['red'], $rgba['green'], $rgba['blue'], $rgba['alpha']);
				echo '.ba-slider .handle {';
				echo "background-color: {$output_bgc};";
				echo '}';
			 }

			 if ($fields['before_after_circle']){
				 echo '.ba-slider .handle::after{';
				 echo "background-color: {$fields['before_after_circle']} !important;";
				 echo '}';
			 }
			 ?>
	     </style>

	     <div class="block">
		     <div class="block__content ba-slider-content">
			     <?php
			     $post_id      = get_the_ID() ? : get_option( '_temp_post_for_templates' );
			     $presentation = get_post_meta( $post_id, $this->prefix() . 'presentation', true );
			     $cover        = isset( $presentation['cover'] ) ? wp_get_attachment_image_url( (int) $presentation['cover'],
				     'large' ) : false;
			     $before_photo = isset( $presentation['before'] ) ? wp_get_attachment_image_url( (int) $presentation['before'],
				     'large' ) : false;
			     $after_photo  = isset( $presentation['after'] ) ? wp_get_attachment_image_url( (int) $presentation['after'],
				     'large' ) : false;

			     if ( $before_photo && $after_photo ): ?>
				     <div class="ba-slider">
					     <img src="<?php echo $after_photo; ?>">

					     <div class="resize">
						     <img src="<?php echo $before_photo; ?>">
						     <meta property="og:image" content="<?php echo $before_photo; ?>"/>
					     </div>
					     <span class="handle"></span>

					     <div class="ba-slider-name">
						     <div class="ba-slider-name-item ba-slider-name-before">
							     <?php _e( 'Before' ); ?>
						     </div>
						     <div class="ba-slider-name-item ba-slider-name-after">
							     <?php _e( 'After' ); ?>
						     </div>
					     </div>
				     </div>

			     <?php else:
				     $html = '';
				     if ( $cover ):
					     $html .= "<img class=\"iu-presentation-cover\" src=\"{$cover}\" alt=\"cover\">";
					     $html .= "<meta property=\"og:image\" content=\"{$cover}\"/>";

				     elseif ( has_post_thumbnail() ):
					     $html .= get_the_post_thumbnail( $post_id, array( 800, 600 ),
						     array( 'class' => 'iu-presentation-cover' ) );
					     $html .= '<meta property="og:image" content="' . get_the_post_thumbnail_url( $post_id,
							     'large' ) . '"/>';
				     else:

					     if ( $pic_for_post = get_post_meta( $post_id, $this->prefix() . 'pic_for_post', true ) ) {
						     $file_url = wp_get_attachment_url( $pic_for_post[0]['id'] );

						     if ( strpos( $file_url, '.mov' ) !== false || strpos( $file_url, '.mp4' ) !== false ) {
							     $thumb_video_id = (int) get_post_meta( $pic_for_post[0]['id'], 'iu-thumb', true );
							     $file_url       = wp_get_attachment_image_url( $thumb_video_id, 'full' );
						     }

						     if ( ! empty( $file_url ) ) {
							     $html .= "<img class=\"iu-presentation-cover \" src=\"{$file_url}\" alt=\"cover\">";
							     $html .= "<meta property=\"og:image\" content=\"{$file_url}\"/>";
						     }
					     }
				     endif; ?>

				     <?php if ( $html ): ?>
				     <div class="ba-slider">
					     <?php echo $html; ?>
					     <div class="profolio-img-hover">
						     <i class="pro_fa pro_fa-search-plus"></i>
					     </div>
				     </div>
			     <?php endif; ?>

			     <?php endif; ?>
		     </div>
	     </div>
	     <?php
     } );