<?php
/**
 * iu-content.php
 * create in 23.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Content' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'checkbox', 'iu_hide_full_txt', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Show not all text?' ) ),

	     Field::make( 'color', 'content_color', __( 'Color for Content' ) )
	          ->set_default_value( '#212529' ),
	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() ),

	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'select', 'block_width', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'select', 'position_txt', __( 'Position Text' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'left'   => 'Left',
		          'center' => 'center',
		          'right'  => 'right',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'line_height', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 39',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_top', __( 'Margin Top (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Info block' ), array(
	     Field::make( 'checkbox', 'iu_use_info', '' )
	          ->set_default_value( false )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Use info block?' ) ),

	     Field::make( 'color', 'bgc_info_block', __( 'Background Block' ) )
	          ->set_default_value( '#f6f7f9' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_info',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'color', 'color_info_block', __( 'Text Color' ) )
	          ->set_default_value( '#000' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_info',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'color', 'bd_info_color', __( 'Border Color' ) )
	          ->set_default_value( '#f6f7f9' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_info',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'bdrs_info', __( 'Border radius (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_info',
			          'value' => true,
		          ),
	          ) ),

     ) )
	 ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $get_font = array('Open Sans, Sans-serif');

	     if ( $fields['select_fonts'] ) {
		     $get_font = explode( ':', $fields['select_fonts'] );
	     }


	     $style_block = ' ';

	     $style_block .= ".block__content.iu-post-content, .block__content.iu-post-content p{";
	     $style_block .= "font-family: {$get_font[0]} !important;";
	     $style_block .= "font-size: 16px !important;";
	     $style_block .= '}';

	     $style_block .= ".block__content.iu-post-content h1{";
	     $style_block .= "font-family: {$get_font[0]} !important;";
	     $style_block .= "font-size: 40px !important;";
	     $style_block .= "margin-bottom: 0;";
	     $style_block .= '}';

	     $style_block .= ".block__content.iu-post-content h2{";
	     $style_block .= "font-family: {$get_font[0]} !important;";
	     $style_block .= "font-size: 26px !important;";
	     $style_block .= "margin-bottom: 0;";
	     $style_block .= '}';

	     $style_block .= ".block__content.iu-post-content h3{";
	     $style_block .= "font-family: {$get_font[0]} !important;";
	     $style_block .= "font-size: 22px !important;";
	     $style_block .= "margin-bottom: 0;";
	     $style_block .= '}';

	     $style_block .= ".block__content.iu-post-content h4{";
	     $style_block .= "font-family: {$get_font[0]} !important;";
	     $style_block .= "font-size: 18px !important;";
	     $style_block .= "margin-bottom: 0;";
	     $style_block .= '}';

	     $style_block .= ".block__content.iu-post-content h5{";
	     $style_block .= "font-family: {$get_font[0]} !important;";
	     $style_block .= "font-size: 17px !important;";
	     $style_block .= "margin-bottom: 0;";
	     $style_block .= '}';

	     $style_block .= ".block__content.block__content.iu-post-content p {";
	     $style_block .= "font-weight: normal;";
	     $style_block .= '}';

	     $style_block .= ".block__content.block__content.iu-post-content li {";
	     $style_block .= "font-weight: normal;";
	     $style_block .= '}';

	     if ( isset( $get_font ) || $fields['font_size'] || $fields['content_color'] ||
	          $fields['margin_top'] || $fields['margin_bottom'] || $fields['position_txt'] ) {

		     $style_block .= ".block__content.iu-post-content *{";
		     if ( $fields['content_color'] ) {
			     $style_block .= "color: {$fields['content_color']} !important;";
		     }
		     $style_block .= '}';

		     $style_block .= ".block__content.iu-post-content, .block__content.iu-post-content p{";

		     if ( isset( $get_font ) ) {
			     $style_block .= "font-family: '{$get_font[0]}' , sans-serif !important;";
		     }

		     if ( $fields['font_size'] ) {
			     $style_block .= "font-size: {$fields['font_size']}px !important;";
		     }

		     if ( $fields['position_txt'] ) {
			     $style_block .= "text-align: {$fields['position_txt']};";
		     }

		     if ( $fields['margin_top'] ) {
			     $style_block .= "margin-top: {$fields['margin_top']}px;";
		     }

		     if ( $fields['margin_bottom'] ) {
			     $style_block .= "margin-bottom: {$fields['margin_bottom']}px !important;";
		     }
		     $style_block .= '}';
	     }

	     if ( $fields['font_size'] ) {
		     $h1_size     = (int) $fields['font_size'] * 2.50;
		     $style_block .= ".block__content.iu-post-content h1 {";
		     $style_block .= "font-size: {$h1_size}px !important;";
		     $style_block .= '}';

		     $h2_size     = (int) $fields['font_size'] * 2.19;
		     $style_block .= ".block__content.iu-post-content h2 {";
		     $style_block .= "font-size: {$h2_size}px !important;";
		     $style_block .= '}';

		     $h3_size     = (int) $fields['font_size'] * 1.41;
		     $style_block .= ".block__content.iu-post-content h3 {";
		     $style_block .= "font-size: {$h3_size}px !important;";
		     $style_block .= '}';

		     $h4_size     = (int) $fields['font_size'] * 1.26;
		     $style_block .= ".block__content.iu-post-content h4 {";
		     $style_block .= "font-size: {$h4_size}px !important;";
		     $style_block .= '}';

		     $h5_size     = (int) $fields['font_size'] * 1.13;
		     $style_block .= ".block__content.iu-post-content h5 {";
		     $style_block .= "font-size: {$h5_size}px !important;";
		     $style_block .= '}';
	     }

	     if ( isset( $get_font ) || $fields['block_width'] || $fields['line_height'] ) {
		     $style_block .= ".block__content.block__content.iu-post-content p{";
		     if ( isset( $get_font ) ) {
			     $style_block .= "font-family: '{$get_font[0]}' , sans-serif !important;";
		     }
		     if ( $fields['block_width'] ) {
			     $style_block .= "font-weight: {$fields['block_width']};";
		     }
		     if ( $fields['line_height'] ) {
			     $style_block .= "line-height: {$fields['line_height']}px;";
		     }
		     $style_block .= '}';
	     }

	     if ( isset($fields['iu_use_info']) && $fields['iu_use_info'] ) {
		     $style_block .= '.iu-info-content {';
		     $style_block .= 'padding: 35px;';

		     if ( $fields['color_info_block'] ) {
			     $style_block .= "color: {$fields['color_info_block']};";
		     }
		     if ( $fields['bdrs_info'] ) {
			     $style_block .= "border-radius: {$fields['bdrs_info']}px;";
		     }
		     if ( $fields['bgc_info_block'] ) {
			     $style_block .= "background-color: {$fields['bgc_info_block']};";
		     }
		     $style_block .= '}';


		     $style_block .= '.iu-info-content-item {';
		     if ( $fields['bd_info_color'] ) {
			     $style_block .= "border-color: {$fields['bd_info_color']};";
		     }
		     $style_block .= '}';
	     }

	     echo "<style>{$style_block}</style>";
	     ?>


	     <div class="block">
		     <div class="block__content iu-post-content">
			     <?php
			     $temp_post   = get_option( '_temp_post_for_templates' );
			     $content     = get_the_content( '', '', get_the_ID() ? : $temp_post );

			     if ( ! empty( trim( $content ) ) ) {
				     if ( $fields['iu_hide_full_txt'] ) {
					     $max_char   = 300;
					     $cnt_length = strlen( $content );
					     $espacio    = strpos( $content, ". ", $max_char );
					     $cnt_part   = substr( $content, 0, $espacio );
					     $cnt_new    = substr( $content, strlen( $cnt_part ) + 1, $cnt_length );

					     echo "<p class='iu-part-content'>{$cnt_part}.<span>..</span></p>";
					     echo '<div class="readmore-btn-wraper">';
					     echo '<hr class="iu-hr-readmore">';
					     echo '<button class="iu-btn-full-cnt btn iu-btn-readmore" type="button">Read more</button>';
					     echo '</div>';


					     echo '<div class="d-none iu-full-cnt">';
					     foreach ( explode( "\n", $cnt_new ) as $item ) {
						     if ( $item ) {
							     echo "<p>{$item}</p>";
						     }
					     }
					     echo '</div>';

				     } elseif ( $content_arr = explode( "\n", $content ) ) {
					     foreach ( $content_arr as $item ) {
						     if ( $item ) {
							     echo "<p>{$item}</p>";
						     }
					     }
				     } else {
					     echo $content;
				     }
			     }

			     if ( isset($fields['iu_use_info']) && $fields['iu_use_info'] ):
				     $taxonomy = $this->prefix_t() . '_categories';
				     $post_id = get_the_ID() ? : get_option( '_temp_post_for_templates' );
				     $city    = get_post_meta( $post_id, $this->prefix() . 'city', true );

				     if ( $tags = get_the_terms( $post_id, $taxonomy ) ) {
					     if ( count( $tags ) === 1 ) {
						     $cat = $tags;
					     }

					     if ( count( $tags ) >= 2 ) {
						     $tags_partition = $this->get_partition( $tags, 2 );
						     $cat            = reset( $tags_partition );
						     $serv           = end( $tags_partition );
					     }
				     }

				     ?>
				     <div class="iu-info-content">
					     <div class="iu-info-content-item">
						     <b class="iu-info-content-item-title"><?php esc_html_e( 'Location', 'instantup' ); ?></b>
						     <div class="iu-info-content-item-location">
							     <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
								     <path fill-rule="evenodd" clip-rule="evenodd" d="M3.53125 7.82997C3.54326 4.29615 6.41772 1.44116 9.95154 1.45316C13.4854 1.46517 16.3404 4.33963 16.3284 7.87345V7.94592C16.2849 10.243 15.0023 12.3662 13.4298 14.0256C12.5305 14.9595 11.5263 15.7862 10.437 16.4894C10.1458 16.7413 9.7138 16.7413 9.42255 16.4894C7.79881 15.4325 6.3737 14.0982 5.21241 12.5474C4.17738 11.195 3.58972 9.55367 3.53125 7.85171L3.53125 7.82997Z" stroke="black" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"></path>
								     <path fill-rule="evenodd" clip-rule="evenodd" d="M9.93354 10.0077C11.0661 10.0077 11.9843 9.08956 11.9843 7.95697C11.9843 6.82439 11.0661 5.90625 9.93354 5.90625C8.80095 5.90625 7.88281 6.82439 7.88281 7.95697C7.88281 9.08956 8.80095 10.0077 9.93354 10.0077Z" stroke="black" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"></path>
							     </svg>

							     <span><?php echo $city ? : 'Collingwood!'; ?></span>
						     </div>
					     </div>

					     <div class="iu-info-content-item">
						     <b class="iu-info-content-item-title"><?php esc_html_e( 'Category', 'instantup' ); ?></b>
						     <?php
						     if ( isset( $cat ) && ! empty( $cat ) ) :
							     foreach ( $cat as $item ) :
								     echo $item->name . '<br>';
							     endforeach;
						     endif;

						     if ( $this->is_admin() ) :
							     echo 'Test name category';
						     endif;
						     ?>
					     </div>

					     <div class="iu-info-content-item">
						     <b class="iu-info-content-item-title"><?php esc_html_e( 'Services', 'instantup' ); ?></b>
						     <?php
						     if ( isset( $serv ) && ! empty( $serv ) ):
							     foreach ( $serv as $item ) :
								     echo $item->name . '<br>';
							     endforeach;
						     endif;

						     if ( $this->is_admin() ) :
							     echo 'Test name Services';
						     endif;
						     ?>
					     </div>
				     </div>
			     <?php endif; ?>
		     </div>
	     </div>
	     <?php
     } );