<?php
/**
 * cover.php
 * create in 23.04.2021
 * SAYri
 *
 */


use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Cover' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'checkbox', 'use_title', __( 'Use post title?' ) )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'use_shadow', __( 'Use shadow?' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'use_thumbnail', __( 'Use post thumbnail?' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_img_post',
			          'value'   => false,
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'use_img_post', __( 'Use img from post?' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_thumbnail',
			          'value'   => false,
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' ),

	     Field::make( 'text', 'img_position_post', __( 'Specify the position of the image' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_img_post',
			          'value'   => true,
			          'compare' => '=',
		          ),
	          ) )
	          ->set_attributes( array(
		          'placeholder' => 'default 1',
		          'type'        => 'number',
	          ) ),

	     Field::make( 'image', 'cover_image', __( 'Set image' ) )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field'   => 'use_thumbnail',
			          'value'   => false,
			          'compare' => '=',
		          ),
		          array(
			          'field'   => 'use_img_post',
			          'value'   => false,
			          'compare' => '=',
		          ),
	          ) )
	          ->set_default_value( false ),

	     Field::make( 'text', 'cover_text', __( 'Enter text' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'use_title',
			          'value'   => false,
			          'compare' => '=',
		          ),
	          ) )
	          ->set_attribute( 'placeholder', 'Your text...' ),

	     Field::make( 'select', 'iu_object_fit', __( 'Image object fit' ) )
	          ->set_default_value( 'cover' )
	          ->set_options( array(
		          'contain' => 'contain',
		          'cover'   => 'cover',
	          ) ),


     ) )
     ->add_tab( __( 'Styles Block' ), array(
	     Field::make( 'text', 'cover_height', __( 'Height' ) )
	          ->set_attributes( array(
		          'placeholder' => 'default 430px',
		          'type'        => 'number',
	          ) ),

	     Field::make( 'separator', 'sep_pos_block', __( 'Position:' ) )
	          ->set_classes( 'iu-separator-margin' ),
	     Field::make( 'text', 'top_block', __( 'Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'bottom_block', __( 'Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'border_radius', __( 'Border radius (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) ),

	     Field::make( 'text', 'margin_top_block', __( 'Margin Top' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom_block', __( 'Margin Bottom' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

     ) )
     ->add_tab( __( 'Styles Title' ), array(
	     Field::make( 'color', 'color_txt', __( 'Color For Text' ) )
	          ->set_conditional_logic( array(
		          'relation' => 'OR',
		          array(
			          'field' => 'use_title',
			          'value' => true,
		          ),
		          array(
			          'field'   => 'cover_text',
			          'value'   => '',
			          'compare' => '!=',
		          ),
	          ) )
	          ->set_default_value( '#ffffff' ),

	     Field::make( 'text', 'font_size_txt', __( 'Font Size (px)' ) )
	          ->set_conditional_logic( array(
		          'relation' => 'OR',
		          array(
			          'field' => 'use_title',
			          'value' => true,
		          ),
		          array(
			          'field'   => 'cover_text',
			          'value'   => '',
			          'compare' => '!=',
		          ),
	          ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'line_height_txt', __( 'Line Height (px)' ) )
	          ->set_conditional_logic( array(
		          'relation' => 'OR',
		          array(
			          'field' => 'use_title',
			          'value' => true,
		          ),
		          array(
			          'field'   => 'cover_text',
			          'value'   => '',
			          'compare' => '!=',
		          ),
	          ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'select', 'position_title', __( 'Position Title' ) )
	          ->set_conditional_logic( array(
		          'relation' => 'OR',
		          array(
			          'field' => 'use_title',
			          'value' => true,
		          ),
		          array(
			          'field'   => 'cover_text',
			          'value'   => '',
			          'compare' => '!=',
		          ),
	          ) )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'left'   => 'Left',
		          'center' => 'center',
		          'right'  => 'right',
	          ) ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields, $attributes, $inner_blocks ) {
	     $id_cover     = str_replace( '.', '_', uniqid( 'iu-cover-', true ) );
	     $template_top = get_option( '_template_for_content' );

	     if ( $template_parent_id = (int) $template_top[ get_post_type( get_the_ID() ) ] ) {
		     $post_cnt = get_the_content( '', '', $template_parent_id );

		     foreach ( parse_blocks( $post_cnt ) as $parse_block ) {
			     if ( $parse_block['blockName'] === 'core/columns' ) {
				     $width_block_title = $parse_block['innerBlocks'][0]['attrs']['width'];
			     }
		     }
	     }

	     if ( ! $fields['line_height_txt'] && $fields['font_size_txt'] ) {
		     $line_height = $fields['font_size_txt'] . 'px';
	     }
	     if ( $fields['line_height_txt'] ) {
		     $line_height = $fields['line_height_txt'] . 'px';
	     }

	     ?>

         <style>
             <?php
             if ($fields['cover_height'] || $fields['top_block'] || $fields['bottom_block'] || $fields['margin_top_block'] || $fields['margin_bottom_block']){
                echo ".{$id_cover}{";

                if ($fields['cover_height']){
                    echo "height: {$fields['cover_height']}px;";
                }

                if ($fields['top_block']){
                    echo "top: {$fields['top_block']}px;";
                }

                if ($fields['bottom_block']){
                    echo "bottom: {$fields['bottom_block']}px;";
                }

                if ($fields['margin_top_block']){
                    echo "margin-top: {$fields['margin_top_block']}px;";
                }

                if ($fields['margin_bottom_block']){
                    echo "margin-bottom: {$fields['margin_bottom_block']}px;";
                }

                if ($fields['top_block'] || $fields['bottom_block']){
                    echo 'z-index: 2;';
                }
                echo '}';
             }

             if ($fields['iu_object_fit']){
                echo ".{$id_cover} img{";
                echo "object-fit: {$fields['iu_object_fit']} !important;";
                echo '}';
             }

             if (!$fields['use_shadow']){
                 echo ".{$id_cover}.wp-block-cover.has-background-dim:not(.has-background-gradient)::before{";
                 echo 'content: none;';
                 echo '}';
             }

             if (isset($width_block_title) && ! empty($width_block_title) && ($fields['use_title'] || $fields['cover_text'])){
                echo '.wp-block-cover__inner-container{';
                echo "max-width: {$width_block_title};";
                echo '}';
             }

             if ($fields['border_radius']){
                 echo '.block__content .wp-block-cover, .wp-block-cover img{';
                 echo "border-radius: {$fields['border_radius']}px;";
                 echo '}';
             }


             echo ".{$id_cover} .iu-cover-title{";
             echo 'font-size: '. ($fields['font_size_txt'] ?: '30') .'px;';
             echo 'line-height: '. ($line_height ?? '1') .';';
             echo 'font-weight: '. ($fields[''] ?: 'bold') .';';
             echo 'color: '. ($fields['color_txt'] ?: '#fff') .' !important;';
             echo 'text-align: '. ($fields['position_title'] ?: 'left') .' !important;';
             echo 'margin-bottom: '. ($fields[''] ?: '0') .';';
             echo '}';


             ?>
         </style>

         <div class="block">
             <div class="block__content">
			     <?php $url_pic = INSTANTUP_URL . 'data/assets/img/temp_thumbnail.jpg';

			     if ( $fields['use_title'] ) {
				     if ( get_the_title() ) {
					     $text = get_the_title();
				     } else {
					     $text = 'This is post title';
				     }
			     } else {
				     $text = $fields['cover_text'];
			     }

			     if ( $fields['use_thumbnail'] ) {
				     if ( has_post_thumbnail() && get_the_ID() ) {
					     $url_pic = get_the_post_thumbnail_url();
				     }

			     } elseif ( $fields['cover_image'] ) {
				     $url_pic = wp_get_attachment_image_url( $fields['cover_image'], 'full' );

			     } elseif ( $fields['use_img_post'] ) {
				     $post_id      = get_the_ID() ? : get_option( '_temp_post_for_templates' );
				     $pic_for_post = get_post_meta( $post_id, $this->prefix() . 'pic_for_post', true );
				     $img_position = $fields['img_position_post'] ? : 1;
				     $id_img       = $pic_for_post[ $img_position ]['id'] ? : end( $pic_for_post )['id'];
				     $url_pic      = wp_get_attachment_url( $id_img );
			     }

			     ?>


                 <!-- wp:cover {"url":"<?php echo $url_pic ?>","id":<?php echo $fields['cover_image'] ?>} -->
                 <div class="<?php echo $id_cover; ?> wp-block-cover has-background-dim">
                     <img class="wp-block-cover__image-background wp-image-440"
                          src="<?php echo $url_pic ?>" data-object-fit="cover"/>
                     <div class="wp-block-cover__inner-container">
                         <p class="iu-cover-title"><?php echo $text ?></p>
                     </div>
                 </div>
                 <!-- /wp:cover -->

             </div>
         </div>
	     <?php
     } );