<?php
/**
 * iu-map.php
 * create in 23.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Location' ) )
     ->add_tab( __( 'Settings' ), [
	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( [
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ] )
	          ->add_options( $this->get_list_fonts() ),

	     Field::make( 'radio', 'iu_location_option', __( 'Location Display Options' ) )
	          ->set_classes( 'iu-radio-option' )
	          ->set_default_value( 'generalized' )
	          ->add_options( [
		          'exact'       => 'Exact',
		          'generalized' => 'Generalized',
	          ] ),
     ] )
     ->add_tab( __( 'Title' ), [
	     Field::make( 'checkbox', 'iu_hidden_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Title' ) ),

	     Field::make( 'checkbox', 'iu_hide_colon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Colon' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_hide_icon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Icon' ) ),

	     Field::make( 'checkbox', 'iu_underline_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Underline' ) ),

	     Field::make( 'color', 'color_title', __( 'Color For Title' ) )
	          ->set_default_value( '#50505a' ),

	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 11',
	          ] )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'select', 'font_weight', __( 'Font Weight' ) )
	          ->set_options( [
		          'normal' => __( 'Normal' ),
	          ] )
	          ->add_options( [
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ] )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height', __( 'Line Height (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ] ),
	     Field::make( 'text', 'margin_top', __( 'Margin Top (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ] )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 12',
	          ] )
	          ->set_width( 45 ),
     ] )
     ->add_tab( __( 'location Text' ), [
	     Field::make( 'checkbox', 'iu_hide_icon_txt', __( 'Hide Icon' ) )
	          ->set_option_value( 'yes' ),
	     Field::make( 'color', 'color_txt', __( 'Color For Text' ) )
	          ->set_default_value( '#5a5a64' ),
	     Field::make( 'text', 'font_size_txt', __( 'Font Size (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 11',
	          ] )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_txt', __( 'Line Height (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ] )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_top_txt', __( 'Margin Top (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ] )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_txt', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( [
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ] )
	          ->set_width( 45 ),

	     Field::make( 'select', 'position_location', __( 'Position Location' ) )
	          ->set_options( [
		          'top' => __( 'Top' ),
	          ] )
	          ->add_options( [
		          'bottom' => __( 'Bottom' ),
	          ] )
	          ->set_width( 45 ),
     ] )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function( $fields ) {
	     if ( ! get_option( '_pap_google_maps_api_key' ) && get_option( '_iu_disable_maps' ) === 'yes' ) {
		     return;
	     }

	     $post_id      = get_the_ID() ?: get_option( '_temp_post_for_templates' );
	     $address      = get_post_meta( $post_id, $this->prefix() . 'address', TRUE );
	     $longitude    = get_post_meta( $post_id, $this->prefix() . 'latitude', TRUE );
	     $latitude     = get_post_meta( $post_id, $this->prefix() . 'longitude', TRUE );
	     $county       = get_post_meta( $post_id, $this->prefix() . 'county', TRUE );
	     $state        = get_post_meta( $post_id, $this->prefix() . 'state', TRUE );
	     $country      = get_post_meta( $post_id, $this->prefix() . 'country', TRUE );
	     $pap_map_zoom = 18;
	     $get_font     = isset( $fields['select_fonts'] ) ? explode( ':', $fields['select_fonts'] ) : FALSE;

	     if ( $fields['position_location'] === 'bottom' ) {
		     $position_loc_part_txt = 'order-1';
		     $position_loc_part_map = 'order-0';
	     }

	     ?>
       <style>
         <?php
				 if ($get_font){
						 echo 'body .iu-location-block .iu-location-title, body .iu-location-block .iu-location-txt {';
						 echo "font-family: {$get_font[0]}, Sans-serif !important;";
						 echo '}';
				 }

				 if ($fields['font_size'] || $fields['line_height'] || $fields['color_title'] ||
					$fields['margin_top'] || ($fields['margin_bottom'] === '0' || (int)$fields['margin_bottom'] > 0)  ){
						 echo '.iu-location-title {';
						 if ($fields['font_size']){
								echo "font-size: {$fields['font_size']}px;";
						 }

						 if ($fields['font_weight']){
								echo "font-weight: {$fields['font_weight']};";
						 }

						 if ($fields['line_height']){
								echo "line-height: {$fields['line_height']}px;";
						 }

						 if ($fields['color_title']){
								echo "color: {$fields['color_title']} !important;";
						 }

						 if ($fields['margin_top']){
								echo "margin-top: {$fields['margin_top']}px;";
						 }
						 if ($fields['margin_bottom']){
								echo "margin-bottom: {$fields['margin_bottom']}px;";
						 }
						 echo '}';
					}

				 if ($fields['font_size_txt'] || $fields['line_height_txt'] || $fields['color_txt'] ||
					$fields['margin_top_txt'] || $fields['margin_bottom_txt'] ){
						 echo '.iu-location-txt {';
						 if ($fields['font_size_txt']){
								echo "font-size: {$fields['font_size_txt']}px;";
						 }

						 if ($fields['line_height_txt']){
								echo "line-height: {$fields['line_height_txt']}px;";
						 }

						 if ($fields['color_txt']){
								echo "color: {$fields['color_txt']};";
						 }

						 if ($fields['margin_top_txt']){
								echo "margin-top: {$fields['margin_top_txt']}px;";
						 }

						 if ($fields['margin_bottom_txt']){
								echo "margin-bottom: {$fields['margin_bottom_txt']}px;";
						 }
						 echo '}';
					}

				 ?>
       </style>

       <div class="block iu-location-block">
		     <?php if ( ! empty( $longitude ) && ! empty( $latitude ) ) { ?>
           <div class="block__content d-flex flex-wrap mb30">

				     <?php if ( ! $fields['iu_hidden_title'] ) : ?>
               <div class="iu-location-title profolio-text-sm">
						     <?php if ( ! $fields['iu_hide_icon'] ) : ?>
                   <i class="pro_fa pro_fa-list"></i>
						     <?php endif; ?>

						     <?php echo $fields['iu_hide_colon']
							     ? esc_html__( 'Location', 'instantup' )
							     : esc_html__( 'Location:', 'instantup' ); ?>
               </div>

					     <?php
					     if ( ! $fields['iu_underline_title'] ):
						     echo '<hr>';
					     endif;
				     endif;

				     if ( $address ) { ?>
               <div
                 class="iu-location-txt profolio-text-sm <?php echo $position_loc_part_txt ?? ''; ?>">
						     <?php if ( ! $fields['iu_hide_icon_txt'] ) { ?>
                   <i class="pro_fa pro_fa-map-marker-alt"></i>
						     <?php } ?>

						     <?php if ( $fields['iu_location_option'] === 'exact' ) {
							     echo $address;
						     }
						     else {
							     $pap_map_zoom -= 2;
							     $state_out    = $state ? $state . ', ' : '';
							     echo $county . ', ' . $state_out . $country;
						     } ?>
               </div>
				     <?php } ?>

				     <?php if ( $maps_api_key = get_option( '_pap_google_maps_api_key' ) ) {
					     $src = "https://maps.googleapis.com/maps/api/staticmap?zoom={$pap_map_zoom}&size=600x300&maptype=roadmap&markers={$longitude},{$latitude}&key={$maps_api_key}"; ?>
               <img
                 class="iu-right-side-map <?php echo $position_loc_part_map ?? ''; ?>"
                 src="<?php echo $src; ?>" onerror="this.style.display='none';"
                 alt="Google map">
				     <?php } ?>

           </div>
		     <?php } ?>
       </div>
	     <?php
     } );