<?php
/**
 * iu_projects-map.php
 * create in 26.07.2023
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

wp_register_style(
	'projects-map',
	INSTANTUP_URL . 'data/assets/back-and-front/css/projects-map.css',
	'',
	INSTANTUP_VERSION
);

$type_output_arr = array();
$select_fields   = $this->get_fields_for_block();
$type_output_arr = array();

if ( $type_slug = get_option( '_iu_custom_type_posts' ) ) {
	foreach ( $type_slug as $item ) {
		$type_output_arr[ $item['slug'] ] = $item['name'];
	}
} else {
	$type_output_arr = array();
}

if ( $type_slug = get_option( '_iu_custom_type_posts' ) ) {
	foreach ( $type_slug as $item ) {
		$type_output_arr[ $item['slug'] ] = $item['name'];
	}
} else {
	$type_output_arr = array();
}

Block::make( __( 'IU Projects Map' ) )
     ->add_tab( __( 'Main settings', 'instantup' ), array(
	     Field::make( 'multiselect', 'iu_output_type',
		     __( 'Choose a Content Type (default all content types)', 'instantup' ) )
	          ->add_options( $type_output_arr ),
	     Field::make( 'text', 'iu_posts_per_page', __( 'How many content items to show per page', 'instantup' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'Choose a number (default 26)',
	          ) ),

	     Field::make( 'separator', 'iu_main_separator', __( 'Settings' ) )
	          ->set_classes( 'iu-separator-margin' ),
	     Field::make( 'color', 'iu_background', __( 'Background block color item', 'instantup' ) )
	          ->set_palette( array( '#FF0000', '#00FF00', '#0000FF' ) ),
	     Field::make( 'color', 'iu_background_maine', __( 'Background main color', 'instantup' ) )
	          ->set_default_value( '#f5f5fa' )
	          ->set_palette( array( '#FF0000', '#00FF00', '#0000FF' ) ),
	     Field::make( 'select', 'iu_settings_columns', __( 'Columns' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->add_options( array(
		          '1' => 1,
		          '2' => 2,
		          '3' => 3,
		          '4' => 4,
	          ) )
	          ->set_default_value( '2' ),
	     Field::make( 'text', 'iu_settings_bdrs', __( 'Border Radius' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type' => 'number',
		          'min'  => '1',
		          'max'  => '100',
	          ) ),
	     Field::make( 'text', 'iu_settings_height', __( 'Items height' ) )
	          ->set_attributes( array(
		          'type' => 'number',
		          'min'  => '100',
	          ) ),
	     Field::make( 'text', 'iu_margin_top', __( 'Margin top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'placeholder' => '0',
		          'type'        => 'number',
		          'min'         => '0',
	          ) ),
	     Field::make( 'text', 'iu_margin_bottom', __( 'Margin bottom' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'placeholder' => '0',
		          'type'        => 'number',
		          'min'         => '0',
	          ) )
     ) )
     ->add_tab( __( 'Post Title' ), array(
	     Field::make( 'checkbox', 'iu_show_post_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Title post (show/hide)' )
	          ->set_default_value( true )
	          ->set_option_value( true ),
	     Field::make( 'color', 'iu_post_title_color', __( 'Color' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'iu_post_title_size', __( 'Font Size (px)' ) )
	          ->set_default_value( '14' )
	          ->set_attribute( 'type', 'number' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'iu_post_title_top', __( 'Padding top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'iu_post_title_right', __( 'Padding right' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'iu_post_title_bottom', __( 'Padding Bottom' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'iu_post_title_left', __( 'Padding left' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'checkbox', 'iu_post_title_blur_use', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_help_text( 'Blur background? (yes/no)' )
	          ->set_default_value( false )
	          ->set_option_value( true ),

	     Field::make( 'text', 'iu_post_title_blur_intensity', __( 'Intensity blur' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'max'         => '10',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
		          array(
			          'field' => 'iu_post_title_blur_use',
			          'value' => true,
		          ),
	          ) ),
     ) )
     ->add_tab( __( 'Map' ), array(
	     Field::make( 'checkbox', 'iu_zoom_all_markers', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Zoom to fit all markers' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_map_fullheight', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Full height map' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_hide_info_window', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Hide info window' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_blue_icon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use blue marker icon' )
	          ->set_default_value( false )
	          ->set_option_value( true ),

	     Field::make( 'checkbox', 'iu_hide_map', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use hide map' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'text', 'top_block', __( 'Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hide_map',
			          'value' => true,
		          ),
	          ) ),

         Field::make( 'text', 'iu_map_style', __( 'JSON Map Style' ) ),

	     Field::make( 'select', 'iu_map_which_posts', __( 'Get coordinates from' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_options( array(
		          'current_page' => 'Display on map same projects as on current pages',
		          'all_pages'    => 'Display on map projects from all pages',
	          ) )
	          ->set_default_value( 'current_page' )
	          ->add_options( function () {
		          $post_id = $_GET['post'] ?? $_POST['id'] ?? $_POST['post_ID'] ?? '';
		          update_option( 'current_post_ID', $post_id );
	          } ),

	     Field::make( 'image', 'marker_image', __( 'Marker Image' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_value_type( 'url' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_blue_icon',
			          'value' => false,
		          ),
	          ) ),
     ) )
     ->add_tab( __( 'Pagination' ), array(
	     Field::make( 'color', 'iu_nav_bgc_current', __( 'Background Current Item' ) ),
	     Field::make( 'color', 'iu_nav_color_current', __( 'Color Current Item' ) ),

	     Field::make( 'color', 'iu_nav_bgc_all', __( 'Background Item' ) ),
	     Field::make( 'color', 'iu_nav_color_all', __( 'Color Item' ) ),

	     Field::make( 'color', 'iu_nav_bgc_all_hover', __( 'Background Hover' ) ),
	     Field::make( 'color', 'iu_nav_color_all_hover', __( 'Color Hover' ) ),

	     Field::make( 'text', 'iu_nav_width', __( 'Width Item' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '36',
	          ) ),
	     Field::make( 'text', 'iu_nav_height', __( 'Height Item' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '40',
	          ) ),

	     Field::make( 'text', 'iu_nav_size_current', __( 'Text Current Size' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '12',
	          ) ),
	     Field::make( 'text', 'iu_nav_size_all', __( 'Text Size' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '12',
	          ) ),

	     Field::make( 'select', 'iu_nav_weight_current', __( 'Text Current Weight' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          '400' => 'regular',
		          '300' => 'Light',
		          '500' => 'Medium',
		          '700' => 'bold',
	          ) ),
	     Field::make( 'select', 'iu_nav_weight_all', __( 'Text Weight' ) )
	          ->set_width( 45 )
	          ->set_options( array(
		          '400' => 'regular',
		          '300' => 'Light',
		          '500' => 'Medium',
		          '700' => 'bold',
	          ) ),

	     Field::make( 'text', 'iu_nav_bdrs_current', __( 'Border Current Radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '3',
	          ) ),
	     Field::make( 'text', 'iu_nav_bdrs_all', __( 'Border radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '3',
	          ) ),

	     Field::make( 'text', 'iu_nav_top', __( 'Margin top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attribute( 'type', 'number' ),
	     Field::make( 'text', 'iu_nav_bottom', __( 'Margin Bottom' ) )
	          ->set_width( 45 )
	          ->set_attribute( 'type', 'number' ),
     ) )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_mode( 'preview' )
     ->set_editor_style( 'projects-map' )
     ->set_style( 'projects-map' )
     ->set_render_callback( function ( $fields ) {
	     $parent_post_id = get_the_ID();
	     $post_ID        = get_option( 'current_post_ID' );
	     $get_font       = '';
	     $disable_maps   = false;
	     $rand           = random_int( 1, 50 );
	     $salt           = substr( md5( $rand * 200 ), 0, 10 );

	     if ( ! get_option( '_pap_google_maps_api_key' ) && get_option( '_iu_disable_maps' ) === 'yes' ) {
		     $disable_maps = true;
	     }

	     if ( $fields['select_fonts'] ) {
		     $get_font = explode( ':', $fields['select_fonts'] );
	     }

	     if ( $fields['use_filters'] ) {
		     $transient_name = $this->get_type_prefix() . '_filters_arg_' . get_the_ID();
		     delete_transient( $transient_name );

		     if ( ! $filters_arr = get_transient( $transient_name ) ) {
			     $taxonomy      = array(
				     $this->prefix_t() . '_tags',
				     $this->prefix_t() . '_categories',
			     );
			     $ids_posts     = new WP_Query( array(
				     'fields'         => 'ids',
				     'post_type'      => $this->get_postype_block( get_the_ID() ),
				     'posts_per_page' => 1000,
				     'post_status'    => array( 'publish' ),
				     'no_found_rows'  => true,
			     ) );
			     $product_terms = wp_get_object_terms( $ids_posts->posts, $taxonomy );

			     if ( $ids_posts->have_posts() && $product_terms && ! is_wp_error( $product_terms ) ) {
				     foreach ( $product_terms as $product_term ) {
					     $filters_arr[] = array(
						     'term_id' => $product_term->term_id,
						     'name'    => sanitize_text_field( $product_term->slug ),
						     'type'    => $product_term->taxonomy,
					     );
				     }
			     }

			     if ( isset( $filters_arr ) && ! empty( $filters_arr ) ) {
				     set_transient( $transient_name, $filters_arr, DAY_IN_SECONDS );
			     }
		     }
	     }

	     if ( empty( $fields['iu_output_type'] ) && ! empty( get_option( '_iu_custom_type_slug' ) ) ) {
		     $post_type = get_option( '_iu_custom_type_slug' );

		     $temp_post_type = array_flip( $post_type );
		     if ( isset( $temp_post_type['iu_ai_writeups'] ) ) {
			     unset( $post_type[ $temp_post_type['iu_ai_writeups'] ] );
		     }
	     } else {
		     $post_type = $fields['iu_output_type'] ?? 'post';
	     }

	     $query_arr = array(
		     'post_type'      => $post_type,
		     'posts_per_page' => $fields['iu_posts_per_page'] ?: 26,
		     'post_status'    => array( 'publish' ),
		     'paged'          => get_query_var( 'paged' ) ?: 1,
		     'orderby'        => array( 'meta_value' => 'DESC', 'date' => 'DESC' ),
		     'meta_query'     => array(
			     array(
				     'relation' => 'OR',
				     array(
					     'key'     => $this->prefix() . 'status_featured',
					     'compare' => 'NOT EXISTS',
				     ),
				     array(
					     'key'     => $this->prefix() . 'status_featured',
					     'compare' => 'EXISTS',
				     ),
			     ),
			     array(
				     array(
					     'key'     => '_thumbnail_id',
					     'compare' => 'EXISTS',
				     ),
			     ),
		     ),
	     );

	     $query = new WP_Query( $query_arr );
	     $posts = $query->posts;

	     $atts = array(
		     'fullheight' => (string) $fields['iu_map_fullheight'],
		     'zoom'       => '7',
	     );
	     if ( isset( $fields['iu_map']['zoom'] ) ) {
		     $atts['zoom'] = (string) $fields['iu_map']['zoom'];
	     }
	     if ( $fields['marker_image'] ) {
		     $atts['marker'] = $fields['marker_image'];
	     }
	     if ( isset( $fields['iu_blue_icon'] ) && $fields['iu_blue_icon'] ) {
		     $atts['marker'] = INSTANTUP_URL . 'data/assets/img/pin_fill.png';
	     }
	     if ( $fields['iu_map_which_posts'] === 'current_page' ) {
		     $atts['number_projects'] = 'current_page';
		     $atts['locations'] = $this->get_map_locations( array( 'post_type' => $post_type), false, $post_ID );
	     } else {
		     $atts['number_projects'] = 'all_pages';
		     $atts['locations']       = $this->get_map_locations( false, false, $post_ID );
	     }
	     if ( $fields['iu_zoom_all_markers'] ) {
		     $atts['zoom_fit'] = true;
	     }
         if ( $fields['iu_map_style'] ) {
		     $atts['style'] = $fields['iu_map_style'];
	     }

	     $atts['location'] = $this->get_one_location( $atts['locations'] );

	     update_post_meta( $parent_post_id, 'iu_pic_show', 'yes' );
	     update_post_meta( $parent_post_id, 'iu_show_loc_title', false );
	     update_post_meta( $parent_post_id, 'iu_location_option', 'large' );
	     update_post_meta( $parent_post_id, 'iu_show_cat', 'yes' );

	     if ( $fields['iu_settings_columns'] ) {
		     update_post_meta( $parent_post_id, 'iu_settings_columns', $fields['iu_settings_columns'] );
	     }

	     if ( $fields['iu_pic_set_size'] ) {
		     update_post_meta( $parent_post_id, 'iu_pic_set_size', $fields['iu_pic_set_size'] );
	     }
	     if ( $fields['iu_pic_set_image'] ) {
		     update_post_meta( $parent_post_id, 'iu_pic_set_image', $fields['iu_pic_set_image'] );
	     }
	     if ( $fields['iu_show_post_title'] ) {
		     update_post_meta( $parent_post_id, 'iu_show_post_title', $fields['iu_show_post_title'] );
	     }
	     ?>

         <style>
             <?php
			 //Start For filters
			  if ($get_font){
				 echo '.iu_location-filter-row input[type="text"].iu_location-filter, .iu_radius-filter-row .iu_radius-filter_output{';
				 echo $get_font ? "font-family: {$get_font[0]}, Sans-serif !important;" : '';
				 echo "}";
			 }

			 if ($fields['location_fonts'] || $fields['location_font_size'] || $fields['location_line_height']){
				 echo '.iu_location-filter-row{';
				 echo $fields['location_title_color'] ? "color: {$fields['location_title_color']};" : '';
				 echo $fields['location_font_size'] ? "font-size: {$fields['location_font_size']}px;" : '';
				 echo $fields['location_line_height'] ? "line-height: {$fields['location_line_height']}px;" : '';
				 echo "}";
			 }
			 //End For filters


			 if($fields['iu_nav_top'] || $fields['iu_nav_bottom']){
				 echo '.profolio-pagination {';
				 if ($fields['iu_nav_top']){
					 echo "margin-top: {$fields['iu_nav_top']}px;";
				 }
				 if ($fields['iu_nav_bottom']){
					 echo "margin-bottom: {$fields['iu_nav_bottom']}px;";
				 }
				 echo '}';
			 }


			 echo '.iu-posts-list {';
			 if ( $fields['iu_background_maine'] ) {
				echo "background-color: {$fields['iu_background_maine']} !important;";
			 }
			echo '}';


			 if ( $fields['iu_settings_bdrs'] >= '0' ){
				 echo '.profolio-project-card, .iu_realestate-item {';
				 echo "border-radius: {$fields['iu_settings_bdrs']}px;";
				 echo '}';

				 echo '.profolio-project-card .profolio-card-cover img {';
				 echo "border-top-left-radius: {$fields['iu_settings_bdrs']}px;";
				 echo "border-top-right-radius: {$fields['iu_settings_bdrs']}px;";
				 echo '}';

				 echo '.iu_realestate-listing {';
				 echo "border-bottom-right-radius: {$fields['iu_settings_bdrs']}px;";
				 echo "border-bottom-left-radius: {$fields['iu_settings_bdrs']}px;";
				 echo '}';

				 echo '.iu-album-temp .card {';
				 echo "border-radius: {$fields['iu_settings_bdrs']}px;";
				 echo '}';

				 echo '.iu-album-temp .card .card-img-top {';
				 echo "border-top-left-radius: {$fields['iu_settings_bdrs']}px;";
				 echo "border-top-right-radius: {$fields['iu_settings_bdrs']}px;";
				 echo '}';
			 }

			 if (is_numeric($fields['iu_settings_height'])){
				echo '.iu_realestate-item {';
				echo "height: {$fields['iu_settings_height']}px !important;";
				echo '}';

			 }


			 if (is_numeric($fields['iu_post_title_left']) || is_numeric($fields['iu_post_title_left']) ||
			 is_numeric($fields['iu_post_title_right']) || is_numeric($fields['iu_post_title_bottom']) ){
				 echo '.iu_realestate-listing {';
				 if (is_numeric($fields['iu_post_title_left'])){
					echo "padding-left: {$fields['iu_post_title_left']}px;";
				 }
				 if (is_numeric($fields['iu_post_title_right'])){
					echo "padding-right: {$fields['iu_post_title_right']}px;";
				 }
				 if (is_numeric($fields['iu_post_title_top'])){
					echo "padding-top: {$fields['iu_post_title_top']}px;";
				 }
				 if (is_numeric($fields['iu_post_title_bottom'])){
					echo "padding-bottom: {$fields['iu_post_title_bottom']}px;";
				 }
				 if ($fields['iu_post_title_blur_use']){
					 $blur = $fields['iu_post_title_blur_intensity'] ?: '10';
					echo "backdrop-filter: blur({$blur}px);";
				 }
				 echo '}';
			 }

			 if ($fields['iu_background']){
				echo '.JS_profolio_project_item .profolio-project-card {';
				 echo "background-color: {$fields['iu_background']} !important;";
				echo '}';
			 }

			 if ($fields['iu_post_title_color'] || $fields['iu_block_title_size'] ||$fields['iu_block_title_weight'] ||
				   $fields['iu_block_title_top'] || $fields['iu_block_title_right'] ||$fields['iu_block_title_bottom'] ||
				   $fields['iu_block_title_left']){
				echo '.profolio-card-descr .profolio-header-xs, .profolio-map-pop .profolio-header-xxs {';

				 if ($fields['iu_post_title_color']){
					echo "color: {$fields['iu_post_title_color']} !important;";
				 }

				 if ($fields['iu_block_title_size']){
					echo "font-size: {$fields['iu_block_title_size']}px;";
				 }

				 if ($fields['iu_block_title_weight']){
					echo "font-weight: {$fields['iu_block_title_weight']};";
				 }

				 if ($fields['iu_block_title_top']){
					echo "margin-top: {$fields['iu_block_title_top']}px;";
				 }

				 if ($fields['iu_block_title_right']){
					echo "margin-right: {$fields['iu_block_title_right']}px;";
				 }

				 if ($fields['iu_block_title_bottom']){
					echo "margin-bottom: {$fields['iu_block_title_bottom']}px;";
				 }

				 if ($fields['iu_block_title_left']){
					echo "margin-left: {$fields['iu_block_title_left']}px;";
				 }
				echo '}';
			 }


			 if ($fields['iu_pic_set_height']){
				echo '.profolio-project-card .profolio-card-image-frame .profolio-card-cover img {';
				echo "height: {$fields['iu_pic_set_height']}% !important;";
				echo '}';
			 }


			 if ($fields['iu_loc_color'] || $fields['iu_loc_size'] || $fields['iu_loc_top'] ||
			  $fields['iu_loc_right'] || $fields['iu_loc_bottom'] || $fields['iu_loc_left']){
				echo '.JS_profolio_project_item .profolio-card-descr .profolio-text-sm {';
				if ($fields['iu_loc_color']){
					echo "color: {$fields['iu_loc_color']} !important;";
				}

				if ($fields['iu_loc_size']){
					echo "font-size: {$fields['iu_loc_size']}px !important;";
				}

				if ($fields['iu_loc_top']){
					echo "margin-top: {$fields['iu_loc_top']}px;";
				}

				if ($fields['iu_loc_right']){
					echo "margin-right: {$fields['iu_loc_right']}px;";
				}

				if ($fields['iu_loc_bottom']){
					echo "margin-bottom: {$fields['iu_loc_bottom']}px;";
				}

				if ($fields['iu_loc_left']){
					echo "margin-left: {$fields['iu_loc_left']}px;";
				}
				echo '}';
			 }

			 if ($fields['iu_cat_text_color'] || $fields['iu_cat_color'] || $fields['iu_cat_size'] ||
			 $fields['iu_cat_weight'] || $fields['iu_cat_top'] || $fields['iu_cat_right']  ||
			 $fields['iu_cat_bottom'] || $fields['iu_cat_left'] || $fields['iu_cat_p_top'] ||
			 $fields['iu_cat_p_right'] || $fields['iu_cat_p_bottom'] || $fields['iu_cat_p_left'] || $fields['iu_cat_bdrs'] ){
				 echo '.JS_profolio_project_item .profolio-card-category-frame a {';
				 if ($fields['iu_cat_text_color']){
					echo "color: {$fields['iu_cat_text_color']} !important;";
				 }

				 if ($fields['iu_cat_color']){
					 echo "background-color: {$fields['iu_cat_color']} !important;";
				 }

				 if ($fields['iu_cat_size']){
					 echo "font-size: {$fields['iu_cat_size']}px !important;";
				 }

				 if ($fields['iu_cat_weight']){
				  echo "font-weight: {$fields['iu_cat_weight']} !important;";
				 }

				 if ($fields['iu_cat_top']){
					 echo "margin-top: {$fields['iu_cat_top']}px;";
				 }

				 if ($fields['iu_cat_right']){
					echo "margin-right: {$fields['iu_cat_right']}px;";
				 }

				 if ($fields['iu_cat_bottom']){
					echo "margin-bottom: {$fields['iu_cat_bottom']}px;";
				 }

				 if ($fields['iu_cat_left']){
					echo "margin-left: {$fields['iu_cat_left']}px;";
				 }

				 if ($fields['iu_cat_p_top']){
					echo "padding-top: {$fields['iu_cat_p_top']}px;";
				 }

				 if ($fields['iu_cat_p_right']){
					echo "padding-right: {$fields['iu_cat_p_right']}px;";
				 }

				 if ($fields['iu_cat_p_bottom']){
					echo "padding-bottom: {$fields['iu_cat_p_bottom']}px;";
				 }

				 if ($fields['iu_cat_p_left']){
					echo "padding-left: {$fields['iu_cat_p_left']}px;";
				 }

				 if ($fields['iu_cat_bdrs']){
					echo "border-radius: {$fields['iu_cat_bdrs']}px;";
				 }
				 echo '}';
			 }


			 if ($fields['iu_nav_width'] || $fields['iu_nav_height'] ||
			  $fields['iu_nav_bgc_all'] || $fields['iu_nav_color_all'] ||
			  $fields['iu_nav_size_all'] || $fields['iu_nav_weight_all'] || $fields['iu_nav_bdrs_all']) {
				 echo '.profolio-pagination li a, .profolio-pagination li span {';
				 if ($fields['iu_nav_width']){
					echo "width: {$fields['iu_nav_width']}px;";
				 }

				 if ($fields['iu_nav_height']){
					echo "height: {$fields['iu_nav_height']}px;";
				 }

				 if ($fields['iu_nav_bgc_all']){
					 echo "background-color: {$fields['iu_nav_bgc_all']};";
				 }

				 if ($fields['iu_nav_color_all']){
					 echo "color: {$fields['iu_nav_color_all']};";
				 }

				 if ($fields['iu_nav_size_all']){
					 echo "font-size: {$fields['iu_nav_size_all']}px;";
				 }
				 if ($fields['iu_nav_weight_all']){
					 echo "font-weight: {$fields['iu_nav_weight_all']};";
				 }
				 if ($fields['iu_nav_bdrs_all'] || $fields['iu_nav_bdrs_all'] === '0'){
					 echo "border-radius: {$fields['iu_nav_bdrs_all']}px;";
				 }
				 echo '}';
			  }

			 if ($fields['iu_nav_bgc_current'] || $fields['iu_nav_color_current'] ||
			  $fields['iu_nav_size_current'] || $fields['iu_nav_weight_current'] || $fields['iu_nav_bdrs_current'] ) {
				 echo '.profolio-pagination .current, .profolio-pagination a.page-numbers.current {';
				 if ($fields['iu_nav_size_current']){
					echo "font-size: {$fields['iu_nav_size_current']}px;";
				 }

				 if ($fields['iu_nav_weight_current']){
					echo "font-weight: {$fields['iu_nav_weight_current']};";
				 }

				 if ($fields['iu_nav_color_current']){
					echo "color: {$fields['iu_nav_color_current']};";
				 }

				 if ($fields['iu_nav_bdrs_current'] || $fields['iu_nav_bdrs_current'] === '0'){
					echo "border-radius: {$fields['iu_nav_bdrs_current']}px;";
				 }

				 if ($fields['iu_nav_bgc_current']){
					echo "background-color: {$fields['iu_nav_bgc_current']};";
				 }
				 echo '}';
			 }

			 if ($fields['iu_nav_bgc_all_hover'] || $fields['iu_nav_color_all_hover']) {
				 echo '.profolio-pagination li a:hover {';
				 if ($fields['iu_nav_color_all_hover']){
					 echo "color: {$fields['iu_nav_color_all_hover']};";
				 }
				 if ($fields['iu_nav_bgc_all_hover']){
					 echo "background-color: {$fields['iu_nav_bgc_all_hover']};";
				 }
				echo '}';
			 }

			 if ( $fields['use_style_btn_status'] && ($fields['style_compl_color'] || $fields['style_compl_bgc'])){
				echo '.iu-filters-btn-wrap .iu_filters-post-comp.active,
					.iu-filters-btn-wrap .iu_filters-post-comp:hover {';

				if ($fields['style_compl_color']){
					echo "color: {$fields['style_compl_color']} !important;";
				}
				if ($fields['style_compl_bgc']){
					echo "border-color: {$fields['style_compl_bgc']} !important;";
					echo "background-color: {$fields['style_compl_bgc']} !important;";
				}
				echo '}';


				if ($fields['style_compl_bgc']){
					echo '.iu-filters-btn-wrap .iu_filters-post-comp {';
					echo "border-bottom-color: {$fields['style_compl_bgc']} !important;";
					echo '}';
				}
			 }

			 if ($fields['use_style_btn_status'] && ($fields['style_open_color'] || $fields['style_open_bgc'])){
				 echo '.iu-filters-btn-wrap .iu_filters-post-open.active,
						.iu-filters-btn-wrap .iu_filters-post-open:hover{';

				 if ($fields['style_open_color']){
					 echo "color: {$fields['style_open_color']} !important;";
				 }
				 if ($fields['style_open_bgc']){
					echo "border-color: {$fields['style_open_bgc']} !important;";
					echo "background-color: {$fields['style_open_bgc']} !important;";
				 }
				 echo '}';

				if ($fields['style_open_bgc']){
					echo '.iu-filters-btn-wrap .iu_filters-post-open {';
					echo "border-bottom-color: {$fields['style_open_bgc']} !important;";
					echo '}';
				}
			 }


			 if ($fields['use_style_btn_status'] && ($fields['style_reset_color'] || $fields['style_reset_bgc'])){
				 echo '.iu-filters-btn-wrap .iu-filters-reset.active,
						.iu-filters-btn-wrap .iu-filters-reset:hover{';

				 if ($fields['style_reset_color']){
					 echo "color: {$fields['style_reset_color']} !important;";
				 }
				 if ($fields['style_reset_bgc']){
					echo "border-color: {$fields['style_reset_bgc']} !important;";
					echo "background-color: {$fields['style_reset_bgc']} !important;";
				 }
				 echo '}';

				 if ($fields['style_reset_bgc']){
					echo '.iu-filters-btn-wrap .iu-filters-reset {';
					echo "border-bottom-color: {$fields['style_reset_bgc']} !important;";
					echo '}';
				 }
			 }

			 echo '.iu-posts-list-box {';
			 if ( $fields['filter_template'] === 'aside' ) {
				 echo 'display: flex;';
				 echo 'flex-wrap: wrap;';
			 }
			 if ( $fields['iu_margin_top'] > 0 ) {
				echo "margin-top: {$fields['iu_margin_top']}px !important;";
			 }
			 if ( $fields['iu_margin_bottom'] > 0 ) {
				echo "margin-bottom: {$fields['iu_margin_bottom']}px !important;";
			 }
			 echo '}';

			 echo '.btn-mob-filter {';
			 if ( $fields['mob_btn_bottom_pos'] > 0 ) {
				echo "bottom: {$fields['mob_btn_bottom_pos']}px;";
			 }
			 echo '}';

			 if ($fields['active_color']){
			 echo '.iu-posts-list-aside-radius-title p span,';
			 echo '.iu-aside-clear-tags {';
			 echo "color: {$fields['active_color']};";
			 echo '}';
			 }


			 ?>
         </style>

         <div class="block iu-projects-map">
		     <?php global $post; ?>

             <!--▼ this aside ▼-->
             <aside class="iu-projects-map-aside">
                 <div class="iu_location-filter-row">
                     <button type="button" class="iu-aside-clear-tags">
					     <?php echo __( 'Clear filters', 'instantup' ) ?>
                     </button>

                     <input type="text" id="iu_location_filter" autocomplete="off"
                            placeholder="<?php esc_attr_e( 'Enter a location or zip', 'instantup' ); ?>"
                            class="iu-projects-map-location-filter profolio-loc-input form-control js-filter-input">
                 </div>

                 <div class="iu-projects-map-filter-row">
                     <p class="iu-projects-map-aside-title">
					     <?php echo __( 'Filters:', 'instantup' ) ?>
                     </p>

                     <div class="iu-aside-term">
					     <?php $iu_categories = get_terms( array( 'taxonomy' => 'iu_categories' ) );
					     if ( $iu_categories && ! is_wp_error( $iu_categories ) ):
						     ?>
                             <div class="iu-aside-term-item">
                                 <p class="iu-aside-term-item-title">Categories</p>

                                 <span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-down">
                                        <svg width="14" height="7" viewBox="0 0 14 7" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.2788 0.964844L7.93208 5.31151C7.41875 5.82484 6.57875 5.82484 6.06542 5.31151L1.71875 0.964844"
                                          stroke="#004383" stroke-width="1.5" stroke-miterlimit="10"
                                          stroke-linecap="round" stroke-linejoin="round"></path>
                                 </svg>
                                    </span>
                                 <span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-up">
                                         <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                              xmlns="http://www.w3.org/2000/svg">
                                            <path d="M2.72125 10.0352L7.06792 5.68849C7.58125 5.17516 8.42125 5.17516 8.93458 5.68849L13.2812 10.0352"
                                                  stroke="#004383" stroke-width="1.5" stroke-miterlimit="10"
                                                  stroke-linecap="round"
                                                  stroke-linejoin="round"></path>
                                        </svg>
                                    </span>

                                 <div class="iu-aside-term-item-child-wrap">
								     <?php foreach ( $iu_categories as $item ) :
									     if ( $item->name ) : ?>
                                             <div class="iu-aside-term-item-child">
                                                 <input type="checkbox" class="aside-filter-cat-input"
                                                        autocomplete="off"
                                                        name="aside_filter_cat_<?php echo $item->term_id; ?>"
                                                        id="aside_filter_cat_<?php echo $item->term_id; ?>"
                                                        value="<?php echo $item->term_id; ?>">
                                                 <label for="aside_filter_cat_<?php echo $item->term_id; ?>"><?php echo $item->name; ?></label>
                                             </div>
									     <?php
									     endif;
								     endforeach; ?>
                                 </div>
                             </div>
					     <?php endif; ?>

					     <?php
					     $all_terms_name   = array();
					     $label_tags       = array();
					     $label_tags_terms = get_terms( array( 'taxonomy' => 'iu_label_tags' ) );

					     if ( $label_tags_terms && ! is_wp_error( $label_tags_terms ) ) {
						     foreach ( $label_tags_terms as $item => $term ) {
							     $all_terms_name[ $term->term_id ] = $term->name;

							     if ( $term->parent === 0 ) {
								     $label_tags[ $term->term_id ]['parent'] = $term->name;
								     continue;
							     }

							     if ( $term->parent !== 0 ) {
								     $label_tags[ $term->parent ]['children'][] = array(
									     $term->name,
									     $term->term_id,
								     );
							     }
						     }

						     foreach ( $label_tags as $key => $item ) {
							     if ( $item['children'] ) {
								     $parent = $item['parent'] ?? $all_terms_name[ $key ];

								     echo '<div class="iu-aside-term-item">';
								     echo '<p class="iu-aside-term-item-title">' . $parent . '</p>';
								     echo '<span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-down"><svg width="14" height="7" viewBox="0 0 14 7" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.2788 0.964844L7.93208 5.31151C7.41875 5.82484 6.57875 5.82484 6.06542 5.31151L1.71875 0.964844" stroke="#004383" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg></span>';
								     echo '<span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-up"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.72125 10.0352L7.06792 5.68849C7.58125 5.17516 8.42125 5.17516 8.93458 5.68849L13.2812 10.0352" stroke="#004383" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg></span>';
								     foreach ( $item['children'] as $child ) {
									     $label_tag = 'aside_filter_tag_' . $child[1];

									     echo '<div class="iu-aside-term-item-child-wrap">';
									     echo '<div class="iu-aside-term-item-child">';
									     echo '<input type="checkbox" class="aside-filter-tag-input" autocomplete="off" name="' . $label_tag . '" id="' . $label_tag . '" value="' . $child[1] . '"></input>';
									     echo '<label for="' . $label_tag . '">' . $child[0] . '</label>';
									     echo '</div>';
									     echo '</div>';
								     }
								     echo '</div>';
							     }
						     }
					     } ?>
                     </div>
                 </div>

                 <div class="iu-projects-map-aside-radius">
                     <p class="iu-projects-map-radius-title">Distance from:</p>

                     <form class="iu-projects-map-radius-row" oninput="iu_radius_output.value = iu_radius_filter.value">
                         <input id="iu_radius_filter" class="iu_radius-filter" autocomplete="off" type="range"
                                name="iu_radius_filter"
                                value="25" min="5" max="200" step="5">

                         <p class="iu_radius-filter_output">
                             <output name="iu_radius_output">25</output>
                             mile radius
                         </p>
                     </form>
                 </div>

                 <div class="btn-iu-group btn-mob-active-filter">
                     <button type="button" class="btn iu-mob-clear-filter">Clear all</button>
                     <button type="button" class="btn iu-mob-accept-filter">Done</button>
                 </div>

             </aside>
             <!--▲ this aside ▲-->

             <!--▼ this map ▼-->
		     <?php if ( ! $disable_maps && ! empty( $atts['locations'] ) ): ?>
                 <style>
                     .profolio_widget_map {
                         position: absolute;
                         top: <?php echo $fields['top_block'] ? "{$fields['top_block']}px;" : '0;'?>;
                         width: 100%;
                         max-height: 100%;
                         height: 450px;
                     }

                     @media (max-width: 589px) {
                         .profolio_widget_map {
                             position: relative;
                             height: 50vh;
                         }
                     }

                     .profolio_widget_map.bottom {
                         position: absolute !important;
                         top: auto;
                         bottom: 0;
                     }

                     .profolio_widget_map.fixed {
                         position: fixed !important;
                         top: 0;
                     }

                     .profolio_widget_map .gm-style .gm-style-iw-d {
                         padding-bottom: 15px;
                     }

                     #profolio_widget_map_<?php echo esc_attr( $salt ); ?> {
                         background-image: url("<?php echo INSTANTUP_URL; ?>data/assets/img/local-seo-map-logo.png") !important;
                         position: absolute;
                         top: 0;
                         right: 0;
                         z-index: 1000;
                         width: 81px;
                         height: 20px;
                         background-size: contain;
                         background-repeat: no-repeat;
                         margin: 10px;
                     }

                     #profolio_widget_map_<?php echo esc_attr( $salt ); ?> a {
                         display: block;
                         position: absolute;
                         width: 100%;
                         height: 100%;
                     }

                     <?php if ( $fields['iu_hide_map'] ): ?>
                     .iu-content-map-box {
                         flex-basis: 75% !important;
                         max-width: 75%;
                     }

                     <?php endif; ?>
                 </style>
                 <script>
				     <?php if ($fields['iu_hide_info_window']): ?>
                     window['iuHideInfoWindow'] = <?php echo $fields['iu_hide_info_window']?>;
				     <?php else:?>
                     window['iuHideInfoWindow'] = 0;
				     <?php endif;?>

				     <?php if (is_numeric( $atts['location'][0] ) && is_numeric( $atts['location'][1] ) ):?>
                     window['iuMapCenterLatLng'] = [
					     <?php echo $atts['location'][0]?>,
					     <?php echo $atts['location'][1]?>
                     ];
				     <?php endif;?>

                     window['iuMapOptions'] = '<?php echo base64_encode( json_encode( $atts ) ); ?>';
                 </script>
                 <script type="text/template" class="hidden" id="tmpl-profolio-infowindow-template">
                     <div class="profolio-map-pop">
                         <div class="profolio-card-image-frame">
                             <a href="{{{data.link}}}" class="profolio-card-cover-sm">
                                 {{{data.image}}}
                             </a>
                         </div>
                         <div class="profolio-card-descr">
                             <a href="{{{data.link}}}" class="profolio-header-xxs">{{{data.title}}}</a>
                         </div>
                     </div>
                 </script>

                 <div class="iu-content-map-box">
                     <div class="profolio-map-wrapper">
					     <?php if ( $this->is_admin() ): ?>
                             <div class="block-map-loading" style="text-align:center;">
                                 <img src="<?php echo INSTANTUP_URL; ?>data/assets/img/ajax-loader.gif" alt="loader">
                                 <p style="font-size: 18px;margin-bottom: 0;">Map loading</p>
                             </div>
					     <?php endif; ?>

                         <div id="iu_map_locations" class="profolio_widget_map JS_profolio_map"></div>

					     <?php if ( $this->is_admin() ): ?>
                             <template>
                                 <p data-iuHideInfoWindow="<?php echo $fields['iu_hide_info_window'] ?: 0; ?>"
                                    data-iuMapCenterLatLng="<?php echo json_encode( $atts['location'] ); ?>"
                                    data-iuMapOptions="<?php echo base64_encode( json_encode( $atts ) ); ?>"></p>
                             </template>
					     <?php endif; ?>
                     </div>
                 </div>
		     <?php endif; ?>
             <!--▲ this map ▲-->

             <!--▼ this content ▼-->
             <div id="iu_posts_block" class="block__content iu-projects-map-cnt-wrap"
                  data-parent-id="<?php echo get_the_ID(); ?>"
                  data-per-page="<?php echo $fields['iu_posts_per_page'] ?: 26; ?>"
                  data-post-type="<?php echo implode( ',', $post_type ) ?>"
                  data-current-page="<?php echo get_query_var( 'paged' ) ?: 1 ?>"
                  data-slug="<?php echo $post->post_name; ?>"
             >
                 <div class="iu-projects-map-cnt">

				     <?php
				     $settings_columns = $fields['iu_settings_columns'];
				     $pic_set_size     = $fields['iu_pic_set_size'];
				     $pic_set_image    = $fields['iu_pic_set_image'];
				     $show_post_title  = $fields['iu_show_post_title'];

				     if ( $settings_columns === '1' ) {
					     $column = 12;
				     } elseif ( $settings_columns === '2' ) {
					     $column = 6;
				     } elseif ( $settings_columns === '3' ) {
					     $column = 4;
				     } elseif ( $settings_columns === '4' ) {
					     $column = 3;
				     } else {
					     $column = 6;
				     }

				     foreach ( $posts as $post ) :
					     setup_postdata( $post );
					     $latitude  = get_post_meta( $post->ID, $this->prefix() . 'latitude', true );
					     $longitude = get_post_meta( $post->ID, $this->prefix() . 'longitude', true );
					     ?>
                         <div class="profolio-col-xs-12 profolio-col-md-<?php echo $column; ?> JS_profolio_project_item"
                              data-latlong="<?php echo esc_attr( $latitude . ',' . $longitude ); ?>"
                              data-post-id="<?php the_ID(); ?>">

                             <div class="profolio-project-card">
                                 <div class="profolio-card-image-frame">
                                     <a <?php echo $parent_post_id ? 'href="' . get_permalink() . '"' : ''; ?>
                                             class="profolio-card-cover">
									     <?php if ( has_post_thumbnail() ) :
										     echo get_the_post_thumbnail( $post->ID, $pic_set_size ?? 'medium' );
									     else:
										     if ( $pic_set_image ):
											     $link = wp_get_attachment_image_url( $pic_set_image, $pic_set_size ?? 'medium' );
											     echo '<img src="' . $link . '" alt="photo">';
										     else:
											     echo '<img src="' . INSTANTUP_URL . 'data/assets/img/placeholder.png' . '" class="no-pic" alt="no-photo">';
										     endif;
									     endif; ?>
                                     </a>
                                 </div>

                                 <div class="profolio-card-descr">
								     <?php if ( isset( $show_post_title ) && $show_post_title ) :
									     $link_href = $parent_post_id ? 'href="' . get_permalink() . '"' : '';

									     echo '<a ' . $link_href . ' class="profolio-header-xs">' . get_the_title() . '</a>';
								     endif; ?>
                                 </div>
                             </div>
                         </div>
				     <?php endforeach; ?>
                 </div>

			     <?php if ( $query->max_num_pages > 1 ): ?>
                     <div class="profolio-row">
                         <div class="profolio-col-12 text-center profolio-pagination">
                             <nav><?php echo paginate_links( array(
								     'total'     => $query->max_num_pages,
								     'current'   => max( 1, get_query_var( 'paged' ) ),
								     'show_all'  => false,
								     'type'      => 'list',
								     'end_size'  => 1,
								     'mid_size'  => 1,
								     'prev_next' => false,
							     ) );
							     ?></nav>
                         </div>
                     </div>
			     <?php
			     endif;

			     wp_reset_postdata();
			     ?>
             </div>
             <!--▲ this content ▲-->

         </div><!-- .block -->

	     <?php if ( $fields['use_filters'] ) { ?>
             <script>
                 window['iu_filters_arg'] = <?php echo json_encode( $filters_arr )?>
             </script>
	     <?php }
     } );