<?php
/**
 * iu-swiper.php
 * create in 26.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Media Carousel' ) )
     ->add_tab( __( 'Image settings' ), array(
	     Field::make( 'text', 'iu_carousel_img_height', __( 'Image height' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right iu_carousel_click iu_carousel_height' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 110',
	          ) ),

	     Field::make( 'text', 'iu_carousel_spacing', __( 'Image spacing' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu_carousel_click iu_carousel_spacing' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),

	     Field::make( 'select', 'iu_slides_per_view', __( 'Slides Per View' ) )
	          ->set_classes( 'iu-blocks-margin_right iu_carousel_click iu_carousel_per_view' )
	          ->set_width( 45 )
	          ->set_options( array(
		          '' => 'Default',
	          ) )
	          ->add_options( array(
		          '1'  => 1,
		          '2'  => 2,
		          '3'  => 3,
		          '4'  => 4,
		          '5'  => 5,
		          '6'  => 6,
		          '7'  => 7,
		          '8'  => 8,
		          '9'  => 9,
		          '10' => 10,
	          ) ),

	     Field::make( 'select', 'iu_slides_to_scroll', __( 'Slides to Scroll' ) )
	          ->set_classes( 'iu_carousel_click iu_carousel_to_scroll' )
	          ->set_width( 45 )
	          ->set_options( array(
		          '' => 'Default',
	          ) )
	          ->add_options( array(
		          '1'  => 1,
		          '2'  => 2,
		          '3'  => 3,
		          '4'  => 4,
		          '5'  => 5,
		          '6'  => 6,
		          '7'  => 7,
		          '8'  => 8,
		          '9'  => 9,
		          '10' => 10,
	          ) ),

	     Field::make( 'checkbox', 'iu_show_img_title', '' )
	          ->set_classes( 'iu-separator-margin iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Media Title (show/hide)' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_show_img_caption', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Media Caption (show/hide)' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_show_img_desc', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Media Description (show/hide)' )
	          ->set_option_value( 'yes' ),

     ) )
     ->add_tab( __( 'Customize Title' ), array(
	     Field::make( 'checkbox', 'iu_hidden_title', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Title (show/hide)' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' ),

	     Field::make( 'text', 'main_title', 'Title' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hidden_title',
			          'value' => false,
		          ),
	          ) )
	          ->set_attribute( 'placeholder', 'Look inside' ),

	     Field::make( 'color', 'main_title_color', __( 'Color' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hidden_title',
			          'value' => false,
		          ),
	          ) )
	          ->set_default_value( '#212529' ),

	     Field::make( 'text', 'main_title_size', __( 'Font Size (px)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hidden_title',
			          'value' => false,
		          ),
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) ),

	     Field::make( 'text', 'main_title_lh', __( 'Line Height (px)' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hidden_title',
			          'value' => false,
		          ),
	          ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) ),
     ) )
     ->add_tab( __( 'Customize Button' ), array(
	     Field::make( 'checkbox', 'buttons_inside', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_help_text( 'Buttons Inside' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'btn_transparent', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_help_text( 'Background Transparent' ),

	     Field::make( 'color', 'btn_color_inactive', __( 'Color no active' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'btn_transparent',
			          'value' => false,
		          ),
	          ) ),

	     Field::make( 'color', 'btn_color_active', __( 'Color active' ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'btn_transparent',
			          'value' => false,
		          ),
	          ) )
	          ->set_default_value( '#0274be' ),

	     Field::make( 'text', 'btn_width', __( 'Button width' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 40',
	          ) ),

	     Field::make( 'text', 'btn_height', __( 'Button height' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 40',
	          ) ),
	     Field::make( 'text', 'btn_font_size', __( 'Size' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) ),
	     Field::make( 'text', 'btn_bdrs', __( 'Border Radius' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 3',
	          ) ),
     ) )
     ->add_tab( __( 'Customize Pagination' ), array(
	     Field::make( 'checkbox', 'iu_hidden_pagination', '' )
	          ->set_classes( 'iu-blocks-margin_right iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Pagination' ) )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $count             = 0;
	     $entropy           = uniqid();
	     $media_list        = array();
	     $post_id           = get_the_ID() ?: get_option( '_temp_post_for_templates' );
	     $pic_for_post      = get_post_meta( $post_id, $this->prefix() . 'pic_for_post1', true ) ?: [];
	     $pic_count         = 0;
	     $carousel_settings = array(
		     'slidesPerView'  => (int) $fields['iu_slides_per_view'],
		     'spaceBetween'   => (int) $fields['iu_carousel_spacing'],
		     'slidesPerGroup' => (int) $fields['iu_slides_to_scroll'],
	     );

	     if ( $pic_for_post && is_array( $pic_for_post ) ) {
		     $pic_count = count( $pic_for_post );
	     }

	     if ( $pic_count ) : ?>
             <style>
                 <?php
					if ( $fields['iu_carousel_img_height'] ){
						echo '.block__content .profolio-gal-frame {';
						echo "height:{$fields['iu_carousel_img_height']}px !important;";
						echo "max-height:{$fields['iu_carousel_img_height']}px !important;";
						echo '}';
					}

					 if ($fields['main_title_size'] || $fields['main_title_lh'] || $fields['main_title_color'] ){
						 echo '.block__content .profolio-section-title-sm b {';
						 if ( $fields['main_title_size'] ){
							echo "font-size: {$fields['main_title_size']}px;";
						 }
						 if ( $fields['main_title_lh'] ){
							 echo "line-height: {$fields['main_title_lh']}px;";
						 }
						 if ( $fields['main_title_color'] ){
							 echo "color: {$fields['main_title_color']};";
						 }
						 echo '}';
					 }

					 if ($fields['btn_width'] || $fields['btn_height'] || $fields['btn_color_active'] || ($fields['btn_bdrs'] || $fields['btn_bdrs'] === '0') || $fields['btn_transparent'] ){
						 echo '.block__content .profolio-button-next, .block__content .profolio-button-prev {';
						 if ( $fields['btn_width'] ){
							 echo 'width: '. $fields['btn_width'] .'px;';
						 }
						 if ( $fields['btn_height'] ){
							 echo 'height: '. $fields['btn_height'] .'px;';
						 }
						 if ( $fields['btn_color_active'] && !$fields['btn_transparent'] ){
							 echo 'background-color: '. $fields['btn_color_active'] .';';
						 }
						 if ($fields['btn_transparent']){
							 echo "background-color: transparent;";
						 }
						 if ( $fields['btn_bdrs'] || $fields['btn_bdrs'] === '0' ){
							 echo 'border-radius: '. $fields['btn_bdrs'] .'px;';
						 }
						 }
					 echo '}';

					 if ( $fields['btn_font_size'] ){
						 echo '.profolio-button-next i, .profolio-button-prev i {';
						 echo 'font-size: '. $fields['btn_font_size'] .'px;';
						 echo '}';
					 }

					 if ( $fields['btn_color_inactive'] && !$fields['btn_transparent'] ){
						 echo '.block__content .swiper-button-disabled {';
						 echo 'background-color: '. $fields['btn_color_inactive'] .';';
						 echo '}';
					 }

					echo '.block__content .iu-carousel-title {';
					 if ( $fields['iu_show_img_title'] ){
						 echo 'display: block; !important';
					 } else{
						 echo 'display: none;';
					 }
					 echo '}';
				  ?>

             </style>

             <div class="block">
                 <div class="block__content iu-carousel-block">

                     <div class="profolio-row justify-content-between <?php echo $pic_count > 3 ? '' : 'mb30'; ?>">
					     <?php if ( ! $fields['iu_hidden_title'] ): ?>
                             <div class="profolio-col-7 profolio-col-sm-6 profolio-col-md-8">
                                 <div class="profolio-section-title-sm">
                                     <b>
									     <?php echo $fields['main_title'] ?: esc_html__( 'Look inside',
										     'instantup' ); ?>
                                     </b>
                                 </div>
                             </div>
					     <?php endif; ?>

					     <?php if ( ( is_array( $pic_for_post ) && $pic_count >= 3 ) && ! $fields['buttons_inside'] ) : ?>
                             <div class="profolio-col-5 align-self-center mb30 <?php echo $fields['iu_hidden_title'] ? '' : 'profolio-col-md-3'; ?>">
                                 <div class="profolio-arrows-wraper">
                                     <div class="profolio-button-prev">
                                         <i class="pro_fa pro_fa-chevron-left"></i>
                                     </div>

                                     <div class="profolio-button-next">
                                         <i class="pro_fa pro_fa-chevron-right"></i>
                                     </div>
                                 </div>
                             </div>
					     <?php endif; ?>
                     </div>

                     <div class="swiper-container profolio-swiper-details"
                          data-media-ogj="iu_carousel_<?php echo $entropy ?>">
					     <?php if ( ( is_array( $pic_for_post ) && $pic_count >= 3 ) && $fields['buttons_inside'] ) : ?>
                             <div class="profolio-arrows-wraper iu-btn-inside">
                                 <div class="profolio-button-prev">
                                     <i class="pro_fa pro_fa-chevron-left"></i>
                                 </div>

                                 <div class="profolio-button-next">
                                     <i class="pro_fa pro_fa-chevron-right"></i>
                                 </div>
                             </div>
					     <?php endif; ?>

                         <div class="iu_use_lightGallery swiper-wrapper js-profolio-filter-wrapper">
						     <?php foreach ( $pic_for_post as $index => $pic ) :
							     try {
								     $pic_id           = $pic['id'] ?? $pic;
								     $file_name        = basename( wp_get_attachment_url( $pic_id ) );
								     $path_file        = get_attached_file( $pic_id );
								     $file_type        = wp_check_filetype_and_ext( $file_name, $path_file );
								     $post_img         = get_post( $pic_id, ARRAY_A );
								     $alt_text         = get_post_meta( $pic_id, '_wp_attachment_image_alt',
									     true ) ?: $post_img['post_title'];

								     ob_start();
								     if ( $file_type['type'] === 'video/mp4' ) :
									     $background_thumb = '';
									     $thumb_id     = (int) get_post_meta( $pic_id, 'iu-thumb', true );

									     if ( $thumb_id ) {
										     $thumb            = wp_get_attachment_image_url( $thumb_id, 'large' );
										     $background_thumb = 'style="background-image:url(' . $thumb . ');"';
									     } else {
										     $thumb = INSTANTUP_URL . 'data/assets/img/video_cover.png';
									     }

									     $media_list[] = array(
										     'html'  => "#iu_carousel_video_{$entropy}_{$count}",
										     'thumb' => $thumb,
									     );
									     ?>

                                         <div style="display:none;"
                                              id="iu_carousel_video_<?php echo "{$entropy}_{$count}"; ?>">
                                             <video class="lg-video-object lg-html5" controls preload="none">
                                                 <source
                                                         src="<?php echo wp_get_attachment_url( $pic_id ); ?>"
                                                         type="video/mp4">
                                             </video>
                                         </div>

                                         <a class="profolio-slctr" data-id="<?php echo $count; ?>">
                                             <div class="profolio-video-preview"
                                                  data-html="#iu_carousel_video_<?php echo "_{$entropy}_{$count}"; ?>"
											     <?php echo $background_thumb; ?> >
                                                 <i class="pro_far pro_fa-play-circle"></i>
                                             </div>
                                         </a>

								     <?php else :
									     $thumb = wp_get_attachment_image_url( $pic_id );
									     $media_list[] = array(
										     'src'   => wp_get_attachment_image_url( $pic_id, 'full' ),
										     'thumb' => wp_get_attachment_image_url( $pic_id ),
									     );

									     if ( $fields['iu_show_img_title'] && $post_img['post_title'] ) {
										     $media_list[ $index ]['subHtml'] .= "<p class='iu-carousel-title2'>{$post_img['post_title']}</p>";
									     }

									     if ( $fields['iu_show_img_caption'] && $post_img['post_excerpt'] ) {
										     $media_list[ $index ]['subHtml'] .= "<p class='iu-carousel-info'>{$post_img['post_excerpt']}</p>";
									     }

									     if ( $fields['iu_show_img_desc'] && $post_img['post_content'] ) {
										     $media_list[ $index ]['subHtml'] .= "<p class='iu-carousel-info'>{$post_img['post_content']}</p>";
									     }
									     ?>
                                         <a class="profolio-slctr" <?php echo get_the_ID() ? "data-id='{$count}'" : ''; ?> >
                                             <div class="profolio-gal-frame">
											     <?php $img_src = wp_get_attachment_image_url( $pic_id, 'full' ); ?>
                                                 <img
                                                         src="<?php echo $img_src ?>"
                                                         class="profolio-bg-img"
                                                         alt="<?php echo $alt_text; ?>">

                                                 <div class="iu-carousel-title">
												     <?php echo $post_img['post_title'] ?>
                                                 </div>

                                                 <div class="profolio-img-hover">
                                                     <i class="pro_fa pro_fa-search-plus"></i>
                                                 </div>
                                             </div>
                                         </a>
								     <?php endif;
								     $html = ob_get_clean();
								     ?>
                                     <div class="swiper-slide profolio-isotope__item js-profolio-filter-item"
                                          data-src="<?php echo $thumb; ?>">
									     <?php echo $html; ?>
                                     </div>
								     <?php
							     } catch ( Exception $e ) {}

							     $count ++;
						     endforeach; ?>
                         </div>

					     <?php if ( ! $fields['iu_hidden_pagination'] ): ?>
                             <div
                                     class="swiper-pagination"<?php echo get_the_ID() ? '' : 'style="display:none;"'; ?>></div>
					     <?php endif; ?>
                     </div>

				     <?php
				     if ( $media_list ) {
					     wp_localize_script(
						     'iu-main-script',
						     "iu_carousel_{$entropy}",
						     array( 'media_list' => json_encode( $media_list ) )
					     );
				     }

				     if ( array_sum( $carousel_settings ) > 0 ) {
					     wp_localize_script(
						     'iu-main-script',
						     'iu_carousel_data',
						     array( 'carousel_settings' => json_encode( $carousel_settings ) )
					     );
				     }
				     ?>
                 </div>
             </div>
	     <?php
	     endif;
     } );