<?php
/**
 * iu-tags.php
 * create in 26.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;


Block::make( __( 'IU Tags' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'checkbox', 'only_smart_tags', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( __( 'Show only smart tags' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block iu-blocks-margin_right' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() )
	          ->set_width( 45 ),

	     Field::make( 'select', 'iu_style_block', __( 'Choose Style Block' ) )
	          ->set_default_value( 'standard' )
	          ->set_options( array(
		          'standard' => 'Standard',
		          'modern'   => 'Modern',
		          'column'   => 'Column',
	          ) )
	          ->set_width( 45 ),

     ) )
     ->add_tab( __( 'Title' ), array(
	     Field::make( 'checkbox', 'iu_hidden_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide All Title' ) ),

	     Field::make( 'checkbox', 'iu_hidden_title_txt', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Text' ) ),

	     Field::make( 'checkbox', 'iu_hide_colon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Colon' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_hide_icon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Icon' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_underline_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Underline' ) )
	          ->set_option_value( 'yes' ),


	     Field::make( 'color', 'color_title', __( 'Color For Title' ) )
	          ->set_default_value( '#8c8c93' ),

	     Field::make( 'text', 'title_txt', __( 'Text For Title' ) )
	          ->set_attributes( array(
		          'placeholder' => 'Title Tags',
	          ) ),


	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 11',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'select', 'font_weight', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'select', 'iu_style_letters', __( 'Choose Style Letter' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_default_value( 'uppercase' )
	          ->set_options( array(
		          'none'      => 'Default',
		          'uppercase' => 'Uppercase',
		          'lowercase' => 'Lowercase',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_top', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 10',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Links' ), array(
	     Field::make( 'color', 'color_title_link', __( 'Color For Links' ) )
	          ->set_default_value( '#8c8c93' ),
	     Field::make( 'text', 'font_size_link', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'select', 'font_weight_link', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'  => __( 'light' ),
		          'bold' => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_link', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 23',
	          ) ),
	     Field::make( 'text', 'margin_top_link', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_link', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $post_id             = get_the_ID();
	     $taxonomy_label_tags = $this->prefix_t() . '_label_tags';
	     $taxonomy_old_tags   = $this->prefix_t() . '_tags';
	     $get_font            = isset( $fields['select_fonts'] ) ? explode( ':', $fields['select_fonts'] ) : false;
	     $label_tags_raw      = get_the_terms( $post_id, $taxonomy_label_tags );
	     $tags__raw           = get_the_terms( $post_id, $taxonomy_old_tags );
	     $all_tags            = array();

	     if (is_array($label_tags_raw)){
		     $all_tags = array_merge($all_tags, $label_tags_raw);
	     }
	     if (is_array($tags__raw)){
		     $all_tags = array_merge($all_tags, $tags__raw);
	     }
	     ?>

	     <style>
		     <?php
			 if ($get_font){
				echo '.iu-tags-block .block__content .iu-tags-block-title, .block__content .profolio-card-area-frame a {';
				echo "font-family: '{$get_font[0]}', Sans-serif !important;";
				echo '}';
			 }


			 if ($fields['font_size'] || $fields['line_height'] || $fields['color_title'] ||
			  $fields['margin_top'] || $fields['margin_bottom'] ){
				 echo '.block__content .iu-tags-block-title {';
				 if ( $fields['font_size'] ){
					 echo "font-size: {$fields['font_size']}px;";
				 }
				 if ( $fields['font_weight'] ){
					 echo "font-weight: {$fields['font_weight']};";
				 }
				 if ( $fields['line_height'] ){
					 echo "line-height: {$fields['line_height']}px;";
				 }
				 if ( $fields['color_title'] ){
					 echo "color: {$fields['color_title']};";
				 }
				 if ( $fields['iu_style_letters'] ){
					 echo "text-transform: {$fields['iu_style_letters']};";
				 }
				 if ( $fields['margin_top'] ){
					 echo "margin-top: {$fields['margin_top']}px;";
				 }
				 if ( $fields['margin_bottom'] ){
					 echo "margin-bottom: {$fields['margin_bottom']}px;";
				 }
				 echo '}';
			 }

			 if ($fields['margin_top_link'] || ($fields['margin_bottom_link'] === '0' || (int)$fields['margin_bottom_link'] > 0) ){
				echo '.profolio-card-area-frame, .iu-tags-links {';
				if ($fields['margin_top_link']){
					echo "margin-top: {$fields['margin_top_link']}px !important;";
				}
				if ($fields['margin_bottom_link']){
					echo "margin-bottom: {$fields['margin_bottom_link']}px !important;";
				}
				echo '}';
			 }

			 if ($fields['font_size_link'] || $fields['color_title_link'] || $fields['line_height_link'] ){
				echo '.block__content .profolio-card-area-frame a, .block__content .iu-tags-links a {';
				if ($fields['font_size_link']){
					echo "font-size: {$fields['font_size_link']}px;";
				}
				if ($fields['font_weight_link']){
					echo "font-weight: {$fields['font_weight_link']};";
				}
				if ($fields['line_height_link']){
					echo "line-height: {$fields['line_height_link']}px;";
				}
				if ($fields['color_title_link']){
					echo "color: {$fields['color_title_link']};";
				}
				echo '}';
			 }

			 if ($fields['color_title_link']){
				echo '.profolio-card-area-frame a:hover, .iu-tags-links a:hover {';
				echo "color: {$fields['color_title_link']};";
				echo '}';
			 }

			 if ($fields['iu_style_block'] === 'modern'){ ?>
             .iu-tags-block .block__content {
                 display: inline-flex;
                 align-items: center;
                 border-bottom: 1px solid #E4E4EF;
                 padding-bottom: 12px;
             }

             .iu-tags-block .iu-tags-block-title {
                 margin-right: 16px;
                 margin-bottom: 0;
             }

             .iu-tags-block .profolio-text-sm {
                 font-size: 20px;
                 color: #4F4F4F;
             }

             .iu-tags-block .iu-tags-block-title hr {
                 display: none;
             }

             .iu-tags-block .profolio-card-area-frame {
                 display: flex;
             }

             .iu-tags-block .profolio-card-area-frame a,
             .iu-tags-block .iu-tags-links li {
                 width: auto;
                 flex-basis: auto;
                 min-width: 72px;
                 padding: 5px 12px;
                 border: 1px solid #0078FF;
                 border-radius: 8px;
                 margin-right: 8px;
                 margin-bottom: 5px !important;
                 transition: all 200ms linear;
             }
             .iu-tags-block .profolio-card-area-frame a:hover,
             .iu-tags-block .iu-tags-links li:hover {
                 color: #fff;
                 background-color: #0078FF;
             }
             .iu-tags-block .iu-tags-links li:hover a {
                 color: #fff;
             }
             .iu-tags-block .profolio-card-area-frame a:hover,
             .iu-tags-block .iu-tags-links li a:hover {
                 text-decoration: none;
             }
             .iu-tags-block .profolio-card-area-frame a:last-child,
             .iu-tags-block .iu-tags-links li:last-child {
                 margin-right: 25px;
             }
		     <?php }

			 ?>
	     </style>

	     <div class="block iu-tags-block">
         <div class="block__content mb30">
		     <?php
		     $html_title = '';

		     if ( isset( $fields['iu_hidden_title'] ) && ! $fields['iu_hidden_title'] ) {
			     if ( isset( $fields['iu_hidden_title_txt'] ) && ! $fields['iu_hidden_title_txt'] ) {
				     $title = esc_html__( 'Tags', 'instantup' );

				     if ( isset( $fields['title_txt'] ) && ! empty( $fields['title_txt'] ) ) {
					     $title = $fields['title_txt'];
				     }
			     }
			     else {
				     $title = '';
			     }

			     ob_start();

			     echo '<div class="iu-tags-block-title profolio-text-sm">';

			     if ( ! $fields['iu_hide_icon'] ):
				     echo '<i class="pro_fa pro_fa-list"></i>';
			     endif;

			     echo $fields['iu_hide_colon'] ? $title : $title . ':';

			     if ( ! $fields['iu_underline_title'] ):
				     echo '<hr>';
			     endif;

			     echo '</div>';

			     $html_title = ob_get_clean();
		     }

		     if ( $post_id && ! empty( $all_tags ) ) {
			     echo $html_title;

			     if ( $fields['only_smart_tags'] ) {
				     echo '<div class="profolio-card-area-frame">';
				     foreach ( $all_tags as $tag ) :
					     if ( get_term_meta( $tag->term_id, 'smart_tag', true ) ):
						     $format = '<a href="%s" rel="tag">%s</a>';
						     printf( $format, get_term_link( (int) $tag->term_id, $tag->taxonomy ), $tag->name );
					     endif;
				     endforeach;
				     echo '</div>';
			     }
                 elseif ( isset( $fields['iu_style_block'] ) ) {
				     if ( $fields['iu_style_block'] !== 'column' ):
					     echo '<ul class="iu-tags-links">';
					     foreach ( $all_tags as $tag ) :
						     echo '<li>';
						     echo "<a href='" . get_term_link( $tag->term_id, $tag->taxonomy ) . "'>{$tag->name}</a>";
						     echo '</li>';
					     endforeach;
					     echo '</ul>';
				     endif;

				     if ( $fields['iu_style_block'] === 'column' ):
					     echo '<div class="profolio-row iu-tags-style-column">';
					     foreach ( $this->get_partition( $all_tags, 4 ) as $i => $tag_items ) :
						     echo '<div class="profolio-col-3">';

						     foreach ( $tag_items as $tag ) :
							     echo "<a href='" . get_term_link( $tag->term_id, $tag_items->taxonomy ) . "'>{$tag->name}</a>";
						     endforeach;

						     echo '</div>';
					     endforeach;
					     echo '</div>';
				     endif;
			     }
		     }

		     if ( ! is_singular() ) {
			     echo $html_title; ?>

			     <?php if ( $fields['iu_style_block'] !== 'column' ) { ?>
                 <div class="profolio-card-area-frame">
                   <a href="#" rel="tag">Tag 1</a>
                   <a href="#" rel="tag">Tag 2</a>
                   <a href="#" rel="tag">Tag 3</a>
                 </div>
			     <?php } ?>

			     <?php if ( $fields['iu_style_block'] === 'column' ) { ?>
                 <div class="profolio-row iu-tags-style-column">
                   <div class="profolio-col-3">
                     <a href='#'>Tag or Category name</a>
                   </div>
                   <div class="profolio-col-3">
                     <a href='#'>Tag or Category name</a>
                   </div>
                   <div class="profolio-col-3">
                     <a href='#'>Tag or Category name</a>
                   </div>
                   <div class="profolio-col-3">
                     <a href='#'>Tag or Category name</a>
                   </div>
                 </div>
			     <?php } ?>

		     <?php } ?>

         </div>
	     </div>
	     <?php
     } );