<?php


namespace InstantUploader;

if ( ! defined( 'WPINC' ) ) {
	die;
}

class Cron {

	public function __construct() {
	}

	public function prefix() {
		$admin = new Admin();

		return $admin::get_type_prefix();//iu
	}

	public function init() {
		add_filter( 'cron_schedules', array( $this, 'cron_add_schedules' ) );

		add_action( $this->prefix() . '_init_send_data', array( $this, 'send_data' ) );
		add_action( $this->prefix() . '_init_del_duplicate', array( $this, 'del_duplicate' ) );
		add_action( $this->prefix() . '_init_re_export', array( $this, 're_export_event' ), 10, 1 );
	}


	public function cron_add_schedules( $schedules ) {
		$schedules['1_hour'] = array(
			'interval' => 3600,
			'display'  => '1 hour',
		);

		$schedules['2_min'] = array(
			'interval' => 120,
			'display'  => 'two min',
		);

		return $schedules;
	}

	public function init_cron() {
		wp_clear_scheduled_hook( $this->prefix() . '_init_send_data' );
		wp_clear_scheduled_hook( $this->prefix() . '_init_del_duplicate' );

		wp_schedule_event( time(), '1_hour', $this->prefix() . '_init_send_data' );
		wp_schedule_event( time(), '2_min', $this->prefix() . '_init_del_duplicate' );
	}

	public function terminate_cron() {
		wp_clear_scheduled_hook( $this->prefix() . '_init_send_data' );
		wp_clear_scheduled_hook( $this->prefix() . '_init_del_duplicate' );

		remove_action( $this->prefix() . '_init_send_data', 'send_data' );
		remove_action( $this->prefix() . '_init_del_duplicate', 'del_duplicate' );
	}


	public function send_data() {
		$user_activity = new User_Activity();
		$user_activity->send_data();
	}

	public function re_export_event( $name ) {
		if ( $export_data = json_decode( get_transient( $name ), true ) ) {
			$export = new Importer();
			$export->export_saas_data( $export_data['data'], true );
		}
	}

	public function del_duplicate() {
		if ( get_transient( $this->prefix() . '_post_changed' ) && $post_type = get_option( '_iu_custom_type_slug' ) ) {
			$query = new \WP_Query( array(
				'post_type'      => $post_type,
				'date_query'     => array(
					'after' => '2 days ago',
				),
				'posts_per_page' => - 1,
			) );

			if ( $query->posts > 1 ) {
				$postsData = $query->posts;
				$search    = array();
				$meta_key  = $this->prefix() . '-uid';

				//debag
				$admin = new Admin();
				$admin->write_log( 'DATE: ' . date( 'Y-m-d H:i:s P' ), 'del_duplicate.txt' );

				for ( $i = 0, $c = $query->post_count; $i < $c; $i ++ ) {
					$search[] = array_shift( $postsData );

					foreach ( $postsData as $project ) {
						$one_id    = get_post_meta( $search[ $i ]->ID, $meta_key, true );
						$second_id = get_post_meta( $project->ID, $meta_key, true );

						if ( $one_id === $second_id && $search[ $i ]->post_type === $project->post_type ) {
							$admin->write_log( "one_id: {$one_id}, title: {$search[ $i ]->post_title}", 'del_duplicate.txt' );
							$admin->write_log( "second_id: {$second_id}, title: {$project->post_title}", 'del_duplicate.txt' );
							$admin->write_log( '---------------', 'del_duplicate.txt' );

							wp_delete_post( $project->ID );
							unset( $postsData[ $i ] );
						}
					}
				}

			}
			wp_reset_query();
		}
	}


}