<?php
/**
 * create in 22.12.2021
 * SAYri
 *
 */

class Elementor_Testimonials_Widget extends \Elementor\Widget_Base {

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		wp_register_script(
			'script-for-masonry',
			INSTANTUP_URL . 'data/assets/back-and-front/js/elementor-masonry.js',
			array( 'elementor-frontend', 'iu_masonry' ),
			INSTANTUP_VERSION,
			true
		);
	}

	public function get_script_depends() {
		return [ 'script-for-masonry' ];
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve list widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 */
	public function get_name() {
		return 'iu_testimonials';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve list widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 */
	public function get_title() {
		return esc_html__( 'Testimonials', 'instantup' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve list widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 */
	public function get_icon() {
		return 'instantuploader-icon';
	}

	/**
	 * Get custom help URL.
	 *
	 * Retrieve a URL where the user can get more information about the widget.
	 *
	 * @return string Widget help URL.
	 * @since 1.0.0
	 * @access public
	 */
	public function get_custom_help_url() {
		return 'https://developers.elementor.com/widgets/';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the list widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 */
	public function get_categories() {
		return [ 'instantuploader' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the list widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 1.0.0
	 * @access public
	 */
	public function get_keywords() {
		return [ 'testimonial', 'testimonials', 'post' ];
	}

	public function get_iu_terms( $options = array() ) {
		$terms    = array();
		$defaults = array(
			'taxonomy' => array( 'iu_categories', 'iu_tags' ),
		);

		$args = wp_parse_args( $options, $defaults );

		foreach ( get_terms( $args ) as $term ) {
			$terms[ $term->term_id ] = $term->name;
		}

		return $terms;
	}

	/**
	 * Register list widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		#TAB_CONTENT
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Testimonials Content', 'instantup' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		#filters
		$this->add_control(
			'filter_options',
			[
				'label'     => esc_html__( 'Filter on:', 'instantup' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'has_video',
			[
				'label'   => esc_html__( 'Has video', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'either',
				'options' => [
					'either' => esc_html__( 'Either', 'instantup' ),
					'yes'    => esc_html__( 'Yes', 'instantup' ),
					'no'     => esc_html__( 'No', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'has_description',
			[
				'label'   => esc_html__( 'Has Description', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'either',
				'options' => [
					'either' => esc_html__( 'Either', 'instantup' ),
					'yes'    => esc_html__( 'Yes', 'instantup' ),
					'no'     => esc_html__( 'No', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'has_customer_name',
			[
				'label'   => esc_html__( 'Has Customer Name', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'either',
				'options' => [
					'either' => esc_html__( 'Either', 'instantup' ),
					'yes'    => esc_html__( 'Yes', 'instantup' ),
					'no'     => esc_html__( 'No', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'has_customer_photo',
			[
				'label'   => esc_html__( 'Has Customer Photo', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'either',
				'options' => [
					'either' => esc_html__( 'Either', 'instantup' ),
					'yes'    => esc_html__( 'Yes', 'instantup' ),
					'no'     => esc_html__( 'No', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'rating_filter',
			[
				'label'   => esc_html__( 'Show Only:', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				//'default' => '',
				'options' => [
					'All Stars',
					esc_html__( '1 stars and up', 'instantup' ),
					esc_html__( '2 stars and up', 'instantup' ),
					esc_html__( '3 stars and up', 'instantup' ),
					esc_html__( '4 stars and up', 'instantup' ),
					esc_html__( '5 stars', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'show_categories',
			[
				'label'    => esc_html__( 'Show Categories:', 'instantup' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options'  => $this->get_iu_terms( array( 'taxonomy' => 'iu_categories' ) ),
			]
		);
		$this->add_control(
			'show_tags',
			[
				'label'    => esc_html__( 'Show Tags:', 'instantup' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options'  => $this->get_iu_terms( array( 'taxonomy' => 'iu_tags' ) ),
			]
		);

		/* Start repeater */
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'id_post',
			[
				'label'       => esc_html__( 'Content ID', 'instantup' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Type ID here', 'instantup' ),
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		/* End repeater */

		$this->add_control(
			'ids_post',
			[
				'label'         => esc_html__( 'Specific Content IDs:', 'instantup' ),
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'prevent_empty' => false,
				'title_field'   => '{{{ id_post }}}',
			]
		);

		#more
		$this->add_control(
			'more_options',
			[
				'label'     => esc_html__( 'More:', 'instantup' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'disable_pagination',
			[
				'label'        => esc_html__( 'Disable Pagination', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'instantup' ),
				'label_off'    => esc_html__( 'No', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'use_template',
			[
				'label'   => esc_html__( 'Use Template:', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'masonry',
				'options' => [
					'masonry' => esc_html__( 'Masonry', 'instantup' ),
					'dafault' => esc_html__( 'Dafault', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'column',
			[
				'label'     => esc_html__( 'Column:', 'instantup' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '4',
				'options'   => [
					'12' => esc_html__( 'One', 'instantup' ),
					'6'  => esc_html__( 'Two', 'instantup' ),
					'4'  => esc_html__( 'Three', 'instantup' ),
					'3'  => esc_html__( 'Four', 'instantup' ),
				],
				'condition' => [
					'use_template' => 'dafault',
				],
			]
		);
		$this->add_control(
			'column_masonry',
			[
				'label'     => esc_html__( 'Column:', 'instantup' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => [
					'1' => esc_html__( 'One', 'instantup' ),
					'2'  => esc_html__( 'Two', 'instantup' ),
					'3'  => esc_html__( 'Three', 'instantup' ),
					'4'  => esc_html__( 'Four', 'instantup' ),
					'5'  => esc_html__( 'Five', 'instantup' ),
				],
				'condition' => [
					'use_template' => 'masonry',
				],
			]
		);
		$this->add_control(
			'posts_per_page',
			[
				'label'       => esc_html__( 'Posts Per Page:', 'instantup' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'default 12', 'instantup' ),
			]
		);
		$this->add_control(
			'sort_by',
			[
				'label'   => esc_html__( 'Sort By:', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'featured',
				'options' => [
					'featured' => esc_html__( 'Content Featured', 'instantup' ),
					'date'     => esc_html__( 'Date desc', 'instantup' ),
				],
			]
		);
		$this->end_controls_section();


		#TAB_STYLE
		#Customer name
		$this->start_controls_section(
			'style_title',
			[
				'label' => esc_html__( 'Customer name', 'instantup' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_customer_name',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'customer_name_color',
			[
				'label' => esc_html__( 'color (no video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.no-video .iu-testimonials-all-customer-name' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'customer_name_color_video',
			[
				'label' => esc_html__( 'color (video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.video .iu-testimonials-all-customer-name' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'typography', 'instantup' ),
				'name' => 'customer_name_typography',
				'selector' => '{{WRAPPER}} .iu-testimonials-all-customer-name',
			]
		);
		$this->add_control(
			'divider0',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->end_controls_section();

		#Customer title
		$this->start_controls_section(
			'style_title1',
			[
				'label'     => esc_html__( 'Customer title', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_customer_title',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'customer_title_color',
			[
				'label' => esc_html__( 'color (no video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.no-video .iu-testimonials-all-customer-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .iu-customer-name' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'customer_title_color_video',
			[
				'label' => esc_html__( 'color (video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.video .iu-testimonials-all-customer-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .iu-customer-name' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'typography', 'instantup' ),
				'name' => 'customer_title_typography',
				'selector' => '{{WRAPPER}} .iu-testimonials-all-customer-title',
			]
		);
		$this->end_controls_section();

		#Customer photo
		$this->start_controls_section(
			'customer_photo',
			[
				'label' => esc_html__( 'Customer photo', 'instantup' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_customer_photo',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'radius_customer_photo',
			[
				'label'      => esc_html__( 'Border Radius', 'instantup' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range'      => [
					'%'  => [
						'min' => 0,
						'max' => 50,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-all-customer-img img' => 'border-radius: {{SIZE}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

		#Rating
		$this->start_controls_section(
			'style_title2',
			[
				'label'     => esc_html__( 'Star rating', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_rating',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'star_rating_color',
			[
				'label' => esc_html__( 'color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .profolio-card-rating li' => 'color: {{VALUE}}',
				]
			]
		);
		$this->end_controls_section();

		#Date
		$this->start_controls_section(
			'style_title3',
			[
				'label'     => esc_html__( 'Date', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
				'condition'    => [
					'use_template' => 'masonry',
				]
			]
		);
		$this->add_control(
			'show_date',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'use_template' => 'masonry',
				],
			]
		);
		$this->add_control(
			'date_color',
			[
				'label' => esc_html__( 'color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-all-customer-date' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'typography', 'instantup' ),
				'name' => 'date_typography',
				'selector' => '{{WRAPPER}} .iu-testimonials-all-customer-date',
				'condition'    => [
					'use_template' => 'masonry',
				]
			]
		);
		$this->end_controls_section();

		#Title
		$this->start_controls_section(
			'style_title4',
			[
				'label'     => esc_html__( 'Title', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'color (no video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.no-video .iu-testimonials-all-title' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'title_color_video',
			[
				'label' => esc_html__( 'color (video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.video .iu-testimonials-all-title' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'title_background',
			[
				'label' => esc_html__( 'background', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-all-title' => 'background-color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__( 'typography', 'instantup' ),
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .iu-testimonials-all-title',
			]
		);
		$this->add_control(
			'divider4',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->end_controls_section();

		#Description
		$this->start_controls_section(
			'style_title5',
			[
				'label'     => esc_html__( 'Description', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_description',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,

				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-all-desc' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'typography', 'instantup' ),
				'name' => 'description_typography',
				'selector' => '{{WRAPPER}} .iu-testimonials-all-desc',
			]
		);
		$this->add_control(
			'divider5',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->end_controls_section();

		#Cover photo
		$this->start_controls_section(
			'style_title6',
			[
				'label'     => esc_html__( 'Cover photo', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_cover',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'cover_size',
			[
				'label'   => esc_html__( 'size image', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'large',
				'options' => [
					'full'      => esc_html__( 'Full', 'instantup' ),
					'large'     => esc_html__( 'Large', 'instantup' ),
					'medium'    => esc_html__( 'Medium', 'instantup' ),
					'thumbnail' => esc_html__( 'Thumbnail', 'instantup' ),
				],
			]
		);
		$this->add_control(
			'cover_height_video',
			[
				'label'       => esc_html__( 'height (for video)', 'instantup' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'number',
				'placeholder' => esc_html__( 'Default auto', 'instantup' ),
			]
		);
		$this->add_control(
			'cover_height_novideo',
			[
				'label'       => esc_html__( 'height (for no video)', 'instantup' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'number',
				'placeholder' => esc_html__( 'Default auto', 'instantup' ),
			]
		);
		$this->end_controls_section();

		#Read more
		$this->start_controls_section(
			'style_title7',
			[
				'label'     => esc_html__( 'Read more', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_readmore',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'readmore_color',
			[
				'label' => esc_html__( 'color (for no video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.no-video .iu-testimonials-all-more a' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'readmore_color_video',
			[
				'label' => esc_html__( 'color (for video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.video .iu-testimonials-all-more a' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'typography', 'instantup' ),
				'name' => 'readmore_typography',
				'selector' => '{{WRAPPER}} .iu-testimonials-all-more a',
			]
		);
		$this->add_control(
			'readmore_txt',
			[
				'label'       => esc_html__( 'Insert your text:', 'instantup' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'read more »', 'instantup' ),
			]
		);
		$this->end_controls_section();

		#Play button
		$this->start_controls_section(
			'style_title8',
			[
				'label'     => esc_html__( 'Play button', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'use_template' => 'masonry',
				]
			]
		);
		$this->add_control(
			'show_play_btn',
			[
				'label'        => esc_html__( 'show', 'instantup' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'instantup' ),
				'label_off'    => esc_html__( 'no ', 'instantup' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition' => [
					'use_template' => 'masonry',
				]
			]
		);
		$this->add_control(
			'play_color',
			[
				'label' => esc_html__( 'color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-play svg' => 'stroke: {{VALUE}}',
				],
				'condition' => [
					'use_template' => 'masonry',
				]
			]
		);
		$this->add_control(
			'play_hover_color',
			[
				'label' => esc_html__( 'hover color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-cover:hover .iu-testimonial-masonry-play svg' => 'stroke: {{VALUE}}',
				],
				'condition' => [
					'use_template' => 'masonry',
				]
			]
		);
		$this->end_controls_section();

        #General
		$this->start_controls_section(
			'style_title9',
			[
				'label'     => esc_html__( 'General', 'instantup' ),
				'tab'      => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'space_between_def',
			[
				'label'      => esc_html__( 'Space Between', 'instantup' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'step' => 1,
						'max'  => 50,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 15,
				],
				'condition' => [
					'use_template' => 'dafault',
				],
			]
		);
		$this->add_control(
			'space_between_man',
			[
				'label'      => esc_html__( 'Space Between', 'instantup' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range'      => [
					'%' => [
						'min'  => 0,
						'step' => 0.5,
						'max'  => 35,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 1.5,
				],
				'condition' => [
					'use_template' => 'masonry',
				],
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label' => esc_html__( 'Background Color (no video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.no-video' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'use_template' => 'masonry',
				],
			]
		);
		$this->add_control(
			'bg_color_video',
			[
				'label' => esc_html__( 'Background Color (video block)', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonial-masonry-item.video .iu-testimonials-all-customer-wrap' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'use_template' => 'masonry',
				],
			]
		);
		$this->add_control(
			'bg_color_default',
			[
				'label' => esc_html__( 'Background Color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-all-item' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'use_template' => 'dafault',
				],
			]
		);
		$this->add_control(
			'bd_color',
			[
				'label' => esc_html__( 'Border Color', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::COLOR,
				'default'  => '#000000',
				'selector' => [
					'{{WRAPPER}} .iu-testimonials-all-container .iu-testimonials-all-item' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .iu-testimonial-masonry-item' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Box Shadow', 'plugin-name' ),
				'selector' => '{{WRAPPER}} .iu-testimonial-masonry-item, .iu-testimonials-all-item',
			]
		);
		$this->add_control(
			'border_size',
			[
				'label' => esc_html__( 'Border Size', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::DIMENSIONS,
			]
		);
		$this->add_control(
			'border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'instantup' ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 7,
				],
				'selectors' => [
					'{{WRAPPER}} .iu-testimonials-all-item,
					 .iu-testimonial-masonry-item,
					 .iu-testimonial-masonry-item.no-video .iu-testimonials-cover img' => 'border-radius: {{SIZE}}{{UNIT}};',
					'
					{{WRAPPER}} .iu-testimonials-cover,
					 .iu-testimonials-cover img' => 'border-top-right-radius: {{SIZE}}{{UNIT}}; border-top-left-radius: {{SIZE}}{{UNIT}};',

                    '{{WRAPPER}} .iu-testimonials-all-customer-wrap' => 'border-bottom-right-radius: {{SIZE}}{{UNIT}};
                     border-bottom-left-radius: {{SIZE}}{{UNIT}};',
				]
			]
		);
		$this->add_control(
			'padding_item',
			[
				'label' => esc_html__( 'Padding', 'instantup' ),
				'type'  => \Elementor\Controls_Manager::DIMENSIONS,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_content_section',
			[
				'label' => esc_html__( 'Main block style', 'instantup' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'padding_main',
			[
				'label'   => esc_html__( 'Padding', 'instantup' ),
				'type'    => \Elementor\Controls_Manager::DIMENSIONS,
				'default' => [
					'top' => 60,
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render list widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings   = $this->get_settings_for_display();
		$template   = $settings['use_template'] ?? 'dafault';
		$query_arr  = array(
			'post_type'      => get_option( '_iu_custom_type_slug' ),
			'posts_per_page' => (int) ( $settings['posts_per_page'] ? : 12 ),
			'paged'          => get_query_var( 'paged' ) ? : 1,
			'fields'         => 'ids',
		);
		$meta_query = array();

		if ( $settings['rating_filter'] ) {
			$meta_query[] = array(
				'key'     => 'iu-testimonial_rating',
				'value'   => (int) $settings['rating_filter'],
				'compare' => '>=',
				'type'    => 'NUMERIC',
			);
		} elseif ( ! $settings['rating_filter'] ) {
			$meta_query[] = array(
				'key' => 'iu-testimonial_rating',
			);
		}

		if ( 'yes' === $settings['has_description'] ) {
			$meta_query[] = array(
				'key'     => 'iu-testimonial_des',
				'value'   => '',
				'compare' => '!=',
			);
		} elseif ( 'no' === $settings['has_description'] ) {
			$meta_query[] = array(
				'key'   => 'iu-testimonial_des',
				'value' => '',
			);
		} elseif ( 'either' === $settings['has_description'] ) {
			$meta_query[] = array(
				'key' => 'iu-testimonial_des',
			);
		}

		if ( 'yes' === $settings['has_customer_name'] ) {
			$meta_query[] = array(
				'key'     => 'iu-testimonial_customerName',
				'value'   => '',
				'compare' => '!=',
			);
		} elseif ( 'no' === $settings['has_customer_name'] ) {
			$meta_query[] = array(
				'key'   => 'iu-testimonial_customerName',
				'value' => '',
			);
		} elseif ( 'either' === $settings['has_customer_name'] ) {
			$meta_query[] = array(
				'key' => 'iu-testimonial_customerName',
			);
		}

		if ( 'featured' === $settings['sort_by'] ) {
			$query_arr['orderby']                = 'meta_value';
			$query_arr['meta_query']['relation'] = 'AND';
			$query_arr['meta_query'][]           = array(
				'relation' => 'OR',
				array(
					'key'     => 'iu-status_featured',
					'compare' => 'NOT EXISTS',
				),
				array(
					'key'     => 'iu-status_featured',
					'compare' => 'EXISTS',
				),
			);

			$meta_query['relation']    = 'AND';
			$query_arr['meta_query'][] = $meta_query;

		} else {
			$query_arr['meta_query']['relation'] = 'AND';
			$query_arr['meta_query']             += $meta_query;
		}

		if ( $settings['show_categories'] ) {
			$query_arr['tax_query'][] = array(
				'taxonomy' => 'iu_categories',
				'terms'    => $settings['show_categories'],
			);
		}
		if ( $settings['show_tags'] ) {
			if ( $query_arr['tax_query'] ) {
				$query_arr['tax_query']['relation'] = 'AND';
			}

			$query_arr['tax_query'][] = array(
				'taxonomy' => 'iu_tags',
				'terms'    => $settings['show_tags'],
			);
		}

		$query_arr['meta_query'][] = array(
			'relation' => 'OR',
			array(
				'key'     => 'iu-testimonial_media',
				'compare' => 'NOT EXISTS',
			),
			array(
				'key'     => 'iu-testimonial_media',
				'compare' => 'EXISTS',
			),
		);

		$query = new WP_Query( $query_arr );

		//echo '<b> query_arr:</b> <pre>' . print_r( $query_arr, 1 ) . '</pre>';
		//echo '<b> Test:</b> <pre>' . print_r( $query->post_count, 1 ) . '</pre>';

		#sort by IDs
		if ( $query->have_posts() ) {
			$posts = $query->posts;

			if ( $settings['ids_post'] ) {
				$sort_ids = array();

				foreach ( $settings['ids_post'] as $id ) {
					if ( $id['id_post'] ) {
						$sort_ids[] = (int) $id['id_post'];
					}
				}

				if ( $sort_ids ) {
					$new_arr_posts = array();

					foreach ( $sort_ids as $sort_id ) :
						foreach ( $posts as $key => $post_id ) :
							if ( $sort_id === $post_id ) {
								$new_arr_posts[] = $post_id;
								unset( $posts[ $key ] );
							}
						endforeach;
					endforeach;

					if ( $new_arr_posts ) {
						//$posts = array_merge( $new_arr_posts, $posts );
						$posts = $new_arr_posts;
					}
				}
			} ?>

            <style><?php
		        if ( $settings['padding_main']['top'] !== false || $settings['padding_main']['right'] !== false ||
		         $settings['padding_main']['bottom'] !== false || $settings['padding_main']['left'] !== false ):
			        echo '.iu-testimonials-all-container {';
			        if ( $settings['padding_main']['top'] === '0' || $settings['padding_main']['top'] ):
				        echo "padding-top: {$settings['padding_main']['top']}{$settings['padding_main']['unit']};";
			        endif;

			        if ( $settings['padding_main']['right'] === '0' || $settings['padding_main']['right'] ):
				        echo "padding-right: {$settings['padding_main']['right']}{$settings['padding_main']['unit']};";
			        endif;

			        if ( $settings['padding_main']['bottom'] === '0' || $settings['padding_main']['bottom'] ):
				        echo "padding-bottom: {$settings['padding_main']['bottom']}{$settings['padding_main']['unit']};";
			        endif;

			        if ( $settings['padding_main']['left'] === '0' || $settings['padding_main']['left'] ):
				        echo "padding-left: {$settings['padding_main']['left']}{$settings['padding_main']['unit']};";
			        endif;

			        echo '}';
		        endif;

		        if ( $settings['border_size']['top'] !== false || $settings['border_size']['right'] !== false ||
		         $settings['border_size']['bottom'] !== false || $settings['border_size']['left'] !== false ||
		         $settings['padding_item']['top'] !== false ||
		         $settings['padding_item']['right'] !== false || $settings['padding_item']['bottom'] !== false ||
		         $settings['padding_item']['left'] !== false){
		            echo '.iu-testimonials-all-item, .iu-testimonial-masonry-item, .iu-testimonial-masonry-item.no-video{';
			        if ( $settings['border_size']['top'] === '0' || $settings['border_size']['top'] ):
				        echo "border-top-width: {$settings['border_size']['top']}{$settings['border_size']['unit']};";
			        endif;

			        if ( $settings['border_size']['right'] === '0' || $settings['border_size']['right'] ):
				        echo "border-right-width: {$settings['border_size']['right']}{$settings['border_size']['unit']};";
			        endif;

			        if ( $settings['border_size']['bottom'] === '0' || $settings['border_size']['bottom'] ):
				        echo "border-bottom-width: {$settings['border_size']['bottom']}{$settings['border_size']['unit']};";
			        endif;

			        if ( $settings['border_size']['left'] === '0' || $settings['border_size']['left'] ):
				        echo "border-left-width: {$settings['border_size']['left']}{$settings['border_size']['unit']};";
			        endif;

			        if ( $settings['padding_item']['top'] === '0' || $settings['padding_item']['top'] ):
				        echo "padding-top: {$settings['padding_item']['top']}{$settings['padding_item']['unit']};";
			        endif;

			        if ( $settings['padding_item']['right'] === '0' || $settings['padding_item']['right'] ):
				        echo "padding-right: {$settings['padding_item']['right']}{$settings['padding_item']['unit']};";
			        endif;

			        if ( $settings['padding_item']['bottom'] === '0' || $settings['padding_item']['bottom'] ):
				        echo "padding-bottom: {$settings['padding_item']['bottom']}{$settings['padding_item']['unit']};";
			        endif;

			        if ( $settings['padding_item']['left'] === '0' || $settings['padding_item']['left'] ):
				        echo "padding-left: {$settings['padding_item']['left']}{$settings['padding_item']['unit']};";
			        endif;
		            echo '}';
		         }


                if ( 'masonry' === $template ) :
                    if ( $settings['bd_color'] ):
                        echo '.iu-testimonial-masonry-item {';
                            echo "border-color: {$settings['bd_color']};";
                        echo '}';
                    endif;

                    if ($settings['play_color']):
                        echo '.iu-testimonial-masonry-item.video .iu-testimonial-masonry-play svg{';
                        echo "stroke: {$settings['play_color']};";
                        echo '}';
                    endif;

                    if ($settings['space_between_man']):
		                echo '.iu-testimonial-masonry-sizer-gutter {';
		                echo "width: {$settings['space_between_man']['size']}{$settings['space_between_man']['unit']};";
		                echo '}';
		            endif;

		            if ($settings['cover_height_video'] > 0):
		                echo '.iu-testimonial-masonry-item.video .iu-testimonials-cover {';
		                echo "height: {$settings['cover_height_video']}px;";
		                echo '}';
		            endif;

		            if ($settings['cover_height_novideo'] > 0):
		                echo '.iu-testimonial-masonry-item.no-video .iu-testimonials-cover {';
		                echo "height: {$settings['cover_height_novideo']}px;";
		                echo '}';
		            endif;

		            if ($settings['column_masonry']) :
		                //echo '@media (min-width: 992px) {';
                            echo '.iu-testimonial-masonry-sizer, .iu-testimonial-masonry-item {';

                            if ( (int)$settings['column_masonry'] === 1 ):
                            echo 'width: 100%';
                            endif;

                            if ( (int)$settings['column_masonry'] === 2 ):
                            echo "width: calc((100% - 1.5%) / {$settings['column_masonry']});";
                            endif;

                            if ( (int)$settings['column_masonry'] === 3 ):
                            echo "width: calc((100% - 3%) / {$settings['column_masonry']});";
                            endif;

                            if ( (int)$settings['column_masonry'] === 4 ):
                            echo "width: calc((100% - 4.5%) / {$settings['column_masonry']});";
                            endif;

                            if ( (int)$settings['column_masonry'] === 5 ):
                            echo "width: calc((100% - 6%) / {$settings['column_masonry']});";
                            endif;

                            echo '}';
		                //echo '}';

//		                echo '.iu-testimonial-masonry-sizer-gutter{';
//		                echo 'width: 2.5%;';
//		                echo '}';
		            endif;
                endif;

		        if ( 'dafault' === $template ) :
			        if ( $settings['space_between_def'] ):
			            echo '.iu-testimonials-all-container [class*="profolio-col-"]{';
				        echo "padding-left: {$settings['space_between_def']['size']}{$settings['space_between_def']['unit']};";
				        echo "padding-right: {$settings['space_between_def']['size']}{$settings['space_between_def']['unit']};";
				        echo '}';
			        endif;

		        endif;
		        ?>

                .elementor-editor-active .profolio-video-preview {
                    position: relative;
                    background-color: transparent;
                }
                .elementor-editor-active .profolio-bg-img {
                    width: 100%;
                    object-fit: cover;
                }
                .elementor-editor-active .profolio-video-preview i {
                    position: absolute;
                }
                .elementor-editor-active .iu-testimonial-photo-name .profolio-reviewer-photo {
                    height: 100%;
                }

            </style>

            <div class="block__content iu-testimonials-all-container">
                <div class="<?php echo 'masonry' === $template ? 'iu-testimonial-masonry' : 'profolio-row' ?> ">
					<?php if ( 'masonry' === $template ) {
						echo '<div class="iu-testimonial-masonry-sizer"></div><div class="iu-testimonial-masonry-sizer-gutter"></div>';
					}

					foreach ( $posts as $post_id ) {
						$media             = get_post_meta( $post_id, 'iu-testimonial_media', true );
						$video_id          = $media['video'] ?? '';
						$cover_id          = $media['cover'] ?? '';
						$customer_photo_id = $media['customerPhoto'] ?? '';

						if ( 'yes' === $settings['has_video'] && ! $video_id ) {
							continue;
						}
						if ( 'no' === $settings['has_video'] && $video_id ) {
							continue;
						}

						if ( 'yes' === $settings['has_customer_photo'] && !$customer_photo_id ) {
							continue;
						}
						if ( 'no' === $settings['has_customer_photo'] && $customer_photo_id ) {
							continue;
						}

						$title          = get_post_meta( $post_id, 'iu-testimonial_title', true );
						$customer_name  = get_post_meta( $post_id, 'iu-testimonial_customerName', true );
						$customer_title = get_post_meta( $post_id, 'iu-testimonial_customerTitle', true );
						$rating         = get_post_meta( $post_id, 'iu-testimonial_rating', true );
						$description    = get_post_meta( $post_id, 'iu-testimonial_des', true );
						$customer_photo = $customer_photo_id ? wp_get_attachment_image_url( $media['customerPhoto'] ) : '';

						include( INSTANTUP_PATH . "data/template/elementor/{$template}.php" );
					} ?>
                </div>

                <!-- pagination-->
				<?php if ( 'yes' !== $settings['disable_pagination'] ): ?>
                    <div class="profolio-row">
                        <div class="profolio-col-12 text-center profolio-pagination">
                            <nav>
								<?php echo paginate_links( array(
									'total'     => $query->max_num_pages,
									'current'   => max( 1, get_query_var( 'paged' ) ),
									'show_all'  => false,
									'type'      => 'list',
									'end_size'  => 5,
									'mid_size'  => 5,
									'prev_next' => false,
								) ); ?>
                            </nav>
                        </div>
                    </div>
				<?php endif; ?>
            </div>

			<?php
		} else {
			echo '<p>Not found</p>';
		}
		wp_reset_query();
	}#render
}
