//START jQuery
jQuery(function ($) {

  $('#profolio-addon-pro-uuid, #profolio-addon-pro-project_uuid').parent().addClass('disabled');

  function show_hide_metaboxes (value) {

    if (value == 'profolio-project-template.php') {
      $('#the-project-list-settings').show();
      $('#the-map-setting').show();
    }
    else {
      $('#the-project-list-settings').hide();
      $('#the-map-setting').hide();
    }
  }

  show_hide_metaboxes();

  $('body').on('change', '#inspector-select-control-1', function () {
    show_hide_metaboxes(this.value);
  });

  if (jQuery('#post_ID').length && wp && wp?.api) {
    var post = new wp.api.models.Page({ id: jQuery('#post_ID').val() });

    if (post) {
      post.fetch().done(function (data) {
        show_hide_metaboxes(data.template);
      });
    }
  }

  let __  = wp.i18n.__;
  let _x  = wp.i18n._x;
  let _n  = wp.i18n._n;
  let _nx = wp.i18n._nx;

  let profolio_api_use_maps = false;

  window.gm_authFailure = function (status = '') {
    if (status === 'OK') {
      $('.import_loader').hide();
      $('.profolio_js_api_test').parent().find('.error').hide();
      $('.profolio_js_api_test').parent().find('.success').show();
    }
    else {
      $('.import_loader').hide();
      $('.profolio_js_api_test').parent().find('.success').hide();
      $('.profolio_js_api_test').parent().find('.error').show();
    }
  };

  window.profolio_api_test = function () {
    let check_map = $('#profolio_js_api_map_library');

    if (check_map.length) {
      check_map.remove();
    }

    var service = new google.maps.places.AutocompleteService();
    service.getPlacePredictions(
      {
        input: 'Brisbane,Australia',
        types: ['(cities)'],
      },

      function (predictions, status) {
        if (status == google.maps.places.PlacesServiceStatus.OK) {
          profolio_api_use_maps = true; /* status is ok so set flag to use Google Maps */
          gm_authFailure(status);
        }
      },
    );
  };

  const $body = $('body');

  $body.on('click', '.profolio_js_api_test', function (e) {
    e.preventDefault();

    let key = $(this).closest('.cf-field').find('input').val();

    if (!key.length) {
      return;
    }

    $(this).parent().find('.import_loader').show();

    let check_map = $('#profolio_js_api_map_library');

    if (check_map.length) {
      check_map.remove();
    }

    let $script = $('<script></script>').attr({
      'type': 'text/javascript',
      'id': 'profolio_js_api_map_library',
      'src': 'https://maps.googleapis.com/maps/api/js?key=' + key
        + '&libraries=places,geometry&callback=profolio_api_test',
    });

    $('head').append($script);
  });

  $body.on('click', '.firebase_api_test', function (evt) {
    evt.preventDefault();

    let $apiKey    = $(this).data('apikey') ?? '',
        $main      = $(this).closest('.firebase-auth'),
        $container = $(this).parent();

    if (!$apiKey) {
      $apiKey = $main.find('.cf-field__body input').val();
    }

    if (!$apiKey || !$apiKey.length) {
      return;
    }

    $container.find('.import_loader').show();

    $.ajax({
      type: 'POST',
      url: '/wp-admin/admin-ajax.php',
      cache: false,
      dataType: 'json',
      data: {
        'action': 'iu_get_content_firebase',
        'apiKey': $apiKey,
        'get_account': true,
      },
      success: function (response) {
        console.log(response);

        if (response['success']) {
          $container.find('.error').hide();
          $container.find('.import_loader').hide();
          $container.find('.success').show();

        }
        else {
          $container.find('.success').hide();
          $container.find('.import_loader').hide();
          $container.find('.error').show();
        }

      },
      error: function (evt) {
        console.error('Ajax error - status:', evt.status, ' statusText:', evt.statusText);
        $container.find('.error').show();
        $container.find('.import_loader').hide();
      },
    });

  });

  $body.on('click', '#iu-cleanup-content', function (evt) {
    const $main       = $(this).closest('.cf-container'),
          $apiKey     = $main.find('.firebase_api_test').data('apikey'),
          $preLoader  = $main.find('.cleanup-content-row .import_loader'),
          $deleteWrap = $main.find('.delete_wrap_count'),
          $deleteNumb = $main.find('.delete_wrap_count span');

    if (!$apiKey.length) {
      console.error('empty apiKey');
      return;
    }

    $deleteWrap.removeClass('active');
    $deleteNumb.html('');
    $preLoader.addClass('active');

    $.ajax({
      type: 'POST',
      url: '/wp-admin/admin-ajax.php',
      dataType: 'json',
      data: {
        'action': 'iu_get_content_firebase',
        'apiKey': $apiKey,
        'cleanup_content': true,
      },
      success: function (response) {
        $preLoader.removeClass('active');

        if (response['success']) {
          $deleteWrap.addClass('active');
          $deleteNumb.html(response['count_deleted']);
        }

      },
      error: function (evt) {
        $preLoader.removeClass('active');
        $deleteWrap.addClass('active');
        $deleteWrap.css('color', 'red');
        $deleteWrap.html('error');

        console.error('Ajax error !! - ', evt['status'], evt['statusText']);
      },
    });
  });

  $body.on('click', '#run-import-firebase', function () {
    var $main   = $(this).closest('.cf-container'),
        $apiKey = $main.find('.firebase-auth input').val() || window['firebase_auth_code'];

    if (!$apiKey.length) {
      console.info('empty apiKey');
      return;
    }

    var showImport     = $main.find('#import_firebase_box .import-projects-log-row'),
        onlyPublished  = $main.find('#iu_only_published'),
        ajaxLoader     = $main.find('.import-projects-log-row .import_loader'),
        importText     = $main.find('.iu-import-text'),
        numberProjects = $main.find('.number_projects'),
        currentImport  = $main.find(' .current_imported'),
        data_obj       = [],
        accountID,
        dbContent,
        contentTypes;

    if (importText.length) {
      importText.remove();
    }
    if (currentImport.length) {
      currentImport.text(0);
    }
    if (numberProjects.length) {
      numberProjects.text(0);
    }

    showImport.css({ 'display': 'flex' });
    ajaxLoader.show();

    $.ajax({
      type: 'POST',
      url: '/wp-admin/admin-ajax.php',
      dataType: 'json',
      data: {
        'action': 'iu_get_content_firebase',
        'apiKey': $apiKey,
        'get_content': true,
      },
      success: function (response) {
        console.dir(response);
        if (response['success']) {
          accountID    = response['content']['account']['uid'];
          contentTypes = response['content']['account']['contentTypes'];
          dbContent    = response['content']['contents'];

          dbContent.forEach((item) => {
            if (onlyPublished.prop('checked')) {
              if (item?.['status']?.['publish'] === 'published') {
                data_obj.push(item);
              }

            }
            else {
              data_obj.push(item);
            }
          });

          if (!data_obj.length) {
            ajaxLoader.hide();
            showImport.append('<div class="iu-import-text">There is nothing to import</div>');
            return;
          }

          import_firebase(data_obj, contentTypes);
        }
      },
      error: function (evt) {
        console.error('Ajax error !! - ', evt['status'], evt['statusText']);
      },
    });

  });

  function import_firebase (data, contentType) {
    if (!data.length) {
      return;
    }

    let importBox      = document.querySelector('.cf-html__content #import_firebase_box'),
        skipProject    = importBox.querySelector('#skip_existing_projects'),
        importLoader   = importBox.querySelector('.import_projects .import_loader'),
        numberProjects = importBox.querySelector('.import_wrap_count .number_projects'),
        importContent  = importBox.querySelector('.import-projects-log-row'),
        currentImport  = importBox.querySelector('.import_wrap_count .current_imported'),
        $i             = 0,
        iteration      = 0,
        finish         = data.length - 1,
        executionTime  = setExecutionTime(finish),
        $data          = {
          'action': 'project_import_firebase',
          'contType': JSON.stringify(contentType),
        };

    console.log(`executionTime: ${executionTime}`);

    numberProjects.textContent = String(data.length);

    if (skipProject.checked) {
      $data['skipProject'] = 1;

    }

    let importSaas = setInterval(() => {
      if ($i === finish) {
        clearInterval(importSaas);
      }
      $data['data'] = JSON.stringify(data[$i]);

      $.ajax({
        type: 'POST',
        url: ajaxurl,
        dataType: 'json',
        data: $data,
        success: function (response) {
          if (iteration === finish) {
            let endImport = document.createElement('div');

            endImport.classList.add('iu-import-text');
            endImport.textContent = 'Import complete';

            importContent.appendChild(endImport);
            importLoader.style.display = 'none';
          }

          if (response === null || response === undefined || response?.success === false) {
            let $errorBlock = document.createElement('div'),
                $message    = response?.message;

            $errorBlock.classList.add('iu-import-text');
            $errorBlock.textContent = `Error, not save project ${iteration}. ${$message}`;
            $errorBlock.style.color = 'crimson';

            importContent.appendChild($errorBlock);
          }

          iteration++;
          currentImport.textContent = String(iteration);
        },
        error: function (e) {
          iteration++;

          let errorBlock = document.createElement('div');

          errorBlock.classList.add('iu-import-text');
          errorBlock.textContent = 'Error project ' + iteration;
          errorBlock.style.color = 'crimson';

          importContent.appendChild(errorBlock);

          if (iteration === finish) {
            let endImport = document.createElement('div');

            endImport.textContent    = 'Import complete';
            endImport.style.width    = '100%';
            endImport.style.fontSize = '16px';

            importContent.appendChild(endImport);
            importLoader.style.display = 'none';
          }

          console.error(e);
          console.error(e.responseText);
        },
      });

      $i++;
    }, executionTime);
  }

  var setExecutionTime = function (tasks) {
    if (tasks > 0 && tasks < 10) {
      return 250;
    }
    else if (tasks > 10 && tasks < 20) {
      return 450;
    }
    else if (tasks > 20 && tasks < 30) {
      return 750;
    }
    else if (tasks > 30 && tasks < 40) {
      return 850;
    }
    else if (tasks > 40 && tasks < 50) {
      return 950;
    }
    else if (tasks > 50 && tasks < 60) {
      return 1050;
    }
    else if (tasks > 60 && tasks < 70) {
      return 1150;
    }
    else if (tasks > 70 && tasks < 85) {
      return 1250;
    }
    else {
      return 1500;
    }
  };

  var current_key = 0;

  function add_noindex (current_key, ids, $this) {

    let $error         = $this.parent().find('.error');
    let $success       = $this.parent().find('.success');
    let $loader        = $this.parent().find('.import_loader');
    let $message_count = $this.parent().find('.profolio_message_count');
    let args           = {
      'action': 'localseomap_add_noindex',
    };

    if (ids) {
      if (ids[current_key]) {
        console.log(ids[current_key]);
        args['post_id'] = ids[current_key];
      }
    }
    else {
      args['get_ids'] = true;
    }

    $.ajax({
      url: ajaxurl,
      dataType: 'json',
      type: 'POST',
      data: args,
      success: function (response) {

        if (response.ids) {
          add_noindex(current_key, response.ids, $this);

          $message_count.html(response.message_label + response.ids.length);
          return;
        }

        current_key++;

        $message_count.html(
          response.message_label + current_key + '/' + ids.length);

        if (ids && ids.length == current_key) {
          if (response.status === 'OK') {
            $error.hide();
            $success.show();
          }
          else {
            if (response.error_message) {
              $error.html(response.error_message);
            }
            else {

            }
          }

          $loader.hide();
          return;
        }

        add_noindex(current_key, ids, $this);

      },
      error: function (xhr, ajaxOptions, thrownError) {

        $loader.hide();
      },
    });
  }

  $body.on('click', '.profolio_js_add_noindex', function (e) {
    e.preventDefault();

    let $this = $('.profolio_js_add_noindex');

    $this.parent().find('.import_loader').show();

    add_noindex(0, null, $this);
  });

  //Start active admin menu
  if (typeof instantup_ogj !== 'undefined') {
    const prefix = instantup_ogj['prefix'];

    if ($('body').hasClass('post-type-' + prefix)) {

      const $main = $('#toplevel_page_projects-type'),
            $link = $main.find('a.toplevel_page_projects-type'),
            $list = $main.find('.wp-submenu-wrap');

      $main.removeClass('wp-not-current-submenu').addClass('wp-has-current-submenu wp-menu-open open-if-no-js');
      $link.removeClass('wp-not-current-submenu').addClass('wp-has-current-submenu wp-menu-open open-if-no-js');
      //$list
    }
  }

  //End active admin menu

});
//END jQuery

// (function () {
//   const { addAction } = window.cf.hooks;
//
//   addAction('carbon-fields.init', 'carbon-fields/metaboxes', () => {
//
//     const { select } = window.cf.vendor['@wordpress/data'];
//     //const fields = select( 'carbon-fields/metaboxes' ).getFieldsByContainerId( 'editor' );
//     const fields = select( 'carbon-fields/metaboxes' );
//     console.dir(select);
//
//      //const textFieldValue = fields.find( ( field ) => field.base_name === 'crb_text' );
//     //console.log(textFieldValue.value);
//
//   });
// })();

document.addEventListener('DOMContentLoaded', () => {
  const deleteElement = (wrapper, element) => {
    setTimeout(() => {
      wrapper.removeChild(element);
    }, 5000);
  };

  //START mutationObserver
  (function () {
    let $bodySite    = document.querySelector('body'),
        $blockEditor = $bodySite.querySelector('.block-editor');

    if ($blockEditor) {

      let observer = new MutationObserver(mutations => {
        for (let mutation of mutations) {

          for (let node of mutation.addedNodes) {
            if (!(node instanceof HTMLElement)) {
              continue;
            }

            if (node.matches('.components-placeholder')) {
              //Init map
              let $initMapCounter = 0,
                  $waiteLoadMap   = setInterval(() => {
                    let $isMap = document.querySelector('.JS_profolio_map');
                    $initMapCounter++;

                    if ($isMap && $initMapCounter < 50) {

                      clearInterval($waiteLoadMap);
                      $isMap.innerHTML = 'Empty';
                      iu_init_map();

                      // let $blockMapLoading = document.querySelector('.block-map-loading');
                      // console.log($blockMapLoading);

                    }
                  }, 500);
              //Init map

              let $$initEditorMasonryCounter = 0,
                  $initEditorMasonry         = setInterval(() => {

                    $$initEditorMasonryCounter++;
                    if (document.querySelector('.iu-testimonial-masonry') && $$initEditorMasonryCounter < 60) {
                      clearInterval($initEditorMasonry);

                      new Masonry('.iu-testimonial-masonry', {
                        itemSelector: '.iu-testimonial-masonry-item',
                        columnWidth: '.iu-testimonial-masonry-sizer',
                        gutter: '.iu-testimonial-masonry-sizer-gutter',
                        percentPosition: true,
                      });
                    }
                  }, 500);
            }

            //START add google font
            if (node.matches('.components-panel__body.is-opened')) {
              let $setFont       = node.querySelector('.select_font_block .cf-select__input'),
                  $templatePosts = node.querySelector('select[name="template_posts"]');

              for (const $item of node.querySelectorAll('select, input')) {
                if ($item && typeof $item !== 'string') {
                  $item.addEventListener('click', function () {
                    let $currentTemplate          = document.querySelector('select[name="template_posts"]'),
                        $initEditorMasonryCounter = 0,
                        $initEditorMasonry        = setInterval(() => {
                          $initEditorMasonryCounter++;

                          if ($currentTemplate?.value === 'masonry') {
                            if (document.querySelector('.iu-grid') && $initEditorMasonryCounter < 30) {
                              clearInterval($initEditorMasonry);

                              new Masonry('.iu-grid', {
                                itemSelector: '.iu-grid-item',
                                columnWidth: 175,
                                gutter: 5,
                              });
                            }
                          }
                          else {
                            clearInterval($initEditorMasonry);
                          }
                        }, 1000);

                  });
                }
              }

              if (!!$templatePosts) {
                $templatePosts.addEventListener('change', function () {
                  if ($templatePosts.value === 'masonry') {
                    setTimeout(() => {
                      new Masonry('.iu-grid', {
                        itemSelector: '.iu-grid-item',
                        columnWidth: 175,
                        gutter: 5,
                      });
                    }, 1200);
                  }
                });
              }

              if ($setFont) {
                $setFont.addEventListener('change', function () {
                  if ($setFont.value !== '0') {
                    let $headSite    = document.querySelector('head'),
                        oldLink      = $headSite.querySelector('#set_google_font_link'),
                        $font        = $setFont.value.replace(':', '%3A').replace(',', '%2C'),
                        $create_link = document.createElement('link'),
                        $href        = '//fonts.googleapis.com/css?family=' + $font + '%26subset%3Dlatin%2Clatin-ext&#038';

                    if (oldLink) {
                      oldLink.setAttribute('href', $href);

                    }
                    else {
                      $create_link.setAttribute('id', 'set_google_font_link');
                      $create_link.setAttribute('rel', 'stylesheet');
                      $create_link.setAttribute('media', 'all');
                      $create_link.setAttribute('href', $href);

                      document.querySelector('head').append($create_link);
                    }
                  }

                });
              }
            }
            //END add google font

            if (node.matches('.block-editor-block-list__block')) {
              setTimeout(() => {
                if (node.querySelector('.iu-grid')) {
                  console.log('tytka1');
                  new Masonry('.iu-grid', {
                    itemSelector: '.iu-grid-item',
                    columnWidth: 175,
                    gutter: 5,
                  });
                }
              }, 100);

              let iuMap = node.querySelector('.cf-map');

              if (iuMap) {
                let allCheckbox = iuMap.closest('.cf-block__fields').querySelectorAll(
                  '.iu-toggle-checked.iu_block_checkbox .cf-checkbox__input');

                if (allCheckbox.length) {
                  for (let i = 0; i < allCheckbox.length; i++) {
                    if (allCheckbox[i].checked) {
                      allCheckbox[i].parentNode.classList.add('checked');
                    }
                  }
                }
              }
            }

            if (node.matches(
              '.block-editor-block-list__block.wp-block.is-selected.wp-block-columns.block-editor-block-list__layout')) {
              setTimeout(() => {
                if (node.querySelector('.cf-block__preview .iu_block-filter')) {
                  priceRangeFilter();
                }
              }, 500);
            }

          }
        }

      });
      observer.observe($blockEditor, {
        childList: true,
        subtree: true,
      });
    }

    $bodySite.addEventListener('click', function (evt) {
      for (let target = evt.target; target && target !== this; target = target.parentNode) {

        if (target.matches('.editor-block-list-item-carbon-fields-iu-content-map')) {
          setTimeout(() => {
            let zoomCheckbox = document.querySelectorAll('.iu_block_checkbox .cf-checkbox__input');

            if (zoomCheckbox.length) {
              for (let i = 0; i < zoomCheckbox.length; i++) {
                if (zoomCheckbox[i].checked) {
                  zoomCheckbox[i].parentNode.classList.add('checked');
                }
              }
            }

          }, 100);

        }

        if (target.matches('.iu-toggle-checked .cf-field__body .cf-checkbox__label')) {
          target.parentNode.classList.toggle('checked');
        }

        if (target.matches('.cf-block__preview')) {
          console.log('isSelected');

          let $template_posts = document.querySelector(
            '.interface-interface-skeleton__sidebar select[name="template_posts"]');
          if ($template_posts && $template_posts.value === 'masonry') {
            new Masonry('.iu-grid', {
              itemSelector: '.iu-grid-item',
              columnWidth: 175,
              gutter: 5,
            });
          }

          let iu_checkbox = document.querySelectorAll(
            '.interface-interface-skeleton__sidebar .iu-toggle-checked.iu_block_checkbox .cf-checkbox__input');
          if (iu_checkbox.length) {
            for (let i = 0; i < iu_checkbox.length; i++) {
              if (iu_checkbox[i].checked) {
                iu_checkbox[i].parentNode.classList.add('checked');
              }
            }
          }
        }

        //START sync with saas
        if (target.matches('.cf-field__help .iu_btn_sync_saas')) {
          let import_loader = target.nextElementSibling,
              blockSuccess  = target.parentNode.querySelector('.success');

          blockSuccess.textContent    = '';
          import_loader.style.display = 'inline-block';

          jQuery.ajax({
            type: 'POST',
            url: ajaxurl,
            dataType: 'json',
            data: {
              'action': 'send_out_of_turn',
            },
            success: function (response) {
              blockSuccess.textContent = response;

              blockSuccess.style.display  = 'inline-block';
              import_loader.style.display = 'none';
            },
            error: function () {
              console.log('Ajax error !!');
              import_loader.style.display = 'none';
            },
          });

          break;
        }
        //END sync with saas

      }
    }, false);
  }());
  //END mutationObserver

  (function () {
    let iuTemplateType = document.querySelector('#iu_checked_template_type'),
        iuPostType     = document.querySelector('#iu-post-type'),
        iuCatTag       = document.querySelector('#iu-cat-tag');

    if (iuTemplateType) {
      if (iuTemplateType.value === 'post_page') {
        iuCatTag.classList.add('closed');
      }
      if (iuTemplateType.value === 'cat_tag') {
        iuPostType.classList.add('closed');
      }

      iuTemplateType.addEventListener('change', function () {
        if (this.value === 'post_page') {
          iuPostType.classList.remove('closed');
          iuCatTag.classList.add('closed');
        }
        if (this.value === 'cat_tag') {
          iuCatTag.classList.remove('closed');
          iuPostType.classList.add('closed');
        }
      });
    }
  })();

  //START full width page
  (function () {
    setTimeout(() => {
      let wpBlock = document.querySelector('body.wp-admin .wp-block-columns');

      if (wpBlock) {
        let inputWidth = document.querySelector('#iu-full-content-page .iu-checked-post-type [type="radio"]:checked');

        if (inputWidth && inputWidth.value === 'full_width') {
          wpBlock.classList.add('set-iu-block-full');
        }
      }
    }, 800);

    let $blockEditor = document.querySelector('.block-editor__container'),
        inputWidth,
        wpBlock;

    if ($blockEditor) {
      $blockEditor.addEventListener('click', () => {
        inputWidth = document.querySelector('#iu-full-content-page .iu-checked-post-type [type="radio"]:checked');
        wpBlock    = document.querySelector('body.wp-admin .wp-block-columns');

        if (wpBlock && inputWidth && inputWidth.value === 'full_width') {
          wpBlock.classList.add('set-iu-block-full');
        }
        if (wpBlock && inputWidth && inputWidth.value === 'boxed') {
          wpBlock.classList.remove('set-iu-block-full');
        }
      });
    }
  }());
  //END full width page

  //START import-export templates
  (function () {
    let $cfContainer = document.querySelector(
      'body.toplevel_page_crb_carbon_fields_container_instantuploader .cf-container');
    if (!$cfContainer) {
      return;
    }

    let $btnExport = $cfContainer.querySelector('#iu_export_btn'),
        $btnImport = $cfContainer.querySelector('#iu_import_btn');

    $btnExport.addEventListener('click', async function () {
      let $templates = $cfContainer.querySelectorAll('.iu-export-import-items input[type="checkbox"]:checked');

      if (!$templates.length) {
        return;
      }

      let $form   = this.closest('.iu-export-import'),
          $data   = new FormData($form),
          $loader = this.closest('.iu-export-import').querySelector('.iu-export-import-loader');

      $data.append('action', 'iu_export_templates');
      $btnExport.setAttribute('disabled', 'disabled');
      $loader.classList.add('active');

      let $response = await fetch(window['ajaxurl'], {
        method: 'POST',
        body: new URLSearchParams(),
      });

      if ($response['ok']) {
        let $result = await $response.blob(),
            $blob   = new Blob([$result], { type: $response.headers.get('Content-Type') }),
            $link   = document.createElement('a');

        $link.href     = window.URL.createObjectURL($blob);
        $link.download = 'iu-templates.json';

        $link.click();
        $loader.classList.remove('active');
        $btnExport.removeAttribute('disabled');

        for (const $template of $templates) {
          $template.checked = false;
        }

      }
      else {
        $loader.classList.remove('active');
        $btnExport.removeAttribute('disabled');
        throw new Error(`Problem! Status Code: ${$response['status']}`);
      }

    });

    $btnImport.addEventListener('click', async function () {
      let $file = document.querySelector('.iu-export-import #iu_import_file');

      if (!$file.value) {
        return;
      }

      let $form        = this.closest('.iu-export-import'),
          $data        = new FormData($form),
          $wrapper     = $form.querySelector('.iu-export-import-wrapper'),
          $infoSuccess = $wrapper.querySelector('.success'),
          $infoError   = $wrapper.querySelector('.error'),
          $infoMessage = $wrapper.querySelector('.errors-message'),
          $loader      = $form.querySelector('.iu-export-import-loader');

      $data.append('action', 'iu_import_templates');
      $btnImport.setAttribute('disabled', 'disabled');
      $loader.classList.add('active');

      if ($infoSuccess) {
        $wrapper.removeChild($infoSuccess);
      }
      if ($infoMessage) {
        $wrapper.removeChild($infoMessage);
      }
      if ($infoError) {
        $wrapper.removeChild($infoError);
      }

      let $response = await fetch(window['ajaxurl'], {
        method: 'POST',
        body: $data,
      });

      if ($response['ok']) {
        let $result = await $response.json();

        if ($result['errors']) {
          $wrapper.insertAdjacentHTML('beforeend',
            `<p class="error">An error has occurred</p> ${$result['errors_message'].join()}`,
          );
          deleteElement($wrapper, $wrapper.querySelector('.error'));
          deleteElement($wrapper, $wrapper.querySelector('.errors-message'));
        }

        if ($result['ids']) {
          $wrapper.insertAdjacentHTML('beforeend', '<p class="success">Import Complete</p>');
          deleteElement($wrapper, $wrapper.querySelector('.success'));
        }

        $loader.classList.remove('active');
        $btnImport.removeAttribute('disabled');
        $file.value = '';

      }
      else {
        $loader.classList.remove('active');
        $btnImport.removeAttribute('disabled');
        throw new Error(`Problem! Status Code: ${$response['status']}`);
      }

    });
  }());
  //END import-export templates

  //START
  (function () {
    let $mapFantom   = document.querySelector('#cf-iu_disable_maps_fantom'),
        $disableMaps = document.querySelector('.iu-disable-maps input[type="checkbox"]');

    if (!$mapFantom && !$disableMaps) {
      return;
    }

    if ($disableMaps.checked !== $mapFantom.checked) {
      $mapFantom.checked = 'checked';
    }

    $mapFantom.addEventListener('click', function (ent) {
      $disableMaps.click();
    });

  }());
  //END

  (function () {
    setTimeout( () => {
      let $dataAccount = document.querySelector('.iu-data-account-output-btn-show');
      if (!$dataAccount) {
        console.info(`We don't find element with class .iu-data-account-output-btn-show`);
        return;
      }

      $dataAccount.addEventListener('click', function (ect) {
        $dataAccount.classList.toggle('active');
        $dataAccount.parentNode.classList.toggle('active');

        let $parentBlock = $dataAccount.closest('.cf-field__help'),
            $outputWrap  = $parentBlock.querySelector('.iu-data-account-output-table');

        if (!$outputWrap) {
          console.info(`We don't find element with class .iu-data-account-output-table`);
          return;
        }

        $outputWrap.classList.toggle('active');
      });
    }, 2000);
  }());

  (function () {
    let $accountBtn = document.querySelector('#iu_get_data_account_btn');
    if (!$accountBtn) {
      return;
    }
    $accountBtn.addEventListener('click', async function () {
      let $data       = new FormData(),
          $imgLoading = document.querySelector('.iu-data-account-output-btn-js .import_loader'),
          $txtSuc     = document.querySelector('.iu-data-account-output-btn-js .success'),
          $txtError   = document.querySelector('.iu-data-account-output-btn-js .error');

      $imgLoading.style.display = 'block';
      $data.append('action', 'iu_get_data_account_seo');

      let $response = await fetch(window['ajaxurl'], {
        method: 'POST',
        body: new URLSearchParams($data),
      });

      if ($response['ok']) {
        $imgLoading.style.display = 'none';
        $txtSuc.style.display     = 'block';

        setTimeout(() => {
          $txtSuc.style.display = 'none';
        }, 5000);

        let $result     = await $response.json(),
            $outputWrap = document.querySelector('.iu-data-account-output .iu-data-account-output-table'),
            $divTable   = document.createElement('div'),
            $tableBody  = document.createElement('div');

        $divTable.classList.add('divTable');
        $tableBody.classList.add('divTableBody');
        $outputWrap.innerHTML = '';

        for (const $resultKey in $result['data']) {
          let $tableRow   = document.createElement('div'),
              $tableCell1 = document.createElement('div'),
              $tableCell2 = document.createElement('div'),
              $name       = $resultKey.replace('_', ' ');

          $tableRow.classList.add('divTableRow');
          $tableCell1.classList.add('divTableCell');
          $tableCell2.classList.add('divTableCell');

          $tableCell1.textContent = $name.charAt(0).toUpperCase() + $name.slice(1);

          if ($resultKey === 'logo') {
            let $img             = document.createElement('img');
            $img.style.objectFit = 'cover';
            $img.setAttribute('src', $result['data'][$resultKey]);
            $img.setAttribute('width', 32);
            $img.setAttribute('height', 32);
            $img.setAttribute('alt', 'logo');
            $tableCell2.insertAdjacentElement('beforeend', $img);
          }
          else {
            $tableCell2.textContent = $result['data'][$resultKey];
          }

          $tableRow.insertAdjacentElement('beforeend', $tableCell1);
          $tableRow.insertAdjacentElement('beforeend', $tableCell2);
          $tableBody.insertAdjacentElement('beforeend', $tableRow);

        }

        $divTable.insertAdjacentElement('beforeend', $tableBody);
        $outputWrap.insertAdjacentElement('beforeend', $divTable);
        $outputWrap.insertAdjacentHTML('beforeend',
          '<a style="float: right;" href="https://app.instantuploader.com/settings/business-account" target="_blank">Edit</a>',
        );

      }
      else {
        $imgLoading.style.display = 'none';
        $txtError.style.display   = 'block';

        setTimeout(() => {
          $txtError.style.display = 'none';
        }, 5000);

        throw new Error(`Problem! Status Code: ${$response['status']}`);
      }
    });
  }());

});

//-----------------
