window.addEventListener('load', function() {
  function swiper_project_details( settings ) {
    let profolio_swiper = document.querySelector('.profolio-swiper-details');

    if (profolio_swiper) {

      let args_slider = {
        slidesPerView: 4,
        spaceBetween: 15,
        breakpoints: {
          992: {
            slidesPerView: '3',
          },
          767: {
            slidesPerView: '2',
          },
          500: {
            slidesPerView: '1',
          },
        },
        navigation: {
          nextEl: '.profolio-button-next',
          prevEl: '.profolio-button-prev',
        },

      };

      if (typeof settings != 'undefined') {
        if (settings.slidesPerView) {
          args_slider[ 'slidesPerView' ] = settings.slidesPerView;
        }

        if (settings.slidesPerGroup) {
          args_slider[ 'slidesPerGroup' ] = settings.slidesPerGroup;
        }

        if (settings.spaceBetween) {
          args_slider[ 'spaceBetween' ] = settings.spaceBetween;
        }
      }

      if (profolio_swiper.querySelectorAll('.swiper-slide').length >= 5) {
        args_slider.pagination = {
          el: '.swiper-pagination',
          clickable: true,
        };
      }

      var swiper = new Swiper('.profolio-swiper-details', args_slider);

    }
  }

  let bodySite = document.querySelector('body');

  bodySite.addEventListener('input', function(evt) {
    for (var target = evt.target; target && target != this; target = target.parentNode) {
      if (target.matches('.iu-toggle-checked.is_swiper')) {
        setTimeout(() => {
          swiper_project_details();
        }, 1000);
        break;
      }

      if (target.matches('.iu_carousel_click .cf-select__input')
          || target.matches('.iu_carousel_click .cf-text__input')) {
        let slidesPerView  = document.querySelector('.iu_carousel_click.iu_carousel_per_view .cf-select__input'),
            slidesPerGroup = document.querySelector('.iu_carousel_click.iu_carousel_to_scroll .cf-select__input'),
            spaceBetween   = document.querySelector('.iu_carousel_click.iu_carousel_spacing .cf-text__input'),
            carousel_set   = {};

        if ( slidesPerView.value ){
          carousel_set['slidesPerView'] = slidesPerView.value;
        }
        if ( slidesPerGroup.value ){
          carousel_set['slidesPerGroup'] = slidesPerGroup.value;
        }
        if ( spaceBetween.value ){
          carousel_set['spaceBetween'] = spaceBetween.value;
        }


        setTimeout(() => {
          swiper_project_details( carousel_set );
        }, 1000);
        break;
      }

    }
  }, false);

  setTimeout(() => {
    swiper_project_details();
  }, 2000);
});