<?php
/**
 * Plugin Name: InstantUploader
 * Plugin URI: https://instantuploaderstorage.com/
 * Description: Allows you to connect to your InsantUploader account..
 * Author: InstantUploader.com
 * Author URI: https://app.instantuploader.com/
 * Version: 3.65.4
 * Requires at least: 5.6.0
 * Tested up to: 7.3
 * Requires PHP: 7.3.0
 * Text Domain: instantup
 */

use InstantUploader\Admin;

if (!defined('ABSPATH')) {
    exit();
}

define('INSTANTUP_VERSION', '3.65.4');
define('INSTANTUP_FILE', __FILE__);
define('INSTANTUP_DIR', basename(__DIR__));
define('INSTANTUP_PATH', wp_normalize_path(plugin_dir_path(INSTANTUP_FILE)));
define('INSTANTUP_URL', wp_normalize_path(plugin_dir_url(INSTANTUP_FILE))); // ../instant-uploader/
define('INSTANTUP_ENABLE_LOGS', false);
#define( 'IU_CLOUDFUNCTIONS_HOST', 'https://us-central1-profolio-instantuploader-1ab31.cloudfunctions.net' ); //DEV
define( 'IU_CLOUDFUNCTIONS_HOST', 'https://us-central1-profolio-6364a.cloudfunctions.net' ); //PROD

include_once ABSPATH . 'wp-admin/includes/plugin.php';

if (class_exists('Elementor\Plugin')) {
    #Create a new category of Elementor.
    add_action('elementor/elements/categories_registered', 'instantuploader_widget_categories');
    function instantuploader_widget_categories($elements_manager) {
        $elements_manager->add_category('instantuploader', [
            'title' => __('IU testimonials', 'instantup'),
            'icon' => 'fa fa-plug',
        ]);
    }
}

#Include libs.
include_once INSTANTUP_PATH . 'vendor/autoload.php';

#Include framework.
include_once INSTANTUP_PATH . 'data/init.php';

#Include the plugin core.
include_once INSTANTUP_PATH . 'src/core.php';

//A hook to do something when the plugin is updated.
add_action('upgrader_process_complete', 'update_plugin_iu', 200, 2);
function update_plugin_iu($upgrader_object, $options) {
    $admin = new Admin();
    $prefix = $admin::get_type_prefix();

    if (
        isset($options) &&
        !empty($options) &&
        $options['action'] === 'update' &&
        $options['type'] === 'plugin'
    ) {
        $admin->write_log(
            'DATE: ' . date('Y-m-d H:i:s P') . ' init hook upgrader_process_complete',
            'plugin-update-log.txt'
        );

        foreach ($options['plugins'] as $plugin_rel_path) {
            if (INSTANTUP_DIR . '/plugin.php' === $plugin_rel_path) {
                //START set option with default metatags
                $all_meta_name = get_option("all_{$prefix}_meta_name", []);
                $meta_keys = [
                    $prefix . '-city' => 'City',
                    $prefix . '-county' => 'County',
                    $prefix . '-country' => 'Country',
                    $prefix . '-address' => 'Address',
                    $prefix . '-state' => 'State',
                    $prefix . '-latitude' => 'Latitude',
                    $prefix . '-longitude' => 'Longitude',
                    $prefix . '-updateDate' => 'Update Date',
                    $prefix . '-start_date' => 'Start Date',
                    $prefix . '-seo_title' => 'Seo Title',
                    $prefix . '-seo_description' => 'Seo Description',
                    $prefix . '-status_content' => 'Status Content',
                    $prefix . '-status_publish' => 'Status Publish',
                    $prefix . '-status_service' => 'Status Service',
                    $prefix . '-status_featured' => 'Status Featured',
                    $prefix . '-testimonial_customerName' => 'Testimonial Customer Name',
                    $prefix . '-testimonial_customerTitle' => 'Testimonial Customer Title',
                    $prefix . '-testimonial_des' => 'Testimonial Description',
                    $prefix . '-testimonial_rating' => 'Testimonial Rating',
                    $prefix . '-testimonial_title' => 'Testimonial Title',
                ];

                foreach ($meta_keys as $key => $meta_key) {
                    if (!isset($all_meta_name[$key])) {
                        $all_meta_name[$key] = $meta_key;
                    }
                }
                update_option('all_iu_meta_name', $all_meta_name, false);

                //START fixe post_type
                if ($saved_type_posts = get_option('_' . $prefix . '_custom_type_posts')) {
                    for ($i = 0, $iMax = count($saved_type_posts); $i < $iMax; $i++) {
                        if (isset($saved_type_posts[$i]['slug'])) {
                            $saved_type_posts[$i]['slug'] =
                                $prefix .
                                '_' .
                                $admin->cleanup_post_type_slug($saved_type_posts[$i]['slug']);
                        }
                    }
                    update_option('_' . $prefix . '_custom_type_posts', $saved_type_posts);
                }
                if ($saved_slugs = get_option('_' . $prefix . '_custom_type_slug')) {
                    for ($i = 0, $iMax = count($saved_slugs); $i < $iMax; $i++) {
                        if (isset($saved_slugs[$i])) {
                            $saved_slugs[$i] =
                                $prefix . '_' . $admin->cleanup_post_type_slug($saved_slugs[$i]);
                        }
                    }
                    update_option('_' . $prefix . '_custom_type_slug', $saved_slugs);
                }

                //START update permalinks
                global $wp_rewrite;
                $wp_rewrite->flush_rules(true);
                flush_rewrite_rules();

                break;
            }
        }
    }
}

//One run of the post_type check
if (!get_option('_iu_one_run_check_post_type_up9')) {
    try {
        if (get_option('_iu_one_run_check_post_type')) {
            delete_option('_iu_one_run_check_post_type');
        }
        if (get_option('_iu_one_run_check_post_type_up')) {
            delete_option('_iu_one_run_check_post_type_up');
        }

        global $wpdb;
        $admin = new Admin();
        $prefix = $admin::get_type_prefix();

        if ($saved_type_posts = get_option('_' . $prefix . '_custom_type_posts')) {
            for ($i = 0, $iMax = count($saved_type_posts); $i < $iMax; $i++) {
                if (isset($saved_type_posts[$i]['slug'])) {
                    $saved_type_posts[$i]['slug'] =
                        $prefix .
                        '_' .
                        $admin->cleanup_post_type_slug($saved_type_posts[$i]['slug']);
                }
            }
            update_option('_' . $prefix . '_custom_type_posts', $saved_type_posts);
        }

        if ($saved_slugs = get_option('_' . $prefix . '_custom_type_slug')) {
            for ($i = 0, $iMax = count($saved_slugs); $i < $iMax; $i++) {
                if (isset($saved_slugs[$i])) {
                    $cleaned_slug = $admin->cleanup_post_type_slug($saved_slugs[$i]);
                    $new_post_type = $prefix . '_' . $cleaned_slug;
                    $saved_slugs[$i] = $new_post_type;
                    $regex = sprintf('^iu(_iu)*_%s$', $cleaned_slug);
                    $wpdb->query(
                        $wpdb->prepare(
                            "UPDATE $wpdb->posts SET post_type = %s WHERE post_type REGEXP %s",
                            $new_post_type,
                            $regex
                        )
                    );
                }
            }
            update_option('_' . $prefix . '_custom_type_slug', $saved_slugs);

            $wpdb->query(
                $wpdb->prepare(
                    "UPDATE $wpdb->posts SET post_type = %s WHERE post_type = %s",
                    'iu_project',
                    'project'
                )
            );
        }

        update_option('_iu_one_run_check_post_type_up9', true);
    } catch (\Exception $e) {
        var_dump($e);
    }
}

#Update the plugin
require 'plugin-update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'https://github.com/MSBNW/InstantUploaderPlugin',
    __FILE__,
    'instantup'
);

#Optional: If you're using a private repository, specify the access token like this:
$myUpdateChecker->setAuthentication('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');


#Optional: Set the branch that contains the stable release.
$myUpdateChecker->setBranch('dev');
