<?php


namespace InstantUploader;

if ( ! defined( 'WPINC' ) ) {
	die;
}


class Blocks extends Admin  {

	public function __construct() { Admin::__construct(); }

	public function get_partition( $list, $p ) {
		return $this->partition($list, $p);
	}


	public function prefix_t() {
		return self::get_type_prefix();//iu
	}

	public function set_cat_slug() {
		return 'instant-up-block';
	}

	public function set_cat_name() {
		return __( 'InstantUploader' );
	}

	public function set_cat_icon() {
		return 'tagcloud';
	}

	public function is_admin() {
		if ( strpos( $_SERVER['REQUEST_URI'], '/index.php?rest_route=%2Fcarbon-fields' ) !== false ||
		     strpos( $_SERVER['REQUEST_URI'], '/wp-json/carbon-fields/v1/block-renderer?_locale=user' ) !== false){
			return true;
		}

		return false;
	}

	public function init() {
		add_action( 'carbon_fields_register_fields', array( $this, 'set_blocks' ) );
		add_filter( 'carbon_fields_map_field_api_key', array( $this, 'crb_get_gmaps_api_key' ) );
	}


	public function crb_get_gmaps_api_key( $key ) {
		return get_option( '_pap_google_maps_api_key' ) ? : '';
	}

	public function set_blocks() {
		include_once INSTANTUP_PATH . 'src/blocks/iu_content-map.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_projects-map.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_posts-list.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_all-testimonials.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_ai-writeups.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_prev-next-post.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_btn-back.php';

		include_once INSTANTUP_PATH . 'src/blocks/realestate-one/header.php';
		include_once INSTANTUP_PATH . 'src/blocks/realestate-one/slider.php';
		include_once INSTANTUP_PATH . 'src/blocks/realestate-one/fields.php';

		include_once INSTANTUP_PATH . 'src/blocks/iu_filters.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_title.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_cover.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_before-after.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_content.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_cat_and_tag.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_location.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_swiper.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_tags.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_category.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_social.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_testimonial.php';
		include_once INSTANTUP_PATH . 'src/blocks/iu_gallery.php';
	}

}