<?php
/**
 * iu-cat_and_tag.php
 * create in 12.05.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

Block::make( __( 'IU Category and Tag' ) )
     ->add_tab( __( 'General' ), array(
	     Field::make( 'checkbox', 'iu_inline_style', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Use Inline Block Style' ) ),
	     Field::make( 'text', 'iu_cat_tag_columns', __( 'Columns' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 2',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_inline_style',
			          'value' => false,
		          ),
	          ) ),

	     Field::make( 'checkbox', 'iu_hide_loc', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Location' ) ),
	     Field::make( 'radio', 'iu_location_option', __( 'Location Display Options' ) )
	          ->set_classes( 'iu-radio-option' )
	          ->set_default_value( 'generalized' )
	          ->add_options( array(
		          'exact'       => 'Exact',
		          'generalized' => 'Generalized',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hide_loc',
			          'value' => false,
		          ),
	          ) ),
     ) )
     ->add_tab( __( 'Maine Title' ), array(
	     Field::make( 'color', 'color_title', __( 'Color for title' ) )
	          ->set_default_value( '#212529' ),
	     Field::make( 'text', 'font_size_title', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 28',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_title', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 36',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Maine Description' ), array(
	     Field::make( 'color', 'color_desc', __( 'Color for title' ) )
	          ->set_default_value( '#212529' ),
	     Field::make( 'text', 'font_size_desc', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_desc', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 27',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Card' ), array(
	     Field::make( 'checkbox', 'iu_hide_shadow', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Shadow' ) ),
	     Field::make( 'checkbox', 'iu_hide_img', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Picture' ) ),
	     Field::make( 'color', 'background_card', __( 'Background Card' ) )
	          ->set_default_value( '#fafaff' )
	          ->set_alpha_enabled( true ),
	     Field::make( 'color', 'color_item_title', __( 'Color for card title' ) )
	          ->set_default_value( '#50505a' ),
	     Field::make( 'color', 'border_color_card', __( 'Border Color' ) )
	          ->set_default_value( '#fafaff' )
	          ->set_alpha_enabled( true ),
	     Field::make( 'text', 'font_size_card_title', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 20',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_card_title', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 34',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'items_bdrs', __( 'Border Radius (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 3',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'border_width_card', __( 'Border Width (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Tags in posts' ), array(
	     Field::make( 'checkbox', 'iu_hide_tags', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Tags' ) ),

	     Field::make( 'color', 'bg_tags', __( 'Background for Tag ' ) )
	          ->set_default_value( '#63adff' ),

     ) )
     ->add_tab( __( 'Pagination' ), array(
	     Field::make( 'color', 'bg_item_nav_current', __( 'Background for Current' ) )
	          ->set_default_value( '#ff8c00' ),
	     Field::make( 'color', 'color_nav_current_txt', __( 'Color Current For Text' ) )
	          ->set_default_value( '#fafaff' ),
	     Field::make( 'color', 'bg_item_nav', __( 'Background For All' ) )
	          ->set_default_value( '#f0f0fa' ),
	     Field::make( 'color', 'color_nav_txt', __( 'Color For Text' ) )
	          ->set_default_value( '#5a5a64' ),
	     Field::make( 'text', 'font_size_nav', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 12',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_nav', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_mode( 'preview' )
     ->set_render_callback( function ( $fields ) {
	     $tax_object = get_queried_object();

	     if ( $fields['iu_cat_tag_columns'] === '1' ) {
		     $column = 12;
	     } elseif ( $fields['iu_cat_tag_columns'] === '2' ) {
		     $column = 6;
	     } elseif ( $fields['iu_cat_tag_columns'] === '3' ) {
		     $column = 4;

	     } elseif ( $fields['iu_cat_tag_columns'] === '4' ) {
		     $column = 3;
	     } else {
		     $column = 6;
	     }

	     $main_clases = "profolio-col-12 profolio-col-sm-{$column} profolio-col-md-{$column}";

	     if ( $fields['iu_inline_style'] ) {
		     $main_clases = 'iu-cat-tag-post mr-2';
	     }
	     ?>

         <style>
             <?php
             if ($fields['iu_inline_style']):
             echo '.iu-cat-tag-wrap .profolio-row.js-projects-wrapper{';
             echo 'margin-right: 0;';
             echo 'margin-left: 0;';
             echo '}';
             endif;


             if ($fields['bg_tags']):
             echo '.profolio-card-category-frame a {';
             echo 'background-color: ' . $fields['bg_tags'] . ' !important ;';
             echo '}';
             endif;
             ?>

             .profolio-project-card {
             <?php
              if ( $fields['background_card'] ){
                 echo 'background-color: ' . $fields['background_card'] . ' !important ;';
              }
              if ($fields['iu_hide_shadow']){
                  echo 'box-shadow: none;';
                  echo '-webkit-box-shadow: none;';
              }
              if ($fields['items_bdrs']){
                echo "border-radius: {$fields['items_bdrs']}px;";
              }
              if ($fields['border_width_card']){
                echo 'border-style: solid;';
                echo "border-width: {$fields['border_width_card']}px;";
              }
              if ($fields['border_color_card']){
                echo "border-color: {$fields['border_color_card']};";
              }
			  ?>
             }

             .profolio-section-title h3 span {
             <?php
              if ( $fields['color_title'] ){
                 echo 'color: ' . $fields['color_title'] . ' !important ;';}

              if ( $fields['font_size_title'] ){
                 echo 'font-size: ' . $fields['font_size_title'] . 'px;';}

              if ( $fields['line_height_title'] ){
                 echo 'line-height: ' . $fields['line_height_title'] . 'px;';}
			  ?>
             }

             .profolio-header-xs {
             <?php
              if ( $fields['color_item_title'] ){
                 echo 'color: ' . $fields['color_item_title'] . ' !important ;';}

              if ( $fields['font_size_card_title'] ){
                 echo 'font-size: ' . $fields['font_size_card_title'] . 'px;';}

              if ( $fields['line_height_card_title'] ){
                 echo 'line-height: ' . $fields['line_height_card_title'] . 'px;';}
             ?>
             }

             .taxonomy-description p {
             <?php
              if ( $fields['color_desc'] ){
                  echo 'color: ' . $fields['color_desc'] . ' !important ;';}

              if ( $fields['font_size_desc'] ){
                 echo 'font-size: ' . $fields['font_size_desc'] . 'px !important;';}

              if ( $fields['line_height_desc'] ){
                 echo 'line-height: ' . $fields['line_height_desc'] . 'px !important;';}
             ?>
             }

             .profolio-pagination .current {
             <?php
              if ( $fields['font_size_nav'] ){
                 echo 'font-size: ' . $fields['font_size_nav'] . 'px !important;';}

              if ( $fields['line_height_nav'] ){
                 echo 'line-height: ' . $fields['line_height_nav'] . 'px !important;';}

              if ( $fields['color_nav_current_txt'] ){
                 echo 'color: ' . $fields['color_nav_current_txt'] . ' !important ;';}
              if ( $fields['bg_item_nav_current'] ){
                 echo 'background-color: ' . $fields['bg_item_nav_current'] . ' !important ;';}
              ?>
             }

             .profolio-pagination li a {
             <?php
             if ( $fields['font_size_nav'] ):
                 echo 'font-size: ' . $fields['font_size_nav'] . 'px !important;'; endif;

              if ( $fields['line_height_nav'] ):
                 echo 'line-height: ' . $fields['line_height_nav'] . 'px !important;'; endif;

              if ( $fields['color_nav_txt'] ):
                 echo 'color: ' . $fields['color_nav_txt'] . ' !important ;'; endif;
              if ( $fields['bg_item_nav'] ):
                 echo 'background-color: ' . $fields['bg_item_nav'] . ' !important ;'; endif;
              ?>
             }
         </style>

         <div class="block iu-cat-tag-wrap">
		     <?php if ( $tax_object ):
			     $page = get_query_var( 'paged' );
			     if ( empty( $page ) ):
				     the_archive_description( '<div class="taxonomy-description">', '</div>' );
			     endif;
		     else:
			     echo '<div class="taxonomy-description"><p>Category and tag description. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua...</p></div>';
		     endif; ?>
             <div class="profolio-underline mb30"></div>

             <div class="profolio-row js-projects-wrapper">
			     <?php
			     if ( $tax_object ):
				     if ( have_posts() ) :
					     while ( have_posts() ) : the_post();
						     if ( strpos( get_post_type(), 'iu_testimon' ) !== false ) {
							     continue;
						     }

						     $post_id = get_the_ID();
						     ?>
                             <div class="<?php echo $main_clases ?>">
                                 <div class="profolio-project-card">

								     <?php if ( ! $fields['iu_hide_img'] ): ?>
                                         <div class="profolio-card-image-frame">
										     <?php if ( has_post_thumbnail() ) : ?>
                                                 <div class="profolio-card-image-frame">
                                                     <a href="<?php the_permalink(); ?>" class="profolio-card-cover">
													     <?php the_post_thumbnail( 'medium_large' ); ?>
                                                     </a>
                                                 </div>
										     <?php else: ?>
                                                 <div class="profolio-card-image-frame">
                                                     <a href="<?php the_permalink(); ?>" class="profolio-card-cover">
                                                         <img src="<?php echo INSTANTUP_URL . 'data/assets/img/placeholder.png' ?>"
                                                              class="no-pic attachment-medium_large size-medium_large wp-post-image" alt="no pic">
                                                     </a>
                                                 </div>
										     <?php endif; ?>
                                         </div>
								     <?php endif; ?>

                                     <div class="profolio-card-descr">
									     <?php the_title( '<a href="' . get_the_permalink() . '"  class="profolio-header-xs">',
										     '</a>' ); ?>

									     <?php if ( ! $fields['iu_hide_tags'] ):
										     $all_tags = array();

										     if ($post_id && ($tags = get_the_terms($post_id, $this->prefix_t() . '_tags')) && is_array($tags) ):
											     $all_tags = array_merge( $all_tags, $tags );
										     endif;

										     if ( $post_id && ($label_tags = get_the_terms( $post_id, $this->prefix_t() . '_label_tags' )) && is_array($label_tags) ):
											     $all_tags = array_merge( $all_tags, $label_tags );
										     endif;

										     if ( count($all_tags) ): ?>
                                                 <div class="profolio-card-category-frame">
												     <?php foreach ( $all_tags as $tag ) :
													     echo '<a href="/' . $tag->taxonomy . '/' . $tag->slug . '/" rel="tag">' . $tag->name . '</a>';
												     endforeach; ?>
                                                 </div>
										     <?php endif;
									     endif; ?>

									     <?php if ( ! $fields['iu_hide_loc'] ):
										     if ( $address = get_post_meta( $post_id, 'iu-address' )[0] ) :
											     $county  = get_post_meta( $post_id, 'iu-county', true );
											     $state   = get_post_meta( $post_id, 'iu-state', true );
											     $country = get_post_meta( $post_id, 'iu-country', true );

											     echo '<div class="profolio-text-sm">';
											     echo '<i class="pro_fa pro_fa-map-marker-alt"></i>';
											     if ( $fields['iu_location_option'] === 'exact' ):
												     echo $address;
											     else:
												     $state_out = $state ? $state . ', ' : '';
												     echo $county . ', ' . $state_out . $country;
											     endif;
											     echo '</div>';
										     endif;
									     endif; ?>

                                     </div>
                                 </div>
                             </div>
					     <?php endwhile;

				     endif;

			     else:
				     $temp_pic = INSTANTUP_URL . 'data/assets/img/temp_img/temp_thumbnail.jpg';
				     $temp_title = 'Title sample';
				     $temp_address = '18601 Valley Boulevard, Bloomington, CA, USA';
				     $temp_state = 'Bloomington';
				     $temp_county = 'CA';
				     $temp_country = 'USA';

				     for ( $i = 0; $i <= 5; $i ++ ): ?>
                         <div class="<?php echo $main_clases ?>">
                             <div class="profolio-project-card">

							     <?php if ( ! $fields['iu_hide_img'] ): ?>
                                     <div class="profolio-card-image-frame">
                                         <div class="profolio-card-image-frame">
                                             <a class="profolio-card-cover">
                                                 <img src="<?php echo $temp_pic ?>"
                                                      class="no-pic attachment-medium_large size-medium_large wp-post-image"
                                                      alt="no pic">
                                             </a>
                                         </div>
                                     </div>
							     <?php endif; ?>

                                 <div class="profolio-card-descr">
                                     <a class="profolio-header-xs"><?php echo $temp_title ?></a>

								     <?php if ( ! $fields['iu_hide_tags'] ): ?>
                                         <div class="profolio-card-category-frame">
                                             <a href="/" rel="tag">Sample tag1</a>
                                             <a href="/" rel="tag">Sample tag2</a>
                                             <a href="/" rel="tag">Sample tag3</a>
                                         </div>
								     <?php endif; ?>

								     <?php if ( ! $fields['iu_hide_loc'] ): ?>
                                         <div class="profolio-text-sm">
                                             <i class="pro_fa pro_fa-map-marker-alt"></i>
										     <?php if ( $fields['iu_location_option'] === 'exact' ):
											     echo $temp_address;
										     else:
											     echo $temp_state . ', ' . $temp_county . ', ' . $temp_country;
										     endif; ?>
                                         </div>
								     <?php endif; ?>
                                 </div>
                             </div>
                         </div>
				     <?php endfor;
			     endif; ?>
             </div>

             <div class="profolio-row">
                 <div class="profolio-col-12 text-center profolio-pagination">
                     <nav>
					     <?php
					     if ( $tax_object ):
						     global $wp_query;

						     echo paginate_links( array(
							     'total'        => $wp_query->max_num_pages,
							     'current'      => max( 1, get_query_var( 'paged' ) ),
							     'show_all'     => false,
							     'type'         => 'list',
							     'end_size'     => 2,
							     'mid_size'     => 1,
							     'prev_next'    => true,
							     'prev_text'    => esc_html__( 'Previous', 'instantup' ),
							     'next_text'    => esc_html__( 'Next', 'instantup' ),
							     'add_args'     => false,
							     'add_fragment' => '',
						     ) );
					     else: ?>
                             <ul class="page-numbers">
                                 <li><span aria-current="page" class="page-numbers current">1</span></li>
                                 <li><a class="page-numbers">2</a></li>
                                 <li><a class="page-numbers">3</a></li>
                                 <li><a class="next page-numbers">Next</a></li>
                             </ul>
					     <?php endif; ?>
                     </nav>
                 </div>
             </div>

         </div>
	     <?php
     } );