<?php
/**
 * iu-category.php
 * create in 26.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;


Block::make( __( 'IU Category' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() ),
     ) )
     ->add_tab( __( 'Title' ), array(
	     Field::make( 'checkbox', 'iu_hidden_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Title' ) ),

	     Field::make( 'checkbox', 'iu_hide_colon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Colon' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_hide_icon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Icon' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_underline_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Underline' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'color_title', __( 'Color For Title' ) )
	          ->set_default_value( '#000' ),

	     Field::make( 'text', 'title_txt', __( 'Text For Title' ) )
	          ->set_attributes( array(
		          'placeholder' => 'Title Category',
	          ) ),

	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 11',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'select', 'font_weight', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'line_height', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ) ),
	     Field::make( 'text', 'margin_top', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 10',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Links' ), array(
	     Field::make( 'color', 'color_title_link', __( 'Color For Links' ) )
	          ->set_default_value( '#ffffff' ),

	     Field::make( 'color', 'background_link', __( 'Background Color' ) )
	          ->set_default_value( '#007bff' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_bg_transparent',
			          'value' => false,
		          ),
	          ) ),

	     Field::make( 'checkbox', 'iu_bg_transparent', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Background Transparent' ) ),

	     Field::make( 'text', 'font_size_link', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 10',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'select', 'font_weight_links', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'line_height_link', __( 'Line Height (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),

	     Field::make( 'text', 'border_radius_link', __( 'Border radius' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),

	     Field::make( 'text', 'margin_top_link', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom_link', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 10',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'separator', 'separator_3', __( 'Padding (px)' ) )
	          ->set_classes( 'iu-separator-margin' ),
	     Field::make( 'text', 'padding_top_link', __( 'Top' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right_4' )
	          ->set_width( 23 ),
	     Field::make( 'text', 'padding_bottom_link', __( 'Bottom' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right_4' )
	          ->set_width( 23 ),
	     Field::make( 'text', 'padding_left_link', __( 'Left' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '15',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right_4' )
	          ->set_width( 23 ),
	     Field::make( 'text', 'padding_right_link', __( 'Right' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '15',
	          ) )
	          ->set_width( 23 ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $post_id  = get_the_ID();
	     $taxonomy = $this->prefix_t() . '_categories';
	     $get_font = isset( $fields['select_fonts'] ) ? explode( ':', $fields['select_fonts'] ) : false;
	     ?>

	     <style>
		     <?php
			 if ($get_font){
				echo '.iu-cat-block-title,
				 .profolio-card-category-frame,
				 .block__content .iu-cats-links a {';
				echo "font-family: '{$get_font[0]}', Sans-serif !important;";
				echo '}';
			 }

			 if ($fields['font_size'] || $fields['line_height'] || $fields['color_title'] || $fields['margin_top'] ||
			  $fields['margin_bottom'] || $fields['font_weight'] ){
				echo '.iu-cat-block-title {';
				if ($fields['font_size']){
					echo "font-size: {$fields['font_size']}px !important;";
				}
				if ($fields['font_weight']){
					echo "font-weight: {$fields['font_weight']};";
				}
				if ($fields['line_height']){
					echo "line-height: {$fields['line_height']}px !important;";
				}
				if ($fields['color_title']){
					echo "color: {$fields['color_title']};";
				}
				if ($fields['margin_top']){
					echo "margin-top: {$fields['margin_top']}px;";
				}
				if ($fields['margin_bottom']){
					echo "margin-bottom: {$fields['margin_bottom']}px;";
				}
				echo '}';
				}

			 if ($fields['margin_top_link'] || $fields['margin_bottom_link'] ){
				 echo '.iu-cats-links {';
				 if ($fields['margin_top_link']){
					 echo "margin-top: {$fields['margin_top_link']}px !important;";
				 }
				 if ($fields['margin_bottom_link'] === '0' || (int)$fields['margin_bottom_link'] > 0){
					 echo "margin-bottom: {$fields['margin_bottom_link']}px !important;";
				 }
				 echo '}';
			 }

			 if ($fields['font_size_link'] || $fields['line_height_link'] || $fields['color_title_link'] ||
			 ($fields['border_radius_link'] === '0' || (int)$fields['border_radius_link'] > 0) ||
			 ($fields['padding_top_link'] === '0' || (int)$fields['padding_top_link'] > 0) ||
			 ($fields['padding_bottom_link'] === '0' || (int)$fields['padding_bottom_link'] > 0) ||
			 ($fields['padding_left_link'] === '0' || (int)$fields['padding_left_link'] > 0) ||
			 ($fields['padding_right_link'] === '0' || (int)$fields['padding_right_link'] > 0) || $fields['background_link'] ){
				echo '.block__content .iu-cats-links a {';
				 if ($fields['font_size_link']){
					echo "font-size: {$fields['font_size_link']}px !important;";
				 }
				 if ($fields['font_weight_links']){
					echo "font-weight: {$fields['font_weight_links']} !important;";
				 }
				 if ($fields['line_height_link']){
					echo "line-height: {$fields['line_height_link']}px;";
				 }
				 if ($fields['color_title_link']){
					echo "color: {$fields['color_title_link']} !important;";
				 }
				 if ($fields['border_radius_link'] === '0' || (int)$fields['border_radius_link'] > 0){
					echo "border-radius: {$fields['border_radius_link']}px;";
				 }
				 if ($fields['padding_top_link'] === '0' || (int)$fields['padding_top_link'] > 0){
					echo "padding-top: {$fields['padding_top_link']}px;";
				 }
				 if ($fields['padding_bottom_link'] === '0' || (int)$fields['padding_bottom_link'] > 0){
					echo "padding-bottom: {$fields['padding_bottom_link']}px;";
				 }
				 if ($fields['padding_left_link'] === '0' || (int)$fields['padding_left_link'] > 0){
					echo "padding-left: {$fields['padding_left_link']}px;";
				 }
				 if ($fields['padding_right_link'] === '0' || (int)$fields['padding_right_link'] > 0){
					echo "padding-right: {$fields['padding_right_link']}px;";
				 }
				 if ($fields['background_link'] && !$fields['iu_bg_transparent']){
					echo "background-color: {$fields['background_link']};";
				 }
				 if ($fields['iu_bg_transparent']){
					echo "background-color: transparent;";
				 }
				 echo '}';
			 }

			 if ($fields['color_title_link'] ){
				 echo '.iu-cats-links a:hover {';
				 echo "color: {$fields['color_title_link']};";
				 echo '}';
			 }
			 ?>
	     </style>

	     <div class="block iu-category-block">
		     <div class="block__content mb30">
			     <?php
			     $html_title = '';

			     if ( ! $fields['iu_hidden_title'] ) :
				     $title = $fields['title_txt'] ? : esc_html__( 'Category', 'instantup' );

				     ob_start();
				     echo '<div class="iu-cat-block-title profolio-text-sm">';

				     if ( ! $fields['iu_hide_icon'] ) :
					     echo '<i class="pro_fa pro_fa-list"></i>';
				     endif;

				     echo $fields['iu_hide_colon'] ? $title : $title . ':';

				     if ( ! $fields['iu_underline_title'] ):
					     echo '<hr>';
				     endif;
				     echo '</div>';

				     $html_title = ob_get_clean();
			     endif;


			     if ( $post_id && ! empty( get_the_terms( $post_id, $this->prefix_t() . '_categories' ) ) ) :
				     echo $html_title;

				     if ( ($categories = get_the_terms( $post_id, $taxonomy )) && is_array($categories) ) {
					     echo '<ul class="iu-cats-links">';
					     foreach ( $categories as $category ) {
						     echo '<li>';
						     echo "<a href='". get_term_link($category->term_id, $taxonomy) ."'>{$category->name}</a>";
						     echo '</li>';
					     }
					     echo '</ul>';
				     }
			     endif; ?>

			     <?php if ( ! is_singular() ) :
				     echo $html_title ?>

				     <ul class="iu-cats-links">
					     <li><a href="#" rel="tag">Category 1</a></li>
					     <li><a href="#" rel="tag">Category 2</a></li>
					     <li><a href="#" rel="tag">Category 3</a></li>
				     </ul>
			     <?php endif; ?>

		     </div>
	     </div>
	     <?php
     } );