<?php
/**
 * iu-gallery.php
 * create in 27.05.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Gallery' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'checkbox', 'iu_lazy_load', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( __( 'Lazy Load (off/on)' ) )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'select', 'iu_image_size', __( 'Image Size' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_default_value( 'large' )
	          ->add_options( array(
		          'medium'    => __( 'Medium' ),
		          'thumbnail' => __( 'Thumbnail' ),
		          'large'     => __( 'Large' ),
		          'full'      => __( 'Full' ),
	          ) ),
	     Field::make( 'select', 'iu_order_by', __( 'Order By' ) )
	          ->set_width( 45 )
	          ->set_options( array(
		          '' => __( 'Default' ),
	          ) )
	          ->add_options( array(
		          'random' => __( 'Random' ),
	          ) ),

	     Field::make( 'select', 'iu_link', __( 'Link' ) )
	          ->set_default_value( 'media_file' )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_options( array(
		          'media_file' => __( 'Media File' ),
	          ) )
	          ->add_options( array(
		          'none' => __( 'None' ),
	          ) ),

	     Field::make( 'select', 'iu_columns', __( 'Columns' ) )
	          ->set_width( 45 )
	          ->set_default_value( '3' )
	          ->add_options( array(
		          '1'  => 1,
		          '2'  => 2,
		          '3'  => 3,
		          '4'  => 4,
		          '6'  => 6,
		          '12' => 12,
	          ) ),

	     Field::make( 'text', 'iu_img_height', __( 'Img Height' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 250px',
	          ) ),

	     Field::make( 'select', 'align_text', __( 'Alignment Text' ) )
	          ->set_width( 45 )
	          ->set_options( array(
		          'left' => __( 'Left' ),
	          ) )
	          ->add_options( array(
		          'center' => __( 'Center' ),
		          'right'  => __( 'Right' ),
	          ) ),


	     Field::make( 'text', 'iu_spacing_between', __( 'Spacing Between' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_default_value( false )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) ),

	     Field::make( 'text', 'iu_spacing_bottom', __( 'Spacing Bottom' ) )
	          ->set_width( 45 )
	          ->set_default_value( false )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) ),

	     Field::make( 'text', 'border_radius_items_pic', __( 'Border radius (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) ),

	     Field::make( 'color', 'bcg_txt', 'Background Text Block' )
	          ->set_alpha_enabled( true )
	          ->set_default_value( '#fff' ),

     ) )
     ->add_tab( __( 'Title block' ), array(
	     Field::make( 'checkbox', 'iu_show_title', '' )
	          ->set_default_value( false )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Show title block?' ) ),

	     Field::make( 'text', 'iu_gallery_title', __( 'Text' ) )
	          ->set_default_value( 'Gallery' )
	          ->set_attributes( array(
		          'placeholder' => 'text',
	          ) ),

	     Field::make( 'color', 'gallery_content_color', __( 'Color for Content' ) )
	          ->set_default_value( '#212529' ),

	     Field::make( 'select', 'gallery_select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() ),

	     Field::make( 'text', 'gallery_font_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'select', 'gallery_block_width', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'select', 'gallery_position_txt', __( 'Position Text' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'left'   => 'Left',
		          'center' => 'Center',
		          'right'  => 'Right',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'gallery_line_height', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 39',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'gallery_margin_top', __( 'Margin Top (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'gallery_margin_bottom', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 10',
	          ) )
	          ->set_width( 45 ),

     ) )
     ->add_tab( __( 'Hide or show blocks' ), array(
	     Field::make( 'checkbox', 'iu_show_img_title', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Media Title (show/hide)' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_show_img_caption', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Media Caption (show/hide)' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_show_img_desc', '' )
	          ->set_classes( 'iu-toggle-checked is_swiper iu_block_checkbox' )
	          ->set_help_text( 'Media Description (show/hide)' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'select', 'iu_txt_position', __( 'Position Select' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_options( array(
		          'under' => __( 'Under the image' ),
	          ) )
	          ->add_options( array(
		          'overlay' => __( 'Overlay' ),
	          ) ),


     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $column       = '';
	     $style        = '';
	     $count        = 0;
	     $entropy      = uniqid();
	     $media_list   = array();
	     $post_id      = get_the_ID() ? : get_option( '_temp_post_for_templates' );
	     $pic_for_post = get_post_meta( $post_id, $this->prefix() . 'pic_for_post', true );
	     $img_lazy     = '';
	     $on_overlay   = $fields['iu_txt_position'] === 'overlay' ? 'iu-gallery-overlay' : '';
	     $columns      = (int) $fields['iu_columns'];

	     if ( $fields['iu_spacing_between'] === '' || $fields['iu_spacing_between'] === false ) {
		     $spacing_between = false;
	     } else {
		     $spacing_between = (int) $fields['iu_spacing_between'];
	     }

	     if ( $fields['iu_spacing_bottom'] === '' || $fields['iu_spacing_bottom'] === false ) {
		     $spacing_bottom = false;
	     } else {
		     $spacing_bottom = (int) $fields['iu_spacing_bottom'];
	     }

	     if ( $fields['iu_order_by'] === 'random' ) {
		     shuffle( $pic_for_post );
	     }

	     if ( $fields['iu_lazy_load'] ) {
		     $img_lazy = 'loading="lazy"';
	     }

	     if ( $spacing_between === 0 || $spacing_bottom === 0 ) {
		     $style = 'style="';
		     $style .= $spacing_between === 0 ? 'margin-left:0; margin-right:0;' : '';
		     $style .= $spacing_bottom === 0 ? 'margin-bottom:30px;' : '';
		     $style .= '"';
	     }

	     if ( $pic_for_post ): ?>
             <style>
                 <?php

				 if ( ($spacing_between !== false) || ($spacing_bottom !== false) ){
					echo '.iu-card-gallery {';
					if ($spacing_between !== false){
						echo "padding: 0 {$spacing_between}px;";
					}

					if ($spacing_bottom >= 0){
						echo "margin-bottom: {$spacing_bottom}px;";
					}
					echo '}';
				 }

				 if ($fields['iu_img_height']){
				    echo '.iu-card-gallery-item {';
				    echo "height: {$fields['iu_img_height']}px !important;";
				    echo "max-height: {$fields['iu_img_height']}px !important;";
				    echo '}';
				 }

				 if ($fields['align_text'] || $fields['bcg_txt']){
					echo '.iu-card-gallery-item .card-body {';
					if ($fields['align_text']){
						echo "text-align: {$fields['align_text']};";
					}

					if ($fields['bcg_txt']){
						echo "background-color: {$fields['bcg_txt']};";
					}
					echo '}';
				 }

				 if ($columns && $columns <= 12 ){
					if ($columns === 2){
						$column = 'profolio-col-md-6 profolio-col-lg-6';
					} elseif ($columns === 3){
						$column = 'profolio-col-md-4 profolio-col-lg-4';

					} elseif ($columns === 4){
						$column = 'profolio-col-md-3 profolio-col-lg-3';

					} elseif ($columns === 6){
						$column = 'profolio-col-md-3 profolio-col-lg-2';

					} elseif ($columns === 12){
						$column = 'profolio-col-md-6 profolio-col-lg-1';
					}
				 }

				 echo '.block .iu-gallery-block .iu-gallery-title {';
				 if ($fields['gallery_content_color']){
                    echo "color: {$fields['gallery_content_color']};";
				 }
				 if ($fields['gallery_font_size']){
                    echo "font-size: {$fields['gallery_font_size']}px;";
				 }
				 if ($fields['gallery_block_width']){
                    echo "font-weight: {$fields['gallery_block_width']};";
				 }
				 if ($fields['gallery_line_height']){
                    echo "line-height:{$fields['gallery_line_height']}px;";
				 }
				 if ($fields['gallery_position_txt']){
                    echo "text-align:{$fields['gallery_position_txt']};";
				 }
				 if ($fields['gallery_margin_top']){
                    echo "margin-top:{$fields['gallery_margin_top']}px;";
				 }
				 if ($fields['gallery_margin_bottom']){
                    echo "margin-bottom:{$fields['gallery_margin_bottom']}px;";
				 }
				 echo '}';

				 if ($fields['border_radius_items_pic']){
				    echo '.iu-card-gallery .card, .iu-card-gallery-item .card-img-top {';
				    echo "border-radius: {$fields['border_radius_items_pic']}px;";
				    echo '}';
				 }

				 ?>
             </style>

             <div class="block">
                 <div class="block__content iu-gallery-block" data-media-ogj="iu_gallery_<?php echo $entropy ?>">
				     <?php if ( $fields['iu_show_title'] ) {
					     echo "<h3 class='iu-gallery-title'>{$fields['iu_gallery_title']}</h3>";
				     } ?>

                     <div <?php echo $style ?> class="profolio-row <?php echo $fields['iu_link'] === 'media_file' ? 'iu_use_lightGallery' : '' ?>">

					     <?php foreach ( $pic_for_post as $key => $pic ) :
						     $pic_id = $pic['id'] ?? $pic;
						     $file_src = wp_get_attachment_url( $pic_id );
						     $file_name = basename( $file_src );
						     $path_file = get_attached_file( $pic_id );
						     $file_type = wp_check_filetype_and_ext( $file_name, $path_file );
						     $post_img = get_post( $pic_id, ARRAY_A );
						     $alt_text = get_post_meta( $pic_id, '_wp_attachment_image_alt', true ) ? : $post_img['post_title'];

						     ?>

                             <div class="iu-card-gallery profolio-col-12 <?php echo $column; ?>">
                                 <div class="card iu-card-gallery-item" data-src="<?php echo $file_src; ?>">
								     <?php if ( strpos( $file_type['type'], 'video/' ) !== false ):
									     $thumb_video_id = (int) get_post_meta( $pic_id, 'iu-thumb', true );
									     $thumb_src = wp_get_attachment_image_url( $thumb_video_id,
										     $fields['iu_image_size'] ) ? : INSTANTUP_URL . 'data/assets/img/video_cover.png';
									     $media_list[] = array(
										     'html'  => "#iu_gallery_video_{$entropy}_{$count}",
										     'thumb' => $thumb_src,
									     );
									     ?>
                                         <div style="display:none;" id="iu_gallery_video_<?php echo "{$entropy}_{$count}"; ?>">
                                             <video class="lg-video-object lg-html5" controls preload="none">
                                                 <source src="<?php echo wp_get_attachment_url( $pic_id ); ?>" type="video/mp4">
                                             </video>
                                         </div>

								     <?php else:
									     $thumb_src    = wp_get_attachment_image_url( $pic_id,
										     $fields['iu_image_size'] ) ? : INSTANTUP_URL . 'data/assets/img/placeholder-cover.png';
									     $media_list[] = array(
										     'src'   => wp_get_attachment_image_url( $pic_id, 'full' ),
										     'thumb' => wp_get_attachment_image_url( $pic_id ),
									     );
								     endif; ?>

                                     <a class="profolio-slctr iu-gallery-item <?php echo isset( $thumb_video_id ) ? 'profolio-video-preview' : ''; ?>" data-id="<?php echo $count; ?>">
                                         <img <?php echo $img_lazy; ?>
                                             class="card-img-top"
                                             src="<?php echo $thumb_src; ?>"
                                             title="<?php echo get_the_title( $pic_id ); ?>"
                                             alt="<?php echo $alt_text; ?>">

                                         <div class="profolio-img-hover">
										     <?php if ( isset( $thumb_video_id ) ): ?>
                                                 <i class="pro_far pro_fa-play-circle"></i>
										     <?php else: ?>
                                                 <i class="pro_fa pro_fa-search-plus"></i>
										     <?php endif; ?>
                                         </div>
                                     </a>

								     <?php if ( ( $fields['iu_show_img_title'] && $post_img['post_title'] ) ||
								                ( $fields['iu_show_img_caption'] && $post_img['post_excerpt'] ) ||
								                ( $fields['iu_show_img_desc'] && $post_img['post_content'] ) ): ?>
                                         <div class="card-body <?php echo $on_overlay; ?>">
										     <?php if ( $post_img['post_title'] && $fields['iu_show_img_title'] ): ?>
                                                 <h5 class="card-title"><?php echo $post_img['post_title'] ?></h5>
										     <?php endif; ?>

										     <?php if ( $post_img['post_excerpt'] && $fields['iu_show_img_caption'] ): ?>
                                                 <p class="card-text"><?php echo $post_img['post_excerpt'] ?></p>
										     <?php endif; ?>

										     <?php if ( $post_img['post_content'] && $fields['iu_show_img_desc'] ): ?>
                                                 <p class="card-text"><?php echo $post_img['post_content'] ?></p>
										     <?php endif; ?>
                                         </div>

								     <?php endif; ?>
                                 </div>
                             </div>
						     <?php
						     $count ++;
						     unset( $thumb_video_id );
					     endforeach;

					     if ( $media_list ) {
						     wp_localize_script(
							     'iu-main-script',
							     "iu_gallery_{$entropy}",
							     array( 'media_list' => json_encode( $media_list ) )
						     );
					     }
					     ?>
                     </div>

                 </div>
             </div>
	     <?php endif;
     } );