<?php
/**
 * iu-prev-next-post.php
 * create in 16.09.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;


Block::make( __( 'IU Post Nav' ) )
     ->add_fields( array(
	     Field::make( 'checkbox', 'iu_big_button', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Big Button' ) ),

	     Field::make( 'text', 'btn_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),

	     Field::make( 'text', 'btn_height', __( 'Line Height (px)' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 23',
	          ) ),

	     Field::make( 'color', 'btn_color', __( 'Color Text' ) )
	          ->set_default_value( '#ffffff' ),

	     Field::make( 'color', 'btn_bgc', __( 'Background Color' ) )
	          ->set_default_value( '#007bff' ),

	     Field::make( 'select', 'position_button', __( 'Position Button' ) )
	          ->set_options( array(
		          'space-between' => __( 'Between' ),
	          ) )
	          ->add_options( array(
		          'space-between' => __( 'Between' ),
		          'center'        => __( 'Center' ),
	          ) ),

	     Field::make( 'text', 'btn_bdrs', __( 'Border radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 3',
	          ) ),

	     Field::make( 'text', 'btn_txt_prev', __( 'Text for Button Prev' ) )
	          ->set_attributes( array(
		          'placeholder' => '◄ Prev',
	          ) ),

	     Field::make( 'text', 'btn_txt_next', __( 'Text for Button Next' ) )
	          ->set_attributes( array(
		          'placeholder' => 'Next ►',
	          ) ),

     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'Previous or next post' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) { ?>

         <style>
             <?php if ($fields['btn_color'] || $fields['btn_size'] || $fields['btn_height'] || $fields['btn_bgc'] || $fields['btn_bdrs']){ ?>

             .iu-post-nav-row .iu-post-nav .btn {
             <?php
				 echo $fields['btn_color']  ? "color: {$fields['btn_color']};" : '';
				 echo $fields['btn_size']   ? "font-size: {$fields['btn_size']}px;" : '';
				 echo $fields['btn_height'] ? "line-height: {$fields['btn_height']}px;" : '';

				 if ($fields['btn_bdrs'] || $fields['btn_bdrs'] >= 0 ){
					echo "border-radius: {$fields['btn_bdrs']}px;";
				 }

				 if ($fields['btn_bgc']){
					echo "background-color: {$fields['btn_bgc']} !important;";
					echo "border-color: {$fields['btn_bgc']} !important;";
					echo 'filter: grayscale(0%);';
					echo 'transition: all 200ms linear;';
				 }
			 ?>
             }

             <?php if ($fields['btn_bgc']){
				 echo '.iu-post-nav-row .iu-post-nav .btn:hover {';
					echo 'filter: grayscale(40%);';
				 echo '}';
			 } ?>

             <?php }?>

             <?php if ($fields['position_button']){ ?>
             .iu-post-nav-row {
                 justify-content: <?php echo $fields['position_button']?>;
             }
             <?php } ?>

             <?php if ($fields['iu_big_button']){ ?>
             .iu-post-nav-row .iu-post-nav .btn {
                 width: 120px;
                 height: 48px;
                 padding: 10px 0 14px 0;
             }
             <?php } ?>

         </style>

         <div class="block">
             <div class="block__content">

                 <div class="profolio-row iu-post-nav-row">
                     <div class="profolio-col-5 profolio-col-md-4 iu-post-nav iu-post-nav-prev">
					     <?php
					     $txt_prev = esc_html( $fields['btn_txt_prev'] ) ? : '◄ Prev';

					     if ( get_the_ID() ) {
						     $prev = get_previous_post_link( '%link', $txt_prev );

						     echo str_replace( '<a', '<a class="btn btn-primary"', $prev );

					     } else {
						     echo '<div class="btn btn-primary" rel="prev">' . $txt_prev . '</div>';
					     }
					     ?>
                     </div>

                     <div class="profolio-col-5 profolio-col-md-4 iu-post-nav iu-post-nav-next">
					     <?php
					     $txt_next = esc_html( $fields['btn_txt_next'] ) ? : 'Next ►';

					     if ( get_the_ID() ) {
						     $next = get_next_post_link( '%link', $txt_next );

						     echo str_replace( '<a', '<a class="btn btn-primary"', $next );

					     } else {
						     echo '<div class="btn btn-primary" rel="next">' . $txt_next . '</div>';
					     }
					     ?>
                     </div>
                 </div>

             </div>
         </div>
	     <?php
     } );