<?php
/**
 * fields.php
 * create in 30.07.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

$select_fields = $this->get_fields_for_block();


Block::make( __( 'IU Realestation One Fields' ) )
     ->add_tab( __( 'Fields settings' ), array(
	     Field::make( 'complex', 'iu_custom_fields', '' )
	          ->set_classes( 'iu-custom-fields' )
	          ->setup_labels( array(
		          'plural_name'   => 'Fields',
		          'singular_name' => 'Field',
	          ) )
	          ->add_fields( array(
		          Field::make( 'text', 'iu_get_name', __( 'Fields Name' ) ),

		          Field::make( 'select', 'iu_get_field', __( 'Fields value' ) )
		               ->add_options( $select_fields ),
	          ) ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( '...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {?>

	     <div class="block">
		     <div id="iu-realestate-details" class="block__content iu-realestate-one">

			     <div class="iu-field-table">
				     <?php if ( empty($fields['iu_custom_fields']) && ! get_the_ID()): ?>
					     <div class="iu-field-table-row">
						     <div class="iu-field-table-col">placeholder</div>
						     <div class="iu-field-table-col iu-field-table-col-last">placeholder</div>
					     </div>
				     <?php endif;

				     foreach ( $fields['iu_custom_fields'] as $key => $item ) : ?>
					     <div class="iu-field-table-row">
						     <div class="iu-field-table-col"><?php echo $item['iu_get_name'] ?></div>
						     <div class="iu-field-table-col iu-field-table-col-last">
							     <?php echo get_post_meta( get_the_ID(), $item['iu_get_field'], true ) ? : '-' ?>
						     </div>
					     </div>
				     <?php endforeach; ?>
			     </div>

		     </div>
	     </div>
	     <?php
     } );