<?php


class IU_Dynamic_Tag extends \Elementor\Core\DynamicTags\Tag {

	public function get_name() {
		return 'tag-name';
	}

	public function get_title() {
		return esc_html__( 'IU Dynamic Tag', 'instantup' );
	}

	public function get_group() {
		return array( 'site' );
	}

	public function get_categories() {
		return array(
			\Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY,
			\Elementor\Modules\DynamicTags\Module::NUMBER_CATEGORY,
		);
	}

	protected function register_controls() {
		$this->add_control(
			'select_meta',
			array(
				'type'    => \Elementor\Controls_Manager::SELECT,
				'label'   => esc_html__( 'Select Meta', 'instantup' ),
				'options' => get_option( 'all_iu_meta_name', array() ),
			)
		);

	}

	public function render() {
		if ($select_meta = $this->get_settings( 'select_meta' )){
			echo get_post_meta( get_the_ID(), $select_meta, true );
		}
	}

}