<?php

namespace InstantUploader;

if (!defined('WPINC')) {
    die;
}

class Webhooks {

    protected $timestamp;

    /**
     * Leads constructor.
     * @since  1.0.0
     * @access public
     */
    public function __construct() {
        $this->timestamp = time();
    }

    /**
     * Init all hooks of the plugin.
     * @since  1.0.0
     * @access public
     */
    public function init() {
        add_action('rest_api_init', array($this, 'register_routes'));
        add_action('wp_create_application_password', array($this, 'trigger_create_application_password'), 10, 2);
        add_action('init', array($this, 'custom_rewrite_endpoint'));
        add_filter('posts_clauses_request', array($this, 'skip_main_query_for_webhook_cnt'), 10, 2);
        add_action('parse_request', array($this, 'custom_query_var'));
    }

    public function first_part_res() {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: *');
        header('Access-Control-Allow-Headers: *');

        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            status_header(200);
            exit('{"status": true, "timestamp":' . $this->timestamp . '}');
        }
    }

    //START using application passwords and rest api
    public function register_routes() {
        $namespace = 'instantuploader/v2';
        $rout_params = array(array('methods' => \WP_REST_Server::READABLE,//It is GET
            'callback' => array($this, 'checking_connection_rest'), 'args' => array('apiKey' => array('type' => 'string', 'required' => true,),), 'permission_callback' => 'is_user_logged_in',), array('methods' => \WP_REST_Server::EDITABLE,//It is POST
            'callback' => array($this, 'actions_on_content'), 'permission_callback' => 'is_user_logged_in',),);

        register_rest_route($namespace, '/webhook-content/', $rout_params);


        global $wp_rewrite;
        $wp_rewrite->flush_rules(true);
        flush_rewrite_rules();
    }//end register_routes

    public function trigger_create_application_password($user_id, $new_item) {
        if ($new_item['app_id'] && stripos($_SERVER['HTTP_REFERER'], 'instantuploader') !== false) {
            update_option('_firebase_alternate_access', true);
            update_option('_firebase_auth', $new_item['app_id']);
        }
    }//end trigger_create_application_password

    public function checking_connection_rest(\WP_REST_Request $request) {
        $this->first_part_res();

        if (!isset($request['apiKey']) || empty($request['apiKey'])) {
            status_header(400);
            exit('{"status": false, "message":"Invalid apiKey", "timestamp":' . $this->timestamp . '}');
        }

        update_option('_firebase_auth', $request['apiKey']);
        status_header(200);


        $admin = new Admin();
        $data = '{"status": true, "message":"Website is successfully connected", "apiKey": "' . $request['apiKey'] . '", "timestamp":' . $this->timestamp . '}';
        $admin->write_log(date('Y-m-d H:i:s P') . ':__ ' . $data, 'trigger-content.txt');

        exit($data);
    }

    /**
     * @throws \JsonException
     */
    public function actions_on_content(\WP_REST_Request $request) {
        $this->first_part_res();
        $import = new Importer();
        $admin = new Admin();
        $project = $request->get_params();

        if (!isset($project['triggerType']) && empty($project['triggerType'])) {
            status_header(400);
            exit('{"status": false, "message":"Bad Request", "timestamp":' . $this->timestamp . '}');
        }

        //TODO start for development
        $data_log = date('Y-m-d H:i:s P') . ':__ ' . json_encode($project);
        $admin->write_log($data_log, 'trigger-content.txt');

        $import->webhook_import($project, 'application/json');
    }//END  using application passwords and rest api


    public function custom_query_var($wp) {
        if (array_key_exists('instantuploader-webhook', $wp->query_vars)) {
            $admin = new Admin();
            $this->first_part_res();

            if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['apiKey'])) {
                $apiKey = $_GET['apiKey'];
                $saas_url = IU_CLOUDFUNCTIONS_HOST . '/app/get-contents';
                $req_args = array('timeout' => 33, 'httpversion' => '1.1', 'headers' => array('Content-Type' => 'application/json'),);
                $req_body = array('apiKey' => $apiKey, 'limit' => 0,);

                $req_args['body'] = wp_json_encode($req_body);
                $saas_raw_res = wp_remote_post($saas_url, $req_args);

                if (!is_wp_error($saas_raw_res)) {
                    $saas_res = json_decode($saas_raw_res['body'], true);

                    if ((isset($saas_res['account']) && !empty($saas_res['account'])) || (isset($saas_res['user']) && !empty($saas_res['user']))) {
                        update_option('_firebase_auth', $apiKey);
                        update_option('_firebase_alternate_access', true);

                        status_header(200);

                        $res_data = '{"status": true, "apiKey":"' . $apiKey . '", "message":"Website is successfully connected", "timestamp":' . $this->timestamp . '}';
                        $admin->write_log(date('Y-m-d H:i:s P') . ':__ ' . $res_data, 'trigger-content.txt');

                        exit($res_data);
                    }
                }

                status_header(400);
                exit('{"status": false, "message":"We could not verify this apiKey", "timestamp":' . $this->timestamp . '}');
            }
            else {
                $data = file_get_contents('php://input');

                if (!empty($data)) {
                    $import = new Importer();
                    $project = json_decode($data, true);

                    if ((string)$project['apiKey'] !== (string)get_option('_firebase_auth')) {
                        status_header(400);
                        exit('{"status": false, "message":"Invalid apiKey", "timestamp":' . $this->timestamp . '}');
                    }

                    if (!isset($project['triggerType']) && empty($project['triggerType'])) {
                        status_header(400);
                        exit('{"status": false, "message":"Bad Request", "timestamp":' . $this->timestamp . '}');
                    }

                    //TODO start for development
                    $data_log = date('Y-m-d H:i:s P') . ':__ ' . $data;
                    $admin->write_log($data_log, 'trigger-content.txt');
                    //END for development

                    $import->webhook_import($project);

                    status_header(400);
                    exit('{"status": false, "message":"Bad Request", "timestamp":' . $this->timestamp . '}');
                }
            }

            status_header(400);
            exit('{"status": false, "message":"Data empty", "timestamp":' . $this->timestamp . '}');
        }
    }

    function skip_main_query_for_webhook_cnt($pieces, $wp_query) {
        if (isset($wp_query->query['instantuploader-webhook']) && $wp_query->is_main_query()) {
            $pieces['where'] = ' AND ID = 0';
        }

        return $pieces;
    }

    public function custom_rewrite_endpoint() {
        add_rewrite_endpoint('instantuploader-webhook', EP_ROOT);
    }

}