window.addEventListener('DOMContentLoaded', function() {
  if (document.querySelector('.iu-grid')) {
    new Masonry('.iu-grid', {
      itemSelector: '.iu-grid-item',
      columnWidth: 250,
      gutter: 10,
    });
  }

  if (document.querySelector('.iu-testimonial-masonry')) {
    new Masonry('.iu-testimonial-masonry', {
      itemSelector: '.iu-testimonial-masonry-item',
      columnWidth: '.iu-testimonial-masonry-sizer',
      gutter: '.iu-testimonial-masonry-sizer-gutter',
      percentPosition: true,
    });
  }

});

( function() {
  if (window.cf !== undefined) {
    const {addAction} = window.cf.hooks;

    addAction('carbon-fields.init', 'carbon-fields/metaboxes', () => {
      let $$initEditorMasonryCounter = 0,
          $initEditorMasonry         = setInterval(() => {
            $$initEditorMasonryCounter++;

            if (document.querySelector('.iu-testimonial-masonry') && $$initEditorMasonryCounter < 30) {
              clearInterval($initEditorMasonry);

              new Masonry('.iu-testimonial-masonry', {
                itemSelector: '.iu-testimonial-masonry-item',
                columnWidth: '.iu-testimonial-masonry-sizer',
                gutter: '.iu-testimonial-masonry-sizer-gutter',
                percentPosition: true,
              });
            }

            if (document.querySelector('.iu-grid') && $$initEditorMasonryCounter < 30) {
              clearInterval($initEditorMasonry);

              new Masonry( '.iu-grid', {
                itemSelector: '.iu-grid-item',
                columnWidth: 175,
                gutter: 5,
              });
            }
          }, 1000);
    });
  }

}() );

