<?php
/**
 * masonry.php
 * create in 09.12.2021
 * SAYri
 *
 */

$latitude      = get_post_meta( $post->ID, $this->prefix() . 'latitude', true );
$longitude     = get_post_meta( $post->ID, $this->prefix() . 'longitude', true );
$pic_set_image = $fields['iu_pic_set_image'];
$pic_set_size  = $fields['iu_pic_set_size'];


if ( wp_doing_ajax() ) {
	$pic_set_image = get_post_meta( $parent_post_id, 'iu_pic_set_image', true );
	$pic_set_size  = get_post_meta( $parent_post_id, 'iu_pic_set_size', true );
}

?>

<a <?php echo $parent_post_id ? 'href="' . get_permalink() . '"' : ''; ?>
    class="iu-grid-item card border-light JS_profolio_project_item"
    data-latlong="<?php echo esc_attr( $latitude . ',' . $longitude ); ?>"
    data-post-id="<?php the_ID(); ?>">

	<?php if ( has_post_thumbnail() ):
		echo get_the_post_thumbnail( '', $pic_set_size ?? 'medium', array( 'class' => 'card-img-top' ) );
    elseif ( $pic_set_image ):
		$link = wp_get_attachment_image_url( $pic_set_image, $pic_set_size ?? 'medium' );
		echo '<img src="' . $link . '" alt="photo">';
	else:
		echo '<img src="' . INSTANTUP_URL . 'data/assets/img/placeholder.png' . '" class="no-pic card-img-top" alt="no-photo">';

	endif;
	?>

    <div class="card-body">
		<?php if ( $fields['iu_show_post_title'] ) {
			the_title( '<p class="card-title">', '</p>' );
		} ?>
    </div>
</a>