<?php
$address          = get_post_meta( $post->ID, $this->prefix() . 'address', true );
$county           = get_post_meta( $post->ID, $this->prefix() . 'county', true );
$state            = get_post_meta( $post->ID, $this->prefix() . 'state', true );
$country          = get_post_meta( $post->ID, $this->prefix() . 'country', true );
$latitude         = get_post_meta( $post->ID, $this->prefix() . 'latitude', true );
$longitude        = get_post_meta( $post->ID, $this->prefix() . 'longitude', true );
$start_date       = get_post_meta( $post->ID, $this->prefix() . 'start_date', true );
$pic_show         = $fields['iu_pic_show'];
$settings_columns = $fields['iu_settings_columns'];
$pic_set_size     = $fields['iu_pic_set_size'];
$pic_set_image    = $fields['iu_pic_set_image'];
$show_post_title  = $fields['iu_show_post_title'];
$show_loc_title   = $fields['iu_show_loc_title'];
$location_option  = $fields['iu_location_option'];

if ( wp_doing_ajax() ) {
	$pic_show         = get_post_meta( $parent_post_id, 'iu_pic_show', true );
	$settings_columns = get_post_meta( $parent_post_id, 'iu_settings_columns', true );
	$pic_set_size     = get_post_meta( $parent_post_id, 'iu_pic_set_size', true );
	$pic_set_image    = get_post_meta( $parent_post_id, 'iu_pic_set_image', true );
	$show_post_title  = get_post_meta( $parent_post_id, 'iu_show_post_title', true );
	$show_loc_title   = get_post_meta( $parent_post_id, 'iu_show_loc_title', true );
	$location_option  = get_post_meta( $parent_post_id, 'iu_location_option', true );
}

if (!get_option( '_pap_google_maps_api_key' ) && get_option('_iu_disable_maps') === 'yes'){
	$column = 3;
}

if ( $settings_columns === '1' ) {
	$column = 12;
} elseif ( $settings_columns === '2' ) {
	$column = 6;
} elseif ( $settings_columns === '3' ) {
	$column = 4;
} elseif ( $settings_columns === '4' ) {
	$column = 3;
} else {
	$column = 6;
}

?>
<div class="profolio-col-xs-12 profolio-col-md-<?php echo $column; ?> JS_profolio_project_item"
     data-latlong="<?php echo esc_attr( $latitude . ',' . $longitude ); ?>"
     data-post-id="<?php the_ID(); ?>">

    <div class="profolio-project-card">
		<?php if ( $pic_show ): ?>
            <div class="profolio-card-image-frame">
                <a <?php echo $parent_post_id  ? 'href="' . get_permalink() . '"' : ''; ?> class="profolio-card-cover">
					<?php if ( has_post_thumbnail() ) :
						echo get_the_post_thumbnail( $post->ID, $pic_set_size ?? 'medium' );
					else:
						if ( $pic_set_image ):
							$link = wp_get_attachment_image_url( $pic_set_image, $pic_set_size ?? 'medium' );
							echo '<img src="' . $link . '" alt="photo">';
						else:
							echo '<img src="' . INSTANTUP_URL . 'data/assets/img/placeholder.png' . '" class="no-pic" alt="no-photo">';
						endif;
					endif; ?>
                </a>
            </div>
		<?php endif; ?>

        <div class="profolio-card-descr">
			<?php if ( isset( $show_post_title ) && $show_post_title ) :
				$link_href = $parent_post_id  ? 'href="' . get_permalink() . '"' : '';

				echo '<a ' . $link_href . ' class="profolio-header-xs">' . get_the_title() .'</a>';
			endif; ?>

			<?php if ( ! empty( $address ) && $show_loc_title ) : ?>
                <div class="profolio-text-sm">
                    <i class="pro_fa pro_fa-map-marker-alt"></i>
	                <?php if ( $location_option === 'exact' ):
		                echo $address;
	                else:
		                $state_out = $state ? $state . ', ' : '';
		                $generalized_address = $county ? $county : '' . $state_out . $country;
		                $generalized_address = preg_replace("/[0-9]/", "", $generalized_address);

		                echo $generalized_address;
	                endif; ?>
                </div>
			<?php endif; ?>

            <div class="profolio-card-descr-bottom">
				<?php if ( $fields['iu_show_cat'] ): ?>
                    <div class="profolio-card-category-frame">
						<?php the_terms( $post->ID, $this->prefix_t() . '_categories', '', '' ); ?>
                    </div>
				<?php endif; ?>
            </div>
        </div>
    </div>
</div>