<?php
/**
 * filters.php
 * create in 16.08.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;


Block::make( __( 'IU filters' ) )
     ->add_tab( __( 'Main Settings' ), array(
	     Field::make( 'color', 'bgc_box', __( 'Background' ) ),
	     Field::make( 'text', 'height_main_box', __( 'Height' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'Choose a number (default 88)',
	          ) ),

     ) )
     ->add_tab( __( 'Location input' ), array(
	     Field::make( 'checkbox', 'use_location', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Location? (No/Yes )' )
	          ->set_default_value( true )
	          ->set_option_value( true ),

	     Field::make( 'text', 'location_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_location',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'location_height', __( 'Line Height (px)' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 39',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_location',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'color', 'location_color', __( 'Color' ) )
	          ->set_default_value( '#50505a' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_location',
			          'value' => true,
		          ),
	          ) ),
     ) )
     ->add_tab( __( 'Radius input' ), array(
	     Field::make( 'checkbox', 'use_radius', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Radius? (No/Yes )' )
	          ->set_default_value( true )
	          ->set_option_value( true ),

	     Field::make( 'color', 'title_color', __( 'Color' ) )
	          ->set_default_value( '#50505a' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_radius',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_radius',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'line_height', __( 'Line Height (px)' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 39',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_radius',
			          'value' => true,
		          ),
	          ) ),

     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'Location filter' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {

	     ?>

         <style>
             .iu-main-filters {
             <?php
              if ($fields['height_main_box']){
                 echo "min-height: {$fields['height_main_box']}px !important;";
              }

              if ($fields['bgc_box']){
                 echo "background-color: {$fields['bgc_box']};";
              }
             ?>
             }
             /*iu-main-filters*/

         </style>

         <div class="block">
             <div class="block__content iu-main-filters">
                 <div class="profolio-container">

                     <?php if ( $fields['use_location'] || $fields['use_radius'] ): ?>
                         <div class="iu_location-filter-row">
						     <?php if ( $fields['use_location'] ): ?>
                                 <input type="text" id="iu_location_filter" autocomplete="on"
                                        placeholder="<?php esc_attr_e( 'Enter a location', 'instantup' ); ?>"
                                        class="iu_location-filter iu-main-filters-input form-control js-filter-input">
						     <?php endif; ?>

						     <?php if ( $fields['use_radius'] ): ?>
                                 <form class="iu_radius-filter-row" oninput="iu_radius_output.value = iu_radius_filter.value">
                                     <input id="iu_radius_filter" class="iu_radius-filter" autocomplete="off" type="range" name="iu_radius_filter"
                                            value="100" min="10" max="500" step="5">

                                     <p class="iu_radius-filter_output">
                                         <output name="iu_radius_output">100</output>
                                         mile radius
                                     </p>
                                 </form>
						     <?php endif; ?>
                         </div>
				     <?php endif; ?>

                 </div>
             </div>
         </div>
	     <?php
     } );
