<?php
/**
 * iu-posts-filter.php
 * create in 02.08.2021
 * SAYri
 *
 */


use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Posts Filter' ) )
     ->add_tab( __( 'Main settings' ), array() )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_mode( 'preview' )
     ->set_render_callback( function ( $fields, $attributes, $inner_blocks ) {
	     $uniqid = uniqid( false );

	     ?>

         <div class="block">
             <div class="block__content">
                 <div class="profolio-search-bar profolio_wrapper_<?php echo esc_attr( $uniqid ); ?>">

                     <form class="profolio-search-form js-profolio-search-form">
                         <div class="profolio-row no-gutters">

                             <div class="profolio-col-12 profolio-col-sm-12">
                                 <div class="input-group profolio-input-frame profolio-pr-15 profolio-ltr-pr-15">
                                     <div class="input-group-prepend">
                                         <span class="input-group-text" id="basic-addon1">
                                             <i class="pro_fa pro_fa-map-marker-alt"></i>
                                         </span>
                                     </div>
                                     <input type="text" class="profolio-loc-input form-control profolio-default-input js-filter-input"
                                            autocomplete="on" placeholder=""
                                            value="<?php esc_attr_e( 'Enter a location', 'instantup' ); ?>">
                                 </div>
                             </div>

                             <div class="more-button-container">
                                 <a href="" class="btn btn-primary profolio-default-button profolio-input-more second-style">
                                     <?php esc_html_e( 'more', 'instantup' ); ?>
                                 </a>

                                 <div class="profolio-more-popup">
                                     <div class="profolio-col-12 profolio-col-sm-4 profolio-col-md-12">
                                         <div class="input-group profolio-input-frame profolio-md-rtl-pl-15">
                                             <div class="input-group-prepend">
                                                 <span class="input-group-text" id="basic-addon1">
                                                     <i class="pro_fa pro_fa-road"></i>
                                                 </span>
                                             </div>

                                             <input type="text" id="profolio-radius-input" value="100 mile(s)"
                                                    class="form-control profolio-default-input js-filter-input">
                                         </div>
                                     </div>

                                     <div class="profolio-col-12 profolio-col-sm-4 profolio-col-md-12">

                                     </div>

								     <?php if ( ! empty( $atts['show_sale_type'] ) ): ?>
                                         <div class="profolio-col-12 profolio-col-sm-4 profolio-col-md-12">
                                             <div class="profolio-input-frame profolio-pr-15">
                                                 <div class="profolio-dropdown-frame">
                                                     <div class="input-group profolio-open-dropdown">
                                                         <div class="input-group-prepend">
                                                             <span class="input-group-text" id="basic-addon1"><i class="pro_fa pro_fa-th-list"></i></span>
                                                         </div>
                                                         <span class="profolio-dropdown-fake-button form-control profolio-default-input"><?php esc_html_e( 'Sale type',
															     'instantup' ); ?></span>
                                                     </div>
                                                     <ul class="profolio-search-dropdown">
                                                         <li>
                                                             <label class="form-check-label">
                                                                 <input type="checkbox" class="form-check-input profolio-sellect-all">
															     <?php esc_html_e( 'Select',
																     'instantup' ); ?>
                                                                 <span class="profolio-d-all profolio-d-true"><?php esc_html_e( 'All',
																	     'instantup' ); ?></span><span class="profolio-d-none"><?php esc_html_e( 'None',
																	     'instantup' ); ?></span>
                                                             </label>
                                                         </li>
                                                         <li>
                                                             <label class="form-check-label">
                                                                 <input name="saleIds" type="checkbox" class="form-check-input js-form-sale-check-input" value="0">
															     <?php esc_html_e( 'For sale',
																     'instantup' ); ?>
                                                             </label>
                                                         </li>
                                                         <li>
                                                             <label class="form-check-label">
                                                                 <input name="saleIds" type="checkbox" class="form-check-input js-form-sale-check-input" value="1">
															     <?php esc_html_e( 'For rent',
																     'instantup' ); ?>
                                                             </label>
                                                         </li>
                                                     </ul>
                                                 </div>
                                             </div>
                                         </div>
								     <?php endif; ?>

								     <?php if ( ! empty( $atts['show_status_field'] ) ): ?>

                                         <div class="profolio-col-12 profolio-col-sm-4 profolio-col-md-12">
                                             <div class="profolio-input-frame profolio-pr-15">
                                                 <div class="profolio-dropdown-frame">
                                                     <div class="input-group profolio-open-dropdown">
                                                         <div class="input-group-prepend">
                                                             <span class="input-group-text" id="basic-addon1"><i class="pro_fa pro_fa-th-list"></i></span>
                                                         </div>
                                                         <span class="profolio-dropdown-fake-button form-control profolio-default-input"><?php esc_html_e( 'Status',
															     'instantup' ); ?></span>
                                                     </div>
                                                     <ul class="profolio-search-dropdown">
                                                         <li>
                                                             <label class="form-check-label">
                                                                 <input type="checkbox" class="form-check-input profolio-sellect-all">
															     <?php esc_html_e( 'Select',
																     'instantup' ); ?>
                                                                 <span class="profolio-d-all profolio-d-true"><?php esc_html_e( 'All',
																	     'instantup' ); ?></span>
                                                                 <span class="profolio-d-none"><?php esc_html_e( 'None',
																	     'instantup' ); ?></span>
                                                             </label>
                                                         </li>

                                                         <li>
                                                             <label class="form-check-label">
                                                                 <input name="statusIds[]" type="checkbox" class="form-check-input js-form-status-check-input" value="0">
															     <?php esc_html_e( 'Active',
																     'instantup' ); ?>
                                                             </label>
                                                         </li>
                                                         <li>

                                                             <label class="form-check-label">
                                                                 <input name="statusIds[]" type="checkbox" class="form-check-input js-form-status-check-input" value="1">
															     <?php esc_html_e( 'Sold',
																     'instantup' ); ?>
                                                             </label>
                                                         </li>
                                                         <li>

                                                             <label class="form-check-label">
                                                                 <input name="statusIds[]" type="checkbox" class="form-check-input js-form-status-check-input" value="2">
															     <?php esc_html_e( 'Inactive',
																     'instantup' ); ?>
                                                             </label>
                                                         </li>

                                                     </ul>
                                                 </div>
                                             </div>
                                         </div>

								     <?php endif; ?>

                                     <button class="btn btn-primary profolio-default-button second-style reset-filter w-100">
                                         <i class="pro_fa pro_fa-times"></i>
                                         <span><?php esc_html_e( 'Reset filter', 'instantup' ); ?></span>
                                     </button>
                                 </div>


                             </div>

                             <div class="profolio-col-12 profolio-col-sm-3">
                                 <div class="profolio-input-frame profolio-rtl-pr-15">
                                     <button type="submit" class="btn btn-primary profolio-default-button w-100">
                                         <i class="pro_fa pro_fa-search"></i>
                                         <span><?php esc_html_e( 'Search', 'instantup' ); ?></span>
                                     </button>
                                 </div>
                             </div>

                             <input type="hidden" name="tags_instead_industry" value="<?php echo esc_attr( $type_terms ); ?>">

                             <input type="hidden" id="profolio-current-post-id" value="<?php echo esc_attr( get_the_ID() ); ?>">
                         </div>
                     </form>
                 </div>

             </div>
         </div>
	     <?php
     } );