<?php
/**
 * iu-title.php
 * create in 23.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

Block::make( __( 'IU Title' ) )
     ->add_tab( __( 'Settings Block' ), array(
	     Field::make( 'checkbox', 'iu_full_screen', '' )
	          ->set_classes( 'iu-blocks-margin-bottom_1 iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Block Full Width' ) ),

	     Field::make( 'checkbox', 'iu_use_img_bgi', '' )
	          ->set_classes( 'iu-blocks-margin-bottom_1 iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Use Picture For Background' ) ),

	     Field::make( 'checkbox', 'iu_use_shadow_bgi', '' )
	          ->set_classes( 'iu-blocks-margin-bottom_1 iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Use Shadow For Background' ) )
	          ->set_option_value( 'yes' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_img_bgi',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'image', 'iu_img_bgi', __( 'Image Background' ) )
	          ->set_help_text( __( '(parent image will be used or set your own)' ) )
	          ->set_classes( 'iu-blocks-margin-bottom_2' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_img_bgi',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'color', 'title_color', __( 'Color' ) )
	          ->set_default_value( '#50505a' ),

	     Field::make( 'color', 'title_background', __( 'Background' ) )
	          ->set_alpha_enabled( true )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_img_bgi',
			          'value' => false,
		          ),
	          ) ),

	     Field::make( 'text', 'title_gradient', __( 'Use Gradient' ) )
	          ->set_classes( 'iu-blocks-margin-bottom_3' )
	          ->set_attributes( array(
		          'placeholder' => 'Enter gradient',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_use_img_bgi',
			          'value' => false,
		          ),
	          ) ),


     ) )
     ->add_tab( __( 'Settings Title' ), array(
	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'iu-blocks-margin-top_2 select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() ),

	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin-top_2 iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 26',
	          ) )
	          ->set_width( 35 ),

	     Field::make( 'select', 'font_weight', __( 'Font Weight' ) )
		     ->set_classes( 'iu-blocks-margin-top_2' )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'line_height', __( 'Line Height (px)' ) )
		     ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 26',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'select', 'position_title', __( 'Position Title' ) )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'left'   => 'Left',
		          'center' => 'center',
		          'right'  => 'right',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'separator', 'padding_separator', __( 'Padding:' ) )
	          ->set_classes( 'iu-separator-margin' ),

	     Field::make( 'text', 'padding_top', __( 'Top' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
	          ) )
	          ->set_width( 30 ),

	     Field::make( 'text', 'padding_bottom', __( 'Bottom' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
	          ) )
	          ->set_width( 33 ),

	     Field::make( 'select', 'padding_units', __( 'units' ) )
	          ->set_default_value( 'px' )
	          ->add_options( array(
		          'px' => 'px',
		          '%'  => '%',
	          ) )
	          ->set_width( 17 ),

	     Field::make( 'separator', 'crb_separator', __( 'Margin:' ) )
	          ->set_classes( 'iu-separator-margin' ),

	     Field::make( 'text', 'margin_top', __( 'Top' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 30 ),

	     Field::make( 'text', 'margin_bottom', __( 'Bottom' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 12',
	          ) )
	          ->set_width( 33 ),

	     Field::make( 'select', 'margin_units', __( 'units' ) )
	          ->set_default_value( 'px' )
	          ->add_options( array(
		          'px' => 'px',
		          '%'  => '%',
	          ) )
	          ->set_width( 17 ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     if ( $fields['select_fonts'] ) {
		     $get_font = explode( ':', $fields['select_fonts'] );
	     }

	     ?>

         <style>
             .iu-block-title {
             <?php
                echo $fields['position_title'] === 'center' ? 'text-align: center;' : '';

                if ($fields['iu_full_screen']){
                    echo 'max-width: 99vw !important;';
                    echo 'width: 99vw !important;';
                    echo 'position: relative !important;';
                    echo 'left: 50.3% !important;';
                    echo 'right: 50% !important;';
                    echo 'margin-left: -50vw !important;';
                    echo 'margin-right: -50vw !important;';
                }

                if ( ((isset($fields['title_background']) && ! empty($fields['title_background'])) || (isset($fields['title_gradient']) && ! empty($fields['title_gradient'])))
                  && $fields['iu_use_img_bgi'] === false && empty($fields['iu_im_bgi']) ){
                    $background = $fields['title_gradient'] ?: $fields['title_background'];
                    echo 'margin-bottom: 50px;';
                    echo "background: {$background};";
                }

                if ($fields['iu_use_img_bgi']){
                    if (empty($fields['iu_img_bgi'])){
                        if ($parent_id = get_post_meta( get_the_ID(), 'parent_id', true )){
                           if (!$link = get_the_post_thumbnail_url( $parent_id )){
                               $link = INSTANTUP_URL . 'data/assets/img/temp_pic.jpg';
                           }
                        }
                    }
                    else{
                        $link = wp_get_attachment_image_url( $fields['iu_img_bgi'], 'large' );
                    }

                    echo "background-image: url({$link});";
                    echo 'background-repeat: no-repeat;';
                    echo 'background-position: center center;';
                    echo 'background-size: cover;';
                }

                if ($fields['iu_use_shadow_bgi'] && $fields['iu_use_img_bgi']){
                    echo 'box-shadow: inset 0 427rem 0 rgb(0,0,0, 0.4 );';
                }

                if ($fields['margin_top']){
                    echo "margin-top: {$fields['margin_top']}{$fields['margin_units']}px !important;";
                }

                if ($fields['margin_bottom']){
                    echo "margin-bottom: {$fields['margin_bottom']}{$fields['margin_units']}px !important;";
                }
             ?>
             }

             .block__content h1.iu-title-page {
                 max-width: 100%;
             <?php echo $get_font[0] ? "font-family: {$get_font[0]}, Sans-serif !important;" : 'Open Sans, Sans-serif !important';?>
                 font-size: 40px !important;
             }

             .block__content .iu-title-page {
             <?php
             if ($fields['position_title'] === 'center' || $fields['position_title'] === 'right'){
                 echo 'width: 100%;';
             }

             if ($fields['title_color']){
                 echo "color: {$fields['title_color']} !important;";
             }

             if ($fields['font_weight']){
                 echo "font-weight: {$fields['font_weight']} !important;";
             }

             if ($fields['font_size']){
                 echo "font-size: {$fields['font_size']}px !important;";
             }

             if ($fields['line_height']){
                 echo "line-height: {$fields['line_height']}px !important;";
             }

             if ($fields['position_title']){
                 echo "text-align: {$fields['position_title']};";
                 echo 'margin: auto;';
             }

             if ($fields['padding_top']){
                 echo "padding-top: {$fields['padding_top']}{$fields['padding_units']}px !important;";
             }

             if ($fields['padding_bottom']){
                 echo "padding-bottom: {$fields['padding_bottom']}{$fields['padding_units']}px !important;";
             }
             ?>
             }

             @media (max-width: 768px) {
                 .block__content .iu-title-page {
                     font-size: 5vw !important;
                 }
             }
         </style>

         <div class="block">
             <div class="block__content iu-block-title">
                 <h1 class="profolio-header-sm iu-title-page">
				     <?php
				     if ( get_the_ID() ) {
					     if ( is_archive() ) {
						     echo get_the_archive_title();
					     } elseif ( is_singular() ) {
						     echo get_the_title();
					     }
				     } else {
					     echo 'This is title';
				     }
				     ?>
                 </h1>
             </div>
         </div>
	     <?php
     } );