<?php


namespace InstantUploader;

if ( ! defined( 'WPINC' ) ) {
	die;
}

class scripts_and_styles {

	public function __construct() {

	}

	public function init() {
		add_action( 'admin_enqueue_scripts', array( $this, 'BACKEND_admin_enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'FRONT_wp_enqueue_scripts' ) );
		add_action( 'enqueue_block_editor_assets', array( $this, 'iu_block_editor_scripts' ) );
		add_action( 'wp_print_styles', array( $this, 'print_custom_styles' ), 1 );
		add_action( 'enqueue_block_assets', array( $this, 'iu_enqueue_block_assets' ) );
		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'elementor_testimonials_css' ) );
		add_action( 'elementor/editor/before_enqueue_styles', array( $this, 'instantuploader_icons' ), 100 );
		add_action( 'admin_init', array( $this, 'instantuploader_icons' ), 100 );

		if ( get_option( '_disable_other_google_map' ) && ! is_admin() ) {
			add_action( 'script_loader_src', array( $this, 'disable_other_google_map' ), 150, 2 );
		}

		add_action( 'save_post', array( $this, 'save_custom_fonts' ), 10, 2 );
		add_action( 'before_delete_post', array( $this, 'delete_custom_fonts' ), 10, 1 );
		add_action( 'wp_trash_post', array( $this, 'delete_custom_fonts' ), 10, 1 );
	}

	public function disable_other_google_map( $src, $handle ) {
		if ( $handle !== 'iu-google-maps' && strpos( $src, 'maps.googleapis.com/maps/api/js' ) !== false ) {
			wp_deregister_script( $handle );
		}

		return $src;
	}

	public function instantuploader_icons() {
		$add_icon = '.instantuploader-icon{
			display: inline-block;
		    width: 35px;
		    height: 35px;
		    background-size: contain; 
		    background-repeat: no-repeat;
		    background-position: center;
			background-image: url("' . INSTANTUP_URL . 'data/assets/img/plugin-icon.png") }';


		wp_add_inline_style( 'elementor-common', $add_icon );
	}

	public function elementor_testimonials_css() {
		wp_enqueue_style( 'iu_testimonials_all_elementor',
			INSTANTUP_URL . 'data/assets/back-and-front/css/testimonials-all.css', array(), INSTANTUP_VERSION );
	}

	public function print_custom_styles() {
		if ( ! is_admin() ) {
			$iu_bootstrap = INSTANTUP_URL . 'data/assets/css/libraries/bootstrap.min.css';

			echo '<link rel="stylesheet" href="' . $iu_bootstrap . '" type="text/css" media="all" />';
		}
	}

	/**
	 * Blocks enqueue styles and scripts for FRONT-END and BACK-END.
	 */
	public function iu_enqueue_block_assets() {
		if ( is_single() || is_admin() ) {
			$iu_swiper_library    = INSTANTUP_URL . 'data/assets/css/libraries/swiper.min.css';
			$iu_my_swiper         = INSTANTUP_URL . 'data/assets/back-and-front/css/slider-swiper.css';
			$before_after_librari = INSTANTUP_URL . 'data/assets/css/libraries/before-after.min.css';
			wp_enqueue_style( 'iu-swiper-library', $iu_swiper_library, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-my-swiper', $iu_my_swiper, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-before-after-library', $before_after_librari, '', INSTANTUP_VERSION );


			$iu_swiper_lib   = INSTANTUP_URL . 'data/assets/js/libraries/swiper.min.js';
			$iu_before_after = INSTANTUP_URL . 'data/assets/js/libraries/before-after.min.js';
			wp_enqueue_script( 'iu-before-after', $iu_before_after, array( 'jquery' ), INSTANTUP_VERSION, true );
			wp_enqueue_script( 'iu_swiper_lib', $iu_swiper_lib, array( 'jquery' ), INSTANTUP_VERSION, true );
		}

		#styles
		//$iu_bootstrap        = INSTANTUP_URL . 'data/assets/css/libraries/bootstrap.min.css';
		$iu_general    = INSTANTUP_URL . 'data/assets/back-and-front/css/general.css';
		$iu_pagination = INSTANTUP_URL . 'data/assets/back-and-front/css/pagination.css';
		$iu_post_cards = INSTANTUP_URL . 'data/assets/back-and-front/css/post-cards.css';
		$iu_gallery    = INSTANTUP_URL . 'data/assets/back-and-front/css/gallery.css';
//		$posts_list          = INSTANTUP_URL . 'data/assets/back-and-front/css/posts-list.css';
		$iu_testimonials_all = INSTANTUP_URL . 'data/assets/back-and-front/css/testimonials-all.css';
		$testimonial_block   = INSTANTUP_URL . 'data/assets/back-and-front/css/testimonial-block.css';
		$iu_location         = INSTANTUP_URL . 'data/assets/back-and-front/css/location.css';
		$category_block      = INSTANTUP_URL . 'data/assets/back-and-front/css/category-block.css';
		$tags_block          = INSTANTUP_URL . 'data/assets/back-and-front/css/tags-block.css';
		$content_block       = INSTANTUP_URL . 'data/assets/back-and-front/css/content-block.css';
		$before_after        = INSTANTUP_URL . 'data/assets/back-and-front/css/before-after.css';
		$iu_css_for_masonry  = INSTANTUP_URL . 'data/assets/back-and-front/css/for-masonry.css';
		$iu_album_temp       = INSTANTUP_URL . 'data/assets/back-and-front/css/for-album.css';
		$iu_cover            = INSTANTUP_URL . 'data/assets/back-and-front/css/cover.css';
		$src_iu_map_popup    = INSTANTUP_URL . 'data/assets/back-and-front/css/map-popup.css';
		$iu_main_filters     = INSTANTUP_URL . 'data/assets/back-and-front/css/main-filters.css';
		$ai_writeups         = INSTANTUP_URL . 'data/assets/back-and-front/css/ai-writeups.css';

		//wp_enqueue_style( 'instantup-bootstrap', $iu_bootstrap, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-custom-fonts', $this->add_custom_fonts_google(), array(), '1.0.0' );
		wp_enqueue_style( 'iu-general', $iu_general, array( 'wp-block-library' ), INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-pagination', $iu_pagination, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-post-cards', $iu_post_cards, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-gallery', $iu_gallery, '', INSTANTUP_VERSION );
//		wp_enqueue_style( 'iu_posts_list', $posts_list, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_testimonials_all', $iu_testimonials_all, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'testimonial_block', $testimonial_block, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-location', $iu_location, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-category_links', $category_block, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-tags-block', $tags_block, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-before-after', $before_after, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu-content_block', $content_block, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_css-for-masonry', $iu_css_for_masonry, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_album_temp', $iu_album_temp, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_cover', $iu_cover, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_map_popup', $src_iu_map_popup, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_main_filters', $iu_main_filters, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_ai_writeups', $ai_writeups, '', INSTANTUP_VERSION );

		$language = carbon_get_theme_option( 'pap_language' );
		if ( ! empty( $language ) ) {
			$language = '&language=' . $language;
		}
		$maps_api_key = get_option( '_pap_google_maps_api_key' );
		$google_maps  = 'https://maps.googleapis.com/maps/api/js?key=' . $maps_api_key . '&libraries=places,geometry' . $language;

		#scripts
		$iu_for_blocks = INSTANTUP_URL . 'data/assets/back-and-front/js/for_blocks.js';
		$iu_masonry    = INSTANTUP_URL . 'data/assets/js/libraries/masonry.pkgd.min.js';
		$iu_map_js     = INSTANTUP_URL . 'data/assets/js/map.js';

		wp_enqueue_script( 'iu_for-blocks', $iu_for_blocks, array( 'wp-i18n' ), INSTANTUP_VERSION, true );
		wp_enqueue_script( 'iu_masonry', $iu_masonry, '', INSTANTUP_VERSION, true );
		wp_enqueue_script( 'iu-google-maps', $google_maps, '', '', true );
		wp_enqueue_script( 'iu-map', $iu_map_js, array( 'iu-google-maps', 'jquery', ), time(), true );
		wp_localize_script(
			'jquery',
			'instantup_object',
			array(
				'ajaxurl'      => admin_url( 'admin-ajax.php' ),
				'directoryurl' => plugin_dir_url( __FILE__ ),
				'plugin_url'   => INSTANTUP_URL,
				'data'         => array(
					'action' => 'instantup_get_products',
				),
				'type_address' => 'exact',
				'rand_meter'   => rand( 0, 1609 ),
				'paged'        => get_query_var( 'paged' ),
			)
		);


		if ( is_admin() ) {
			$iu_fonts             = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/fonts.css';
			$iu_default           = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/default.css';
			$iu_button_style      = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/iu-button.css';
			$iu_before_after      = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/before-after-add.css';
			$iu_title             = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/iu-title.css';
			$iu_tags_style        = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/tags.css';
			$iu_category_style    = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/category.css';
			$iu_testimonial_style = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/testimonial.css';
			$iu_social_style      = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/social.css';
			$iu_video_testimonial = INSTANTUP_URL . 'data/assets/admin/css/for_blocks/video-testimonial.css';
			wp_enqueue_style( 'iu-fonts', $iu_fonts, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-default', $iu_default, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-button-style', $iu_button_style, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-before-after', $iu_before_after, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-title', $iu_title, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-tags-style', $iu_tags_style, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-category-style', $iu_category_style, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-testimonial-style', $iu_testimonial_style, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-social-style', $iu_social_style, '', INSTANTUP_VERSION );
			wp_enqueue_style( 'iu-video-testimonial', $iu_video_testimonial, '', INSTANTUP_VERSION );


			$iu_swiper_js = INSTANTUP_URL . 'data/assets/admin/js/for_blocks/iu-swiper.js';
			wp_enqueue_script( 'iu-swiper', $iu_swiper_js, array( 'jquery' ), INSTANTUP_VERSION, true );
		}
	}

	/**
	 * Enqueue styles and scripts for BACK-END all page (admin page).
	 */
	public function BACKEND_admin_enqueue_scripts() {
		$gutenberg   = INSTANTUP_URL . 'data/assets/admin/css/gutenberg.css';
		$admin_style = INSTANTUP_URL . 'data/assets/admin/css/admin.css';
		$iu_content  = INSTANTUP_URL . 'data/assets/back-and-front/css/iu-content.css';
		wp_enqueue_style( 'iu-content', $iu_content, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'gutenberg', $gutenberg, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'admin-style', $admin_style, '', INSTANTUP_VERSION );


		if ( wp_script_is( 'iu-map' ) ) {
			$admin_script_deps = array( 'jquery', 'wp-api', 'wp-i18n', 'iu-map' );
		} else {
			$admin_script_deps = array( 'jquery', 'wp-api', 'wp-i18n' );
		}

		$admin_script  = INSTANTUP_URL . 'data/assets/admin/js/admin.js';
		$iu_content_js = INSTANTUP_URL . 'data/assets/back-and-front/js/iu-content.js';
		$iu_cover_js   = INSTANTUP_URL . 'data/assets/back-and-front/js/iu-cover.js';
		wp_enqueue_script( 'admin-script', $admin_script, $admin_script_deps, INSTANTUP_VERSION, true );
		wp_enqueue_script( 'iu_content', $iu_content_js, array( 'jquery' ), INSTANTUP_VERSION, true );
		wp_enqueue_script( 'iu_cover', $iu_cover_js, array( 'jquery', 'thickbox' ), INSTANTUP_VERSION, true );


		ob_start(); ?>
        document.addEventListener('DOMContentLoaded', () => {
        var $carbonInstantuploader = document.querySelector('#carbon_fields_container_instantuploader .theme-options-container');

        if ($carbonInstantuploader) {
        let $childNodes = $carbonInstantuploader.childNodes;

        if ($childNodes.length === 0) {
        let $carbonEmpty = `
        <div style='padding: 15px;'><h1 style='color: crimson;'>Error 403 Forbidden</h1>
            <p style='font-size: 16px; margin: 0;'>You need clear cache or change permission on files.</p></div>`;
        $carbonInstantuploader.insertAdjacentHTML('afterbegin', $carbonEmpty);
        }
        }
        });
		<?php
		$data_js = ob_get_clean();
		wp_add_inline_script( 'jquery', $data_js, 'before' );

		$firebase_auth_code = '"' . get_option( '_firebase_auth', '' ) . '"';
		$data_js2           = <<<END
		window['firebase_auth_code'] = {$firebase_auth_code};
		END;
		wp_add_inline_script( 'admin-script', $data_js2, 'before' );

		if ( $get_custom_type = get_option( '_iu_custom_type_posts' ) ) {
			$custom_type = reset( $get_custom_type );
			$post_type   = $custom_type['slug'] ?? 'post';

			wp_localize_script(
				'instantup-admin',
				'instantup_ogj',
				array(
					'prefix' => $post_type,
				)
			);
		}
	}

	/**
	 * Blocks enqueue style and scripts for BACK-END (only for editor page).
	 */
	public function iu_block_editor_scripts() {
		wp_enqueue_script(
			'iu-gutenberg',
			INSTANTUP_URL . 'data/assets/admin/js/gutenberg.js',
			array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ),
			INSTANTUP_VERSION
		);

		$iu_js_for_masonry = INSTANTUP_URL . 'data/assets/back-and-front/js/for-masonry.js';
		wp_enqueue_script(
			'iu_for-masonry',
			$iu_js_for_masonry,
			array( 'jquery', 'carbon-fields-vendor', 'iu_masonry' ),
			INSTANTUP_VERSION,
			true
		);
	}

	/**
	 * Enqueue styles and scripts for FRONT-END.
	 */
	public function FRONT_wp_enqueue_scripts() {
		$template_top = get_option( '_template_for_content' );
		$post_type    = get_post_type( get_the_ID() );

		if ( $post_type && is_array( $template_top ) && isset( $template_top[ $post_type ] ) && ( $template_parent_id = (int) $template_top[ $post_type ] ) && has_block( 'carbon-fields/iu-content', $template_parent_id ) ) {
			$iu_content    = INSTANTUP_URL . 'data/assets/back-and-front/css/iu-content.css';
			$iu_content_js = INSTANTUP_URL . 'data/assets/back-and-front/js/iu-content.js';

			wp_enqueue_style( 'iu-content', $iu_content, '', INSTANTUP_VERSION );
			wp_enqueue_script( 'iu_content', $iu_content_js, array( 'jquery' ), INSTANTUP_VERSION, true );
		}

		$src_iu_icons          = INSTANTUP_URL . 'data/assets/css/all.css';
		$src_iu_magnific_popup = INSTANTUP_URL . 'data/assets/css/libraries/magnific-popup.css';
		$src_iu_lightgallery   = INSTANTUP_URL . 'data/assets/css/libraries/lightgallery.min.css';
		$src_iu_css            = INSTANTUP_URL . 'data/assets/css/style.css';
		wp_enqueue_style( 'iu_icons', $src_iu_icons, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_magnific_popup', $src_iu_magnific_popup, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_lightgallery', $src_iu_lightgallery, '', INSTANTUP_VERSION );
		wp_enqueue_style( 'iu_css', $src_iu_css, '', INSTANTUP_VERSION );


		$lightgallery_js   = INSTANTUP_URL . 'data/assets/js/libraries/lightgallery-all.min.js';
		$magnific_popup_js = INSTANTUP_URL . 'data/assets/js/libraries/jquery.magnific-popup.min.js';
		$iu_front_ui       = INSTANTUP_URL . 'data/assets/js/front-ui.js';
		$iu_js_for_masonry = INSTANTUP_URL . 'data/assets/back-and-front/js/for-masonry.js';
		//wp_enqueue_editor();//this code add TinyMCE editor in front-end
		wp_enqueue_script( 'wp-util' );
		wp_enqueue_script( 'lightgallery', $lightgallery_js, array( 'jquery' ), INSTANTUP_VERSION, true );
		wp_enqueue_script( 'magnific-popup', $magnific_popup_js, array( 'jquery' ), INSTANTUP_VERSION, true );
		wp_enqueue_script(
			'iu_for-masonry',
			$iu_js_for_masonry,
			array( 'jquery', 'iu_masonry' ),
			INSTANTUP_VERSION,
			true
		);
		wp_enqueue_script( 'iu-main-script', $iu_front_ui, array( 'wp-api', 'jquery' ), INSTANTUP_VERSION, true );
	}


	public function add_custom_fonts_google() {
		$fonts     = array();
		$block_cnt = parse_blocks( get_the_content( '', '', get_the_ID() ) );

		if ( $block_cnt ) {
			foreach ( $block_cnt as $block ) {
				if ( isset( $block['attrs']['data'] ) &&
				     $block['attrs']['data']['select_fonts'] &&
				     ! in_array( $block['attrs']['data']['select_fonts'], $fonts ) ) {

					$fonts[] = $block['attrs']['data']['select_fonts'];
				}

				if ( count( $block['innerBlocks'] ) ) {
					foreach ( $block['innerBlocks'] as $innerBlocks ) {
						if ( $innerBlocks['innerBlocks'] ) {
							foreach ( $innerBlocks['innerBlocks'] as $parent_item ) {
								$select_fonts = $parent_item['attrs']['data']['select_fonts'] ?? '';

								if ( $select_fonts && ! in_array( $parent_item['attrs']['data']['select_fonts'],
										$fonts ) ) {
									$fonts[] = $select_fonts;
								}

								unset( $select_fonts );
							}
						}
					}
				}

			}


			if ( $fonts ) {
				$combine   = implode( '|', $fonts );
				$urlencode = urlencode( $combine . "&subset=latin,latin-ext" );

				return add_query_arg( 'family', $urlencode, "//fonts.googleapis.com/css" );
			}
		}

		return '';
	}

	public function save_custom_fonts( $post_ID, $post ) {
		$fonts = array();

		//if ( $_REQUEST['select_fonts'] ) {
//			$get_font = explode( ':', $_REQUEST['select_fonts'] );
//
//			if ($custom_fonts = get_option('_iu_custom_fonts')){
//				if ($custom_fonts[$get_font[0]]){
//					$custom_fonts[$get_font[0]] += 1;
//				} else{
//					$custom_fonts[$get_font[0]] = 1;
//				}
//
//			} else{
//				$custom_fonts = array(
//					$get_font[0] => 1,
//				);
//			}

		//( new Admin )->write_log($post->post_type);

		if ( $post->post_type === 'page' && $post->post_content ) {
			$blocks = parse_blocks( $post->post_content );

			if ( $blocks ) {
				foreach ( $blocks as $block ) :
					if ( isset( $block['attrs']['data'] ) &&
					     $block['attrs']['data']['select_fonts'] &&
					     ! in_array( $block['attrs']['data']['select_fonts'], $fonts ) ) {

						$fonts[] = $block['attrs']['data']['select_fonts'];
					}

					if ( count( $block['innerBlocks'] ) ) {
						foreach ( $block['innerBlocks'] as $innerBlocks ) {
							if ( $innerBlocks['innerBlocks'] ) {
								foreach ( $innerBlocks['innerBlocks'] as $parent_item ) {
									$select_fonts = $parent_item['attrs']['data']['select_fonts'] ?? '';

									if ( $select_fonts && ! in_array( $parent_item['attrs']['data']['select_fonts'],
											$fonts ) ) {
										$fonts[] = $select_fonts;
									}

									unset( $select_fonts );
								}
							}
						}
					}

				endforeach;
			}

		}

		update_option( '_iu_custom_fonts', $fonts );
		//треба переробити, щоб добавлялося тільки при збережені запису
		//}
	}

	public function delete_custom_fonts( $post_id ) {


	}

}