<?php

namespace InstantUploader;

use SxGeo;

if ( ! defined( 'WPINC' ) ) {
	die;
}


/**
 * Class User Activity
 *
 * @since  1.0.0
 */
class User_Activity {

	/**
	 * User_Activity constructor.
	 *
	 * @since  1.0.0
	 * @access public
	 */
	public function __construct() { }

	public function init() {
		add_action( 'get_header', array( $this, 'follow_user' ), 1 );
		add_action( 'wp_ajax_send_out_of_turn', array( $this, 'ajax_send_out_of_turn' ) );
	}

	public function follow_user() {
		$user_ip = $_SERVER['REMOTE_ADDR'];

		if ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) && ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
			$http_x_forwarded_for = explode( ',', $_SERVER['HTTP_X_FORWARDED_FOR'] );
			$user_ip              = $http_x_forwarded_for[0];
		}

		if ( empty( $user_ip ) || $user_ip === 'Unknown' ) {
			$user_ip = '127.0.0.1';
		}

		if ( ! filter_var( $user_ip, FILTER_VALIDATE_IP ) || $this->is_bot( $user_ip ) ) {
			return;
		}

		$posts_type  = get_option( '_iu_custom_type_posts' );
		$is_taxonomy = get_queried_object()->taxonomy ?? false;

		if ( $posts_type ) {
			$admin       = new Admin();
			$type_check  = false;
			$post_id     = get_the_ID();
			$post_type   = get_post_type( $post_id );
			$prefix_type = $admin::get_type_prefix();

			foreach ( $posts_type as $type ) {
				if ( $type['slug'] === $post_type ) {
					$type_check = true;
					break;
				}
			}

			if ( ( $type_check && ! is_admin() ) || $is_taxonomy === $prefix_type . '_categories' || $is_taxonomy === $prefix_type . '_tags' ) {

				global $wpdb;
				include_once( 'SxGeo.php' );

				if ( is_user_logged_in() ) {
					$id_user = get_current_user_id();

				} else {
					if ( isset($_COOKIE['visitor_id']) ) {
						$id_user = $_COOKIE['visitor_id'];
					} else {
						$cookie_val = base64_encode( time() );
						$cookie_arr = array(
							'expires' => time() + ( 86400 * 30 ),
							'path'    => '/',
						);

						$id_user = $cookie_val;
						setcookie( 'visitor_id', $cookie_val, $cookie_arr );
					}
				}

				$SxGeo      = new SxGeo( INSTANTUP_PATH . '/data/SxGeoCity.dat', SXGEO_BATCH | SXGEO_MEMORY );
				$location   = $SxGeo->getCityFull( $user_ip );
				$table_name = $wpdb->base_prefix . 'user_activity';
				$table_data = array(
					'id_user'      => $id_user,
					'user_ip'      => $user_ip,
					'page_url'     => home_url() . $_SERVER['REQUEST_URI'],
					'city'         => $location['city']['name_en'] ?? 'Unknown',
					'latitude'     => $location['city']['lat'] ?? 'Unknown',
					'longitude'    => $location['city']['lon'] ?? 'Unknown',
					'region'       => $location['region']['name_en'] ?? 'Unknown',
					'country'      => $location['country']['name_en'] ?? 'Unknown',
					'referer'      => $_SERVER['HTTP_REFERER'] ?? '',
					'display_name' => get_user_meta( get_current_user_id(), 'nickname' )[0] ?? 'Guest',
					'visit_date'   => time(),
					'user_agent'   => $_SERVER['HTTP_USER_AGENT'],
				);

				if ( $type_check ) {
					$table_data['uid']       = get_post_meta( $post_id, 'iu-uid', true );
					$table_data['page_id']   = $post_id;
					$table_data['page_name'] = get_query_var( 'name' );
					$table_data['post_type'] = get_query_var( 'post_type' );
				}

				if ( $is_taxonomy === $prefix_type . '_categories' || $is_taxonomy === $prefix_type . '_tags' ) {
					$term_ogj = get_queried_object();

					$table_data['uid']       = get_term_meta( $term_ogj->term_id, 'uid', true );
					$table_data['page_id']   = $term_ogj->term_id;
					$table_data['page_name'] = $term_ogj->name;

					if ( $is_taxonomy === $prefix_type . '_categories' ) {
						$table_data['post_type'] = 'Category';
					}

					if ( $is_taxonomy === $prefix_type . '_tags' ) {
						$table_data['post_type'] = 'Tag';
					}
				}

				if ( ! $wpdb->insert( $table_name, $table_data ) ) {
					$admin->write_log( $wpdb->last_error, 'follow-insert-error.txt' );
				}
			}
		}
	}

	public function ajax_send_out_of_turn() {
		$out_of_turn = $this->send_data( true );
		wp_send_json( $out_of_turn );
	}

	public function send_data( $return = false ) {
		global $wpdb;
		$table_name  = $wpdb->base_prefix . 'user_activity';
		$has_stopped = (int) get_option( 'has_stopped' );
		$api_key     = get_option( '_firebase_auth' );

		if ( $has_stopped ) {
			$sql = "SELECT * FROM $table_name WHERE id > $has_stopped";

		} else {
			$sql = "SELECT * FROM $table_name";
		}

		$data_log    = $wpdb->get_results( $sql, ARRAY_A );
		$output_data = array();
		$_end        = end( $data_log );
		$key         = 0;

		if ( $data_log ) {
			for ( $i = 0, $c = count( $data_log ); $i < $c; $i ++ ) {

				if ( isset( $output_data['data'][ $key ]['visit_date'] ) ) {
					$date_output = date( 'Y-m-d', $output_data['data'][ $key ]['visit_date'] );
				} else {
					$date_output = false;
				}

				$_date       = date( 'Y-m-d', $data_log[ $i ]['visit_date'] );
				$page_output = $output_data['data'][ $key ]['page_url'] ?? false;
				$_page       = $data_log[ $i ]['page_url'];

				if ( $date_output === $_date && $page_output === $_page ) {
					if ( $output_data['data'][ $key ]['count'] ) {
						$output_data['data'][ $key ]['count'] += 1;
					} else {
						$output_data['data'][ $key ]['count'] = 1;
					}

				} else {
					if ( $i !== 0 ) {
						$key ++;
					}

					$data_log[ $i ]['count']   = 1;
					$data_log[ $i ]['date']    = $this->time_format( $data_log[ $i ]['visit_date'] );
					$data_log[ $i ]['geohash'] = md5( $data_log[ $i ]['latitude'] . ',' . $data_log[ $i ]['longitude'] );
					$output_data['data'][]     = $data_log[ $i ];
				}
			}

			$admin                    = new Admin();
			$output_data['apiKey']    = $api_key;
			$output_data['accountId'] = get_option( 'iu_saas_accountId' ) ? : '';
			update_option( 'has_stopped', $_end['id'], false );

			$ch = curl_init( IU_CLOUDFUNCTIONS_HOST . '/app/usage-log' );
			curl_setopt( $ch, CURLOPT_POST, 1 );
			curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $output_data ) );
			curl_setopt( $ch, CURLOPT_HTTPHEADER, array( 'Content-Type:application/json' ) );
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
			$data = curl_exec( $ch );
			$admin->write_log( $output_data, 'cron_user_log.txt' );

			if ( curl_errno( $ch ) ) {
				$admin->write_log( $output_data, 'error_user_log.txt' );
			}

			curl_close( $ch );

			if ( $return ) {
				return $data;
			}
		}

		if ( $return ) {
			return 'there is nothing to send';
		}
	}

	public function time_format( $time = '' ) {
		$time = $time ? : time();

		return date( 'Y-m-d', $time ) . 'T' . date( 'H:i:s.Z', $time ) . 'Z';
	}

	public function is_bot( $ip ) {
		if ( empty( $ip ) ) {
			return false;
		}

		$pattern = '/bot|crawl|slurp|spider|mediapartners|parser3|Bot|W3C_Validator|Yandex|WebAlta|Aport|ia_archiver|Scooter|Teoma|Slurp|Yahoo/i';
		$bot_ips = array(
			'5.181.',
			'2.57.',
			'5.180.',
			'85.208.',
			'97.107.',
			'96.55.',
			'95.91.',
			'95.216.',
			'95.163.',
			'93.158.',
			'92.220.',
			'91.242.',
			'88.214.',
			'88.198.',
			'85.215.',
			'85.10.',
			'82.80.',
			'82.165.',
			'78.46.',
			'78.129.',
			'77.88.',
			'77.75.',
			'74.91.',
			'70.175.',
			'69.160.',
			'68.231.',
			'66.249.',
			'64.21.',
			'62.210.',
			'62.138.',
			'58.173.',
			'54.36.',
			'54.201.',
			'52.70.',
			'52.162.',
			'51.15.',
			'5.9.',
			'5.45.',
			'5.255.',
			'5.189.',
			'5.188.',
			'49.148.',
			'46.4.',
			'45.5.',
			'44.195.',
			'44.194.',
			'44.192.',
			'40.77.',
			'40.66.',
			'37.0.',
			'35.84.',
			'35.240.',
			'35.225.',
			'35.196.',
			'35.185.',
			'34.78.',
			'34.73.',
			'34.139.',
			'3.99.',
			'3.98.',
			'3.97.',
			'3.96.',
			'3.89.',
			'3.81.',
			'3.236.',
			'3.224.',
			'3.19.',
			'3.15.',
			'3.143.',
			'3.141.',
			'3.139.',
			'3.128.',
			'23.228.',
			'23.22.',
			'23.100.',
			'220.241.',
			'216.244.',
			'216.18.',
			'213.239.',
			'213.180.',
			'213.136.',
			'212.192.',
			'207.46.',
			'203.159.',
			'20.55.',
			'20.110.',
			'198.27.',
			'198.12.',
			'195.20.',
			'194.61.',
			'194.209.',
			'193.23.',
			'192.99.',
			'185.191.',
			'185.101.',
			'181.214.',
			'18.224.',
			'18.223.',
			'18.222.',
			'18.221.',
			'18.216.',
			'18.189.',
			'18.188.',
			'18.119.',
			'18.118.',
			'18.117.',
			'18.116.',
			'178.63.',
			'176.31.',
			'176.231.',
			'173.231.',
			'173.212.',
			'172.70.',
			'17.121.',
			'167.99.',
			'167.114.',
			'162.55.',
			'159.138.',
			'158.69.',
			'157.90.',
			'157.55.',
			'157.38.',
			'15.222.',
			'149.202.',
			'148.251.',
			'144.76.',
			'141.8.',
			'138.201.',
			'136.144.',
			'13.66.',
			'127.0.',
			'123.58.',
			'121.200.',
			'118.26.',
			'116.203.',
			'114.119.',
			'112.213.',
			'107.181.',
			'104.33.',
			'104.155.',
			'104.128.',
			'101.36.',
		);

		$ip_arr = explode( '.', $ip );
		$ip     = isset($ip_arr[0],$ip_arr[1]) ? "{$ip_arr[0]}.{$ip_arr[1]}." : '0.0';

		$check_user_agent = isset( $_SERVER['HTTP_USER_AGENT'] ) && preg_match( $pattern, $_SERVER['HTTP_USER_AGENT'] );
		$check_ip_user    = in_array( $ip, $bot_ips );


		return ( $check_user_agent || $check_ip_user );
	}

	public function creating_db() {
		global $wpdb;
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		$charset_collate = $wpdb->get_charset_collate();

		$user_activity = $wpdb->base_prefix . 'user_activity';

		$sql = "CREATE TABLE {$user_activity} (
			id             bigint(20) unsigned NOT NULL auto_increment,
			uid            char(255) NOT NULL,
			id_user        varchar(255) NOT NULL,
			page_id        int(20) NOT NULL,
			user_ip        varchar(255) NULL default null,
			page_name      tinytext NULL default null,
			page_url       tinytext NULL default null,
			city           varchar(255) NULL default null,
			latitude       varchar(255) NULL default null,
			longitude      varchar(255) NULL default null,
			region         varchar(255) NULL default null,
			country        varchar(255) NULL default null,
			post_type      varchar(255) NULL default null,
			referer        tinytext NULL default null,
			display_name   varchar(255) NULL default null,
			visit_date     char(255) NOT NULL,
			user_agent     tinytext NULL default null,
			PRIMARY KEY  (id)
			)
			{$charset_collate};";

		dbDelta( $sql );
	}

}