'use strict';

const $isAdmin = document.querySelector('body.wp-admin');

let $locations = undefined,
    $interval = 0,
    $iuAside = document.querySelector('.iu-posts-list-aside'),
    $cntMapBox = document.querySelector('.iu-content-map-box'),
    linkAjax = typeof instantup_object === 'undefined'
        ? `${window.location.origin}/wp-admin/admin-ajax.php`
        : instantup_object?.ajaxurl,
    $ajaxMapObject = {
        'action': 'iu_ajax_filters',
    };

if (!!$isAdmin) {
    $interval = 1000;
}

document.addEventListener('DOMContentLoaded', function () {
    //START Fixed Map
    let $firstWaitInit = 0,
        $firstInitMap = () => {
            var map_element = jQuery('.JS_profolio_map'),
                column;

            if (map_element.length) {
                var is_responsive = false,
                    is_fixed,
                    is_bottom,
                    parent_witdh = map_element.parent().width();

                    column = map_element.closest('.wp-block-columns .wp-block-column');

                if (!column.length) {
                    column = map_element;
                }

                map_element.parent().css({
                    'overflow': 'hidden',
                });

                map_element.css({
                    'width': parent_witdh,
                });

                if (jQuery(window).width() <= 588) {
                    is_responsive = true;
                } else if (jQuery(window).width() >= 589) {
                    map_element.closest('.elementor-widget-map').css('height', '100vh');
                    map_element.closest('.elementor-widget-container').css('height', '100%');
                    map_element.closest('.profolio-map-wrapper').css('height', '100vh');
                    //map_element.css('height', '100%');
                } else {
                    is_responsive = false;
                }
            }

            window.iu_map_fixed_map = function () {
                var cur_pos_top = jQuery(document).scrollTop(),
                    cur_pos_bot = cur_pos_top + jQuery(window).height(),
                    parent_witdh = map_element.parent().width(),
                    header_height = column.offset().top || 100,
                    column_pos_bottom = header_height + column.height();

                if (!is_responsive) {

                    is_fixed = false;
                    is_bottom = false;

                    if (cur_pos_top >= header_height) {
                        if (cur_pos_bot <= column_pos_bottom) {
                            is_fixed = true;

                        } else {
                            is_fixed = false;
                            is_bottom = true;
                        }
                    } else {
                        is_fixed = false;
                    }

                    if (is_fixed) {
                        map_element.addClass('fixed');

                        map_element.css({
                            'width': parent_witdh,
                        });

                        map_element.closest('.elementor-widget-map').css('height', '100vh');
                        map_element.closest('.profolio-map-wrapper').css('height', '100vh');
                        map_element.closest('.elementor-widget-container').css('height', '100%');
                    } else {
                        map_element.removeClass('fixed bottom');

                        if (is_bottom) {
                            map_element.addClass('bottom');
                        }
                    }

                }
            };

            if (!!$isAdmin) {
                let $mapData = document.querySelector('.profolio-map-wrapper template').content.querySelector('p');
                window['iuMapOptions'] = $mapData.dataset.iumapoptions;
            }

            if (window['iuMapOptions']) {
                let map_params = JSON.parse(atob(window['iuMapOptions']));

                jQuery(document).on('scroll', function () {
                    if (jQuery(window).width() >= 589) {
                        if (map_element.length && (map_params.fullheight === 'yes' || map_params.fullheight === '1')) {
                            iu_map_fixed_map();
                        }
                    }
                });
            }

            jQuery(window).on('resize', function () {
                if (jQuery(window).width() <= 588) {
                    is_responsive = true;
                } else if (jQuery(window).width() >= 589) {
                    map_element.closest('.elementor-widget-map').css('height', '100vh');
                    map_element.closest('.elementor-widget-container').css('height', '100%');
                    map_element.closest('.profolio-map-wrapper').css('height', '100vh');
                    map_element.css('height', '100vh');
                } else {
                    is_responsive = false;
                }
            });
        };//This style

    if (!$cntMapBox) {
        let $firstMapTimer = setInterval(() => {
            $firstWaitInit++;

            if (!!$isAdmin) {
                if ($firstWaitInit >= 20) {
                    clearInterval($firstMapTimer);
                }

                if (document.querySelector('.block-map-bottom .profolio-map-wrapper template')) {
                    $firstInitMap();
                    clearInterval($firstMapTimer);
                }
            } else {
                $firstInitMap();
                clearInterval($firstMapTimer);
            }
        }, $interval);
    }
    //END Fixed Map

    let $secondWaitInit = 0;
    let $fixedAdminHeightMap = () => {
        let $mapAdmin = document.querySelector('.block-map-bottom');
        if ($mapAdmin){
            let $parentMapAdmin = $mapAdmin.closest('.block-editor-block-list__block'),
                $previewMapAdmin = $mapAdmin.closest('.cf-block__preview'),
                $divMapAdmin = $mapAdmin.parentNode;

            $parentMapAdmin.style.height = $divMapAdmin.style.height = $previewMapAdmin.style.height = '100%';
        }
    };
    let $secondInitMap = () => {
        if (!!$isAdmin) {
            let $mapData = document.querySelector('.profolio-map-wrapper template').content.querySelector('p');
            window['iuMapOptions'] = $mapData.dataset.iumapoptions;
            $cntMapBox = document.querySelector('.iu-content-map-box');
        }

        let $noMapApi = document.querySelector('#iu_no_map_api');
        console.log('! $noMapApi', !!$noMapApi);
        if (!!$noMapApi) {
            $noMapApi.parentElement.style.display = 'none';
            $noMapApi.parentElement.nextElementSibling.style.cssText = `flex-basis: 100% !important; max-width: 100%;`;
        }

        window['$iuPosts'] = document.querySelector('#iu_posts_block');

        let $mapZoomFit,
            activeInfoWindow,
            $objLinkParams = {};

        let create_marker = function (map_core, params, location) {
                let latlng = {
                        lat: Number(location.lat),
                        lng: Number(location.lng),
                    },
                    marker_options = {
                        map: map_core,
                        position: latlng,
                    };

                if (params.marker) {
                    marker_options.icon = params.marker;
                }

                let template = wp.template('profolio-infowindow-template'),
                    infowindow = new google.maps.InfoWindow({
                        content: template(location),
                    });

                let marker = new google.maps.Marker(marker_options);

                marker.addListener('mouseover', function () {
                    if (activeInfoWindow) {
                        activeInfoWindow.close();
                    }
                    infowindow.open(map_core, marker);

                    activeInfoWindow = infowindow;
                });

                marker.addListener('mouseleave', function () {
                    if (activeInfoWindow) {
                        activeInfoWindow.close();
                    }
                });

                marker.addListener('click', function () {
                    if (jQuery(window).width() <= 767) {
                        if (activeInfoWindow) {
                            activeInfoWindow.close();
                        }
                        infowindow.open(map_core, marker);

                        activeInfoWindow = infowindow;
                    } else {
                        if (activeInfoWindow) {
                            infowindow.close();
                        }
                    }
                });

                google.maps.event.addListener(map_core, 'click', function (event) {
                    infowindow.close();
                });

                google.maps.event.addListener(infowindow, 'domready', function () {
                    let $image = jQuery('.profolio-map-pop img');
                    let src = $image.data('src');
                    let srcset = $image.data('srcset');

                    if (src) {
                        jQuery('.profolio-map-pop img').attr({
                            'src': src,
                            'srcset': srcset,
                        });
                        $image.removeAttr('data-src');
                        $image.removeAttr('data-srcset');
                    }
                });

                return marker;

            },
            proximate_loc = function (location) {
                if (window.instantup_object.type_address === 'general') {

                    let rand_meter = window.instantup_object.rand_meter,
                        rand_coef = parseFloat(rand_meter) * 0.0000089;

                    location.lat = parseFloat(location.lat) + (rand_coef
                        / Math.cos(
                            parseFloat(location.lng) * 0.018));
                    location.lng = parseFloat(location.lng) + rand_coef;

                }

                return location;
            },
            show_info_window = function () {
                let $projectItems = jQuery('.JS_profolio_project_item');

                if (!$projectItems.length) {
                    return;
                }

                let show_info_window_func = function ($this) {
                    $this = jQuery($this);

                    let latlong = `${$this.data('latlong')}_${$this.data('post-id')}`;

                    if (!latlong.length) {
                        return false;
                    }

                    if (window.iu_init_markers && latlong) {

                        var location = {
                            lat: latlong.split(',')[0],
                            lng: latlong.split(',')[1],
                        };
                        console.log('show_info_window_func');
                        location = proximate_loc(location);
                        latlong = `${location.lat.toString()},${location.lng.toString()}`;

                        var marker = window.iu_init_markers[latlong];

                        if ($cntMapBox) {
                            if (marker !== 'undefined' && typeof window.google !== 'undefined') {
                                new google.maps.event.trigger(marker, 'mouseover');
                            }
                        } else {
                            if (jQuery(window).width() >= 589 && marker !== 'undefined' && typeof window.google !== 'undefined') {
                                new google.maps.event.trigger(marker, 'mouseover');
                            }
                        }

                    }
                };

                $projectItems.on('mouseenter', function () {
                    show_info_window_func(this);
                });

                $projectItems.on('touchstart', function () {
                    console.log('touchstart', this);
                    show_info_window_func(this);
                });

            };

        window.iu_init_map = function (newLocations, data_object = undefined) {
            if (typeof window.google === 'undefined' && !window['iuMapOptions']) {
                return;
            }

            let map_attr = data_object ?? undefined,
                locsItem = newLocations !== undefined ? JSON.parse(atob(newLocations)) : null,
                geocoder = new google.maps.Geocoder();

            console.log('locsItem', locsItem);

            jQuery('.JS_profolio_map').each(function () {
                let map_params = JSON.parse(atob(window['iuMapOptions'])),
                    core_options = {zoom: 8};

                $mapZoomFit = map_params['zoom_fit'] ?? false;

                if (locsItem) {
                    map_params['locations'] = locsItem;
                }

                if (!$mapZoomFit) {
                    let iuLocationLat = 39.8034993,
                        iuLocationLng = -100.5229836;

                    if (window['iuMapCenterLatLng']) {
                        iuLocationLat = window['iuMapCenterLatLng'][0];
                        iuLocationLng = window['iuMapCenterLatLng'][1];
                    }

                    core_options['center'] = new google.maps.LatLng(iuLocationLat, iuLocationLng,);
                }

                if (map_params['zoom']) {
                    core_options['zoom'] = parseInt(map_params['zoom']);
                }

                if (map_params['style']){
                    try {
                        core_options['styles'] = JSON.parse(map_params['style']);
                    } catch (e){
                        console.error('An error occurred when trying to convert map styles to an object');
                    }
                }

                if (map_params['scrollwheel']) {
                    core_options['scrollwheel'] = true;
                }

                // select type map
                if (map_params['select_map_types']) {
                    core_options['mapTypeId'] = map_params['select_map_types'];
                }

                core_options['mapTypeControl'] = false;
                core_options['scaleControl'] = false;
                core_options['fullscreenControl'] = false;
                core_options['rotateControl'] = false;
                core_options['zoomControl'] = false;

                if (map_params['map_type_control']) {
                    core_options['mapTypeControl'] = true;
                }

                if (map_params['scale_control']) {
                    core_options['scaleControl'] = true;
                }

                if (map_params['fullscreen_control']) {
                    core_options['fullscreenControl'] = true;
                }

                if (map_params['rotate_control']) {
                    core_options['rotateControl'] = true;
                }

                if (map_params['zoom_control']) {
                    core_options['zoomControl'] = true;
                }

                if (!map_params['enable_default_ui']) {
                    core_options['mapTypeControl'] = false;
                    core_options['scaleControl'] = false;
                    core_options['fullscreenControl'] = false;
                    core_options['rotateControl'] = false;
                    core_options['zoomControl'] = false;
                }

                core_options['streetViewControl'] = false;

                let map_core = new google.maps.Map(this, core_options);


                if (map_attr !== undefined && map_attr['lat'] && map_attr['lng']) {

                    window['iuMapCenterLatLng'][0] = map_attr['lat'];
                    window['iuMapCenterLatLng'][1] = map_attr['lng'];
                    map_core.setCenter(
                        {
                            lat: Number(map_attr['lat']),
                            lng: Number(map_attr['lng']),
                        });
                    map_core.setZoom(8);
                }

                map_core.setTilt(0);

                if (map_params['imagery_45']) {
                    map_core.setTilt(45);
                }

                if (window['iuMapCenterLatLng'] && !$mapZoomFit) {
                    let $geocodeAttr = {'address': window['iuMapCenterLatLng'].toString()};

                    geocoder.geocode($geocodeAttr, function (results, status) {
                            if (status === 'OK') {
                                let $cityName = '';

                                for (let $i = 0; $i < results.length; $i++) {
                                    if (!$cityName && results[$i].types[0]
                                        === 'locality') {
                                        let $address = results[$i]['address_components'];

                                        for (let $i2 = 0; $i2 < $address.length; $i2++) {
                                            let $component = $address[$i2];
                                            if ($component.types[0] === 'locality') {
                                                $cityName = $component['long_name'];
                                                break;
                                            }
                                        }

                                    }
                                }

                                map_core.setCenter(results[0].geometry.location);

                                let locationFilter = document.querySelector('.iu_location-filter');
                                if (locationFilter) {
                                    locationFilter.value = $cityName;
                                }

                            } else {
                                console.info(
                                    `Geocode was not successful for the following reason: ${status}`);
                            }
                        },
                    );
                }

                let bounds = new google.maps.LatLngBounds(),
                    boundsComplete = 0;

                window.iu_init_markers = {};

                if (window?.instantup_object?.type_address !== 'exact') {
                    jQuery.each(map_params.locations, function (index, location) {
                        location = proximate_loc(location);
                        map_params.locations[index].lat = location.lat ?? 0;
                        map_params.locations[index].lng = location.lng ?? 0;
                    });
                }//by default it we skipping

                map_params['locations'].forEach(function (location, i) {
                    ++boundsComplete;

                    if (location?.lat && location?.lng &&
                        Number.isInteger(Number(location['lat'].replace('.', ''))) &&
                        Number.isInteger(Number(location['lng'].replace('.', '')))) {

                        let marker = create_marker(map_core, map_params, location);

                        //console.log(location['lat'],location['lng'], Number.isInteger(Number(location['lat'].replace('.', ''))), Number.isInteger(Number(location['lng'].replace('.', ''))) );

                        bounds.extend(marker['position']);
                        window['iu_init_markers'][`${location['lat']},${location['lng']}_${location['id']}`] = marker;

                    }

                });

                if (map_params['locations'] && $mapZoomFit && map_attr === undefined) {
                    //console.log('IUIU');

                    let boundsTime = setInterval(() => {
                        if (boundsComplete === map_params['locations'].length) {
                            clearInterval(boundsTime);
                            map_core.fitBounds(bounds);

                            google.maps.event.addListenerOnce(map_core, 'bounds_changed', function () {
                                    if (this?.getZoom) {
                                        let minZoom = (this.getZoom() > 3) ? this.getZoom() : 3;

                                        this.setZoom(Math.min(12, minZoom));
                                    }

                                },
                            );

                        }
                    }, 500);

                }

            });
        };

        if ($cntMapBox) {
            if (document.querySelector('.iu-posts-list-box')){
                if ( $cntMapBox.classList.contains('d-none')){
                    if (sessionStorage.getItem('iu_show_map') === 'true' && Number(instantup_object?.paged) > 1) {

                        document.querySelector('.iu-posts-list-box').classList.add('active');
                        document.querySelector('.btn-pc-active-filter').classList.add('active');
                        $iuAside.classList.add('d-none');
                        $cntMapBox.classList.remove('d-none');
                        iu_init_map($locations);
                        $firstInitMap();
                    }

                    let $mapBtn = document.querySelector('.iu-aside-map-box-btn');
                    $mapBtn.addEventListener('click', () => {
                        sessionStorage.setItem(`iu_show_map`, 'true');
                        iu_init_map($locations);
                        $firstInitMap();
                    });
                } else {
                    iu_init_map();
                }
            }
        }
        else{
            iu_init_map($locations);
            $firstInitMap();
        }

        if (!!$isAdmin) {
            return;
        }

        //START Show/Hide info window
        if (!window['iuHideInfoWindow']) {
            show_info_window();
        }
        //END Show/Hide info window

        //START autocomplete and filters and sort
        if (!$iuPosts) {
            return;
        }

        if (window['iuMapCenterLatLng']) {
            $iuPosts.setAttribute('data-lat',
                String(window['iuMapCenterLatLng'][0]),
            );
            $iuPosts.setAttribute('data-lng',
                String(window['iuMapCenterLatLng'][1]),
            );
        }

        if (String(window.location).lastIndexOf('?') !== -1) {
            $objLinkParams = JSON.parse(localStorage.getItem('objLinkParams'));
        }

        let $locRememberValue,
            $pagination = $iuPosts.querySelector('.profolio-pagination nav'),
            $locFilter = document.querySelector('.iu_location-filter-row #iu_location_filter'),
            $radius = document.querySelector('#iu_radius_filter'),
            $fromLocationNow = document.querySelector('.iu-posts-list-aside-radius-title p span'),
            $clearLocation = document.querySelector('.iu-posts-list-aside-radius-title .iu_location-filter-clear'),
            $postType = $iuPosts?.dataset.postType,
            $perPage = $iuPosts?.dataset.perPage,
            $template = $iuPosts?.dataset.template,
            $pageSlug = `/${$iuPosts.dataset.slug}/` ?? window.location.pathname,
            $order = $iuPosts?.dataset.order,
            $currentPage = $iuPosts?.dataset.currentPage,
            $parentId = $iuPosts?.dataset.parentId,
            $mapObject = {
                'parent_id': $parentId,
                'post_type': $postType,
                'template': $template || 'project-item',
                'posts_per_page': $perPage,
            };

        $ajaxMapObject = {...$ajaxMapObject, ...$mapObject};

        let setValue = function (obj1, obj2, key, tag) {
                if (tag === 'input' && key && obj2 && obj2[key]) {
                    obj1.value = obj2[key];
                }

                if (tag === 'checkbox') {
                    let key = `${obj1.getAttribute('name')}_${obj1.dataset.id}`;

                    if (obj2['filters'] && obj2['filters'][key]) {
                        obj1.setAttribute('checked', '');
                    }
                }

                if (tag === 'select' && obj1) {
                    for (let item of obj1) {
                        if (item.value === obj2[key]) {
                            item.setAttribute('selected', '');
                        }
                    }
                }

            },
            changeUrl = function (name, val) {
                if (name === 'filters') {
                    if ($objLinkParams['filters']) {
                        if (!val['value']) {
                            delete $objLinkParams['filters'][val['key']];

                            if (Object.keys($objLinkParams['filters']).length
                                === 0) {
                                delete $objLinkParams['filters'];
                            }

                        } else {
                            $objLinkParams['filters'][val['key']] = val['value'];
                        }

                    } else {
                        $objLinkParams['filters'] = {};
                        $objLinkParams['filters'][val['key']] = val['value'];
                    }

                } else {
                    !val ? delete $objLinkParams[name] : $objLinkParams[name] = val;
                }

                let $urlLocation = `${window.location.origin}${$pageSlug}`;

                if (Object.keys($objLinkParams).length) {
                    let $urlObj = {};

                    Object.assign($urlObj, $objLinkParams);

                    if ($objLinkParams['filters']) {
                        $urlObj['filters'] = new URLSearchParams($objLinkParams['filters']).toString();
                    }

                    let $urlParams = new URLSearchParams($urlObj).toString();

                    $urlLocation += `?${$urlParams}`;
                }

                history.pushState(null, null, $urlLocation);

                localStorage.setItem('objLinkParams', JSON.stringify($objLinkParams),);
            },
            navHandler = function (maxPages) {
                const createMain = () => {
                    let $ul = document.createElement('ul');

                    $ul.classList.add('page-numbers');

                    return $ul;
                };

                const createCurrent = () => {
                    let $li = document.createElement('li'),
                        $span = document.createElement('span');

                    $span.classList.add('page-numbers');
                    $span.classList.add('current');
                    $span.setAttribute('aria-current', 'page');
                    $span.textContent = '1';

                    $li.insertAdjacentElement('afterbegin', $span);

                    return $li;
                };

                const createDots = () => {
                    let $li = document.createElement('li'),
                        $span = document.createElement('span');

                    $span.classList.add('page-numbers');
                    $span.classList.add('dots');
                    $span.textContent = '…';
                    $li.insertAdjacentElement('afterbegin', $span);

                    return $li;
                };

                const createLink = () => {
                    let $li = document.createElement('li'),
                        $link = document.createElement('a'),
                        $href = `${window.location.origin}${$pageSlug}page/${$pageCount}/${window.location.search}`;

                    $link.classList.add('page-numbers');
                    $link.textContent = String($pageCount);
                    $link.setAttribute('href', $href);
                    $li.insertAdjacentElement('afterbegin', $link);

                    return $li;
                };

                let $pageCount = 2,
                    $navUl = createMain();

                $pagination.textContent = '';
                $pagination.insertAdjacentElement('afterbegin', $navUl);
                $navUl.insertAdjacentElement('afterbegin', createCurrent());

                for (let i = 1; i < maxPages; i++) {
                    if (maxPages > 5) {
                        createDots();
                    }

                    $navUl.insertAdjacentElement('beforeend', createLink());
                    $pageCount++;
                }

            },
            filtersHandler = function (dataObject, initMap = false) {
                if (!dataObject.posts_per_page) {
                    dataObject.posts_per_page = 26;
                }

                let $loaderImgDiv = document.createElement('div'),
                    $loaderImg = document.createElement('img'),
                    $realestateList = $iuPosts.querySelector('.profolio-cards-row');

                if (!$realestateList){
                    $realestateList = $iuPosts.querySelector('.iu-projects-map-cnt');
                }

                if ($pagination) {
                    let $paginationUl = $pagination.querySelector('ul.page-numbers');

                    if ($paginationUl) {
                        $paginationUl.remove();
                    }
                }

                $loaderImgDiv.classList.add('rp-cart-loader');
                $loaderImg.setAttribute('src',
                    `${instantup_object['plugin_url']}data/assets/img/ajax-loader.gif`,
                );

                $loaderImgDiv.insertAdjacentElement('afterbegin', $loaderImg);
                $realestateList.insertAdjacentElement('afterbegin', $loaderImgDiv);

                jQuery.ajax({
                    type: 'POST',
                    url: linkAjax,
                    dataType: 'json',
                    data: dataObject,
                    success: function (response) {
                        console.log(response);
                        let $showingCount = $iuPosts.querySelector('.iu_realestate-count-sort strong:first-child'),
                            $totalItems = $iuPosts.querySelector('.iu_realestate-count-sort strong:last-child');

                        $realestateList.innerHTML = '';
                        $realestateList.innerHTML = response['content'];

                        $loaderImgDiv.remove();

                        if ($showingCount && $totalItems && response['count_post'] && response['all_post']) {
                            $showingCount.textContent = String(response['count_post']);
                            $totalItems.textContent = String(response['all_post']);
                        }

                        if (document.querySelector('.iu-posts-list-aside.active-pc')) {
                            initMap = true;
                        }

                        console.log('initMap', initMap);

                        if (response['locations']) {
                            $locations = response['locations'];

                            if (initMap) {
                                iu_init_map(response['locations']);
                            }

                            if (!$cntMapBox) {
                                iu_map_fixed_map();
                            }
                        }

                        if (!window['iuHideInfoWindow']) {
                            show_info_window();
                        }

                        if (response['max_pages'] > 1) {
                            navHandler(response['max_pages']);
                        }
                        window.scrollTo(0, 0);
                    },
                    error: function () {
                        $loaderImgDiv.remove();

                        $realestateList.innerHTML = 'Ajax error !!';
                        console.error('Ajax error !!');
                    },
                });
            },
            addFiltersHandler = function (item) {
                setValue(item, $objLinkParams, 'filters', 'checkbox');

                if (item.checked) {
                    $ajaxMapObject['more_filters'].push({
                        'id': item.dataset.id,
                        'status': item.checked,
                        'value': item.parentNode.textContent.trim(),
                        'key': item.getAttribute('name'),
                    });

                }

                item.addEventListener('click', function () {
                    let $index,
                        $update = false,
                        $filters = $ajaxMapObject['more_filters'],
                        $ID = this.dataset.id,
                        $name = this.getAttribute('name'),
                        $value = this.parentNode.textContent.trim(),
                        $checked = this.checked;

                    if ($filters.length) {
                        for (let $i = 0; $i < $filters.length; $i++) {

                            if ($filters[$i]['id'] === $ID
                                && $filters[$i]['status']
                                !== $checked) {

                                $update = true;
                                $index = $i;

                                break;
                            }
                        }
                    }

                    changeUrl('filters',
                        {
                            'key': `${$name}_${$ID}`,
                            'value': $checked ? $value : '',
                        },
                    );

                    if ($update) {
                        $filters.splice($index, 1);
                        filtersHandler($ajaxMapObject, true);

                        return;
                    }

                    $filters.push({
                        'id': $ID,
                        'status': $checked,
                        'value': $value,
                        'key': $name,
                    });

                    filtersHandler($ajaxMapObject, true);
                });

            };

        //Start Order
        if ($order) {
            $ajaxMapObject['order'] = $order;
        }
        //End Order

        //Start radius
        if ($radius) {
            if ($objLinkParams?.radius) {
                $radius.value = $objLinkParams['radius'];

                let filterOutput = $radius.nextElementSibling.querySelector('output');

                filterOutput.textContent = $objLinkParams['radius'];
            }

            $ajaxMapObject['radius'] = $radius.value;

            $radius.addEventListener('change', function () {
                changeUrl('radius', this.value);

                $ajaxMapObject['radius'] = this.value ?? '0';

                if ($ajaxMapObject['lat'] && $ajaxMapObject['lng']) {
                    filtersHandler($ajaxMapObject, true);
                    return;
                }

                if ($ajaxMapObject['lat'] === undefined && $ajaxMapObject['lng'] === undefined) {
                    $ajaxMapObject['lat'] = $iuPosts.dataset.lat;
                    $ajaxMapObject['lng'] = $iuPosts.dataset.lng;

                    filtersHandler($ajaxMapObject, true);
                }

            }, false);
        }
        //End radius

        //Start location
        if ($locFilter) {
            setValue($locFilter, $objLinkParams, 'locName', 'input');

            let $autocomplete = new google.maps.places.Autocomplete($locFilter);

            $locFilter.addEventListener('focus', function () {
                $locRememberValue = this.value;
                this.value = '';
            });
            $locFilter.addEventListener('blur', function () {
                if (!this.value) {
                    this.value = $locRememberValue;
                }
            });

            google.maps.event.addListener($autocomplete, 'place_changed', function () {
                    let $place = $autocomplete.getPlace();

                    changeUrl('lat', $place.geometry.location.lat());
                    changeUrl('lng', $place.geometry.location.lng());
                    changeUrl('locName', $locFilter.value);

                    if ($fromLocationNow) {
                        $fromLocationNow.textContent = $locFilter.value;
                    }
                    if ($clearLocation) {
                        $clearLocation.classList.remove('d-none');
                    }

                    $ajaxMapObject['lat'] = $place.geometry.location.lat();
                    $ajaxMapObject['lng'] = $place.geometry.location.lng();

                    filtersHandler($ajaxMapObject);
                }, false,
            );
        }
        //End location

        //Start clear location
        if ($clearLocation) {
            $clearLocation.addEventListener('click', function () {
                delete $ajaxMapObject['lat'];
                delete $ajaxMapObject['lng'];

                $fromLocationNow.textContent = '';
                $clearLocation.classList.add('d-none');

                filtersHandler($ajaxMapObject);
            });
        }
        //End clear location

        //Start label-tags filter
        let $filterTerms = document.querySelector('.iu-aside-term');
        if ($filterTerms) {
            $filterTerms.addEventListener('change', function (e) {
                for (let target = e.target; target && target !== this; target = target.parentNode) {
                    if (target.matches('input.aside-filter-tag-input')) {
                        if (!$ajaxMapObject['tags']) {
                            $ajaxMapObject['tags'] = {
                                ids: [],
                                term_type: '',
                            };
                        }

                        if (target.checked) {
                            $ajaxMapObject['tags']['ids'].push(Number(target.value));
                            $ajaxMapObject['tags']['term_type'] = 'iu_label_tags';
                        } else {
                            let $tagIndex = $ajaxMapObject['tags']['ids'].indexOf(Number(target.value));
                            if ($tagIndex !== -1) {
                                $ajaxMapObject['tags']['ids'].splice($tagIndex, 1);
                            }
                        }

                        filtersHandler($ajaxMapObject);
                        break;
                    }

                    if (target.matches('input.aside-filter-cat-input')) {
                        if (target.checked) {
                            if (!$ajaxMapObject['categories']) {
                                $ajaxMapObject['categories'] = {
                                    ids: [],
                                    term_type: '',
                                };
                            }

                            console.log('target.checked', target.checked);
                            $ajaxMapObject['categories']['ids'].push(Number(target.value));
                            $ajaxMapObject['categories']['term_type'] = 'iu_categories';
                        } else {
                            console.log('target.checked', target.checked);

                            let $catIndex = $ajaxMapObject['categories']['ids'].indexOf(Number(target.value));
                            if ($catIndex !== -1) {
                                $ajaxMapObject['categories']['ids'].splice($catIndex, 1);
                            }
                        }

                        filtersHandler($ajaxMapObject);
                    }

                }
            }, false);
        }
        //End label-tags filter

        //Start clear label-tags filter
        let $asideClearTags = document.querySelector('.iu-aside-clear-tags'),
            $asideClear = document.querySelector('.iu-mob-clear-filter'),
            funcAsideClear = function () {
                console.log(this);
                let $tagsChecked = document.querySelectorAll('.iu-aside-term-item-child input:checked');

                if ($tagsChecked.length) {
                    for (let $tagInput of $tagsChecked) {
                        $tagInput.checked = false;
                    }
                }

                if (this.classList.contains('iu-mob-clear-filter')) {
                    delete $ajaxMapObject['lat'];
                    delete $ajaxMapObject['lng'];

                    $fromLocationNow.textContent = '';
                    $clearLocation.classList.add('d-none');
                    changeUrl('lat');
                    changeUrl('lng');
                    changeUrl('locName');
                }

                delete $ajaxMapObject['categories'];
                delete $ajaxMapObject['tags'];
                filtersHandler($ajaxMapObject);
            };

        if ($asideClearTags) {
            $asideClearTags.addEventListener('click', funcAsideClear);
        }
        if ($asideClear) {
            $asideClear.addEventListener('click', funcAsideClear);
        }
        //End clear label-tags filter

        let $iuFilterBtn = $iuPosts.querySelector('#iu_filters_btn'),
            $additionalFilterWrap = $iuPosts.querySelector('.iu_filters-block');

        if (!!$iuFilterBtn && !!$additionalFilterWrap) {
            $iuFilterBtn.addEventListener('click', function () {
                $additionalFilterWrap.classList.toggle('active');
            }, false);
        }

        if (!$iuPosts.classList.contains('iu_realestate-block')) {
            return;
        }
        //TODO need ixed (working only iu_realestate)

        //Start variables the real-estate
        let $body = document.querySelector('body'),
            $minPrice = $iuPosts.querySelector('#iu_min_price'),
            $maxPrice = $iuPosts.querySelector('#iu_max_price'),
            $sortBy = $iuPosts.querySelector('.iu_realestate-sort .iu_realestate-select'),
            $additionalFilters = $iuPosts.querySelectorAll('.iu_filters-item-row input[type="checkbox"]');
        //End variables the real-estate

        setValue($minPrice, $objLinkParams, 'min_price', 'select');
        setValue($maxPrice, $objLinkParams, 'max_price', 'select');
        setValue($sortBy, $objLinkParams, 'sort', 'select');

        $ajaxMapObject['sort'] = $sortBy?.value ?? '';
        $ajaxMapObject['min_price'] = $minPrice?.value ?? '';
        $ajaxMapObject['max_price'] = $maxPrice?.value ?? '';
        $ajaxMapObject['more_filters'] = [];

        //console.dir($ajaxMapObject)

        //Start minPrice
        if ($minPrice) {
            $minPrice.addEventListener('change', function () {
                changeUrl('min_price', this.value);

                $ajaxMapObject['min_price'] = this.value;

                filtersHandler($ajaxMapObject, true);
            }, false);
        }
        //End minPrice

        //Start maxPrice
        if ($maxPrice) {
            $maxPrice.addEventListener('change', function () {
                changeUrl('max_price', this.value);

                $ajaxMapObject['max_price'] = this.value;

                filtersHandler($ajaxMapObject, true);
            }, false);
        }
        //End maxPrice

        //Start Sort
        if ($sortBy) {
            $sortBy.addEventListener('change', function () {
                changeUrl('sort', this.value);

                $ajaxMapObject['sort'] = this.value;
                //$ajaxMapObject[ 'page' ] = $currentPage;

                filtersHandler($ajaxMapObject);

            }, false);
        }
        //End Sort

        //Start Filters
        if ($additionalFilters.length) {
            console.log($additionalFilters);
            for (let $arrayFilter of $additionalFilters) {
                addFiltersHandler($arrayFilter);
            }
        }
        //Start End

        $body.addEventListener('click', function (evt) {
            let $activeBtnFilters = $body.querySelector(
                '#iu_posts_block .iu_filters-block.active');

            if (($activeBtnFilters && !evt.target.matches('.iu_filters-btn'))
                &&
                ($activeBtnFilters && !evt.target.closest('.iu_filters-more'))
                &&
                ($activeBtnFilters && !evt.target.classList.contains('iu_price-select'))) {

                $activeBtnFilters.classList.remove('active');
            }

        }, false);
        //END autocomplete and filters and sort
    };
    let $secondMapTimer = setInterval(() => {
        $secondWaitInit++;

        if (!!$isAdmin) {
            if ($secondWaitInit >= 20) {
                clearInterval($secondMapTimer);
            }

            if (document.querySelector('.profolio-map-wrapper template')) {
                console.log('$secondWaitInit isAdmin1', !!$isAdmin);
                $secondInitMap();
                $fixedAdminHeightMap();
                clearInterval($secondMapTimer);
            }
        } else {
            console.log('Init map');
            clearInterval($secondMapTimer);
            $secondInitMap();
        }

    }, $interval);

    //START Mob show map
    (function () {
        let $showMobFilter = document.querySelector('.iu-show-mob-filters'),
            $showMobMap = document.querySelector('.iu-show-mob-map'),
            $showMobMapTxt = document.querySelector('.iu-show-mob-map span'),
            $iuPosts = document.querySelector('#iu_posts_block'),
            $doneFilter = document.querySelector('.iu-mob-accept-filter');

        if ($showMobFilter) {
            $showMobFilter.addEventListener('click', function () {
                if ($iuPosts) {
                    $iuPosts.classList.toggle('d-none');
                }
                if ($iuAside) {
                    $iuAside.classList.toggle('active');
                }

                let $parentMob = $showMobMap.closest('.btn-mob-filter');

                document.querySelector('.iu-posts-list .profolio-cards-row').classList.remove('active');
                $parentMob.classList.add('d-none');
                $parentMob.classList.remove('active-map');
                $cntMapBox.querySelector('.profolio-map-wrapper').classList.remove('active');
                $cntMapBox.classList.add('d-none');
                document.querySelector('html').classList.remove('overflow-hidden');
            });

            let $showFilterPc = document.querySelector('.iu-pc-show-filter');
            if ($showFilterPc) {
                $showFilterPc.addEventListener('click', function () {
                    if ($iuPosts) {
                        $iuPosts.classList.toggle('d-none');
                    }

                    if ($iuAside) {
                        $iuAside.classList.toggle('d-none');
                        $iuAside.classList.toggle('active-pc');
                    }
                });
            }

        }

        if ($showMobMap) {
            $showMobMap.addEventListener('click', () => {
                if ($iuPosts) {
                    $iuPosts.classList.remove('d-none');
                }
                if ($iuAside) {
                    $iuAside.classList.remove('active');
                }

                $showMobMap.classList.toggle('active');

                if ($showMobMap.classList.contains('active')) {
                    $showMobMapTxt.textContent = 'List View';
                } else {
                    $showMobMapTxt.textContent = 'Map View';
                }

                $showMobMap.closest('.btn-mob-filter').classList.toggle('active-map');
                document.querySelector('.iu-posts-list .profolio-cards-row').classList.toggle('active');
                $cntMapBox.querySelector('.profolio-map-wrapper').classList.toggle('active');
                $cntMapBox.classList.toggle('d-none');
                document.querySelector('html').classList.toggle('overflow-hidden');
                iu_init_map($locations);
            });
        }

        if ($doneFilter) {
            $doneFilter.addEventListener('click', () => {
                if ($iuPosts) {
                    $iuPosts.classList.toggle('d-none');
                }
                if ($iuAside) {
                    $iuAside.classList.toggle('active');
                }

                if ($showMobMap.classList.contains('active')) {
                    let $showMobMapMain = $showMobMap.closest('.btn-mob-filter');
                    $showMobMapMain.classList.remove('d-none');
                    $showMobMapMain.classList.toggle('active-map');

                    document.querySelector('.iu-posts-list .profolio-cards-row').classList.toggle('active');
                    $cntMapBox.querySelector('.profolio-map-wrapper').classList.toggle('active');
                    $cntMapBox.classList.toggle('d-none');
                    document.querySelector('html').classList.toggle('overflow-hidden');
                    iu_init_map($locations);
                } else {
                    $showMobMap.classList.remove('active');
                    $showMobMapTxt.textContent = 'Map View';
                    document.querySelector('.iu-posts-list .profolio-cards-row').classList.remove('active');
                    document.querySelector('.btn-mob-filter').classList.remove('d-none');
                    $cntMapBox.querySelector('.profolio-map-wrapper').classList.remove('active');
                    $cntMapBox.classList.add('d-none');
                    window.scrollTo(0, 0);
                }

            });
        }

        let scrollContainer = document.querySelector('.iu-posts-list .profolio-cards-row');
        if (scrollContainer) {
            scrollContainer.addEventListener('wheel', (evt) => {
                if (document.querySelector('.btn-mob-filter.active-map')) {
                    evt.preventDefault();
                    scrollContainer.scrollLeft += evt.deltaY;
                }
            });
        }

    }());
    //END Mob show map


});//DOMContentLoaded

//BEFORE FILTER.JS ▼
(function () {
    let $filterItem = [];

    document.addEventListener('DOMContentLoaded', function () {
        let $iuPosts = document.querySelector('#iu_posts_block');
        if (!$iuPosts) {
            return;
        }

        let $showMapFilters = $iuPosts.querySelector('#iu_filters_btn'),
            $mapFilters = $iuPosts.querySelector('.iu_filters-more');

        document.querySelector('body').addEventListener('click', function (evt) {
            if (evt.target !== $showMapFilters && evt.target.closest(
                    '.iu_filters-more') !== $mapFilters
                && $mapFilters.classList.contains('active')) {
                let $additionalFilterWrap = $iuPosts.querySelector(
                    '.iu_filters-block');

                $mapFilters.classList.remove('active');
                $additionalFilterWrap.classList.remove('active');
            }
        });

        if (typeof window['iu_filters_arg'] !== 'undefined' && window['iu_filters_arg'].length && !!$showMapFilters
            && !!$mapFilters) {
            $showMapFilters.addEventListener('click', (evt) => {
                $mapFilters.classList.toggle('active');

                if (!$mapFilters.classList.contains('iu-filters-filled')) {
                    let $container = document.createElement('div'),
                        $row = document.createElement('div'),
                        $cats = document.createElement('div'),
                        $tags = document.createElement('div'),
                        $catsTitle = document.createElement('b'),
                        $tagsTitle = document.createElement('b'),
                        $catsUl = document.createElement('ul'),
                        $tagsUl = document.createElement('ul'),
                        $postsBox = $iuPosts.querySelector('.profolio-cards-row') || $iuPosts.querySelector('.iu-grid') || $iuPosts.querySelector('.iu-projects-map-cnt'),
                        $btnBox = document.createElement('div'),
                        $postType = $iuPosts?.dataset.postType,
                        $perPage = $iuPosts?.dataset.perPage,
                        $template = $iuPosts?.dataset.template,
                        $parentId = $iuPosts?.dataset.parentId,
                        $filterObject = {
                            'parent_id': $parentId,
                            'post_type': $postType,
                            'template': $template ?? 'project-item',
                            'posts_per_page': $perPage,
                        };

                    $ajaxMapObject = {...$ajaxMapObject, ...$filterObject};

                    for (const $filter of window['iu_filters_arg']) {
                        let $li = document.createElement('li'),
                            $name = $filter['name'].replace('-', ' ');

                        $name = `${$name.charAt(0).toUpperCase()}${$name.slice(1)}`;
                        $filterItem.push($li);

                        $li.classList.add('filter-arg-item');
                        $li.setAttribute('data-term-id', $filter['term_id']);
                        $li.setAttribute('data-type', $filter['type']);
                        $li.textContent = $name;

                        if ($filter['type'] === 'iu_categories') {
                            $catsUl.insertAdjacentElement('beforeend', $li);
                        }

                        if ($filter['type'] === 'iu_tags') {
                            $tagsUl.insertAdjacentElement('beforeend', $li);
                        }
                        clickLi($li, $postsBox, $ajaxMapObject);
                    }

                    $container.classList.add('profolio-container');
                    $row.classList.add('profolio-row');

                    if ($catsUl.childNodes.length && !$tagsUl.childNodes.length) {
                        $cats.classList.add('profolio-col-12');
                    } else {
                        $cats.classList.add('profolio-col-6');
                    }

                    $cats.classList.add('iu-filter-arg');
                    $cats.classList.add('filter-arg-cats');

                    if ($tagsUl.childNodes.length && !$catsUl.childNodes.length) {
                        $tags.classList.add('profolio-col-12');
                    } else {
                        $tags.classList.add('profolio-col-6');
                    }

                    $tags.classList.add('iu-filter-arg');
                    $tags.classList.add('filter-arg-tags');
                    $btnBox.classList.add('d-flex');
                    $btnBox.classList.add('justify-content-end');
                    $btnBox.classList.add('iu-filters-btn-wrap');
                    $btnBox.classList.add('mb-4');

                    $cats.insertAdjacentElement('beforeend', $catsUl);
                    $tags.insertAdjacentElement('beforeend', $tagsUl);

                    $row.insertAdjacentElement('afterbegin', $tags);
                    $row.insertAdjacentElement('afterbegin', $cats);

                    $container.insertAdjacentElement('afterbegin', $row);
                    $mapFilters.insertAdjacentElement('afterbegin', $container);
                    $container.insertAdjacentElement('afterbegin', $btnBox);
                    $btnBox.insertAdjacentHTML('afterbegin',
                        '<button type="button" class="btn btn-outline-dark iu-filters-reset">Reset filters</button>',
                    );
                    $btnBox.insertAdjacentHTML('afterbegin',
                        '<button type="button" class="btn iu_filters-post-open">Status Open</button>',
                    );
                    $btnBox.insertAdjacentHTML('afterbegin',
                        '<button type="button" class="btn iu_filters-post-comp">Status Completed</button>',
                    );

                    if ($catsUl.childNodes.length) {
                        $catsTitle.textContent = 'Categories';
                        $cats.insertAdjacentElement('afterbegin', $catsTitle);
                    }
                    if ($tagsUl.childNodes.length) {
                        $tagsTitle.textContent = 'Tags';
                        $tags.insertAdjacentElement('afterbegin', $tagsTitle);
                    }

                    $mapFilters.classList.add('iu-filters-filled');

                    let $resetFilters = document.querySelector('.iu-filters-reset');
                    let $postOpen = document.querySelector('.iu_filters-post-open');
                    let $postComp = document.querySelector('.iu_filters-post-comp');

                    $resetFilters.addEventListener('click', function (evt) {
                        evt.preventDefault();

                        console.log($row, $row.classList.contains('active'));

                        $postComp.classList.remove('active');
                        $postOpen.classList.remove('active');

                        let $iuFilters = this.closest('.iu_filters-more'),
                            $filterItem = $iuFilters.querySelector(
                                '.filter-arg-item.active');

                        if ($row.classList.contains('active')) {
                            $row.classList.remove('active');

                            if ($filterItem) {
                                $filterItem.classList.remove('active');
                            }

                            delete $ajaxMapObject['meta_query'];
                            $ajaxMapObject['reset'] = true;

                            initAjax($postsBox, $ajaxMapObject, $template);
                        }
                    });

                    $postOpen.addEventListener('click', async function () {
                        $postComp.classList.remove('active');
                        $postOpen.classList.add('active');
                        $row.classList.add('active');

                        $ajaxMapObject['meta_query'] = 'open';
                        await initAjax($postsBox, $ajaxMapObject);
                    });

                    $postComp.addEventListener('click', async function () {
                        $postOpen.classList.remove('active');
                        $postComp.classList.add('active');
                        $row.classList.add('active');

                        $ajaxMapObject['meta_query'] = 'completed';
                        await initAjax($postsBox, $ajaxMapObject);
                    });
                }
            });
        } else {
            if ($mapFilters?.children.length) {
                $mapFilters.closest('.iu_block-filter').style.display = 'none';
                $showMapFilters.style.display = 'none';
            }
        }

    });//DOMContentLoaded

    const clickLi = (item, postsBox, dataObject) => {
        item.addEventListener('click', async () => {
            let $label,
                $checkedItem = true,
                $itemRow = item.closest('.profolio-row');

            if ($filterItem) {
                for (let $li of $filterItem) {

                    if ($li === item) {
                        if ($li.classList.contains('active')) {
                            item.classList.remove('active');
                        } else {
                            item.classList.add('active');
                        }
                    } else {
                        $li.classList.remove('active');
                    }

                    if ($li.classList.contains('active')) {
                        $checkedItem = false;
                    }

                }
            }

            if (item.dataset.type === 'iu_tags') {
                $label = 'tags';
                delete dataObject['categories'];
            }

            if (item.dataset.type === 'iu_categories') {
                $label = 'categories';
                delete dataObject['tags'];
            }

            if ($checkedItem) {
                $itemRow.classList.remove('active');
                delete dataObject[$label];
            } else {
                $itemRow.classList.add('active');

                dataObject[$label] = {
                    ids: Number(item.dataset.termId),
                    term_type: item.dataset.type,
                };
            }
            console.log(dataObject);
            await initAjax(postsBox, dataObject);
        });

    };//clickLi

    const initAjax = async (postsBox, dataObject) => {
        let $loaderImg = `<div class="rp-cart-loader"><img src="${instantup_object.plugin_url}/data/assets/img/ajax-loader.gif" /></div>`;
        postsBox.insertAdjacentHTML('afterbegin', $loaderImg);

        jQuery.ajax({
            type: 'POST',
            url: linkAjax,
            dataType: 'json',
            data: dataObject,
            success: function ($result) {
                let $pageCount = 2,
                    maxPages = $result['max_pages'] || 1,
                    $showingCount = postsBox.closest('.iu-posts-list').querySelector(
                        '.iu_realestate-count-sort strong:first-child'),
                    $totalItems = postsBox.closest('.iu-posts-list').querySelector(
                        '.iu_realestate-count-sort strong:last-child'),
                    $pageSlug = `/${postsBox.closest('#iu_posts_block').dataset.slug}/` ?? window.location.pathname,
                    $pagination = document.querySelector('.profolio-pagination nav'),
                    createUlNav = () => {
                        let $ul = document.createElement('ul');

                        $ul.classList.add('page-numbers');

                        return $ul;
                    },
                    createCurrent = () => {
                        let $li = document.createElement('li'),
                            $span = document.createElement('span');

                        $span.classList.add('page-numbers');
                        $span.classList.add('current');
                        $span.setAttribute('aria-current', 'page');
                        $span.textContent = '1';

                        $li.insertAdjacentElement('afterbegin', $span);

                        return $li;
                    },
                    createDots = () => {
                        let $li = document.createElement('li'),
                            $span = document.createElement('span');

                        $span.classList.add('page-numbers');
                        $span.classList.add('dots');
                        $span.textContent = '…';
                        $li.insertAdjacentElement('afterbegin', $span);

                        return $li;
                    },
                    createLink = () => {
                        let $li = document.createElement('li'),
                            $link = document.createElement('a'),
                            $href = `${window.location.origin}${$pageSlug}page/${$pageCount}/${window.location.search}`;

                        $link.classList.add('page-numbers');
                        $link.textContent = String($pageCount);
                        $link.setAttribute('href', $href);
                        $li.insertAdjacentElement('afterbegin', $link);

                        return $li;
                    },
                    $navUl = createUlNav();

                console.log($result, postsBox, $pageSlug);

                if ($showingCount && $totalItems) {
                    $showingCount.textContent = String($result?.count_post || '0');
                    $totalItems.textContent = String($result?.all_post ?? '0');
                }

                postsBox.innerHTML = '';
                postsBox.innerHTML = $result?.content ?? 'Your search did not match any posts';
                $pagination.textContent = '';

                if ($result['max_pages'] > 1) {
                    $pagination.insertAdjacentElement('afterbegin', $navUl);
                    $navUl.insertAdjacentElement('afterbegin', createCurrent());

                    for (let i = 1; i < maxPages; i++) {
                        if (maxPages > 5) {
                            createDots();
                        }

                        $navUl.insertAdjacentElement('beforeend', createLink());
                        $pageCount++;
                    }
                }

                if ($result['locations']) {
                    iu_init_map($result['locations']);
                    iu_map_fixed_map();
                }

                if (dataObject['template'] === 'masonry') {
                    new Masonry('.iu-grid', {
                        itemSelector: '.iu-grid-item',
                        columnWidth: 250,
                        gutter: 10,
                    });
                }
            },
            error: function (e) {
                console.log(e);
                console.log('Ajax error !!');
            },
        });
    };
//BEFORE FILTER.JS ▲

}());