<?php
/**
 * iu-posts.php
 * create in 13.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

wp_register_style( 'iu_posts_list', INSTANTUP_URL . 'data/assets/back-and-front/css/posts-list.css', array(), INSTANTUP_VERSION );

$type_output_arr      = array();
$select_fields        = $this->get_fields_for_block();
$content_type_default = '';

if ( $type_slug = get_option( '_iu_custom_type_posts' ) ) {
	foreach ( $type_slug as $item ) {
		if ( $item['slug'] === 'iu_project' ) {
			$content_type_default = 'iu_project';
		}
        elseif ( $item['slug'] === 'project' ) {
			$content_type_default = 'project';
		}

		$type_output_arr[ $item['slug'] ] = $item['name'];
	}
}

Block::make( __( 'IU Content Posts', 'instantup' ) )
     ->add_tab( __( 'Main settings', 'instantup' ), array(
	     Field::make( 'multiselect', 'iu_output_type', __( 'Choose a Content Type (default all content types)', 'instantup' ) )
	          ->set_default_value( [ $content_type_default ] )
	          ->set_options( $type_output_arr ),
	     Field::make( 'text', 'iu_posts_per_page', __( 'How many content items to show per page' ), 'instantup' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'Choose a number (default 26)',
	          ) ),
	     Field::make( 'separator', 'iu_main_separator', __( 'Settings' ) )->set_classes( 'iu-separator-margin' ),
	     Field::make( 'color', 'iu_background', 'Background block color item' )->set_palette( array(
			     '#FF0000',
			     '#00FF00',
			     '#0000FF',
		     ) ),
	     Field::make( 'color', 'iu_background_maine', 'Background main color' )
	          ->set_default_value( '#f5f5fa' )
	          ->set_palette( array( '#FF0000', '#00FF00', '#0000FF' ) ),
	     Field::make( 'select', 'iu_settings_columns', __( 'Columns' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->add_options( array(
		          '1' => 1,
		          '2' => 2,
		          '3' => 3,
		          '4' => 4,
	          ) )
	          ->set_default_value( '2' )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'template_posts',
			          'value'   => 'masonry',
			          'compare' => '!=',
		          ),
	          ) ),
	     Field::make( 'text', 'iu_settings_bdrs', __( 'Border Radius' ) )->set_width( 45 )->set_attributes( array(
			     'type' => 'number',
			     'min'  => '1',
			     'max'  => '100',
		     ) ),
	     Field::make( 'text', 'iu_settings_height', __( 'Items height' ) )->set_attributes( array(
			     'type' => 'number',
			     'min'  => '100',
		     ) ),
	     Field::make( 'text', 'iu_margin_top', __( 'Margin top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'placeholder' => '0',
		          'type'        => 'number',
		          'min'         => '0',
	          ) ),
	     Field::make( 'text', 'iu_margin_bottom', __( 'Margin bottom' ) )->set_width( 45 )->set_attributes( array(
			     'placeholder' => '0',
			     'type'        => 'number',
			     'min'         => '0',
		     ) ),

	     Field::make( 'select', 'template_posts', __( 'Choose Template' ) )->add_options( array(
			     'project-item' => __( 'Default Template' ),
			     'realestate'   => __( 'Real-estate Template' ),
			     'masonry'      => __( 'Masonry Template' ),
			     'album'        => __( 'Album Template' ),
		     ) )->set_default_value( 'project-item' ),

	     Field::make( 'separator', 'separator_realestate', __( 'Real-estate Fields' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          array(
			          'field'   => 'template_posts',
			          'value'   => 'realestate',
			          'compare' => '=',
		          ),
	          ) ),

	     Field::make( 'select', 'iu_set_price', __( 'Price' ) )->set_conditional_logic( array(
			     array(
				     'field'   => 'template_posts',
				     'value'   => 'realestate',
				     'compare' => '=',
			     ),
		     ) )->set_options( array(
			     '' => 'chouse fild',
		     ) )->add_options( $select_fields ),

	     Field::make( 'select', 'iu_set_item_title', __( 'Title' ) )->set_conditional_logic( array(
			     array(
				     'field'   => 'template_posts',
				     'value'   => 'realestate',
				     'compare' => '=',
			     ),
		     ) )->set_options( array(
			     '' => 'chouse fild',
		     ) )->add_options( $select_fields ),

	     Field::make( 'select', 'iu_set_beds', __( 'Bedrooms' ) )->set_conditional_logic( array(
			     array(
				     'field'   => 'template_posts',
				     'value'   => 'realestate',
				     'compare' => '=',
			     ),
		     ) )->set_options( array(
			     '' => 'chouse fild',
		     ) )->add_options( $select_fields ),

	     Field::make( 'select', 'iu_set_baths', __( 'Bathrooms' ) )->set_conditional_logic( array(
			     array(
				     'field'   => 'template_posts',
				     'value'   => 'realestate',
				     'compare' => '=',
			     ),
		     ) )->set_options( array(
			     '' => 'chouse fild',
		     ) )->add_options( $select_fields ),

	     Field::make( 'select', 'iu_set_sqft', __( 'SquareFeet' ) )->set_conditional_logic( array(
			     array(
				     'field'   => 'template_posts',
				     'value'   => 'realestate',
				     'compare' => '=',
			     ),
		     ) )->set_options( array(
			     '' => 'chouse fild',
		     ) )->add_options( $select_fields ),
     ) )
     ->add_tab( __( 'Priority' ), array(
	     Field::make( 'separator', 'separator_priority', __( 'Featured Status' ) )
	          ->set_classes( 'iu-separator-margin' ),
	     Field::make( 'checkbox', 'use_priority', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Featured (on/off )' )
	          ->set_default_value( true )
	          ->set_option_value( true ),
     ) )
     ->add_tab( __( 'Filters' ), array(
	     Field::make( 'checkbox', 'use_filters', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Filters? (No/Yes )' )
	          ->set_default_value( false )
	          ->set_option_value( true ),

	     Field::make( 'select', 'filter_template', __( 'Choose Template' ) )
	          ->set_default_value( 'simple' )
	          ->set_options( array(
		          'simple' => 'Simple (button in top)',
		          'aside'  => 'Full View in Aside',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'mob_btn_bottom_pos', __( 'Mobile button bottom position' ) )->set_attributes( array(
			     'type'        => 'number',
			     'min'         => '0',
			     'placeholder' => '0',
		     ) )->set_conditional_logic( array(
			     array(
				     'field' => 'use_filters',
				     'value' => true,
			     ),
			     array(
				     'field' => 'filter_template',
				     'value' => 'aside',
			     ),
		     ) ),
	     Field::make( 'color', 'active_color', __( 'Color' ) )
	          ->set_default_value( '#82d7f7' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),

	     //Count Posts
	     Field::make( 'separator', 'separator_count', __( 'Count Posts' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_filter_count', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Show Count Posts? (No/Yes )' )
	          ->set_default_value( true )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),

	     //Map block
	     Field::make( 'separator', 'separator_map', __( 'Map Box' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_map_block', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Map Box? (No/Yes )' )
	          ->set_default_value( false )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field'   => 'filter_template',
			          'value'   => 'aside',
			          'compare' => '=',
		          ),
	          ) ),

	     //Location
	     Field::make( 'separator', 'separator_location', __( 'Location' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_filter_location', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Location? (No/Yes )' )
	          ->set_default_value( false )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'location_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_filter_location',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'location_height', __( 'Line Height (px)' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => 'default 39',
		     ) )->set_conditional_logic( array(
			     array(
				     'field' => 'use_filters',
				     'value' => true,
			     ),
			     array(
				     'field' => 'use_filter_location',
				     'value' => true,
			     ),
		     ) ),
	     Field::make( 'color', 'location_color', __( 'Location Color' ) )
	          ->set_default_value( '#50505a' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_filter_location',
			          'value' => true,
		          ),
	          ) ),

	     //Radius
	     Field::make( 'separator', 'separator_radius', __( 'Radius' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_filter_radius', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Radius? (No/Yes )' )
	          ->set_default_value( false )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),
	     Field::make( 'text', 'radius_font_size', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_filter_radius',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'radius_line_height', __( 'Line Height (px)' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => 'default 39',
		     ) )->set_conditional_logic( array(
			     array(
				     'field' => 'use_filters',
				     'value' => true,
			     ),
			     array(
				     'field' => 'use_filter_radius',
				     'value' => true,
			     ),
		     ) ),
	     Field::make( 'color', 'radius_title_color', __( 'Title Color' ) )
	          ->set_default_value( '#50505a' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_filter_radius',
			          'value' => true,
		          ),
	          ) ),

	     //Category in filter
	     Field::make( 'separator', 'separator_cat', __( 'Categories' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_category', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Category? (No/Yes )' )
	          ->set_default_value( true )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),

	     //Labels / Tags
	     Field::make( 'separator', 'separator_tags', __( 'Labels / Tags' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_tags_block', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Labels / Tags? (No/Yes )' )
	          ->set_default_value( false )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'aside',
		          ),
	          ) ),

	     //Price
	     Field::make( 'separator', 'separator_price', __( 'Price' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'template_posts',
			          'value' => 'realestate',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_filter_price', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Price? (No/Yes )' )
	          ->set_default_value( true )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'template_posts',
			          'value' => 'realestate',
		          ),
	          ) ),

	     //Sort
	     Field::make( 'separator', 'separator_sort', __( 'Sort' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'template_posts',
			          'value' => 'realestate',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_filter_sort', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Sorts? (No/Yes )' )
	          ->set_default_value( true )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'template_posts',
			          'value' => 'realestate',
		          ),
	          ) ),

	     //Style btn status
	     Field::make( 'separator', 'separator_btn_status', __( 'Style Buttons Status' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field'   => 'filter_template',
			          'value'   => 'simple',
			          'compare' => '=',
		          ),
	          ) ),
	     Field::make( 'checkbox', 'use_style_btn_status', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use Style Button? (No/Yes )' )
	          ->set_default_value( false )
	          ->set_option_value( true )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'filter_template',
			          'value' => 'simple',
		          ),
	          ) ),

	     Field::make( 'separator', 'separator_btn_compl_status', __( 'Completed Button' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'color', 'style_compl_color', __( 'Color' ) )
	          ->set_default_value( '#212529' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'color', 'style_compl_bgc', __( 'Background' ) )
	          ->set_default_value( '#61BD4F' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'separator', 'separator_btn_open_status', __( 'Status Open Button' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'color', 'style_open_color', __( 'Color' ) )
	          ->set_default_value( '#212529' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'color', 'style_open_bgc', __( 'Background' ) )
	          ->set_default_value( '#0079BF' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'separator', 'separator_btn_reset_status', __( 'Reset Button' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'color', 'style_reset_color', __( 'Color' ) )
	          ->set_default_value( '#ffffff' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'color', 'style_reset_bgc', __( 'Background' ) )
	          ->set_default_value( '#343a40' )
	          ->set_conditional_logic( array(
		          'relation' => 'AND',
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
		          array(
			          'field' => 'use_style_btn_status',
			          'value' => true,
		          ),
	          ) ),

	     //Add Fields for Filters
	     Field::make( 'separator', 'separator_custon_filter', __( 'Add Fields for Filters' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'complex', 'iu_custom_filter', '' )
	          ->set_classes( 'iu-custom-fields iu-add-filter' )
	          ->setup_labels( array(
		          'plural_name'   => 'Fields',
		          'singular_name' => 'Field',
	          ) )
	          ->add_fields( array(
		          Field::make( 'text', 'iu_filter_legend', __( 'Block Title' ) ),

		          Field::make( 'complex', 'iu_filter_item', '' )
		               ->set_classes( 'iu-custom-fields iu-add-filter' )
		               ->setup_labels( array(
			               'plural_name'   => 'Filters',
			               'singular_name' => 'Filter',
		               ) )
		               ->add_fields( array(
			               Field::make( 'text', 'iu_filter_name', __( 'Name' ) ),

			               Field::make( 'select', 'iu_filter_value', __( 'Value' ) )->add_options( $select_fields ),
		               ) ),
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'use_filters',
			          'value' => true,
		          ),
	          ) ),

     ) )
     ->add_tab( __( 'Post Title' ), array(
	     Field::make( 'checkbox', 'iu_show_post_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Title post (show/hide)' )
	          ->set_default_value( true )
	          ->set_option_value( true ),
	     Field::make( 'color', 'iu_post_title_color', __( 'Color' ) )->set_conditional_logic( array(
			     array(
				     'field' => 'iu_show_post_title',
				     'value' => true,
			     ),
		     ) ),

	     Field::make( 'text', 'iu_post_title_size', __( 'Font Size (px)' ) )
	          ->set_default_value( '14' )
	          ->set_attribute( 'type', 'number' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'text', 'iu_post_title_top', __( 'Padding top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'iu_post_title_right', __( 'Padding right' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) )->set_conditional_logic( array(
			     array(
				     'field' => 'iu_show_post_title',
				     'value' => true,
			     ),
		     ) ),
	     Field::make( 'text', 'iu_post_title_bottom', __( 'Padding Bottom' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
	          ) ),
	     Field::make( 'text', 'iu_post_title_left', __( 'Padding left' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) )->set_conditional_logic( array(
			     array(
				     'field' => 'iu_show_post_title',
				     'value' => true,
			     ),
		     ) ),

	     Field::make( 'checkbox', 'iu_post_title_blur_use', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox iu-separator-margin' )
	          ->set_help_text( 'Blur background? (yes/no)' )
	          ->set_default_value( false )
	          ->set_option_value( true ),

	     Field::make( 'text', 'iu_post_title_blur_intensity', __( 'Intensity blur' ) )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'max'         => '10',
		          'placeholder' => '10',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_post_title',
			          'value' => true,
		          ),
		          array(
			          'field' => 'iu_post_title_blur_use',
			          'value' => true,
		          ),
	          ) ),

     ) )
     ->add_tab( __( 'Picture' ), array(
	     Field::make( 'checkbox', 'iu_pic_show', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Picture (show/hide)' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'image', 'iu_pic_set_image', __( 'Placeholder image' ) ),

	     Field::make( 'text', 'iu_pic_set_height', __( 'Image Height' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_default_value( '100' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'min'         => '0',
		          'max'         => '100',
		          'placeholder' => 'example 50',
	          ) ),

	     Field::make( 'select', 'iu_pic_set_size', __( 'Image Size' ) )
	          ->set_width( 45 )
	          ->set_default_value( 'large' )
	          ->add_options( array(
		          'thumbnail' => __( 'Thumbnail' ),
		          'medium'    => __( 'Small' ),
		          'iu-medium' => __( 'Medium' ),
		          'large'     => __( 'Large' ),
		          'full'      => __( 'Full Size' ),
	          ) ),

     ) )
     ->add_tab( __( 'Location' ), array(
	     Field::make( 'checkbox', 'iu_show_loc_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Location (show/hide)' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),
	     Field::make( 'color', 'iu_loc_color', __( 'Color' ) ),
	     Field::make( 'radio', 'iu_location_option', __( 'Location Display Options' ) )
	          ->set_classes( 'iu-radio-option' )
	          ->set_default_value( 'generalized' )
	          ->add_options( array(
		          'exact'       => 'Exact',
		          'generalized' => 'Generalized',
	          ) ),
	     Field::make( 'select', 'iu_loc_font', __( 'Font' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          'roboto'         => 'Roboto',
		          'pt+sans+narrow' => 'PT Sans Narrow',
		          'open+sans'      => 'Open Sans',
		          'noto+sans'      => 'Noto Sans',
	          ) ),
	     Field::make( 'text', 'iu_loc_size', __( 'Text Size' ) )
	          ->set_width( 45 )
	          ->set_default_value( '11' )
	          ->set_attribute( 'type', 'number' ),

	     Field::make( 'text', 'iu_loc_top', __( 'Margin top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'text', 'iu_loc_right', __( 'Margin right' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) ),
	     Field::make( 'text', 'iu_loc_bottom', __( 'Margin Bottom' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'text', 'iu_loc_left', __( 'Margin left' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) ),
     ) )
     ->add_tab( __( 'Category' ), array(
	     Field::make( 'checkbox', 'iu_show_cat', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Category (show/hide)' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' ),
	     Field::make( 'color', 'iu_cat_color', __( 'Background Color' ) ),

	     Field::make( 'color', 'iu_cat_text_color', __( 'Text Color' ) ),

	     Field::make( 'text', 'iu_cat_bdrs', __( 'Border radius' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'select', 'iu_cat_font', __( 'Choose Fonts' ) )->set_width( 45 )->set_options( array(
			     'roboto'         => 'Roboto',
			     'pt+sans+narrow' => 'PT Sans Narrow',
			     'open+sans'      => 'Open Sans',
			     'noto+sans'      => 'Noto Sans',
		     ) ),
	     Field::make( 'select', 'iu_cat_weight', __( 'Text Weight' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          '400' => 'regular',
		          '300' => 'Light',
		          '500' => 'Medium',
		          '700' => 'bold',
	          ) ),

	     Field::make( 'text', 'iu_cat_size', __( 'Text Size' ) )
	          ->set_width( 45 )
	          ->set_default_value( '14' )
	          ->set_attribute( 'type', 'number' ),

	     Field::make( 'text', 'iu_cat_top', __( 'Margin top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'text', 'iu_cat_right', __( 'Margin right' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) ),
	     Field::make( 'text', 'iu_cat_bottom', __( 'Margin Bottom' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'text', 'iu_cat_left', __( 'Margin left' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) ),

	     Field::make( 'text', 'iu_cat_p_top', __( 'Padding top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'text', 'iu_cat_p_right', __( 'Padding right' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) ),
	     Field::make( 'text', 'iu_cat_p_bottom', __( 'Padding Bottom' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '10',
	          ) ),
	     Field::make( 'text', 'iu_cat_p_left', __( 'Padding left' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '10',
		     ) ),
     ) )
     ->add_tab( __( 'Pagination' ), array(
	     Field::make( 'color', 'iu_nav_bgc_current', __( 'Background Current Item' ) ),
	     Field::make( 'color', 'iu_nav_color_current', __( 'Color Current Item' ) ),

	     Field::make( 'color', 'iu_nav_bgc_all', __( 'Background Item' ) ),
	     Field::make( 'color', 'iu_nav_color_all', __( 'Color Item' ) ),

	     Field::make( 'color', 'iu_nav_bgc_all_hover', __( 'Background Hover' ) ),
	     Field::make( 'color', 'iu_nav_color_all_hover', __( 'Color Hover' ) ),

	     Field::make( 'text', 'iu_nav_width', __( 'Width Item' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '36',
	          ) ),
	     Field::make( 'text', 'iu_nav_height', __( 'Height Item' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '40',
		     ) ),

	     Field::make( 'text', 'iu_nav_size_current', __( 'Text Current Size' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '12',
	          ) ),
	     Field::make( 'text', 'iu_nav_size_all', __( 'Text Size' ) )->set_width( 45 )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '12',
		     ) ),

	     Field::make( 'select', 'iu_nav_weight_current', __( 'Text Current Weight' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          '400' => 'regular',
		          '300' => 'Light',
		          '500' => 'Medium',
		          '700' => 'bold',
	          ) ),
	     Field::make( 'select', 'iu_nav_weight_all', __( 'Text Weight' ) )->set_width( 45 )->set_options( array(
			     '400' => 'regular',
			     '300' => 'Light',
			     '500' => 'Medium',
			     '700' => 'bold',
		     ) ),

	     Field::make( 'text', 'iu_nav_bdrs_current', __( 'Border Current Radius' ) )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '3',
		     ) ),
	     Field::make( 'text', 'iu_nav_bdrs_all', __( 'Border radius' ) )->set_attributes( array(
			     'type'        => 'number',
			     'placeholder' => '3',
		     ) ),

	     Field::make( 'text', 'iu_nav_top', __( 'Margin top' ) )
	          ->set_width( 45 )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attribute( 'type', 'number' ),
	     Field::make( 'text', 'iu_nav_bottom', __( 'Margin Bottom' ) )
	          ->set_width( 45 )
	          ->set_attribute( 'type', 'number' ),
     ) )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_mode( 'preview' )
     ->set_editor_style( 'iu_posts_list' )
     ->set_style( 'iu_posts_list' )
     ->set_render_callback( function( $fields ) {
	     $template_name  = $fields['template_posts'] ?: 'project-item';
	     $parent_post_id = get_the_ID();
	     $get_font       = '';
	     $class_posts    = 'profolio-cards-row';

	     if ( $fields['select_fonts'] ) {
		     $get_font = explode( ':', $fields['select_fonts'] );
	     }

	     if ( $fields['use_filters'] ) {
		     $transient_name = $this->get_type_prefix() . '_filters_arg_' . get_the_ID();
		     delete_transient( $transient_name );

		     if ( ! $filters_arr = get_transient( $transient_name ) ) {
			     $taxonomy      = array(
				     $this->prefix_t() . '_tags',
				     $this->prefix_t() . '_categories',
			     );
			     $ids_posts     = new WP_Query( array(
				     'fields'         => 'ids',
				     'post_type'      => $this->get_postype_block( get_the_ID() ),
				     'posts_per_page' => 1000,
				     'post_status'    => array( 'publish' ),
				     'no_found_rows'  => true,
			     ) );
			     $product_terms = wp_get_object_terms( $ids_posts->posts, $taxonomy );

			     if ( $ids_posts->have_posts() && $product_terms && ! is_wp_error( $product_terms ) ) {
				     foreach ( $product_terms as $product_term ) {
					     $filters_arr[] = array(
						     'term_id' => $product_term->term_id,
						     'name'    => sanitize_text_field( $product_term->slug ),
						     'type'    => $product_term->taxonomy,
					     );
				     }
			     }

			     if ( isset( $filters_arr ) && ! empty( $filters_arr ) ) {
				     set_transient( $transient_name, $filters_arr, DAY_IN_SECONDS );
			     }
		     }
	     }

	     if ( $fields['iu_settings_columns'] ) {
		     update_post_meta( $parent_post_id, 'iu_settings_columns', $fields['iu_settings_columns'] );
	     }
	     if ( $fields['iu_pic_show'] ) {
		     update_post_meta( $parent_post_id, 'iu_pic_show', $fields['iu_pic_show'] );
	     }
	     if ( $fields['iu_pic_set_size'] ) {
		     update_post_meta( $parent_post_id, 'iu_pic_set_size', $fields['iu_pic_set_size'] );
	     }
	     if ( $fields['iu_pic_set_image'] ) {
		     update_post_meta( $parent_post_id, 'iu_pic_set_image', $fields['iu_pic_set_image'] );
	     }
	     if ( $fields['iu_show_post_title'] ) {
		     update_post_meta( $parent_post_id, 'iu_show_post_title', $fields['iu_show_post_title'] );
	     }
	     if ( $fields['iu_show_loc_title'] ) {
		     update_post_meta( $parent_post_id, 'iu_show_loc_title', $fields['iu_show_loc_title'] );
	     }
	     if ( $fields['iu_location_option'] ) {
		     update_post_meta( $parent_post_id, 'iu_location_option', $fields['iu_location_option'] );
	     }
	     if ( $fields['iu_show_cat'] ) {
		     update_post_meta( $parent_post_id, 'iu_show_cat', $fields['iu_show_cat'] );
	     }
	     if ( $fields['iu_set_price'] ) {
		     update_post_meta( $parent_post_id, 'iu_set_price', $fields['iu_set_price'] );
	     }
	     if ( $fields['iu_set_item_title'] ) {
		     update_post_meta( $parent_post_id, 'iu_set_item_title', $fields['iu_set_item_title'] );
	     }
	     if ( $fields['iu_set_beds'] ) {
		     update_post_meta( $parent_post_id, 'iu_set_beds', $fields['iu_set_beds'] );
	     }
	     if ( $fields['iu_set_baths'] ) {
		     update_post_meta( $parent_post_id, 'iu_set_baths', $fields['iu_set_baths'] );
	     }
	     if ( $fields['iu_set_sqft'] ) {
		     update_post_meta( $parent_post_id, 'iu_set_sqft', $fields['iu_set_sqft'] );
	     }

	     if ( empty( $fields['iu_output_type'] ) && ! empty( get_option( '_iu_custom_type_slug' ) ) ) {
		     $post_type = get_option( '_iu_custom_type_slug' );

		     $temp_post_type = array_flip( $post_type );
		     if ( isset( $temp_post_type['iu_ai_writeups'] ) ) {
			     unset( $post_type[ $temp_post_type['iu_ai_writeups'] ] );
		     }
	     }
	     else {
		     $post_type = $fields['iu_output_type'] ?? 'post';
	     }

	     $query_arr = array(
		     'post_type'      => $post_type,
		     'posts_per_page' => $fields['iu_posts_per_page'] ?: 26,
		     'post_status'    => array( 'publish' ),
		     'paged'          => get_query_var( 'paged' ) ?: 1,
		     'orderby'        => array(
			     //                     "{$prefix}updateDate" => 'DESC',
			     //                     'meta_value' => 'DESC',
			     'modified' => 'DESC',
		     ),
		     'meta_query'     => array(
			     array(
				     'key'     => '_thumbnail_id',
				     'compare' => 'EXISTS',
			     ),
		     ),
	     );

	     if ( $fields['use_priority'] ) {
		     $query_arr['meta_query'][] = array(
			     array(
				     'relation' => 'OR',
				     array(
					     'key'     => $this->prefix() . 'status_featured',
					     'compare' => 'NOT EXISTS',
				     ),
				     array(
					     'key'     => $this->prefix() . 'status_featured',
					     'compare' => 'EXISTS',
				     ),
			     ),
		     );
	     }

	     if ( $template_name === 'realestate' ) {
		     global $wpdb;

		     $meta_key     = $this->prefix() . 'price';
		     $iu_sql_query = "SELECT MIN(cast(meta_value as DECIMAL(9))) as minPrice, MAX(cast(meta_value as DECIMAL(9))) as maxPrice FROM $wpdb->postmeta WHERE `meta_key` = '$meta_key'";
		     $all_price    = $wpdb->get_results( $iu_sql_query, ARRAY_A );

		     $min_price = (int) $all_price[0]['minPrice'];
		     $max_price = (int) $all_price[0]['maxPrice'];

		     $parent_post_id = get_the_ID();

		     if ( ! empty( $_GET['lat'] ) && ! empty( $_GET['lng'] ) ) {
			     global $wpdb;

			     $lat = sanitize_text_field( $_GET['lat'] );
			     $lng = sanitize_text_field( $_GET['lng'] );

			     $radius = isset( $_GET['radius'] ) ? sanitize_text_field( (int) $_GET['radius'] ) : 100;

			     $cache_key = 'instantup_filter_ids_' . md5( $lat . $lng . $radius );

			     $posts_in = wp_cache_get( $cache_key );

			     if ( false === $posts_in ) {
				     $sql = $wpdb->prepare( "
                    SELECT pm1.post_id, (3959 *acos(cos(radians('%s'))*cos(radians(pm1.meta_value))*cos(radians(pm2.meta_value)-radians('%s'))+sin(radians('%s'))*sin(radians(pm1.meta_value)))) AS distance
                    FROM {$wpdb->postmeta} AS pm1
                    INNER JOIN {$wpdb->postmeta} AS pm2 ON pm1.post_id = pm2.post_id
                    WHERE pm1.meta_key = %s AND pm2.meta_key = %s
                    HAVING distance < %d
                    ORDER BY distance
                    LIMIT 0, 1000;
                ", $lat, $lng, $lat, 'iu-latitude', 'iu-longitude', $radius );

				     $posts_in = $wpdb->get_col( $sql ) ? $wpdb->get_col( $sql ) : array( 0 );
				     wp_cache_set( $cache_key, $posts_in );
			     }
		     }

		     if ( ! empty( $posts_in ) ) {
			     $query_arr['post__in'] = $posts_in;
		     }

		     if ( isset( $_GET['sort'] ) && ! empty( $_GET['sort'] ) ) {
			     $sort_key = sanitize_text_field( $_GET['sort'] );

			     $query_arr['order']   = 'ASC';
			     $query_arr['orderby'] = 'meta_value_num';

			     $query_arr['meta_query'] = array(
				     array(
					     'relation' => 'OR',
					     array(
						     'key'     => $sort_key,
						     'compare' => 'NOT EXISTS',
					     ),
					     array(
						     'key'     => $sort_key,
						     'compare' => 'EXISTS',
					     ),
				     ),
			     );
		     }

		     if ( ! empty( $_GET['min_price'] ) && empty( $_GET['max_price'] ) ) {
			     $query_arr['meta_query'][] = array(
				     'key'     => $this->prefix() . 'price',
				     'value'   => (int) sanitize_text_field( $_GET['min_price'] ),
				     'type'    => 'numeric',
				     'compare' => '>=',
			     );
		     }

		     if ( empty( $_GET['min_price'] ) && ! empty( $_GET['max_price'] ) ) {
			     $query_arr['meta_query'][] = array(
				     'key'     => $this->prefix() . 'price',
				     'value'   => (int) sanitize_text_field( $_GET['max_price'] ),
				     'type'    => 'numeric',
				     'compare' => '<=',
			     );
		     }

		     if ( ! empty( $_GET['min_price'] ) && ! empty( $_GET['max_price'] ) ) {
			     $query_arr['meta_query'][] = array(
				     'key'     => $this->prefix() . 'price',
				     'value'   => array(
					     (int) sanitize_text_field( $_GET['min_price'] ),
					     (int) sanitize_text_field( $_GET['max_price'] ),
				     ),
				     'type'    => 'numeric',
				     'compare' => 'BETWEEN',
			     );
		     }

		     if ( isset( $_GET['filters'] ) && ! empty( $_GET['filters'] ) ) {
			     parse_str( $_GET['filters'], $filters );
			     $query_filters = array( 'relation' => 'OR' );

			     foreach ( $filters as $key => $item ) {
				     $key = explode( '_', $key )[0];

				     $query_filters[] = array(
					     'key'     => $key,
					     'value'   => array( ucfirst( $item ), lcfirst( $item ) ),
					     'compare' => 'IN',
				     );
			     }

			     $query_arr['meta_query'][] = $query_filters;
		     }

		     if ( $fields['iu_set_price'] ) {
			     update_post_meta( $parent_post_id, 'iu_set_price', $fields['iu_set_price'] );
		     }
		     if ( $fields['iu_set_item_title'] ) {
			     update_post_meta( $parent_post_id, 'iu_set_item_title', $fields['iu_set_item_title'] );
		     }
		     if ( $fields['iu_set_beds'] ) {
			     update_post_meta( $parent_post_id, 'iu_set_beds', $fields['iu_set_beds'] );
		     }
		     if ( $fields['iu_set_baths'] ) {
			     update_post_meta( $parent_post_id, 'iu_set_baths', $fields['iu_set_baths'] );
		     }
		     if ( $fields['iu_set_sqft'] ) {
			     update_post_meta( $parent_post_id, 'iu_set_sqft', $fields['iu_set_sqft'] );
		     }
	     }
         elseif ( $template_name === 'masonry' ) {
		     $class_posts = 'iu-grid';
	     }
         elseif ( $template_name === 'album' ) {
		     $class_posts = 'profolio-cards-row iu-album-temp';
	     }

	     $query = new WP_Query( $query_arr );
	     $posts = $query->posts;

	     update_post_meta( $parent_post_id, 'iu_filter_template', $fields['filter_template'] );
	     ?>

       <style>
         <?php
		 //Start For filters
		  if ($get_font){
			 echo '.iu_location-filter-row input[type="text"].iu_location-filter, .iu_radius-filter-row .iu_radius-filter_output{';
			 echo $get_font ? "font-family: {$get_font[0]}, Sans-serif !important;" : '';
			 echo "}";
		 }

		 if ($fields['location_fonts'] || $fields['location_font_size'] || $fields['location_line_height']){
			 echo '.iu_location-filter-row{';
			 echo $fields['location_title_color'] ? "color: {$fields['location_title_color']};" : '';
			 echo $fields['location_font_size'] ? "font-size: {$fields['location_font_size']}px;" : '';
			 echo $fields['location_line_height'] ? "line-height: {$fields['location_line_height']}px;" : '';
			 echo "}";
		 }
		 //End For filters


		 if($fields['iu_nav_top'] || $fields['iu_nav_bottom']){
			 echo '.profolio-pagination {';
			 if ($fields['iu_nav_top']){
				 echo "margin-top: {$fields['iu_nav_top']}px;";
			 }
			 if ($fields['iu_nav_bottom']){
				 echo "margin-bottom: {$fields['iu_nav_bottom']}px;";
			 }
			 echo '}';
		 }


		 echo '.iu-posts-list {';
		 if ( $fields['iu_background_maine'] ) {
			echo "background-color: {$fields['iu_background_maine']} !important;";
		 }
		echo '}';


		 if ( $fields['iu_settings_bdrs'] >= '0' ){
			 echo '.profolio-project-card, .iu_realestate-item {';
			 echo "border-radius: {$fields['iu_settings_bdrs']}px;";
			 echo '}';

			 echo '.profolio-project-card .profolio-card-cover img {';
			 echo "border-top-left-radius: {$fields['iu_settings_bdrs']}px;";
			 echo "border-top-right-radius: {$fields['iu_settings_bdrs']}px;";
			 echo '}';

			 echo '.iu_realestate-listing {';
			 echo "border-bottom-right-radius: {$fields['iu_settings_bdrs']}px;";
			 echo "border-bottom-left-radius: {$fields['iu_settings_bdrs']}px;";
			 echo '}';

			 echo '.iu-album-temp .card {';
			 echo "border-radius: {$fields['iu_settings_bdrs']}px;";
			 echo '}';

			 echo '.iu-album-temp .card img, .iu-album-temp .card .card-img-top {';
			 echo "border-top-left-radius: {$fields['iu_settings_bdrs']}px;";
			 echo "border-top-right-radius: {$fields['iu_settings_bdrs']}px;";
			 echo '}';
		 }

		 if (is_numeric($fields['iu_settings_height'])){
			echo '.iu_realestate-item {';
			echo "height: {$fields['iu_settings_height']}px !important;";
			echo '}';

		 }


		 if (is_numeric($fields['iu_post_title_left']) || is_numeric($fields['iu_post_title_left']) ||
		 is_numeric($fields['iu_post_title_right']) || is_numeric($fields['iu_post_title_bottom']) ){
			 echo '.iu_realestate-listing {';
			 if (is_numeric($fields['iu_post_title_left'])){
				echo "padding-left: {$fields['iu_post_title_left']}px;";
			 }
			 if (is_numeric($fields['iu_post_title_right'])){
				echo "padding-right: {$fields['iu_post_title_right']}px;";
			 }
			 if (is_numeric($fields['iu_post_title_top'])){
				echo "padding-top: {$fields['iu_post_title_top']}px;";
			 }
			 if (is_numeric($fields['iu_post_title_bottom'])){
				echo "padding-bottom: {$fields['iu_post_title_bottom']}px;";
			 }
			 if ($fields['iu_post_title_blur_use']){
				 $blur = $fields['iu_post_title_blur_intensity'] ?: '10';
				echo "backdrop-filter: blur({$blur}px);";
			 }
			 echo '}';
		 }

		 if ($fields['iu_background']){
			echo '.JS_profolio_project_item .profolio-project-card {';
			 echo "background-color: {$fields['iu_background']} !important;";
			echo '}';
		 }

		 if ($fields['iu_post_title_color'] || $fields['iu_block_title_size'] ||$fields['iu_block_title_weight'] ||
			   $fields['iu_block_title_top'] || $fields['iu_block_title_right'] ||$fields['iu_block_title_bottom'] ||
			   $fields['iu_block_title_left']){
			echo '.profolio-card-descr .profolio-header-xs, .profolio-map-pop .profolio-header-xxs {';

			 if ($fields['iu_post_title_color']){
				echo "color: {$fields['iu_post_title_color']} !important;";
			 }

			 if ($fields['iu_block_title_size']){
				echo "font-size: {$fields['iu_block_title_size']}px;";
			 }

			 if ($fields['iu_block_title_weight']){
				echo "font-weight: {$fields['iu_block_title_weight']};";
			 }

			 if ($fields['iu_block_title_top']){
				echo "margin-top: {$fields['iu_block_title_top']}px;";
			 }

			 if ($fields['iu_block_title_right']){
				echo "margin-right: {$fields['iu_block_title_right']}px;";
			 }

			 if ($fields['iu_block_title_bottom']){
				echo "margin-bottom: {$fields['iu_block_title_bottom']}px;";
			 }

			 if ($fields['iu_block_title_left']){
				echo "margin-left: {$fields['iu_block_title_left']}px;";
			 }
			echo '}';
		 }


		 if ($fields['iu_pic_set_height']){
			echo '.profolio-project-card .profolio-card-image-frame .profolio-card-cover img {';
			echo "height: {$fields['iu_pic_set_height']}% !important;";
			echo '}';
		 }


		 if ($fields['iu_loc_color'] || $fields['iu_loc_size'] || $fields['iu_loc_top'] ||
		  $fields['iu_loc_right'] || $fields['iu_loc_bottom'] || $fields['iu_loc_left']){
			echo '.JS_profolio_project_item .profolio-card-descr .profolio-text-sm {';
			if ($fields['iu_loc_color']){
				echo "color: {$fields['iu_loc_color']} !important;";
			}

			if ($fields['iu_loc_size']){
				echo "font-size: {$fields['iu_loc_size']}px !important;";
			}

			if ($fields['iu_loc_top']){
				echo "margin-top: {$fields['iu_loc_top']}px;";
			}

			if ($fields['iu_loc_right']){
				echo "margin-right: {$fields['iu_loc_right']}px;";
			}

			if ($fields['iu_loc_bottom']){
				echo "margin-bottom: {$fields['iu_loc_bottom']}px;";
			}

			if ($fields['iu_loc_left']){
				echo "margin-left: {$fields['iu_loc_left']}px;";
			}
			echo '}';
		 }

		 if ($fields['iu_cat_text_color'] || $fields['iu_cat_color'] || $fields['iu_cat_size'] ||
		 $fields['iu_cat_weight'] || $fields['iu_cat_top'] || $fields['iu_cat_right']  ||
		 $fields['iu_cat_bottom'] || $fields['iu_cat_left'] || $fields['iu_cat_p_top'] ||
		 $fields['iu_cat_p_right'] || $fields['iu_cat_p_bottom'] || $fields['iu_cat_p_left'] || $fields['iu_cat_bdrs'] ){
			 echo '.JS_profolio_project_item .profolio-card-category-frame a {';
			 if ($fields['iu_cat_text_color']){
				echo "color: {$fields['iu_cat_text_color']} !important;";
			 }

			 if ($fields['iu_cat_color']){
				 echo "background-color: {$fields['iu_cat_color']} !important;";
			 }

			 if ($fields['iu_cat_size']){
				 echo "font-size: {$fields['iu_cat_size']}px !important;";
			 }

			 if ($fields['iu_cat_weight']){
			  echo "font-weight: {$fields['iu_cat_weight']} !important;";
			 }

			 if ($fields['iu_cat_top']){
				 echo "margin-top: {$fields['iu_cat_top']}px;";
			 }

			 if ($fields['iu_cat_right']){
				echo "margin-right: {$fields['iu_cat_right']}px;";
			 }

			 if ($fields['iu_cat_bottom']){
				echo "margin-bottom: {$fields['iu_cat_bottom']}px;";
			 }

			 if ($fields['iu_cat_left']){
				echo "margin-left: {$fields['iu_cat_left']}px;";
			 }

			 if ($fields['iu_cat_p_top']){
				echo "padding-top: {$fields['iu_cat_p_top']}px;";
			 }

			 if ($fields['iu_cat_p_right']){
				echo "padding-right: {$fields['iu_cat_p_right']}px;";
			 }

			 if ($fields['iu_cat_p_bottom']){
				echo "padding-bottom: {$fields['iu_cat_p_bottom']}px;";
			 }

			 if ($fields['iu_cat_p_left']){
				echo "padding-left: {$fields['iu_cat_p_left']}px;";
			 }

			 if ($fields['iu_cat_bdrs']){
				echo "border-radius: {$fields['iu_cat_bdrs']}px;";
			 }
			 echo '}';
		 }


		 if ($fields['iu_nav_width'] || $fields['iu_nav_height'] ||
		  $fields['iu_nav_bgc_all'] || $fields['iu_nav_color_all'] ||
		  $fields['iu_nav_size_all'] || $fields['iu_nav_weight_all'] || $fields['iu_nav_bdrs_all']) {
			 echo '.profolio-pagination li a, .profolio-pagination li span {';
			 if ($fields['iu_nav_width']){
				echo "width: {$fields['iu_nav_width']}px;";
			 }

			 if ($fields['iu_nav_height']){
				echo "height: {$fields['iu_nav_height']}px;";
			 }

			 if ($fields['iu_nav_bgc_all']){
				 echo "background-color: {$fields['iu_nav_bgc_all']};";
			 }

			 if ($fields['iu_nav_color_all']){
				 echo "color: {$fields['iu_nav_color_all']};";
			 }

			 if ($fields['iu_nav_size_all']){
				 echo "font-size: {$fields['iu_nav_size_all']}px;";
			 }
			 if ($fields['iu_nav_weight_all']){
				 echo "font-weight: {$fields['iu_nav_weight_all']};";
			 }
			 if ($fields['iu_nav_bdrs_all'] || $fields['iu_nav_bdrs_all'] === '0'){
				 echo "border-radius: {$fields['iu_nav_bdrs_all']}px;";
			 }
			 echo '}';
		  }

		 if ($fields['iu_nav_bgc_current'] || $fields['iu_nav_color_current'] ||
		  $fields['iu_nav_size_current'] || $fields['iu_nav_weight_current'] || $fields['iu_nav_bdrs_current'] ) {
			 echo '.profolio-pagination .current, .profolio-pagination a.page-numbers.current {';
			 if ($fields['iu_nav_size_current']){
				echo "font-size: {$fields['iu_nav_size_current']}px;";
			 }

			 if ($fields['iu_nav_weight_current']){
				echo "font-weight: {$fields['iu_nav_weight_current']};";
			 }

			 if ($fields['iu_nav_color_current']){
				echo "color: {$fields['iu_nav_color_current']};";
			 }

			 if ($fields['iu_nav_bdrs_current'] || $fields['iu_nav_bdrs_current'] === '0'){
				echo "border-radius: {$fields['iu_nav_bdrs_current']}px;";
			 }

			 if ($fields['iu_nav_bgc_current']){
				echo "background-color: {$fields['iu_nav_bgc_current']};";
			 }
			 echo '}';
		 }

		 if ($fields['iu_nav_bgc_all_hover'] || $fields['iu_nav_color_all_hover']) {
			 echo '.profolio-pagination li a:hover {';
			 if ($fields['iu_nav_color_all_hover']){
				 echo "color: {$fields['iu_nav_color_all_hover']};";
			 }
			 if ($fields['iu_nav_bgc_all_hover']){
				 echo "background-color: {$fields['iu_nav_bgc_all_hover']};";
			 }
			echo '}';
		 }

		 if ( $fields['use_style_btn_status'] && ($fields['style_compl_color'] || $fields['style_compl_bgc'])){
			echo '.iu-filters-btn-wrap .iu_filters-post-comp.active,
				.iu-filters-btn-wrap .iu_filters-post-comp:hover {';

			if ($fields['style_compl_color']){
				echo "color: {$fields['style_compl_color']} !important;";
			}
			if ($fields['style_compl_bgc']){
				echo "border-color: {$fields['style_compl_bgc']} !important;";
				echo "background-color: {$fields['style_compl_bgc']} !important;";
			}
			echo '}';


			if ($fields['style_compl_bgc']){
				echo '.iu-filters-btn-wrap .iu_filters-post-comp {';
				echo "border-bottom-color: {$fields['style_compl_bgc']} !important;";
				echo '}';
			}
		 }

		 if ($fields['use_style_btn_status'] && ($fields['style_open_color'] || $fields['style_open_bgc'])){
			 echo '.iu-filters-btn-wrap .iu_filters-post-open.active,
					.iu-filters-btn-wrap .iu_filters-post-open:hover{';

			 if ($fields['style_open_color']){
				 echo "color: {$fields['style_open_color']} !important;";
			 }
			 if ($fields['style_open_bgc']){
				echo "border-color: {$fields['style_open_bgc']} !important;";
				echo "background-color: {$fields['style_open_bgc']} !important;";
			 }
			 echo '}';

			if ($fields['style_open_bgc']){
				echo '.iu-filters-btn-wrap .iu_filters-post-open {';
				echo "border-bottom-color: {$fields['style_open_bgc']} !important;";
				echo '}';
			}
		 }


		 if ($fields['use_style_btn_status'] && ($fields['style_reset_color'] || $fields['style_reset_bgc'])){
			 echo '.iu-filters-btn-wrap .iu-filters-reset.active,
					.iu-filters-btn-wrap .iu-filters-reset:hover{';

			 if ($fields['style_reset_color']){
				 echo "color: {$fields['style_reset_color']} !important;";
			 }
			 if ($fields['style_reset_bgc']){
				echo "border-color: {$fields['style_reset_bgc']} !important;";
				echo "background-color: {$fields['style_reset_bgc']} !important;";
			 }
			 echo '}';

			 if ($fields['style_reset_bgc']){
				echo '.iu-filters-btn-wrap .iu-filters-reset {';
				echo "border-bottom-color: {$fields['style_reset_bgc']} !important;";
				echo '}';
			 }
		 }

		 //Style for template "realestate"
		 if ( $template_name === 'realestate' ) {
			 if ($fields['iu_post_title_size']){
				 echo '.iu_realestate-title {';
				 echo "font-size: {$fields['iu_post_title_size']}px;";
				 echo '}';
			 }

		 }


		 echo '.iu-posts-list-box {';
		 if ( $fields['filter_template'] === 'aside' ) {
			 echo 'display: flex;';
			 echo 'flex-wrap: wrap;';
		 }
		 if ( $fields['iu_margin_top'] > 0 ) {
			echo "margin-top: {$fields['iu_margin_top']}px !important;";
		 }
		 if ( $fields['iu_margin_bottom'] > 0 ) {
			echo "margin-bottom: {$fields['iu_margin_bottom']}px !important;";
		 }
		 echo '}';

		 echo '.btn-mob-filter {';
		 if ( $fields['mob_btn_bottom_pos'] > 0 ) {
			echo "bottom: {$fields['mob_btn_bottom_pos']}px;";
		 }
		 echo '}';

		 if ($fields['active_color']){
		 echo '.iu-posts-list-aside-radius-title p span,';
		 echo '.iu-aside-clear-tags {';
		 echo "color: {$fields['active_color']};";
		 echo '}';
		 }


		 ?>
       </style>

       <div class="block iu-posts-list-box">

	       <?php global $post; ?>

         <!--▼ buttons only show in pc ▼-->
         <div class="btn-iu-group btn-pc-active-filter">
           <button type="button" class="btn btn-pc-filter iu-pc-show-filter">
             <svg width="16" height="13" viewBox="0 0 16 13" fill="#82D7F7" xmlns="http://www.w3.org/2000/svg">
               <path
                 d="M10.6221 4.00732C11.3838 4.00732 12.0283 3.5166 12.2773 2.84277H14.8115C15.1118 2.84277 15.3755 2.5791 15.3755 2.24951C15.3755 1.91992 15.1118 1.66357 14.8115 1.66357H12.2773C12.0356 0.982422 11.3838 0.484375 10.6221 0.484375C9.86035 0.484375 9.20117 0.982422 8.95947 1.66357H1.20312C0.873535 1.66357 0.617188 1.91992 0.617188 2.24951C0.617188 2.5791 0.873535 2.84277 1.20312 2.84277H8.9668C9.2085 3.5166 9.86035 4.00732 10.6221 4.00732ZM10.6221 3.10645C10.1387 3.10645 9.76514 2.72559 9.76514 2.24219C9.76514 1.75879 10.1387 1.38525 10.6221 1.38525C11.1055 1.38525 11.479 1.75879 11.479 2.24219C11.479 2.72559 11.1055 3.10645 10.6221 3.10645ZM1.17383 6.13135C0.873535 6.13135 0.617188 6.39502 0.617188 6.72461C0.617188 7.0542 0.873535 7.31055 1.17383 7.31055H3.7959C4.0376 7.99902 4.68945 8.48975 5.45117 8.48975C6.21289 8.48975 6.86475 7.99902 7.11377 7.31055H14.7822C15.1118 7.31055 15.3755 7.0542 15.3755 6.72461C15.3755 6.39502 15.1118 6.13135 14.7822 6.13135H7.10645C6.86475 5.45752 6.21289 4.9668 5.45117 4.9668C4.68945 4.9668 4.0376 5.45752 3.7959 6.13135H1.17383ZM5.45117 7.58154C4.9751 7.58154 4.59424 7.20068 4.59424 6.72461C4.59424 6.24121 4.9751 5.86768 5.45117 5.86768C5.93457 5.86768 6.30811 6.24121 6.30811 6.72461C6.30811 7.20068 5.93457 7.58154 5.45117 7.58154ZM10.6221 12.9575C11.3838 12.9575 12.0356 12.4668 12.2773 11.7856H14.8115C15.1118 11.7856 15.3755 11.5293 15.3755 11.1997C15.3755 10.8701 15.1118 10.6064 14.8115 10.6064H12.2773C12.0356 9.92529 11.3838 9.44189 10.6221 9.44189C9.86035 9.44189 9.2085 9.92529 8.9668 10.6064H1.20312C0.873535 10.6064 0.617188 10.8701 0.617188 11.1997C0.617188 11.5293 0.873535 11.7856 1.20312 11.7856H8.95947C9.2085 12.4668 9.86035 12.9575 10.6221 12.9575ZM10.6221 12.0566C10.1387 12.0566 9.76514 11.6758 9.76514 11.1997C9.76514 10.709 10.1387 10.3428 10.6221 10.3428C11.1055 10.3428 11.479 10.709 11.479 11.1997C11.479 11.6758 11.1055 12.0566 10.6221 12.0566Z"
                 fill="#82D7F7"></path>
             </svg>
             <span>Edit filters</span>
           </button>

           <button type="button" class="btn btn-pc-filter search-map-back-btn">
             <svg width="12" height="12" viewBox="0 0 12 12" fill="none" style="fill: #82D7F7;">
               <path d="M4 2H10.5" stroke="#82D7F7" stroke-linecap="round" stroke-linejoin="round"></path>
               <path d="M4 6H10.5" stroke="#82D7F7" stroke-linecap="round" stroke-linejoin="round"></path>
               <path d="M4 10H10.5" stroke="#82D7F7" stroke-linecap="round" stroke-linejoin="round"></path>
               <path d="M1.5 2H1.505" stroke="#82D7F7" stroke-width="2" stroke-linecap="round"
                     stroke-linejoin="round"></path>
               <path d="M1.5 6H1.505" stroke="#82D7F7" stroke-width="2" stroke-linecap="round"
                     stroke-linejoin="round"></path>
               <path d="M1.5 10H1.505" stroke="#82D7F7" stroke-width="2" stroke-linecap="round"
                     stroke-linejoin="round"></path>
             </svg>
             <span>List View</span>
           </button>
         </div>
         <!--▲ buttons only show in pc ▲-->

         <!--▼ this aside ▼-->
	       <?php if ( $fields['use_filters'] && $fields['filter_template'] === 'aside' ): ?>
             <aside class="iu-posts-list-aside">
			     <?php if ( $fields['use_map_block'] ): ?>
                   <div class="iu-aside-map-box-btn">
                     <img src="<?php echo INSTANTUP_URL ?>data/assets/img/map-btn.jpg" alt="mapImage">
                     <button type="button">
                       <svg width="16" height="18" viewBox="0 0 16 18" fill="none">
                         <path fill-rule="evenodd" clip-rule="evenodd"
                               d="M1.53125 7.82607C1.54326 4.29225 4.41772 1.43725 7.95154 1.44926C11.4854 1.46126 14.3404 4.33572 14.3284 7.86955V7.94201C14.2849 10.2391 13.0023 12.3623 11.4298 14.0217C10.5305 14.9556 9.52626 15.7823 8.43705 16.4855C8.1458 16.7374 7.7138 16.7374 7.42255 16.4855C5.79881 15.4286 4.3737 14.0943 3.21241 12.5435C2.17738 11.1911 1.58972 9.54976 1.53125 7.84781L1.53125 7.82607Z"
                               stroke="#82D7F7" stroke-width="1.5" stroke-linecap="round"
                               stroke-linejoin="round"/>
                         <path fill-rule="evenodd" clip-rule="evenodd"
                               d="M7.93354 9.99989C9.06612 9.99989 9.98426 9.08175 9.98426 7.94916C9.98426 6.81658 9.06612 5.89844 7.93354 5.89844C6.80095 5.89844 5.88281 6.81658 5.88281 7.94916C5.88281 9.08175 6.80095 9.99989 7.93354 9.99989Z"
                               stroke="#82D7F7" stroke-width="1.5" stroke-linecap="round"
                               stroke-linejoin="round"/>
                       </svg>
                       <span><?php echo __( 'Map View', 'instantup' ); ?></span>
                     </button>
                   </div>
			     <?php endif; ?>

			     <?php if ( $fields['use_filter_radius'] ): ?>
                   <div class="iu-posts-list-aside-radius">
                     <div class="iu-posts-list-aside-radius-title">
                       <p>Distance from: <span></span></p>
                       <button type="button" class="iu_location-filter-clear d-none">×</button>
                     </div>

                     <form class="iu_radius-filter-row"
                           oninput="iu_radius_output.value = iu_radius_filter.value">
                       <input id="iu_radius_filter" class="iu_radius-filter" autocomplete="off" type="range"
                              name="iu_radius_filter"
                              value="25" min="5" max="200" step="5">

                       <p class="iu_radius-filter_output">
                         <output name="iu_radius_output">25</output>
                         mile radius
                       </p>
                     </form>
                   </div>
			     <?php endif; ?>

               <div class="iu_location-filter-row">
			       <?php if ( $fields['use_filter_location'] ): ?>
                     <input type="text" id="iu_location_filter" autocomplete="off"
                            placeholder="<?php esc_attr_e( 'Enter a location or zip', 'instantup' ); ?>"
                            class="iu_location-filter profolio-loc-input form-control js-filter-input">
			       <?php endif; ?>
               </div>

			     <?php if ( $fields['use_category'] || $fields['use_tags_block'] ): ?>
                   <div class="iu-posts-list-row">
                     <p class="iu-posts-list-aside-title">
					     <?php echo __( 'Filters:', 'instantup' ) ?>
                     </p>

                     <div class="iu-aside-clear-tags">
					     <?php echo __( 'Clear filters', 'instantup' ) ?>
                     </div>
                   </div>

                   <div class="iu-aside-term">
				       <?php
				       $iu_categories = get_terms( array( 'taxonomy' => 'iu_categories' ) );
				       if ( $fields['use_category'] && $iu_categories && ! is_wp_error( $iu_categories ) ):
					       ?>
                         <div class="iu-aside-term-item">
                           <p class="iu-aside-term-item-title">Categories</p>

                           <span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-down">
                                 <svg width="14" height="7" viewBox="0 0 14 7" fill="none"
                                      xmlns="http://www.w3.org/2000/svg">
                                    <path
                                      d="M12.2788 0.964844L7.93208 5.31151C7.41875 5.82484 6.57875 5.82484 6.06542 5.31151L1.71875 0.964844"
                                      stroke="black" stroke-width="1.5" stroke-miterlimit="10"
                                      stroke-linecap="round" stroke-linejoin="round"></path>
                                 </svg>
                             </span>
                           <span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-up"><svg width="16"
                                                                                                   height="16"
                                                                                                   viewBox="0 0 16 16"
                                                                                                   fill="none"
                                                                                                   xmlns="http://www.w3.org/2000/svg">
                                <path
                                  d="M2.72125 10.0352L7.06792 5.68849C7.58125 5.17516 8.42125 5.17516 8.93458 5.68849L13.2812 10.0352"
                                  stroke="black" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                  stroke-linejoin="round"></path>
                                </svg>
                             </span>

						     <?php foreach ( $iu_categories as $item ) :
							     if ( $item->name ) : ?>
                                   <div class="iu-aside-term-item-child">
                                     <input type="checkbox" class="aside-filter-cat-input"
                                            autocomplete="off"
                                            name="aside_filter_cat_<?php echo $item->term_id; ?>"
                                            id="aside_filter_cat_<?php echo $item->term_id; ?>"
                                            value="<?php echo $item->term_id; ?>">
                                     <label
                                       for="aside_filter_cat_<?php echo $item->term_id; ?>"><?php echo $item->name; ?></label>
                                   </div>
							     <?php
							     endif;
						     endforeach; ?>
                         </div>
				       <?php endif; ?>

				       <?php if ( $fields['use_tags_block'] ):
					       $all_terms_name   = array();
					       $label_tags       = array();
					       $label_tags_terms = get_terms( array( 'taxonomy' => 'iu_label_tags' ) );

					       if ( $label_tags_terms && ! is_wp_error( $label_tags_terms ) ) {
						       foreach ( $label_tags_terms as $item => $term ) {
							       $all_terms_name[ $term->term_id ] = $term->name;

							       if ( $term->parent === 0 ) {
								       $label_tags[ $term->term_id ]['parent'] = $term->name;
								       continue;
							       }

							       if ( $term->parent !== 0 ) {
								       $label_tags[ $term->parent ]['children'][] = array(
									       $term->name,
									       $term->term_id,
								       );
							       }
						       }

						       foreach ( $label_tags as $key => $item ) {
							       if ( $item['children'] ) {
								       $parent = $item['parent'] ?? $all_terms_name[ $key ];

								       echo '<div class="iu-aside-term-item">';
								       echo '<p class="iu-aside-term-item-title">' . $parent . '</p>';
								       echo '<span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-down"><svg width="14" height="7" viewBox="0 0 14 7" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.2788 0.964844L7.93208 5.31151C7.41875 5.82484 6.57875 5.82484 6.06542 5.31151L1.71875 0.964844" stroke="black" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg></span>';
								       echo '<span class="iu-aside-term-item-arrow iu-aside-term-item-arrow-up"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M2.72125 10.0352L7.06792 5.68849C7.58125 5.17516 8.42125 5.17516 8.93458 5.68849L13.2812 10.0352" stroke="black" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg></span>';
								       foreach ( $item['children'] as $child ) {
									       $label_tag = 'aside_filter_tag_' . $child[1];

									       echo '<div class="iu-aside-term-item-child">';
									       echo '<input type="checkbox" class="aside-filter-tag-input" autocomplete="off" name="' . $label_tag . '" id="' . $label_tag . '" value="' . $child[1] . '"></input>';
									       echo '<label for="' . $label_tag . '">' . $child[0] . '</label>';
									       echo '</div>';
								       }
								       echo '</div>';
							       }
						       }
					       }
				       endif; ?>
                   </div>
			     <?php endif; ?>

               <div class="btn-iu-group btn-mob-active-filter">
                 <button type="button" class="btn iu-mob-clear-filter">Clear all</button>
                 <button type="button" class="btn iu-mob-accept-filter">Done</button>
               </div>

             </aside>
	       <?php endif; ?>
         <!--▲ this aside ▲-->

         <!--▼ this content ▼-->
         <div id="iu_posts_block" class="block__content iu-posts-list
             <?php echo $fields['filter_template'] === 'aside' ? 'iu-posts-list-aside-active' : '' ?> <?php echo $template_name === 'realestate' ? 'iu_realestate-block' : ''; ?>"
              data-template="<?php echo $template_name ?>" data-parent-id="<?php echo get_the_ID(); ?>"
              data-per-page="<?php echo $fields['iu_posts_per_page'] ?: 26; ?>"
              data-post-type="<?php echo implode( ',', $post_type ) ?>"
              data-current-page="<?php echo get_query_var( 'paged' ) ?: 1 ?>"
              data-slug="<?php echo $post->post_name; ?>">

		     <?php if ( $fields['use_filters'] ): ?>
               <div class="iu_filters-block">

			       <?php if ( $fields['filter_template'] === 'simple' ): ?>

				       <?php if ( $fields['use_filter_location'] || $fields['use_filter_radius'] ): ?>
                       <div class="iu_location-filter-row">
					       <?php if ( $fields['use_filter_location'] ): ?>
                             <input type="text" id="iu_location_filter" autocomplete="on"
                                    placeholder="<?php esc_attr_e( 'Enter a location', 'instantup' ); ?>"
                                    class="iu_location-filter profolio-loc-input form-control js-filter-input">
					       <?php endif; ?>

					       <?php if ( $fields['use_filter_radius'] ): ?>
                             <form class="iu_radius-filter-row"
                                   oninput="iu_radius_output.value = iu_radius_filter.value">
                               <input class="iu_radius-filter" autocomplete="off" type="range"
                                      name="iu_radius_filter"
                                      value="100" min="10" max="500" step="5">

                               <p class="iu_radius-filter_output">
                                 <output name="iu_radius_output">100</output>
                                 mile radius
                               </p>
                             </form>
					       <?php endif; ?>
                       </div>
				       <?php endif; ?>

                     <div class="iu_block-filter">
                       <div class="iu_filters-more">
					       <?php if ( $fields['iu_custom_filter'] ):
						       $filter_id = 0;
						       foreach ( $fields['iu_custom_filter'] as $field ) : ?>
                                 <section class="iu_filters-wrapper">
                                   <fieldset>
                                     <legend><?php echo $field['iu_filter_legend'] ?></legend>

                                     <div class="iu_filters-item-row">
									     <?php foreach ( $field['iu_filter_item'] as $filter ) : ?>
                                           <label>
                                             <input type="checkbox" autocomplete="off"
                                                    data-id="<?php echo $filter_id; ?>"
                                                    name="<?php echo $filter['iu_filter_value'] ?>">
										       <?php echo $filter['iu_filter_name'] ?>
                                           </label>
										     <?php
										     $filter_id ++;
									     endforeach; ?>
                                     </div>
                                   </fieldset>
                                 </section>
						       <?php endforeach;
					       endif; ?>
                       </div>

                       <div class="iu_price-filter-row">
					       <?php if ( $fields['use_filter_price'] && $template_name === 'realestate' ): ?>
                             <div class="iu-select">
                               <select class="iu_price-select" name="min_price" autocomplete="off"
                                       id="iu_min_price">
                                 <option selected value="">No Min Price</option>
							       <?php echo isset( $min_price, $max_price ) ? $this->get_price_for_select( $min_price, $max_price ) : ''; ?>
                               </select>
                             </div>

                             <span class="iu_price-filter-separator">-</span>

                             <div class="iu-select">
                               <select class="iu_price-select" name="max_price" autocomplete="off"
                                       id="iu_max_price">
                                 <option selected value="">No Max Price</option>
							       <?php echo isset( $min_price, $max_price ) ? $this->get_price_for_select( $min_price, $max_price ) : ''; ?>
                               </select>
                             </div>
					       <?php endif; ?>

                         <button id="iu_filters_btn" class="iu_filters-btn" type="button">Filters</button>
                       </div>
                     </div>
			       <?php endif; ?>

			       <?php if ( $fields['use_filter_sort'] || $fields['use_filter_count'] ): ?>
                     <div class="iu_realestate-sort">

					     <?php if ( $fields['use_filter_count'] ): ?>
                           <div class="iu_realestate-count-sort">
                             <strong data-tn="resultsBar-showingCount"><?php echo count( $posts ) ?> </strong>
                             of
                             <strong data-tn="resultsBar-totalItemsCount"><?php echo $query->found_posts ?> </strong>
						       <?php if ( $fields['template_posts'] === 'realestate' ) {
							       echo 'Homes';
						       }
						       else {
							       echo 'Posts';
						       } ?>
                           </div>
					     <?php endif; ?>

					     <?php if ( $fields['use_filter_sort'] && $template_name === 'realestate' && $fields['filter_template'] === 'simple' ): ?>
                           <div class="iu-select">
                             <select class="iu_realestate-select" name="iu_realestate_sort"
                                     autocomplete="off">
                               <option value="">Sort by most recent</option>
                               <option value="<?php echo $fields['iu_set_price'] ?? ''; ?>">Sort by Price
                               </option>
                               <option value="<?php echo $fields['iu_set_beds'] ?? ''; ?>">Sort by Beds
                               </option>
                               <option value="<?php echo $fields['iu_set_baths'] ?? ''; ?>">Sort by Baths
                               </option>
                               <option value="<?php echo $fields['iu_set_sqft'] ?? ''; ?>">Sort by Square
                                 Feet
                               </option>
                             </select>
                           </div>
					     <?php endif; ?>

                     </div>
			       <?php endif; ?>

               </div>
		     <?php endif; ?>

           <div class="<?php echo $class_posts ?>">
		       <?php foreach ( $posts as $key => $post ) :
			       setup_postdata( $post );
			       if ( has_post_thumbnail() || $fields['iu_pic_set_image'] ):
				       include INSTANTUP_PATH . "data/template/blocks/posts/{$template_name}.php";
			       endif;
		       endforeach; ?>
           </div>

		     <?php if ( $query->max_num_pages > 1 ): ?>
               <div class="profolio-row">
                 <div class="profolio-col-12 text-center profolio-pagination">
                   <nav><?php echo paginate_links( array(
					       'total'     => $query->max_num_pages,
					       'current'   => max( 1, get_query_var( 'paged' ) ),
					       'show_all'  => false,
					       'type'      => 'list',
					       'end_size'  => 1,
					       'mid_size'  => 1,
					       'prev_next' => false,
				       ) );
				       ?></nav>
                 </div>
               </div>
		     <?php
		     endif;

		     wp_reset_postdata();
		     ?>
         </div>
         <!--▲ this content ▲-->

       </div><!-- .block -->

       <!-- Mobile button -->
	     <?php if ( $fields['filter_template'] === 'aside' ): ?>
         <div class="btn-group btn-mob-filter">
           <button type="button" class="btn iu-show-mob-filters">
             <svg width="16" height="13" viewBox="0 0 16 13" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path
                 d="M10.6221 4.00732C11.3838 4.00732 12.0283 3.5166 12.2773 2.84277H14.8115C15.1118 2.84277 15.3755 2.5791 15.3755 2.24951C15.3755 1.91992 15.1118 1.66357 14.8115 1.66357H12.2773C12.0356 0.982422 11.3838 0.484375 10.6221 0.484375C9.86035 0.484375 9.20117 0.982422 8.95947 1.66357H1.20312C0.873535 1.66357 0.617188 1.91992 0.617188 2.24951C0.617188 2.5791 0.873535 2.84277 1.20312 2.84277H8.9668C9.2085 3.5166 9.86035 4.00732 10.6221 4.00732ZM10.6221 3.10645C10.1387 3.10645 9.76514 2.72559 9.76514 2.24219C9.76514 1.75879 10.1387 1.38525 10.6221 1.38525C11.1055 1.38525 11.479 1.75879 11.479 2.24219C11.479 2.72559 11.1055 3.10645 10.6221 3.10645ZM1.17383 6.13135C0.873535 6.13135 0.617188 6.39502 0.617188 6.72461C0.617188 7.0542 0.873535 7.31055 1.17383 7.31055H3.7959C4.0376 7.99902 4.68945 8.48975 5.45117 8.48975C6.21289 8.48975 6.86475 7.99902 7.11377 7.31055H14.7822C15.1118 7.31055 15.3755 7.0542 15.3755 6.72461C15.3755 6.39502 15.1118 6.13135 14.7822 6.13135H7.10645C6.86475 5.45752 6.21289 4.9668 5.45117 4.9668C4.68945 4.9668 4.0376 5.45752 3.7959 6.13135H1.17383ZM5.45117 7.58154C4.9751 7.58154 4.59424 7.20068 4.59424 6.72461C4.59424 6.24121 4.9751 5.86768 5.45117 5.86768C5.93457 5.86768 6.30811 6.24121 6.30811 6.72461C6.30811 7.20068 5.93457 7.58154 5.45117 7.58154ZM10.6221 12.9575C11.3838 12.9575 12.0356 12.4668 12.2773 11.7856H14.8115C15.1118 11.7856 15.3755 11.5293 15.3755 11.1997C15.3755 10.8701 15.1118 10.6064 14.8115 10.6064H12.2773C12.0356 9.92529 11.3838 9.44189 10.6221 9.44189C9.86035 9.44189 9.2085 9.92529 8.9668 10.6064H1.20312C0.873535 10.6064 0.617188 10.8701 0.617188 11.1997C0.617188 11.5293 0.873535 11.7856 1.20312 11.7856H8.95947C9.2085 12.4668 9.86035 12.9575 10.6221 12.9575ZM10.6221 12.0566C10.1387 12.0566 9.76514 11.6758 9.76514 11.1997C9.76514 10.709 10.1387 10.3428 10.6221 10.3428C11.1055 10.3428 11.479 10.709 11.479 11.1997C11.479 11.6758 11.1055 12.0566 10.6221 12.0566Z"
                 fill="none"/>
             </svg>
             <span><?php echo __( 'Edit filters', 'instantup' ); ?></span>
           </button>

           <button type="button" class="btn iu-show-mob-map">
             <svg width="15" height="18" viewBox="0 0 15 18" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path fill-rule="evenodd" clip-rule="evenodd"
                     d="M1.53125 7.82607C1.54326 4.29225 4.41772 1.43725 7.95154 1.44926C11.4854 1.46126 14.3404 4.33572 14.3284 7.86955V7.94201C14.2849 10.2391 13.0023 12.3623 11.4298 14.0217C10.5305 14.9556 9.52626 15.7823 8.43705 16.4855C8.1458 16.7374 7.7138 16.7374 7.42255 16.4855C5.79881 15.4286 4.3737 14.0943 3.21241 12.5435C2.17738 11.1911 1.58972 9.54976 1.53125 7.84781L1.53125 7.82607Z"
                     stroke="none" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
               <path fill-rule="evenodd" clip-rule="evenodd"
                     d="M7.93354 9.99989C9.06612 9.99989 9.98426 9.08175 9.98426 7.94916C9.98426 6.81658 9.06612 5.89844 7.93354 5.89844C6.80095 5.89844 5.88281 6.81658 5.88281 7.94916C5.88281 9.08175 6.80095 9.99989 7.93354 9.99989Z"
                     stroke="none" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
             </svg>
             <span><?php echo __( 'Map View', 'instantup' ); ?></span>
           </button>
         </div>
	     <?php endif; ?>

	     <?php if ( $fields['use_filters'] ) { ?>
         <script>
					 window['iu_filters_arg'] = <?php echo json_encode( $filters_arr )?>
         </script>
	     <?php }
     } );