<?php
/**
 * header.php
 * create in 26.07.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

$select_fields = $this->get_fields_for_block();

Block::make( __( 'IU Realestation One Header' ) )
     ->add_tab( __( 'Fields settings' ), array(
	     Field::make( 'select', 'iu_get_price', __( 'Price' ) )
	          ->set_options( array(
		          '' => 'chouse fild',
	          ) )
	          ->add_options( $select_fields ),

	     Field::make( 'select', 'iu_get_beds', __( 'Bedrooms' ) )
	          ->set_options( array(
		          '' => 'chouse fild',
	          ) )
	          ->add_options( $select_fields ),

	     Field::make( 'select', 'iu_get_baths', __( 'Bathrooms' ) )
	          ->set_options( array(
		          '' => 'chouse fild',
	          ) )
	          ->add_options( $select_fields ),

	     Field::make( 'select', 'iu_get_sqft', __( 'SquareFeet' ) )
	          ->set_options( array(
		          '' => 'chouse fild',
	          ) )
	          ->add_options( $select_fields ),

     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'Header tempplate for realestation one' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields, $attributes, $inner_blocks ) {
	     $prefix  = $this->get_metabox_prefix();
	     $post_id = get_the_ID() ? : get_option( '_temp_post_for_templates' );
	     $address = get_post_meta( $post_id, $prefix . 'address', true );

	     $realestate_price = false;
	     $realestate_beds  = false;
	     $realestate_baths = false;
	     $realestate_sqft  = false;

	     if ( isset($fields['iu_get_price']) && ! empty($fields['iu_get_price']) ) {
	         if ($realestate_price = get_post_meta( $post_id, $fields['iu_get_price'], true )){
		         $realestate_price = number_format($realestate_price, 0, ',', ',');
             }
	     }
	     if ( isset($fields['iu_get_beds']) && ! empty($fields['iu_get_beds']) ) {
		     $realestate_beds = get_post_meta( $post_id, $fields['iu_get_beds'], true ) ? : false;
	     }
	     if ( isset($fields['iu_get_baths']) && ! empty($fields['iu_get_baths']) ) {
		     $realestate_baths = get_post_meta( $post_id, $fields['iu_get_baths'], true ) ? : false;
	     }
	     if ( isset($fields['iu_get_sqft']) && ! empty($fields['iu_get_sqft']) ) {
		     $realestate_sqft = get_post_meta( $post_id, $fields['iu_get_sqft'], true ) ? : false;
	     }

	     ?>

         <div class="block">
             <div class="block__content iu-realestate-one">

                 <div class="iu-realestate-header-row">
                     <div class="iu-realestate-header-left">
                         <h1 class="iu-realestate-header-value"><?php echo get_the_ID() ? get_the_title() : 'This is post title'; ?></h1>
                         <div class="iu-realestate-header-field"><?php echo $address; ?></div>
                     </div>

                     <div class="iu-realestate-header-right">
                         <div class="iu-realestate-header-summary">
                             <div class="iu-realestate-header-value">
                                 <?php echo $realestate_price ? "\${$realestate_price}" : '-';?>
                             </div>
                             <div class="iu-realestate-header-field price">Price</div>
                         </div>

                         <div class="iu-realestate-header-summary">
                             <div class="iu-realestate-header-value"><?php echo $realestate_beds ?: '-';?></div>
                             <div class="iu-realestate-header-field beds">Beds</div>
                         </div>

                         <div class="iu-realestate-header-summary">
                             <div class="iu-realestate-header-value"><?php echo $realestate_baths ?: '-';?></div>
                             <div class="iu-realestate-header-field baths">Baths</div>
                         </div>

                         <div class="iu-realestate-header-summary">
                             <div class="iu-realestate-header-value"><?php echo $realestate_sqft ?: '-';?></div>
                             <div class="iu-realestate-header-field sqft">Sq. Ft.</div>
                         </div>
                     </div>
                 </div>


             </div>
         </div>
	     <?php
     } );