<?php

namespace InstantUploader;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class Metaboxes
 * @since  1.0.0
 */
class Metaboxes {

	public function admin() {
		return new Admin();
	}

	/**
	 * Init class.
	 */
	public function init() {
		if ( is_admin() ) {
			$type_prefix = $this->admin()->get_type_prefix();
			add_action( 'add_meta_boxes_' . $type_prefix . '_templates', array( $this, 'create_meta_boxes' ) );
			add_action( 'add_meta_boxes', array( $this, 'meta_boxes_for_page' ) );

			add_action( 'save_post', array( $this, 'save_meta_content_width' ), 10, 2 );
			add_action( 'save_post', array( $this, 'save_meta_hide_title' ), 10, 1 );
			add_action( 'save_post_' . $type_prefix . '_templates', array( $this, 'save_meta_post_type' ), 10, 2 );
			add_action( 'save_post_' . $type_prefix . '_templates', array( $this, 'save_meta_cat_tag' ), 10, 1 );
			add_action( 'save_post_' . $type_prefix . '_templates', array( $this, 'save_meta_content_width' ), 10, 2 );
			add_action( 'save_post_' . $type_prefix . '_templates', array( $this, 'save_meta_template_type' ), 10, 1 );

			add_action( 'before_delete_post', array( $this, 'delete_meta_boxes' ), 10, 1 );
			add_action( 'wp_trash_post', array( $this, 'delete_meta_boxes' ), 10, 1 );
		}
	}

	//For page
	public function meta_boxes_for_page() {
		add_meta_box( 'iu-full-content-page', 'Content Width', array( $this, 'output_html_meta_content_width' ), 'page',
			'side',
			'low',
			array(
				'__back_compat_meta_box ' => false,
			)
		);

		add_meta_box( 'iu-hide-page-title', 'Title Page', array( $this, 'output_html_hide_title' ), 'page',
			'side',
			'low',
			array(
				'__back_compat_meta_box ' => false,
			)
		);
	}

	public function create_meta_boxes() {
		add_meta_box( 'iu-template-type', 'Choose Template Type', array( $this, 'output_html_template_type' ), '',
			'side',
			'low',
			array(
				'__back_compat_meta_box' => false,
			) );

		add_meta_box( 'iu-post-type', 'Usage: single pages', array( $this, 'output_html_meta_post_type' ), '',
			'side',
			'low',
			array(
				'__back_compat_meta_box' => false,
			) );

		add_meta_box( 'iu-cat-tag', 'Usage: category and tag', array( $this, 'output_html_meta_cat_tag' ), '',
			'side',
			'low',
			array(
				'__back_compat_meta_box' => false,
			) );

		add_meta_box( 'iu-full-content', 'Content Width', array( $this, 'output_html_meta_content_width' ), '',
			'side',
			'low',
			array(
				'__back_compat_meta_box' => false,
			) );
	}

	//Html meta boxes
	public function output_html_template_type( $post_ogj ) {
		wp_nonce_field( 'iu_inner_checked_type', 'iu_inner_checked_template_type' );

		if ( $get_selected = get_post_meta( $post_ogj->ID, 'iu_template_type', true ) ) {
			$selected = $get_selected;
		} else {
			$selected = 'post_page';
		}
		?>
        <select id="iu_checked_template_type" name="checked_template_type">
            <option <?php echo $selected === 'post_page' ? 'selected' : '' ?> value="post_page">Post and Page</option>
            <option <?php echo $selected === 'cat_tag' ? 'selected' : '' ?> value="cat_tag">Category and Tag</option>
        </select>
		<?php
	}

	public function output_html_meta_post_type( $post_ogj ) {
		wp_nonce_field( 'iu_inner_checked', 'iu_inner_checked_box_nonce' );

		if ( $post_types = get_option( '_iu_custom_type_posts' ) ) :
			$template_for_type = get_post_meta( $post_ogj->ID, '_template_for_content', true ); ?>
            <ul class="iu-checked-post-type">
				<?php foreach ( $post_types as $post_type_data ) : ?>
                    <li>
                        <label>
							<?php if ( $template_for_type ):
								foreach ( $template_for_type as $key => $item ) :
									if ( $key === $post_type_data['slug'] ):
										$checked = 'checked';
										break;
									endif;
								endforeach;
							endif; ?>
                            <input type="checkbox"
                                   class="" <?php echo $checked ?? '' ?>
                                   name="iu_post_types[<?php echo esc_attr( $post_type_data['slug'] ); ?>]"
                                   value="<?php echo $post_ogj->ID; ?>"
                                   autocomplete="off"
                                   title="uid <?php echo $post_type_data['id']?>"/>
							<?php echo $post_type_data['name']; ?>
                        </label>
                    </li>
					<?php
					unset( $checked );
				endforeach; ?>
            </ul>

		<?php else:
			echo '<p>No custom post</p>';
		endif;
	}

	public function output_html_meta_cat_tag( $post_ogj ) {
		wp_nonce_field( 'iu_inner_cat_tag', 'iu_inner_cat_tag_nonce' );
		$type_prefix      = $this->admin()->get_type_prefix();

		if ( taxonomy_exists( $type_prefix . '_categories' ) ||
		     taxonomy_exists( $type_prefix . '_tags' ) ||
		     taxonomy_exists( $type_prefix . '_label_tags' ) ):

			$template_for_cat_tag = get_post_meta( $post_ogj->ID, '_template_for_cat_tag', true );
			$get_selected = get_post_meta( $post_ogj->ID, 'iu_template_type', true );
			$set_checked  = '';

			if ( $get_selected === 'cat_tag' &&
			     empty( $template_for_cat_tag['iu_categories'] ) &&
			     empty( $template_for_cat_tag['iu_tags'] ) &&
			     empty( $template_for_cat_tag['iu_label_tags'] ) ) {
				$set_checked = 'checked';
			}
			?>
            <ul class="iu-checked-post-type">
                <li>
                    <label>
                        <input type="checkbox" <?php echo $set_checked ?> name="tax_input[all][]" value="all" autocomplete="off"/>
                        All category and tags
                    </label>
                </li>
				<?php
				$iu_categories = array(
					'taxonomy'      => $type_prefix . '_categories',
					'selected_cats' => $template_for_cat_tag['iu_categories'] ?? '',
					'checked_ontop' => true,
				);
				$iu_tags       = array(
					'taxonomy'      => $type_prefix . '_tags',
					'selected_cats' => $template_for_cat_tag['iu_tags'] ?? '',
					'checked_ontop' => true,
				);

				$iu_label_tags = array(
					'taxonomy'      => $type_prefix . '_label_tags',
					'selected_cats' => $template_for_cat_tag['iu_label_tags'] ?? '',
					'checked_ontop' => true,
				);

				echo '<li>Cat</li>';
				wp_terms_checklist( 0, $iu_categories );
				echo '<li>Tags</li>';
				wp_terms_checklist( 0, $iu_tags );
				echo '<li>Label Tags</li>';
				wp_terms_checklist( 0, $iu_label_tags );
				?>
            </ul>
		<?php else:
			echo '<p>No custom category or tag</p>';
		endif;


	}

	public function output_html_meta_content_width( $post ) {
		wp_nonce_field( 'iu_inner_checked', 'iu_inner_checked_box_nonce' ); ?>
        <ul class="iu-checked-post-type">
			<?php if ( $content_width = get_post_meta( $post->ID, 'iu_content_width', true ) ): ?>
                <li>
                    <input type="radio" <?php echo $content_width === 'boxed' ? 'checked' : ''; ?> name="iu_content_width"
                           value="boxed"
                           autocomplete="off">
                    Boxed
                </li>
                <li>
                    <input type="radio" <?php echo $content_width === 'full_width' ? 'checked' : ''; ?> name="iu_content_width"
                           value="full_width"
                           autocomplete="off">
                    Full Width
                </li>
			<?php else: ?>
                <li><input type="radio" checked name="iu_content_width" value="boxed" autocomplete="off">Boxed</li>
                <li><input type="radio" name="iu_content_width" value="full_width" autocomplete="off">Full Width</li>
			<?php endif; ?>
        </ul>
	<?php }

	public function output_html_hide_title( $post ) {
		wp_nonce_field( 'iu_inner_checked', 'iu_nonce_hide_title' ); ?>
        <label>
            <input <?php checked( get_post_meta( $post->ID, 'iu_hide_title', true ), 'on' ); ?>
                type="checkbox" name="iu_hide_title" autocomplete="off">
            Hide title?
        </label>
	<?php }

	//Save
	public function save_meta_post_type( $post_id, $post ) {
		if ( ! isset( $_POST['iu_inner_checked_box_nonce'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['iu_inner_checked_box_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'iu_inner_checked' ) ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( $_POST['checked_template_type'] === 'cat_tag' ) {
			return $post_id;
		}

		if ( $template_arr = get_option( '_template_for_content' ) ) {
			$data = $_POST['iu_post_types'];

			foreach ( $template_arr as $key => $id ) {
				if ( (int) $id === (int) $post_id ) {
					unset( $template_arr[ $key ] );
				}
			}

			$data_result = is_array( $data ) ? array_merge( $template_arr, $data ) : $template_arr;

			update_option( '_template_for_content', $data_result );

		} else {
			update_option( '_template_for_content', $_POST['iu_post_types'] );
		}

		update_post_meta( $post_id, '_template_for_content', $_POST['iu_post_types'] );

		return $post_id;
	}

	public function save_meta_cat_tag( $post_id ) {
		if ( ! isset( $_POST['iu_inner_cat_tag_nonce'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['iu_inner_cat_tag_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'iu_inner_cat_tag' ) ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( $_POST['checked_template_type'] === 'post_page' ) {
			return $post_id;
		}

		if ( $template_arr = get_option( '_template_for_cat_tag' ) ) {
			$data = array_merge(
				$_POST['tax_input']['iu_categories'] ?? array(),
				$_POST['tax_input']['iu_tags'] ?? array(),
				$_POST['tax_input']['iu_label_tags'] ?? array()
			);

			foreach ( $template_arr as $template_id => $array_ids ) {
				$c = count( $data );

				for ( $i = 0; $i < $c; $i ++ ) {
					if ( $data[ $i ] && is_array( $array_ids ) ) {
						$search_key = array_search( $data[ $i ], $array_ids, true );

						if ( $search_key !== false ) {
							unset( $template_arr[ $template_id ][ $search_key ] );
						}
					}
				}

				if ( isset( $_POST['tax_input']['all'] ) && !empty( $_POST['tax_input']['all'] ) ) {
					$template_arr[$post_id] = 'all';
				} else {
					unset( $template_arr['all'] );
					$template_arr[ $post_id ] = $data;
				}
			}

			update_option( '_template_for_cat_tag', $template_arr );

		} else {
			$id_arr = array(
				$post_id => array_merge(
					$_POST['tax_input']['iu_categories'],
					$_POST['tax_input']['iu_tags'],
					$_POST['tax_input']['iu_label_tags']
				),
			);

			if ( isset( $_POST['tax_input']['all'] ) && !empty( $_POST['tax_input']['all'] ) ) {
				$id_arr[$post_id] = 'all';
			}

			update_option( '_template_for_cat_tag', $id_arr );
		}


		update_post_meta( $post_id, '_template_for_cat_tag', $_POST['tax_input'] );

		return $post_id;
	}

	public function save_meta_hide_title( $post_id ) {
		if ( ! isset( $_POST['iu_nonce_hide_title'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['iu_nonce_hide_title'];

		if ( ! wp_verify_nonce( $nonce, 'iu_inner_checked' ) ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		update_post_meta( $post_id, 'iu_hide_title', $_POST['iu_hide_title'] ?? false );
	}

	public function save_meta_content_width( $post_id, $post ) {
		if ( ! isset( $_POST['iu_inner_checked_box_nonce'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['iu_inner_checked_box_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'iu_inner_checked' ) ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( $post->post_type !== 'page' && isset($_POST['iu_post_types']) ) {
			$content_width_arr = array();

			foreach ( $_POST['iu_post_types'] as $key => $item ) :
				$content_width_arr[ $key ] = $_POST['iu_content_width'];
			endforeach;

			if ( $content_width = get_option( 'iu_content_width' ) ) {
				foreach ( $content_width as $key => $id ) {
					if ( $key === $_POST['iu_content_width'][ $key ] ) {
						unset( $content_width[ $key ] );
					}
				}

				$data_result = array_merge( $content_width, $content_width_arr );
				update_option( 'iu_content_width', $data_result );

			} else {
				update_option( 'iu_content_width', $content_width_arr );
			}
		}

		update_post_meta( $post_id, 'iu_content_width', $_POST['iu_content_width'] );
	}

	public function save_meta_template_type( $post_id ) {
		if ( ! isset( $_POST['iu_inner_checked_template_type'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['iu_inner_checked_template_type'];

		if ( ! wp_verify_nonce( $nonce, 'iu_inner_checked_type' ) ) {
			return $post_id;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		update_post_meta( $post_id, 'iu_template_type', $_POST['checked_template_type'] );
	}

	//Delete meta
	public function delete_meta_boxes( $post_id ) {
		if ( $tem_for_content = get_option( '_template_for_content' ) ) {
			foreach ( $tem_for_content as $key => $id ) {
				if ( (int) $id === (int) $post_id ) {
					unset( $tem_for_content[ $key ] );
				}
			}

			update_option( '_template_for_content', $tem_for_content );
		}

		if ( $tem_for_cat_tag = get_option( '_template_for_cat_tag' ) ) {
			foreach ( $tem_for_cat_tag as $template_id => $arr_ids ) {
				if ( (int) $template_id === (int) $post_id ) {
					unset( $tem_for_cat_tag[ $template_id ] );
				}
			}

			update_option( '_template_for_cat_tag', $tem_for_cat_tag );
		}

	}

}
