<?php

namespace InstantUploader;

if (!defined('WPINC')) {
    die;
}

use Carbon_Fields\Container;
use Carbon_Fields\Field;

class Options extends Admin
{

    /**
     * Leads constructor.
     */
    public function __construct()
    {
        Admin::__construct();
    }

    /**
     * Init Options.
     */
    public function init()
    {
        add_action('carbon_fields_register_fields', array($this, 'page_options'));
        add_action('carbon_fields_theme_options_container_saved', array($this, 'action_carbon_saved'));
        add_filter('carbon_fields_should_delete_field_value_on_save', array($this, 'carbon_save_field_value',), 10, 2);
    }

    #------------------

    public function carbon_save_field_value($delete, $field)
    {
        if (stripos($field->get_name(), 'rewrite_project_slug') !== false) {
            $old_val = get_option($field->get_name());

            if ($field->get_value() !== $old_val) {
                update_option($field->get_name() . '_old', $old_val);
            }
        }

        return $delete;
    }

    /**
     * Update routs.
     */
    public function action_carbon_saved()
    {
        if (get_option('_rewrite_project_slug_cat')) {
            update_option('changed_instantup_slug_cat', true);
        }

        if (get_option('_rewrite_project_slug_tag')) {
            update_option('changed_instantup_slug_tag', true);
        }

        update_option('changed_instantup_slug_cnt', true);
    }

    /**
     * Add new menu item to the admin navigation and some fields.
     */
    public function page_options()
    {
        $prefix = self::get_type_prefix(); // iu
        $framework = Container::make('theme_options', 'InstantUploader');
        $framework->set_icon(INSTANTUP_URL . 'data/assets/img/icon-m.png');

        $api_notice = '<b style="margin:0;color:red;">' . __('Notice: ', 'instantup') . '</b>';
        $api_notification_dom_text = wp_sprintf(__('When restricting your Maps JavaScript API Key, make sure to accept requests from your HTTP referrer:  <b> %s/*</b>', 'instantup'), home_url());
        $apiKey = get_option('_firebase_auth', '');

        //Tab General
        $post_types = get_post_types(array(
            'public' => 1,
        ));
        unset($post_types['attachment'], $post_types['iu_templates']);

        if ($iu_post_type = get_option('_iu_custom_type_slug')) {
            $select_post_type = array_diff($post_types, $iu_post_type);
        } else {
            $select_post_type = $post_types;
        }

        $general_array = array(
            Field::make('text', 'pap_google_maps_api_key', __('Maps JavaScript API', 'instantup'))
                ->set_help_text($api_notice . $api_notification_dom_text . $this->iu_test_api_button_html(__('Test JavaScript API', 'instantup'), 'profolio_js_api_test')),
            Field::make('checkbox', 'iu_disable_maps', 'Disable maps until API key is provided here')
                ->set_classes('iu-disable-maps')
                ->set_option_value('yes')
                ->set_default_value('yes'),

            Field::make('separator', $prefix . '_connection_saas', __('Sync with InstantUploader', 'instantup'))
                ->set_classes($prefix . '_option_wrap_minimal')
                ->set_help_text($this->iu_test_api_button_html(__('Sync now', 'instantup'), $prefix . '_btn_sync_saas', 'Data send to saas', 'Data no send to saas')),

        );

        //update_option('_firebase_alternate_access', true);

        if (get_option('_firebase_alternate_access', false)) {
            $temp_html = '<strong>' . __('InstantUploader API Key', 'instantup') . '</strong>';

            $temp_html .= $this->iu_test_api_button_html(__('Test InstantUploader API', 'instantup'), 'firebase_api_test', '', '', $apiKey);

            array_unshift($general_array, Field::make('html', 'firebase_access_txt')->set_html($temp_html));
        } else {
            if (get_option('_firebase_auth')) {
                array_unshift($general_array, Field::make('text', 'firebase_auth', __('InstantUploader API Key', 'instantup'))
                    ->set_classes('firebase-auth d-none')
                    ->set_help_text($this->iu_test_api_button_html(__('Test InstantUploader API', 'instantup'), 'firebase_api_test')));
            } else {
                $config_link = '//';
                $config_link .= get_option('_iu_whitelabel_domain') ?: 'app.instantuploader.com';
                $config_link .= '/settings/integrations/wordpresswebsites';

                array_unshift($general_array, Field::make('html', 'crb_information_text22')
                    ->set_html('<strong>' . __('InstantUploader API', 'instantup') . '</strong><p>' . __('Integration is not configured', 'instantup') . '</p> <a href="' . $config_link . '">' . __('Go to integration', 'instantup') . '</a>'));
            }
        }

        $framework->add_tab(__('General', 'instantup'), $general_array);

        //Tab Customizing Slugs
        if ($custom_type_posts = get_option('_' . $prefix . '_custom_type_posts')) {
            $help_text_post = esc_html__('It will be used in the url. For example: http://your-website.com/SLUG/post-name/', 'instantup');
            $help_text_tax = esc_html__('It will be used in the url. For example: http://your-website.com/SLUG/tags-and-cat-name/', 'instantup');

            //Slug for posts
            $slugs_tab_arr = array(
                Field::make('separator', 'post_separator', __('Posts Slug'))->set_help_text($help_text_post),
            );

            //START duplicate name check
            $unique = [];
            $names = [];

            foreach ($custom_type_posts as $item) {
                if (isset($item['name']) && !isset($names[$item['name']])) {
                    $names[$item['name']] = true;
                    $unique[] = $item;
                }
            }
            //END duplicate name check

            $temp_arr = array();
            if ($unique) {
                foreach ($unique as $item) {
                    if (isset($item['slug'], $temp_arr[$item['slug']])) {
                        continue;
                    }
                    else if (isset($item['slug'], $item['name']) && !empty($item['slug'] && !empty($item['name']))) {
                        $slug = $this->cleanup_post_type_slug($item['slug']);
                        $temp_arr[$slug] = 1;

                        $slugs_tab_arr[] = Field::make('text', 'rewrite_project_slug_' . $slug, esc_html__('For ' . $item['name'], 'instantup'))
                            ->set_width(50)
                            ->set_attribute('placeholder', 'default: ' . $slug);
                    }
                }
            }

            //Slug for taxonomy
            $type_prefix = self::get_type_prefix();
            $taxonomy_cat = $type_prefix . '_categories';
            $taxonomy_tag = $type_prefix . '_tags';

            if (!taxonomy_exists($taxonomy_cat)) {
                $types = new Types();
                $types->new_taxonomy();
            }

            $slugs_tab_arr[] = Field::make('separator', 'slug_separator', __('Cat and Tag Slug'))
                ->set_help_text($help_text_tax);
            $slugs_tab_arr[] = Field::make('text', 'rewrite_project_slug_tag', esc_html__('For tag', 'instantup'))
                ->set_attribute('placeholder', 'default: ' . $taxonomy_tag)
                ->set_width(50);
            $slugs_tab_arr[] = Field::make('text', 'rewrite_project_slug_cat', esc_html__('For cat', 'instantup'))
                ->set_attribute('placeholder', 'default: ' . $taxonomy_cat)
                ->set_width(50);//TODO here can modify slug category or tag
        } else {
            $slugs_tab_arr[] = Field::make('html', 'crb_information_text')
                ->set_html('<h2>' . esc_html__('You can update slugs after importing some content.', 'instantup') . '</h2>');
        }

        $framework->add_tab(esc_html__('Customize Slugs', 'instantup'), $slugs_tab_arr);

        //Tab Customizing Layout
        $framework->add_tab(esc_html__('Customize Layout', 'instantup'), array(
            Field::make('separator', $prefix . '_separator_all', __('Global')),
            Field::make('text', 'iu_margin_top_all', __('Margin top'))
                ->set_width(33)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_margin_bottom__all', __('Margin bottom'))
                ->set_width(33)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_set_for_tag__all', __('Set for this tag'))
                ->set_width(33)
                ->set_attribute('placeholder', 'default #content'),

            Field::make('separator', $prefix . '_separator_cat', __('Category/Tag Pages')),
            Field::make('text', $prefix . '_margin_top_cat', __('Margin top'))
                ->set_width(33)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_margin_bottom_cat', __('Margin bottom'))
                ->set_width(33)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_set_for_tag_cat', __('Set for this tag'))
                ->set_width(33)
                ->set_attribute('placeholder', 'default #content'),

            Field::make('separator', $prefix . '_separator_post', __('Content Posts')),
            Field::make('checkbox', $prefix . '_use_padding_post', __('Use "padding" instead of "margin"'))
                ->set_option_value('yes'),
            Field::make('text', $prefix . '_margin_top_post', __('Margin top'))
                ->set_width(33)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_margin_bottom_post', __('Margin bottom'))
                ->set_width(33)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_set_for_tag_post', __('Set for this tag'))
                ->set_width(33)
                ->set_attribute('placeholder', 'default #content'),

            Field::make('separator', $prefix . '_separator_spec', __('Specific Posts')),
            Field::make('checkbox', $prefix . '_use_padding_spec', __('Use "padding" instead of "margin"'))
                ->set_option_value('yes'),
            Field::make('text', $prefix . '_margin_top_spec', __('Margin top'))
                ->set_width(25)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('text', $prefix . '_margin_bottom_spec', __('Margin bottom'))
                ->set_width(25)
                ->set_attribute('type', 'number')
                ->set_attribute('placeholder', 'For example 100'),

            Field::make('association', 'iu_association_spec', __('Association'))->set_width(50)->set_types(array(
                array(
                    'type' => 'post',
                    'post_type' => 'page',
                ),
            )),

            Field::make('text', $prefix . '_default_gallery_images', esc_html__('Default Max number of Gallery images', 'instantup'))
                ->set_attribute('placeholder', 'default 15'),
        ));

        //Tab Other Settings
        $framework->add_tab(esc_html__('Other Settings', 'instantup'), array(
            Field::make('checkbox', $prefix . '_use_elementor_template', __('Allow use of Elementor templates'))
                ->set_option_value('yes')
                ->set_width(40),

            Field::make('checkbox', $prefix . '_duplicate_categories', __('For blog posts, use native categories'))
                ->set_default_value('yes')
                ->set_option_value('yes')
                ->set_width(40),

            Field::make('checkbox', 'disable_other_google_map', __('Disable other Google map scripts'))
                ->set_option_value('yes')
                ->set_width(40),

            Field::make('checkbox', $prefix . '_enable_seo_meta', __('Enable SEO meta'))
                ->set_option_value('yes')
                ->set_help_text('Before turning on. You should disable meta of their <u>other seo plugins</u> for our content types.')
                ->set_width(40),

            Field::make('html', 'cleanup-content')->set_html('
                        <div class="import-projects-row cleanup-content-row">
                            <button id="iu-cleanup-content" 
                            class="button button-large button-primary" type="button">Cleanup content</button>
                            
                            <img class="import_loader" alt="ajax loader"
                                src="' . INSTANTUP_URL . '/data/assets/img/ajax-loader.gif"/>
                            
                            <div class="delete_wrap_count">number of deleted posts <span></span></div>
                            <small class="cleanup-content-help">Delete all content that does not match that of saas.</small>
                        </div>
'),

            Field::make('separator', $prefix . '_sync_data_account', __('Sync data account', 'instantup'))
                ->set_width(40)
                ->set_classes($prefix . '_option_wrap_minimal iu-data-account-output')
                ->set_help_text($this->iu_data_account_output()),

            Field::make('select', 'iu_schema', __('Select Schema Default'))
                ->set_width(40)
                ->set_classes('sssss')
                ->set_options(array(
                    '' => '',
                ))
                ->add_options(array(
                    'localbusiness' => 'LocalBusiness',
                    'organization' => 'Organization',
                    'place' => ' Place',
                    'thing' => 'Thing',
                )),

            Field::make('separator', 'blog_main_separator', __('Where add blog with posts?'))
                ->set_classes($prefix . '-blog-main-separator'),
            Field::make('select', 'whither_blog_type', __('Post type'))
                ->set_width(40)
                ->set_classes($prefix . '_clear_bt ' . $prefix . '-other-settings')
                ->set_options(array(
                    '' => 'select post type',
                ))
                ->add_options($select_post_type ?? array()),

            Field::make('association', $prefix . '_blog_author', __('Set Blog Author'))
                ->set_max(1)
                ->set_width(60)
                ->set_types(array(
                    array(
                        'type' => 'user',
                    ),
                )),

            Field::make('separator', 'import_export_separator', __('Import \ Export templates'))
                ->set_classes($prefix . '-blog-main-separator'),

            Field::make('html', 'export_templates')->set_width(60)->set_html($this->export_templates()),

            Field::make('html', 'import_templates')->set_width(35)->set_html($this->import_templates()),

            Field::make('textarea', 'iu_header_custom_code', __('Header custom code'))
                ->set_rows(4)
                ->set_attribute('placeholder', 'Enter your custom code'),
            Field::make('textarea', 'iu_footer_custom_code', __('Footer custom code'))
                ->set_rows(4)
                ->set_attribute('placeholder', 'Enter your custom code'),

        ));

        //Tab Import
        $framework->add_tab(esc_html__('Import', 'instantup'), array(
            Field::make('html', 'run_import_firebase')->set_html($this->run_import_firebase()),
        ));

        if (defined('INSTANTUP_ENABLE_LOGS') && INSTANTUP_ENABLE_LOGS == true) {
            ob_start(); ?>
            <a
                    href="<?php echo home_url('wp-admin/admin.php?page=crb_carbon_fields_container_instantup_for_elementor.php&localseomap_clear_logs=true'); ?>"
                    class="button button-primary button-large">
                <?php esc_html_e('Clear logs', 'instantup'); ?>
            </a>
            <?php
            $clear_button = ob_get_clean();

            $framework->add_tab(esc_html__('Logs', 'instantup'), array(
                Field::make('html', 'pap_knowledge_logs')
                    ->set_html('<div style="text-align: right"><a target="_blank" href="https://www.localseomap.com/knowledge-base/logs/">Get help</a></div>'),

                Field::make('html', 'pap_logs_response', esc_html__('Errors', 'instantup'))
                    ->set_html('<p>' . esc_html__('Error logs', 'instantup') . '</p><pre style="background: grey;padding: 10px;color: #fff;overflow-y: scroll;height: 400px;width: 870px">' . get_option('localseomap_error_logs') . '</pre>'),

                Field::make('html', 'pap_logs_webhooks', esc_html__('Logs', 'instantup'))
                    ->set_html('<p>' . esc_html__('Logs', 'instantup') . '</p><pre style="background: grey;padding: 10px;color: #fff;overflow-y: scroll;height: 400px;width: 870px">' . get_option('localseomap_success_logs') . '</pre>'),

                Field::make('html', 'pap_logs_clear_button', esc_html__('Clear logs', 'instantup'))
                    ->set_html($clear_button),
            ));
        }
    }

    public function run_import_firebase()
    {
        ob_start(); ?>
        <div id="import_firebase_box" class="import_form import_projects">
            <button id="run-import-firebase" class="button button-large button-primary" type="button">
                <?php esc_html_e('Import data', 'instantup'); ?></button>

            <div class="import-projects-row">
                <label for="skip_existing_projects" class="import-projects-option skip-projects">
                    <input type="checkbox" value="1" id="skip_existing_projects">
                    <span><?php esc_html_e('Skip existing projects', 'instantup'); ?></span>
                </label>

                <label for="iu_only_published" class="import-projects-option">
                    <input type="checkbox" checked value="1" id="iu_only_published">
                    <span><?php esc_html_e('Imports only with status "Published"', 'instantup'); ?></span>
                </label>
            </div>

            <div class="import-projects-row import-projects-log-row">
                <div class="import_wrap_count">
                    <?php esc_html_e('Number of imported projects', 'instantup'); ?>
                    <span class="current_imported">0</span> /
                    <span class="number_projects">0</span>
                </div>
                <img class="import_loader" alt="ajax loader"
                     src="<?php echo INSTANTUP_URL; ?>/data/assets/img/ajax-loader.gif"/>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    public function export_templates()
    {
        $posts = get_posts(array(
            'numberposts' => 100,
            'post_type' => 'iu_templates',
            'suppress_filters' => true,
        ));

        ob_start(); ?>
        <form method="post" class="iu-export-import">
            <p class="export-template-legend"><?php echo __('Export templates'); ?></p>

            <div class="iu-export-import-row">
                <p class="iu-export-import-title"><?php echo __('Select Templates'); ?></p>

                <ul class="iu-export-import-items">
                    <?php foreach ($posts as $post) : ?>
                        <li>
                            <label>
                                <input type="checkbox" autocomplete="off" name="templates[]"
                                       value="<?php echo $post->ID ?>">
                                <?php echo $post->post_title ?>
                            </label>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

            <div class="iu-export-import-wrapper">
                <button id="iu_export_btn" type="button" class="button iu-export-import-btn button-primary">
                    <?php echo __('Export File'); ?>
                </button>
                <img class="iu-export-import-loader" alt="ajax loader"
                     src="<?php echo INSTANTUP_URL; ?>/data/assets/img/ajax-loader.gif"/>
            </div>


            <small class="iu-export-import-help"><?php echo __('Select the posts you would like to export. Use the download button to
                export to a .json file which
                you can then import to another IU installation.'); ?></small>
        </form>
        <?php return ob_get_clean();
    }

    public function import_templates()
    {
        ob_start(); ?>
        <form method="post" class="iu-export-import">
            <p class="export-template-legend"><?php echo __('Import templates'); ?></p>

            <div class="iu-export-import-row">
                <p class="iu-export-import-title"><?php echo __('Select File'); ?></p>
                <input id="iu_import_file" type="file" autocomplete="off" name="iu_import_file">
            </div>

            <div class="iu-export-import-wrapper">
                <button id="iu_import_btn" type="button" class="button iu-export-import-btn button-primary">
                    <?php echo __('Import File'); ?>
                </button>
                <img class="iu-export-import-loader" alt="ajax loader"
                     src="<?php echo INSTANTUP_URL; ?>/data/assets/img/ajax-loader.gif"/>
            </div>

            <small class="iu-export-import-help"><?php echo __('If you have templates in another site, WordPress can import those into
                this site. To get started,
                choose a file to import from.'); ?></small>
        </form>
        <?php return ob_get_clean();
    }

}