<?php


namespace InstantUploader;

use InstantUploader\Admin;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class Templates
 * @since  1.0.0
 */
class Templates {

	private $prefix;
	private $tax_arr;

	public function __construct() {
		$this->prefix  = Admin::get_type_prefix();
		$this->tax_arr = array(
			$this->prefix . '_categories',
			$this->prefix . '_tags',
			$this->prefix . '_label_tags',
		);
	}

	public function init() {
		add_action( 'iu_single_content', array( $this, 'iu_content' ) );
		add_action( 'iu_cat_tag_content', array( $this, 'cat_tag_content' ) );
		add_filter( 'template_include', array( $this, 'iu_include_template_pages' ), 99 );
		add_action( 'pre_get_posts', array( $this, 'fixed_count_post_in_cat_tag' ) );
		add_action( 'elementor/dynamic_tags/register', array( $this, 'register_new_dynamic_tags' ) );
	}


	public function register_new_dynamic_tags( $dynamic_tags_manager ) {
		require_once( INSTANTUP_PATH . 'src/elementor/dynamic-tags/iu-dynamic-tag.php' );

		$dynamic_tags_manager->register( new \IU_Dynamic_Tag() );
	}

	public function fixed_count_post_in_cat_tag( $query ) {
		if ( is_tax( $this->tax_arr ) ) {
			$query->set( 'posts_per_page', '30' );
		}
	}


	/**
	 * Include template pages.
	 */
	public function iu_include_template_pages( $template ) {
		if ( is_tax( $this->tax_arr ) ) {
			$template = plugin_dir_path( __DIR__ ) . 'data/template/categories.php';
		}

		if ( $all_type = get_option( "_{$this->prefix}_custom_type_slug" ) ) {
			if ( is_post_type_archive( $all_type ) ) {
				$template = plugin_dir_path( __DIR__ ) . 'data/template/categories.php';
			}

			if ( is_singular( $all_type ) ) {
				if ( get_option( "_{$this->prefix}_use_elementor_template" ) ) {
					$query = new \WP_Query( array(
						'posts_per_page' => 1,
						'post_type'      => 'elementor_library',
						'fields'         => 'ids',
						'meta_query'     => array(
							array(
								'key'     => '_elementor_conditions',
								'value'   => 'include/singular/' . get_post_type(),
								'compare' => 'LIKE',
							),
						),
					) );

					if ( $query->posts ) {
						return $template;
					}

					wp_reset_query();
				}

				$template = plugin_dir_path( __DIR__ ) . 'data/template/single.php';
			}
		}

		return $template;
	}

	/**
	 * show content in single
	 */
	public function iu_content() {
		if ( $template_top = get_option( '_template_for_content' ) ) {

			foreach ( $template_top as $key => $template_id ) {
				if ( is_singular( $key ) ) : ?>
                    <div class="profolio-col-lg-12">
						<?php echo apply_filters( 'the_content', get_the_content( '', '', $template_id ) ); ?>
                    </div>
				<?php endif;
			}
		}
	}

	/**
	 * show content in category or tags
	 */
	public function cat_tag_content() {
		if ( $template_cat_tag = get_option( '_template_for_cat_tag' ) ) {
			$queried_object  = get_queried_object();
			$current_term_id = $queried_object->term_id ?? '0';
			$that_id         = false;
			$all_id          = false;

			foreach ( $template_cat_tag as $temp_id => $arr_ids ) {
				if ( is_array( $arr_ids ) && in_array( (string)$current_term_id, $arr_ids, true ) && is_tax( $this->tax_arr, $arr_ids ) ) {
				    $that_id = $temp_id;
				}

				if ( 'all' === $arr_ids ) {
					$all_id = $temp_id;
				}
			}

			if (!$that_id){
			    if ($all_id){
				    $that_id = $all_id;
			    } else{
				    $that_id = $template_cat_tag['all'] ?? false;
			    }
			}
			if ($that_id){
				echo apply_filters( 'the_content', get_the_content( '', '', $that_id ) );
			}
		}
	}


}