<?php

namespace InstantUploader;

if ( ! defined( 'WPINC' ) ) {
	die;
}

class Types extends Admin {

	/**
	 * Types constructor.
	 * @since  1.0.0
	 * @access public
	 */
	public function __construct() {
		Admin::__construct();
	}

	public function init() {
		if ( get_option( '_iu_custom_type_posts' ) ) {
			add_action( 'init', array( $this, 'new_taxonomy' ), 10 );
			add_action( 'init', array( $this, 'custom_posts_type' ), 11 );
			add_action( 'init', array( $this, 'redirect_page' ), 11 );
			add_action( 'admin_menu', array( $this, 'instantup_menu' ) );
			add_action( 'admin_menu', array( $this, 'instantup_submenu' ) );
		}

		add_action( 'init', array( $this, 'default_custom_posts_type' ) );
	}

	public function redirect_page() {
		if ( $iu_post_type_slug = get_option( '_iu_custom_type_slug' ) ) {

			$iu_post_type_slug[] = 'tag';
			$iu_post_type_slug[] = 'cat';

			foreach ( $iu_post_type_slug as $item ) {
				$new = strtolower( (string) get_option( "_rewrite_project_slug_{$item}", '' ) );
				$old = strtolower( (string) get_option( "_rewrite_project_slug_{$item}_old", '' ) );

				if ( empty( $new ) ) {
					if ( $item === 'tag' ) {
						$new = 'iu_tags';
					} elseif ( $item === 'cat' ) {
						$new = 'iu_categories';
					} else {
						$new = $item;
					}
				}

				if ( empty( $old ) ) {
					if ( $item === 'tag' ) {
						$old = 'iu_tags';
					} elseif ( $item === 'cat' ) {
						$old = 'iu_categories';
					} else {
						$old = $item;
					}
				}

				if ( $old === $new ) {
					continue;
				}

				if ( stripos( $_SERVER['REQUEST_URI'], "/{$old}/" ) !== false ) {
					$request_uri = str_replace( "/{$old}/", "/{$new}/", $_SERVER['REQUEST_URI'] );
					wp_redirect( home_url() . "{$request_uri}", '301' );
					exit;
				}
			}
		}
	}

	public function instantup_menu() {
		$icon_projects = plugin_dir_url( __DIR__ ) . 'data/assets/img/svg/profolio-icon.svg';

		add_menu_page(
			'IU Content',
			'IU Content',
			'edit_posts',
			'projects-type',
			'',
			$icon_projects,
			5
		);
	}

	public function instantup_submenu() {
		$prefix          = self::get_type_prefix();//iu
		$get_custom_type = get_option( '_iu_custom_type_posts' );
		$custom_type     = reset( $get_custom_type );
		$post_type       = $custom_type['slug'] ?? 'post';

		add_submenu_page(
			'projects-type',
			'Categories',
			'Categories',
			'edit_posts',
			'edit-tags.php?taxonomy=' . $prefix . '_categories&post_type=' . $post_type
		);

		add_submenu_page(
			'projects-type',
			'Label/Tags',
			'Label/Tags',
			'edit_posts',
			'edit-tags.php?taxonomy=' . $prefix . '_label_tags&post_type=' . $post_type
		);

		add_submenu_page(
			'projects-type',
			'Tags',
			'Tags',
			'edit_posts',
			'edit-tags.php?taxonomy=' . $prefix . '_tags&post_type=' . $post_type
		);
	}

	public function new_taxonomy() {
		$prefix = self::get_type_prefix();

		if ( get_option( '_iu_duplicate_categories' ) ) {
			$posts_type_slug = array();
		} else {
			$posts_type_slug = array( 'post' );
		}

		if ( $all_type_posts = get_option( '_iu_custom_type_posts' ) ) {
			foreach ( $all_type_posts as $all_type_post ) {
				$posts_type_slug[] = $all_type_post['slug'];
			}
		}

		//Categories taxonomy
		$cat_arr = array(
			'label'             => esc_html__( 'IU Categories', 'instantup' ),
			'labels'            => array(
				'name'              => esc_html__( 'IU Categories', 'instantup' ),
				'singular_name'     => esc_html__( 'IU Categories', 'instantup' ),
				'search_items'      => esc_html__( 'Search Categories', 'instantup' ),
				'all_items'         => esc_html__( 'All Categories', 'instantup' ),
				'parent_item'       => esc_html__( 'Parent Categories', 'instantup' ),
				'parent_item_colon' => esc_html__( 'Parent Categories:', 'instantup' ),
				'edit_item'         => esc_html__( 'Edit Categories', 'instantup' ),
				'update_item'       => esc_html__( 'Update Categories', 'instantup' ),
				'add_new_item'      => esc_html__( 'Add New Categories', 'instantup' ),
				'new_item_name'     => esc_html__( 'New Categories Name', 'instantup' ),
				'menu_name'         => esc_html__( 'IU Categories', 'instantup' ),
			),
			'hierarchical'      => true,
			'show_in_rest'      => true,
			'show_admin_column' => true,
		);

		$slug_cat = strtolower( str_replace( ' ', '_', get_option( '_rewrite_project_slug_cat' ) ) );
		if ( $slug_cat ) {
			$cat_arr['rewrite'] = array( 'slug' => $slug_cat );

			if ( get_option( 'changed_instantup_slug_cat' ) ) {
				update_option( 'changed_instantup_slug_cat', false );
				global $wp_rewrite;
				$wp_rewrite->flush_rules( true );
				flush_rewrite_rules();
			}
		}
		register_taxonomy( $prefix . '_categories', $posts_type_slug, $cat_arr );

		//Label-tag taxonomy
		$label_tags_arr = array(
			'label'             => esc_html__( 'IU Label/Tags', 'instantup' ),
			'labels'            => array(
				'name'              => esc_html__( 'IU Label/Tags', 'instantup' ),
				'singular_name'     => esc_html__( 'IU Label/Tags', 'instantup' ),
				'search_items'      => esc_html__( 'Search Label/Tags', 'instantup' ),
				'all_items'         => esc_html__( 'All Label/Tags', 'instantup' ),
				'parent_item'       => esc_html__( 'Parent Label/Tags', 'instantup' ),
				'parent_item_colon' => esc_html__( 'Parent Label/Tags:', 'instantup' ),
				'edit_item'         => esc_html__( 'Edit Label/Tags', 'instantup' ),
				'update_item'       => esc_html__( 'Update Label/Tags', 'instantup' ),
				'add_new_item'      => esc_html__( 'Add New Label/Tags', 'instantup' ),
				'new_item_name'     => esc_html__( 'New Label/Tags Name', 'instantup' ),
				'menu_name'         => esc_html__( 'IU Label/Tags', 'instantup' ),
			),
			'hierarchical'      => true,
			'show_in_rest'      => true,
			'show_admin_column' => true,
		);
		register_taxonomy( $prefix . '_label_tags', $posts_type_slug, $label_tags_arr );

		//Tags taxonomy
		$tags_arr = array(
			'label'             => esc_html__( 'IU Tags', 'instantup' ),
			'labels'            => array(
				'name'              => esc_html__( 'IU Tags', 'instantup' ),
				'singular_name'     => esc_html__( 'IU Tags', 'instantup' ),
				'search_items'      => esc_html__( 'Search Tags', 'instantup' ),
				'all_items'         => esc_html__( 'All Tags', 'instantup' ),
				'parent_item'       => esc_html__( 'Parent Tags', 'instantup' ),
				'parent_item_colon' => esc_html__( 'Parent Tags:', 'instantup' ),
				'edit_item'         => esc_html__( 'Edit Tags', 'instantup' ),
				'update_item'       => esc_html__( 'Update Tags', 'instantup' ),
				'add_new_item'      => esc_html__( 'Add New Tags', 'instantup' ),
				'new_item_name'     => esc_html__( 'New Tags Name', 'instantup' ),
				'menu_name'         => esc_html__( 'IU Tags', 'instantup' ),
			),
			'show_in_rest'      => true,
			'show_admin_column' => true,
		);

		$slug_tag = strtolower( str_replace( ' ', '_', get_option( '_rewrite_project_slug_tag' ) ) );
		if ( $slug_tag ) {
			$tags_arr['rewrite'] = array( 'slug' => $slug_tag );

			if ( get_option( 'changed_instantup_slug_tag' ) ) {
				update_option( 'changed_instantup_slug_tag', false );
				global $wp_rewrite;
				$wp_rewrite->flush_rules( true );
				flush_rewrite_rules();
			}
		}

		register_taxonomy( $prefix . '_tags', $posts_type_slug, $tags_arr );
	}

	public function custom_posts_type() {
		$prefix         = self::get_type_prefix();
		$all_type_posts = get_option( '_iu_custom_type_posts' );

		//START delete AI post type IT's temporarily
		$post_type          = 'iu_ai_writeups';
		$all_type_posts_up  = false;
		$all_posts_slugs_up = false;
		$all_posts_slugs    = get_option( '_iu_custom_type_slug' );
		$temp_posts_slugs   = array_flip( $all_posts_slugs );

		foreach ( $all_type_posts as $index => $item ) {
			if ( $post_type === $item['slug'] ) {
				unset( $all_type_posts[ $index ] );
				$all_type_posts_up = true;
			}
		}
		if ( isset( $temp_posts_slugs[ $post_type ] ) ) {
			unset( $all_posts_slugs[ $temp_posts_slugs[ $post_type ] ] );
			$all_posts_slugs_up = true;
		}
		if ( $all_type_posts_up ) {
			update_option( '_iu_custom_type_posts', $all_type_posts );
		}
		if ( $all_posts_slugs_up ) {
			update_option( '_iu_custom_type_slug', $all_posts_slugs );
		}
		//END delete AI

		foreach ( $all_type_posts as $key => $type_post ) {
			$post_arr = array(
				'public'            => true,
				//'has_archive'       => true, //delete such pages site.com/iu_project/
				'show_in_rest'      => true,
				'supports'          => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
				'show_in_menu'      => 'projects-type',
				'show_ui'           => true,
				'show_in_nav_menus' => true,
				'show_in_admin_bar' => true,
				'taxonomies'        => array( $prefix . '_tags', $prefix . '_categories' ),
				'menu_icon'         => plugin_dir_url( __DIR__ ) . 'data/assets/img/svg/profolio-icon.svg',
			);

			$post_arr['labels'] = array(
				'name'          => _x( $type_post['name'], 'instantup' ),
				'singular_name' => _x( $type_post['name'], 'instantup' ),
			);

			$slug_rewrite = strtolower( str_replace( ' ', '_', get_option( '_rewrite_project_slug_' . $type_post['slug'] ) ) );

			if  ('_rewrite_project_slug_features' === $slug_rewrite){
				$slug_rewrite = '_rewrite_project_slug_features_test';
			}

			if ( ! $slug_rewrite ) {
				$slug_rewrite = $type_post['slug'];
			}

			$post_arr['rewrite'] = array(
				'slug'       => $slug_rewrite,
				'with_front' => false,
			);
			$post_arr['rest_base'] = $slug_rewrite;

			if ( get_option( 'changed_instantup_slug_cnt' ) ) {
				update_option( 'changed_instantup_slug_cnt', false );
				global $wp_rewrite;
				$wp_rewrite->flush_rules( true );
				flush_rewrite_rules();
			}


			register_post_type( $type_post['slug'], $post_arr );

		}
	}

	public function default_custom_posts_type() {
		$type_prefix = self::get_type_prefix();

		register_post_type( $type_prefix . '_templates',
			array(
				'labels'             => array(
					'name'          => _x( 'Templates', 'instantup' ),
					'singular_name' => _x( 'Template', 'instantup' ),
				),
				'public'             => true,
				'publicly_queryable' => false,
				'has_archive'        => true,
				'show_in_rest'       => true,
				'supports'           => array( 'title', 'editor', 'author' ),
				'show_in_menu'       => 'crb_carbon_fields_container_instantuploader.php',
				'show_ui'            => true,
			)
		);

		register_post_type( $type_prefix . '_temp_post',
			array(
				'labels'       => array(
					'name'          => _x( 'Temp', 'instantup' ),
					'singular_name' => _x( 'tepm', 'instantup' ),
				),
				'public'       => false,
				'show_in_rest' => true,
				'supports'     => array( 'title', 'editor', 'custom-fields', 'thumbnail', ),
			)
		);
	}

}
