jQuery(function ($) {

    if (typeof window.google === 'undefined') {
        return;
    }

    /*====================
     START невідома хрень
     ====================*/
    $('.swiper-thumb').on('click', function () {
        $('.profolio-slider-frame').addClass('profolio-show-slider');
    });

    $('.profolio-close-btn').on('click', function () {
        $('.profolio-slider-frame').removeClass('profolio-show-slider');
    });

    $('.profolio-sellect-all').change(function () {
        var checkboxes = $(this).closest('.profolio-search-dropdown').find(':checkbox');
        checkboxes.prop('checked', $(this).is(':checked'));
        $('.profolio-d-all').toggleClass('profolio-d-true');
        $('.profolio-d-none').toggleClass('profolio-d-true');
    });

    $('.profolio-open-dropdown').on('click', function () {
        var parent = $(this).closest('.profolio-input-frame');

        var isActive = parent.find('.profolio-search-dropdown').hasClass('profolio-search-dropdown-active') ? true : false;
        console.log(isActive);

        $('.profolio-search-dropdown').removeClass('profolio-search-dropdown-active');

        if (!isActive) {
            parent.find('.profolio-search-dropdown').toggleClass('profolio-search-dropdown-active');
        }
    });
    /*====================
     END невідома хрень
     ====================*/

    /*====================
     START Swiper Project details
     ====================*/
    $('.swiper-thumb').on('click', function () {
        $('.profolio-slider-frame').addClass('profolio-show-slider');
    });

    function swiper_project_details() {
        let profolioSwiperDetails       = $('.profolio-swiper-details'),
            profolioSwiperDetailsLength = profolioSwiperDetails.find(
                '.swiper-slide').length;

        if (!profolioSwiperDetails.length) {
            return;
        }

        let args_slider = {
            slidesPerView: 1,
            spaceBetween:  15,
            breakpoints:   {
                992: {
                    slidesPerView: '3',
                },
                767: {
                    slidesPerView: '2',
                },
            },
            navigation:    {
                nextEl: '.profolio-button-next',
                prevEl: '.profolio-button-prev',
            },

        };

        if (typeof iu_carousel_data != 'undefined') {
            let carousel_settings = JSON.parse(
                window.iu_carousel_data.carousel_settings);

            if (carousel_settings.slidesPerView) {
                args_slider['slidesPerView'] = args_slider['breakpoints']['992']['slidesPerView'] = carousel_settings.slidesPerView;
            }

            if (carousel_settings.slidesPerGroup) {
                args_slider['slidesPerGroup'] = carousel_settings.slidesPerGroup;
            }

            if (carousel_settings.spaceBetween) {
                args_slider['spaceBetween'] = carousel_settings.spaceBetween;
            }
        }

        if (window.outerWidth < 767 && profolioSwiperDetailsLength) {
            args_slider.pagination = {
                el:        '.swiper-pagination',
                clickable: true,
            };
        }

        if (window.outerWidth > 767 && window.outerWidth < 992
            && profolioSwiperDetailsLength > 2) {
            args_slider.pagination = {
                el:        '.swiper-pagination',
                clickable: true,
            };
        }

        if (window.outerWidth > 992 && profolioSwiperDetailsLength > 3) {
            args_slider.pagination = {
                el:        '.swiper-pagination',
                clickable: true,
            };
        }

        new Swiper('.profolio-swiper-details', args_slider);
    }

    setTimeout(() => {
        swiper_project_details();
    }, 100);

    if ($('.swiper-thumb').length) { //if gallery
        var galleryThumbs = new Swiper('.swiper-thumb', {
            spaceBetween:          10,
            slidesPerView:         4,
            watchSlidesVisibility: true,
            watchSlidesProgress:   true,
            breakpoints:           {
                992: {
                    slidesPerView: '3',
                },
                767: {
                    slidesPerView: '2',
                },
            },
        });
    }

    if ($('.swiper-zoom').length) {
        new Swiper('.swiper-zoom', {
            spaceBetween: 10,
            effect:       'fade',
            navigation:   {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            thumbs:       {
                swiper: galleryThumbs,
            },
        });
    }
    /*====================
     END Swiper Project details
     ====================*/

    /*======================
     START Profolio Map on the Detail Page
     ======================*/
    function profolio_display_map() {
        $('.profolio-details-map-frame img').on('load', function () {
            $(this).parent().show();
        });
    }

    profolio_display_map();
    /*======================
     END Profolio Map on the Detail Page
     ======================*/

    /*====================
     START Before/After block
     ====================*/
    function profolio_before_after_init() {

        if ($('.ba-slider').length) {
            $('.ba-slider').beforeAfter();
        }
    }

    profolio_before_after_init();
    /*====================
     END Before/After block
     ====================*/

    /*====================
     Project modal init
     ====================*/
    let cache        = {},
        current_path = window.location.pathname;

    function set_to_template(data, id) {
        var template = wp.template(id);
        return template(data);
    }

    $('.JS_profolio_project_item.enable_modal a').on('click', function (e) {
        e.preventDefault();

        let project_path = this.href.replace(/^.*\/\/[^\/]+/, ''),
            $wrap        = $(this).closest('.enable_modal'),
            post_id      = $wrap.data('post-id');

        $.magnificPopup.open({
            items:     {
                src:  '<div class="profolio-project-modal"></div>',
                type: 'inline',
            },
            callbacks: {

                open: function () {
                    $('html').css('overflow-y', 'hidden');
                }, // over-write URL when popup is opened

                close: function () {
                    $('html').css('overflow-y', 'auto');
                    history.pushState('', document.title, current_path);
                }, // over-write URL when popup is closed
            },
        });

        if (cache[post_id]) {
            let project = cache[post_id];
            let project_path = project.link.replace(/^.*\/\/[^\/]+/, '');
            history.pushState('', project.link, project_path);
            let html = set_to_template(cache[post_id], 'profolio-modal-detail');
            $('.profolio-project-modal').html(html);
            return;
        }

        $.get(
            wpApiSettings.root + wpApiSettings.versionString + 'profolio_projects/'
            + post_id,
            function (project) {
                let project_path = project.link.replace(/^.*\/\/[^\/]+/, '');
                history.pushState('', project.link, project_path);
                let html = set_to_template(project, 'profolio-modal-detail');
                $('.profolio-project-modal').html(html);
                cache[post_id] = project;

            },
        );
    });

    window.onpopstate = function (event) {
        if (event.target.location.pathname == current_path) {
            $.magnificPopup.close();
        }
    };

    /*====================
     Leads form
     ====================*/
    if ($('.js-show-leads-form').length) {
        $('.js-show-leads-form').magnificPopup({
            type:      'inline',
            preloader: false,
        });
    }

    if ($('.elementor-form').length) {
        $('.elementor-form').each(function () {
            $(this).append(
                '<input type="hidden" name="form_fields[hidden_referrer_page_url]" value="'
                + document.referrer + '" />');
        });
    }

    $('.profolio-leads-form').on('submit', function (e) {
        e.preventDefault();

        var _this = $(this);

        $.ajax({
            type:       'POST',
            url:        instantup_object.ajaxurl,
            data:       {
                action:    'submit_leads_form',
                'request': $(this).serialize(),
            },
            beforeSend: function () {
                var loaderImg = '<div class="rp-cart-loader"><img src="'
                    + instantup_object.directoryurl
                    + '/assets/img/ajax-loader.gif" /></div>';

                $('.profolio-leads-popup').append(loaderImg);
            },
            success:    function (response) {
                var response_data = JSON.parse(response);

                $('.rp-cart-loader').remove();

                if (response_data.status === 200) {
                    _this.find('.form-control').val('');
                }

                $('.profolio-leads-message').html(response_data.message);
            },
            error:      function () {
                $('.profolio-leads-message').html('Something went wrong, try again!');
            },
        });

        return false;
    });

    /*====================
     START Image Bg
     ====================*/
    window.wpc_add_img_bg = function (img_sel, parent_sel) {
        if (!img_sel) {
            console.info('no img selector');
            return false;
        }
        var $parent, $imgDataHidden, _this;
        $(img_sel).each(function () {
            _this = $(this);
            $imgDataHidden = _this.data('s-hidden');
            $parent = _this.closest(parent_sel);
            $parent = $parent.length ? $parent : _this.parent();
            $parent.css('background-image', 'url(' + this.src + ')').addClass('s-back-switch');
            if ($imgDataHidden) {
                _this.css('visibility', 'hidden');
            }
            else {
                _this.hide();
            }
        });
    };
    wpc_add_img_bg('.profolio-bg-img');
    /*====================
     END Image Bg
     ====================*/

    /*====================
     START Share links
     ====================*/
    $('[data-share]').on('click', function (e) {
        e.preventDefault();

        var w          = window,
            url        = $(this).attr('data-share'),
            title      = '',
            w_pop      = 600,
            h_pop      = 600,
            scren_left = w.screenLeft != undefined ? w.screenLeft : screen.left,
            scren_top  = w.screenTop != undefined ? w.screenTop : screen.top,
            width      = w.innerWidth,
            height     = w.innerHeight,
            left       = ((width / 2) - (w_pop / 2)) + scren_left,
            top        = ((height / 2) - (h_pop / 2)) + scren_top,
            newWindow  = w.open(url, title,
                'scrollbars=yes, width=' + w_pop + ', height=' + h_pop + ', top='
                + top + ', left=' + left,
            );

        if (w.focus) {
            newWindow.focus();
        }

        return false;
    });
    /*====================
     END Share links
     ====================*/

    /*====================
     START Light Gallery
     ====================*/
    window['iu_play_lightbox_video'] = function () {
        let $video = $('.lg-current video');
        if ($video.length) {
            $video.get(0).play();
        }
    };

    let $videoGallery = $('.video-gallery'),
        $lightGallery = $('.iu_use_lightGallery');

    if ($videoGallery.length) {
        $videoGallery.lightGallery({
            download: false,
        }).on('onBeforeOpen.lg', function (e) {

            console.log('onBeforeOpen', this);
        });

    }

    if ($lightGallery.length) {
        $lightGallery.each(function (i, el) {
            let mediaOgj = false;

            if (el.parentElement.dataset.mediaOgj) {
                mediaOgj = el.parentElement.dataset.mediaOgj;
            }

            if (mediaOgj && window[mediaOgj]) {

                $('.profolio-slctr').on('click', function (evt) {
                    evt.preventDefault();

                    let item_id = $(this).data('id'),
                        $lg     = $(this).lightGallery({
                            download:  false,
                            loop:      false,
                            index:     parseInt(item_id),
                            dynamic:   true,
                            dynamicEl: JSON.parse(window[mediaOgj].media_list),
                        });

                    $lg.on('onAfterSlide.lg', function () {
                        iu_play_lightbox_video();
                    });

                    $lg.on('onAfterOpen.lg', function () {
                        iu_play_lightbox_video();
                    });
                });

                var params = location.hash.split('&')
                    .map(function (v) {return v.split('=');})
                    .reduce(function (pre, _ref) {
                        var _ref2;

                        var key   = _ref[0],
                            value = _ref[1];
                        return _ref2 = {}, _ref2[key] = value, _ref2;
                    }, {});

                if ($('.profolio-slctr').length && params.slide) {
                    $(this).lightGallery({
                        download:  false,
                        loop:      false,
                        index:     parseInt(params.slide),
                        dynamic:   true,
                        dynamicEl: JSON.parse(window[mediaOgj].media_list),
                    });
                }
            }
        });
    }

    if ($lightGallery.length && $lightGallery.data('lightGallery')) {
        $(this).lightGallery({
            download: false,
            selector: '.profolio-slctr',
            loop:     false,
        });
    }
    /*====================
     END Light gallery
     ====================*/

    /*======================
     START Profolio Filter Slider
     ======================*/
    function profolio_filter_init() {

        if ($('.js-profolio-filter-wrapper').length) {

            $('.js-profolio-filter-frame').find('> div').hide();

            $('.js-profolio-filter-wrapper').each(function () {

                var $container = $(this),
                    data_items = $container.find('.js-profolio-filter-item'),
                    $filters   = $('.js-profolio-filter-frame').find('div');

                var $slide = $container.find('> div');

                var is_category = false;
                $slide.each(function () {
                    var filterValue = $(this).attr('data-category');

                    if (filterValue != '') {
                        //filterValue = '*';
                        is_category = true;
                        $('.js-profolio-filter-frame').find('[data-filter="' + filterValue + '"]').show();
                    }
                });

                if (is_category) {
                    $('.js-profolio-filter-frame').find('[data-filter="*"]').show();
                }

                // Filter
                $filters.on('click', function () {

                    // Show/Hide active class
                    $filters.removeClass('profolio-filter-current');
                    $(this).addClass('profolio-filter-current');

                    var filterValue = $(this).attr('data-filter');

                    // Show/Hide brands item
                    if (filterValue === '*') {
                        $('.js-profolio-filter-wrapper').find('.js-profolio-filter-item').show();
                        $('.profolio-arrows-wraper').show();
                    }
                    else {
                        var filteredItems = data_items.filter(
                            '[data-category = "' + filterValue + '"]');

                        $('.js-profolio-filter-wrapper').find('.js-profolio-filter-item').hide();
                        filteredItems.show();

                        if ($('.js-profolio-filter-wrapper').find('[data-category = "' + filterValue + '"]').length
                            <= 4) {
                            $('.profolio-arrows-wraper').hide();
                        }
                        else {
                            $('.profolio-arrows-wraper').show();
                        }
                    }

                    swiper_project_details();

                    return false;
                });
            });
        }
    }

    profolio_filter_init();

    if ($('.js-profolio-filter-wrapper').length) {
        $('.js-profolio-filter-wrapper').each(function () {

            var $container = $(this),
                data_items = $container.find('.js-profolio-filter-item'),
                $filters   = $('.js-profolio-filter-frame').find('div');

            // Filter
            $filters.on('click', function () {

                // Show/Hide active class
                $filters.removeClass('profolio-filter-current');
                $(this).addClass('profolio-filter-current');

                var filterValue = $(this).attr('data-filter');

                // Show/Hide brands item
                if (filterValue === '*') {
                    $('.js-profolio-filter-wrapper').find('.js-profolio-filter-item').show();
                }
                else {
                    var filteredItems = data_items.filter(
                        '[data-category = "' + filterValue + '"]');

                    $('.js-profolio-filter-wrapper').find('.js-profolio-filter-item').hide();
                    filteredItems.show();
                }

                //swiper_project_details();

                return false;
            });
        });
    }
    /*======================
     END Profolio Filter Slider
     ======================*/

    /*====================
     Before/After block
     ====================*/
    if ($('.ba-slider').length) {
        $('.ba-slider').beforeAfter();
    }

    let js_basic_multiple = $('.js-example-basic-multiple');
    if (js_basic_multiple.length) {
        js_basic_multiple.select2().on('select2:open', function (element) {
            $('.select2-container--open').addClass('profolio-select2-result');
        });
    }

    $('.profolio-add-form-field').click(function (e) {
        e.preventDefault();

        $(this).prev().append($(this).next('.profolio-inpt').clone().css({
            'display': 'flex',
        })); //add input box
    });

    $('.profolio-ad-inp-frame').on('click', '.profolio-delete-inpt', function (e) {
        e.preventDefault();
        $(this).parent('.profolio-inpt').remove();
    });

    $('.profolio-add-file-form').on('submit', function (e) {

        $form = $(this);
        $loader = $form.parent().find('.profolio-ajax-form-loader');

        $loader.addClass('active');

        jQuery.ajax({
            method:  $form.attr('method'),
            type:    'POST',
            url:     instantup_object.ajaxurl,
            data:    $form.serialize(),
            success: function (response) {

                if ('success' === response.status) {
                    let template = wp.template('localseomap-form-success-template');
                    $form.parent().find('.profolio-form-success').addClass('active').html(template(response));

                    setTimeout(function () {
                        $('html, body').animate({
                            scrollTop: $('.profolio-form-success').offset().top - 150,
                        }, 1000);
                    }, 1000);
                }

                if ('error' === response.status) {
                    $form.parent().find('.profolio-form-error').addClass('active').html(response.message);
                }

                $loader.removeClass('active');
                $form.hide();
                $form.parent().find('.profolio-add-new-project').show();
            },
        });

        return false;

    });

    $('.profolio-add-new-project').on('click', function (e) {
        location.href = location.href;
    });

    if ($('.profolio-datepick').length && $.fn.datepicker.language
        != undefined) {
        $.fn.datepicker.language['en'] = {
            days:        [
                'Sunday',
                'Monday',
                'Tuesday',
                'Wednesday',
                'Thursday',
                'Friday',
                'Saturday',
            ],
            daysShort:   ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
            daysMin:     ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
            months:      [
                'January',
                'February',
                'March',
                'April',
                'May',
                'June',
                'July',
                'August',
                'September',
                'October',
                'November',
                'December',
            ],
            monthsShort: [
                'Jan',
                'Feb',
                'Mar',
                'Apr',
                'May',
                'Jun',
                'Jul',
                'Aug',
                'Sep',
                'Oct',
                'Nov',
                'Dec',
            ],
            today:       'Today',
            clear:       'Clear',
            dateFormat:  'yy-mm-dd',
            timeFormat:  'hh:ii',
            firstDay:    0,
        };

        $('.profolio-datepick').datepicker({
            language:   'en',
            timepicker: true,
        });
    }

    $('.profolio-hidden-part-btn').on('click', function () {

        $(this).find('i').toggleClass('profolio-rotate');
        $(this).next('.profolio-hidden-part').toggleClass('profolio-hidden-part-show');

    });

});

document.addEventListener('DOMContentLoaded', function () {
    const changeMapWidth = () => {
        let $map = document.querySelector('#iu_map_locations');

        if (!$map) {
            return;
        }

        let $parent = $map.closest('.profolio-map-wrapper');

        $map.style.width = `${$parent.offsetWidth}px`;
    };//using on 'Project map' page
    let $mapBtn = document.querySelector('.iu-aside-map-box-btn');

    (function () {
        if (!$mapBtn) {
            //START hide map when mobile
            let $body = document.querySelector('body');

            if (window.innerWidth <= 768) {
                let iuPostsBlock = $body.querySelector('#iu_posts_block'),
                    mapBlock     = $body.querySelector('.profolio-map-wrapper');

                if (iuPostsBlock && mapBlock) {
                    mapBlock.closest('.wp-block-column').classList.add('hidden');
                    iuPostsBlock.closest('.wp-block-column').style.setProperty('flex-basis', '100%', 'important');
                }
            }
            //END hide map when mobile

            window.addEventListener('resize', () => {
                changeMapWidth();
            });

            setTimeout(() => {
                changeMapWidth();
            }, 100);
        }

    }());

    (function () {
        let $cover          = document.querySelector('.ba-slider .profolio-img-hover'),
            $iuLightGallery = document.querySelector('.iu_use_lightGallery'),
            $galleries;

        if (!!$cover && !!$iuLightGallery) {
            const iuClickOnCover = (galleries, assignment) => {
                $cover.addEventListener('click', (evt) => {
                    let $wrap        = $cover.closest('.ba-slider'),
                        $coverImg    = $wrap.querySelector('.iu-presentation-cover'),
                        $coverSrc    = $coverImg.getAttribute('src'),
                        $coverLength = $coverSrc.length - 20,
                        $img         = $coverSrc.substr(0, $coverLength),
                        $imgGallery;

                    for (let $gallery of galleries) {
                        if (assignment === 'carousel') {
                            $imgGallery = $gallery.style.backgroundImage.trim();
                            $imgGallery = $gallery.style.backgroundImage.trim();
                        }

                        if (assignment === 'gallery') {
                            //$imgGallery = $gallery.parentElement.dataset.src;
                            $imgGallery = $gallery.querySelector('.card-img-top').getAttribute('src');
                        }

                        if ($imgGallery.indexOf($img) !== -1) {
                            $gallery.click();

                            break;
                        }

                    }
                });
            };

            if ($iuLightGallery.closest('.block__content').classList.contains('iu-carousel-block')) {
                $galleries = $iuLightGallery.querySelectorAll('.js-profolio-filter-item .profolio-gal-frame');
                iuClickOnCover($galleries, 'carousel');

            }
            else if ($iuLightGallery.closest('.block__content').classList.contains('iu-gallery-block')) {
                $galleries = $iuLightGallery.querySelectorAll('.iu-gallery-item');
                iuClickOnCover($galleries, 'gallery');
            }
        }

    }());


    (function () {
        let $backMapBtn = document.querySelector('.search-map-back-btn'),
            $parentMain  = document.querySelector('.iu-column-page.wp-block-columns');

        if (!$mapBtn || !$backMapBtn || !$parentMain) {
            return;
        }

        let $aside       = $parentMain.querySelector('.iu-posts-list-aside'),
            $mapBox      = $parentMain.querySelector('.iu-content-map-box'),
            $postsBoxAll = $parentMain.querySelectorAll('.iu-posts-list-box') || [],
            $btnPc       = $parentMain.querySelector('.btn-pc-active-filter'),
            iuPostsBlock = $parentMain.querySelector('#iu_posts_block'),
            $postsBox;

        $postsBoxAll.forEach(function (item) {
            if (item.querySelector('#iu_posts_block')) {
                $postsBox = item;
            }
        });

        $mapBtn.addEventListener('click', () => {
            $aside.classList.toggle('d-none');
            $mapBox.classList.remove('d-none');
            $btnPc.classList.toggle('active');

            if ($postsBox) {
                $postsBox.classList.toggle('active');
            }
        });

        $backMapBtn.addEventListener('click', () => {
            sessionStorage.setItem(`iu_show_map`, 'false');
            $aside.classList.remove('d-none');
            iuPostsBlock.classList.remove('d-none');
            $mapBox.classList.add('d-none');
            $btnPc.classList.toggle('active');
            $aside.classList.remove('active-pc');

            if ($postsBox) {
                $postsBox.classList.remove('active');
            }
        });
    }());

    (function () {
        let $asideTerms = document.querySelector('.iu-aside-term');
        if (!$asideTerms) {
            return;
        }

        $asideTerms.addEventListener('click', function (evt) {
            let $asideTermActive = $asideTerms.querySelector('.iu-aside-term-item.active');

            if (evt.target?.closest('.iu-aside-term-item') === $asideTermActive) {
                $asideTermActive.classList.remove('active');
                return;
            }

            if ($asideTermActive) {
                $asideTermActive.classList.remove('active');
            }

            for (let target = evt.target; target && target !== this; target = target.parentNode) {
                if (target.matches('.iu-aside-term-item-arrow') || target.matches('.iu-aside-term-item-title')) {
                    target.closest('.iu-aside-term-item').classList.toggle('active');
                    break;
                }
            }
        }, false);
    }());

});