<?php
/**
 * album.php
 * create in 06.12.2021
 * SAYri
 *
 */

$point_mobile     = 'md';
$latitude         = get_post_meta( $post->ID, $this->prefix() . 'latitude', true );
$longitude        = get_post_meta( $post->ID, $this->prefix() . 'longitude', true );
$show_title       = $fields['iu_show_post_title'];
$settings_columns = $fields['iu_settings_columns'];
$pic_set_image    = $fields['iu_pic_set_image'];
$pic_set_size     = $fields['iu_pic_set_size'];
$filter_template  = $fields['filter_template'];

if ( wp_doing_ajax() ) {
	$show_title       = get_post_meta( $parent_post_id, 'iu_pic_set_size', true );
	$settings_columns = get_post_meta( $parent_post_id, 'iu_settings_columns', true );
	$pic_set_image    = get_post_meta( $parent_post_id, 'iu_pic_set_image', true );
	$pic_set_size     = get_post_meta( $parent_post_id, 'iu_pic_set_size', true );
	$filter_template  = get_post_meta( $parent_post_id, 'iu_filter_template', true );
}

if ($filter_template === 'aside'){
	$point_mobile = 'lg';
}

if ( $settings_columns === '1' ) {
	$column = $point_mobile . '-12';
}
elseif ( $settings_columns === '2' ) {
	$column = $point_mobile . '-6';
}
elseif ( $settings_columns === '3' ) {
	$column = $point_mobile . '-4';
}
elseif ( $settings_columns === '4' ) {
	$column = $point_mobile . '-3';
}
else {
	$column = $point_mobile . '-4';
}


?>

<div class="profolio-col-xs-12 profolio-col-<?php echo $column; ?> JS_profolio_project_item"
     data-latlong="<?php echo esc_attr( $latitude . ',' . $longitude ); ?>"
     data-post-id="<?php the_ID(); ?>">

    <a <?php echo $parent_post_id ? 'href="' . get_permalink() . '"' : ''; ?> class="card text-center">
		<?php if ( has_post_thumbnail() ):
			echo get_the_post_thumbnail( '', $pic_set_size ?? 'medium', array( 'class' => 'card-img-top' ) );
        elseif ( $pic_set_image ):
			$link = wp_get_attachment_image_url( $pic_set_image, $pic_set_size ?? 'medium' );
			echo '<img src="' . $link . '" alt="photo">';
		else:
			echo '<img src="' . INSTANTUP_URL . 'data/assets/img/placeholder.png' . '" class="no-pic card-img-top" alt="no-photo">';

		endif;
		?>

        <div class="card-body">
			<?php
			//var_dump($fields['iu_show_post_title']);
			?>
			<?php if ( $show_title ) {
				the_title( '<p class="card-title">', '</p>' );
			} ?>
        </div>
    </a>

</div>
