<?php
/**
 * masonry.php
 * create in 27.12.2021
 * SAYri
 *
 */

use InstantUploader\Admin;

if ( empty( $cover_id ) ) {
	$cover_id = (int) get_post_meta( $video_id, 'iu-thumb', true );
}

$admin = new Admin();

if ( $video_id ) : ?>
    <div class="iu-testimonial-masonry-item video">
		<?php echo $admin->get_schema_rating( $post_id ); ?>
        <div style="display:none;" id="testimonial_video_<?php echo $post_id; ?>">
			<?php if ( ! is_admin() ): ?>
                <video class="lg-video-object lg-html5" controls preload="metadata">
                    <source src="<?php echo wp_get_attachment_url( $video_id ); ?>" type="video/mp4">
                </video>
			<?php endif; ?>
        </div>


        <div class="iu-video-gallery video-gallery">
            <div class="iu-testimonials-cover" data-html="#testimonial_video_<?php echo $post_id; ?>"
                 data-sub-html="<?php echo esc_html( $title ); ?>">

				<?php if ( empty( $cover_id ) ): ?>
                    <img src="<?php echo INSTANTUP_URL ?>data/assets/img/placeholder-cover.png"
                         class="attachment-large size-large" alt="cover" loading="lazy"/>
				<?php else:
					echo wp_get_attachment_image( $cover_id, $settings['cover_size'] );
				endif;
				?>

                <div class="iu-testimonial-masonry-overlay">
					<?php if ( 'yes' === $settings['show_play_btn'] ): ?>
                        <div class="iu-testimonial-masonry-play">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                 stroke="#FFB902" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round">
                                <polygon points="5 3 19 12 5 21 5 3"></polygon>
                            </svg>
                        </div>
					<?php endif; ?>


					<?php if ( ! empty( $customer_name ) || ! empty( $customer_title ) ): ?>
                        <div class="iu-testimonials-all-customer">
							<?php if ( ! empty( $customer_name ) && 'yes' === $settings['show_customer_name'] ): ?>
                                <div class="iu-testimonials-all-customer-name"><?php echo $customer_name; ?></div>
							<?php endif; ?>

							<?php if ( ! empty( $customer_title ) && 'yes' === $settings['show_customer_title'] ): ?>
                                <div class="iu-testimonials-all-customer-title"><?php echo $customer_title; ?></div>
							<?php endif; ?>
                        </div>
					<?php endif; ?>
                </div>

            </div>
        </div>


        <div class="iu-testimonials-all-customer-wrap">
			<?php if ( ! empty( $title ) && 'yes' === $settings['show_title'] ): ?>
                <div class="iu-testimonials-all-title">
					<?php if ( ! empty( $post_id ) && 'yes' === $settings['show_readmore'] ): ?>
                        <a href="<?php the_permalink( $post_id ); ?>"><?php echo $title; ?></a>
					<?php else: ?>
						<?php echo $title; ?>
					<?php endif; ?>
                </div>
			<?php endif; ?>

            <div class="iu-testimonials-all-customer-info">
				<?php if ( ! empty( $rating ) && 'yes' === $settings['show_rating'] ): ?>
                    <ul class="profolio-card-rating">
						<?php if ( ! empty( $rating ) ) : ?>
							<?php for ( $i = 1; $i <= 5; $i ++ ) :
								if ( $rating >= 1 ) : ?>
                                    <li><i class="pro_fa pro_fa-star"></i></li>
									<?php $rating --;
								else : ?>
                                    <li><i class="pro_far pro_fa-star"></i></li>
								<?php endif;
							endfor; ?>
						<?php endif; ?>
                    </ul>
				<?php endif; ?>

				<?php if ( 'yes' === $settings['show_date'] ): ?>
                    <div class="iu-testimonials-all-customer-date"><?php echo get_the_date( 'm-d-Y',
							$post_id ); ?></div>
				<?php endif; ?>

				<?php if ( ! empty( $post_id ) && 'yes' === $settings['show_readmore'] ): ?>
                    <div class="iu-testimonials-all-more">
                        <a href="<?php the_permalink( $post_id ); ?>"><?php echo $settings['readmore_txt'] ? : 'read more »'; ?></a>
                    </div>
				<?php endif; ?>
            </div>
        </div>


    </div>

<?php
else : ?>
    <div class="iu-testimonial-masonry-item no-video">
		<?php echo $admin->get_schema_rating( $post_id ); ?>
        <div class="iu-testimonials-all-customer">
			<?php if ( ! empty( $customer_photo ) && 'yes' === $settings['show_customer_photo'] ): ?>
                <div class="iu-testimonials-all-customer-img">
                    <img src="<?php echo $customer_photo; ?>" alt="<?php echo $customer_name; ?>">
                </div>
			<?php endif; ?>

			<?php if ( ! empty( $customer_name ) && ! empty( $customer_title ) ): ?>
                <div class="iu-testimonials-all-customer">
					<?php if ( 'yes' === $settings['show_customer_name'] ): ?>
                        <div class="iu-testimonials-all-customer-name"><?php echo $customer_name; ?></div>
					<?php endif; ?>
					<?php if ( 'yes' === $settings['show_customer_title'] ): ?>
                        <div class="iu-testimonials-all-customer-title"><?php echo $customer_title; ?></div>
					<?php endif; ?>
                </div>
			<?php endif; ?>
        </div>


        <div class="iu-testimonials-all-customer-info">
			<?php if ( ! empty( $rating ) && 'yes' === $settings['show_rating'] ): ?>
                <ul class="profolio-card-rating">
					<?php if ( ! empty( $rating ) ) : ?>
						<?php for ( $i = 1; $i <= 5; $i ++ ) :
							if ( $rating >= 1 ) : ?>
                                <li><i class="pro_fa pro_fa-star"></i></li>
								<?php $rating --;
							else : ?>
                                <li><i class="pro_far pro_fa-star"></i></li>
							<?php endif;
						endfor; ?>
					<?php endif; ?>
                </ul>
			<?php endif; ?>
			<?php if ( 'yes' === $settings['show_date'] ): ?>
                <div class="iu-testimonials-all-customer-date"><?php echo get_the_date( 'm-d-Y', $post_id ); ?></div>
			<?php endif; ?>
        </div>


		<?php if ( ! empty( $title ) && 'yes' === $settings['show_title'] ): ?>
            <div class="iu-testimonials-all-title"><?php echo $title; ?></div>
		<?php endif; ?>

		<?php if ( ! empty( $description ) && 'yes' === $settings['show_description'] ): ?>
            <div class="iu-testimonials-all-desc"><?php echo $description; ?></div>
		<?php endif; ?>

		<?php if ( ! empty( $cover_id ) && 'yes' === $settings['show_cover'] ): ?>
            <div class="iu-testimonials-cover">
				<?php echo wp_get_attachment_image( $cover_id, $settings['cover_size'] ); ?>
            </div>
		<?php endif; ?>

		<?php if ( ! empty( $post_id ) && 'yes' === $settings['show_readmore'] ): ?>
            <div class="iu-testimonials-all-more">
                <a href="<?php the_permalink( $post_id ); ?>"><?php echo $settings['readmore_txt'] ? : 'read more »'; ?></a>
            </div>
		<?php endif; ?>
    </div>
<?php endif;