<?php

namespace InstantUploader;

//use ElementorPro;
use WP_Query;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class Admin
 *
 * @since  1.0.0
 */
class Admin {
	protected $template = 'profolio-project-template.php';

	/**
	 * Leads constructor.
	 * @since  1.0.0
	 * @access public
	 */
	public function __construct() {
	}

	/**
	 * Init all hooks of the plugin.
	 * @since  1.0.0
	 * @access public
	 */
	public function init() {
		add_action( 'init', array( $this, 'iu_add_image_size' ) );
		add_action( 'init', array( $this, 'iu_register_pattern_category' ), 25 );
		add_action( 'init', array( $this, 'iu_register_block_pattern' ), 25 );
		add_action( 'init', array( $this, 'change_seo_meta_other_plugins' ), 500 );
		add_action( 'excerpt_more', array( $this, 'change_excerpt_more' ) );
		add_action( 'wp_head', array( $this, 'change_wp_head' ) );
		add_action( 'wp_head', array( $this, 'css_hide_page_title' ) );
		add_action( 'admin_menu', array( $this, 'add_submenu_link' ), 1 );
		add_action( 'mime_types', array( $this, 'webp_upload_mimes' ) );
		add_action( 'admin_bar_menu', array( $this, 'add_item_in_bar_menu' ), 81 );
		add_action( 'after_setup_theme', array( $this, 'init_carbon_fields' ) );
		add_action( 'after_setup_theme', array( $this, 'my_add_theme_support' ) );
		add_filter( 'document_title_parts', array( $this, 'change_title' ) );
		add_filter( 'get_the_archive_title', array( $this, 'clear_archive_title' ) );
		add_filter( 'body_class', array( $this, 'add_class_for_map' ) );
		add_action( 'wp_ajax_iu_get_content_firebase', array( $this, 'iu_get_content_firebase' ) );
		add_action( 'carbon_fields_container_instantup_before_fields', array( $this, 'remove_autocomplete' ) );
		add_action( 'plugin_action_links_' . INSTANTUP_DIR . '/plugin.php',
			array( $this, 'filter_plugin_action_links' ) );


		if ( wp_doing_ajax() ) {
			add_action( 'wp_ajax_iu_ajax_filters_post', array( $this, 'iu_ajax_filters_post' ) );
			add_action( 'wp_ajax_nopriv_iu_ajax_filters_post', array( $this, 'iu_ajax_filters_post' ) );

			add_action( 'wp_ajax_iu_ajax_filters', array( $this, 'iu_ajax_filters' ) );
			add_action( 'wp_ajax_nopriv_iu_ajax_filters', array( $this, 'iu_ajax_filters' ) );

			add_action( 'wp_ajax_iu_export_templates', array( $this, 'iu_export_templates' ) );
			add_action( 'wp_ajax_nopriv_iu_export_templates', array( $this, 'iu_export_templates' ) );

			add_action( 'wp_ajax_iu_get_data_account_seo', array( $this, 'iu_get_data_account_seo' ) );

			add_action( 'wp_ajax_iu_import_templates', array( $this, 'iu_import_templates' ) );
			add_action( 'wp_ajax_nopriv_iu_import_templates', array( $this, 'iu_import_templates' ) );
		}
	}

	#---------------------------

	final public function activation_plugin_iu() {
		$this->creating_post_for_preview();
		$this->creating_default_template_post();
		$this->creating_default_template_cat_tag();
		$this->creating_page_map();
		$this->creating_old_page_map();
		$this->creating_servicearea_map();
		$this->creating_template_citypage();
	}

	public function partition( $list, $p ) {
		$listlen   = count( $list );
		$partlen   = floor( $listlen / $p );
		$partrem   = $listlen % $p;
		$partition = array();
		$mark      = 0;
		for ( $px = 0; $px < $p; $px ++ ) {
			$incr             = ( $px < $partrem ) ? $partlen + 1 : $partlen;
			$partition[ $px ] = array_slice( $list, $mark, $incr );
			$mark             += $incr;
		}

		return $partition;
	}

	public function change_excerpt_more() {
		return '...';
	}

	public function iu_add_image_size() {
		add_image_size( 'iu-medium', 400, 400, true );
	}

    public function remove_text_after_colon($txt){
        $position = strpos($txt, ':');

        if ($position !== false) {
            $txt = substr($txt, 0, $position);
        }
        return $txt;
    }

    public function text_cleanup($txt){
        $allowedChars = '/[^a-zA-Z0-9_\-]/';
        $txt = preg_replace($allowedChars, '', $txt);
        $txt = str_replace('iu_', '', $txt);
        return $txt;
    }

    public function limit_text_length($txt, $max_length = 15) {
        if (strlen($txt) > $max_length) {
            $txt = substr($txt, 0, $max_length);
        }

        return $txt;
    }

    public function cleanup_post_type_slug($slug){
        $slug = $this->remove_text_after_colon($slug);
        $slug = $this->text_cleanup($slug);
        return $this->limit_text_length($slug);
    }

	public function add_class_for_map( $classes ) {
		$post_id = get_the_ID();

		if ( $post_id === (int) get_option( '_page_map_project' ) ) {
			$classes[] = self::get_type_prefix() . '-page-map';
		}

		if ( 'full_width' === get_post_meta( $post_id, 'iu_content_width', true ) ) {
			$classes[] = self::get_type_prefix() . '-content-width-full';
		}

		return $classes;
	}

	public function create_page_testimonials() {
		if ( ! get_option( '_iu_page_all_testimonials' ) ) {
			$project_data = array(
				'post_type'    => 'page',
				'post_status'  => 'publish',
				'post_title'   => __( 'Testimonials' ),
				'post_content' => '<!-- wp:carbon-fields/iu-all-testimonial {"data":{"select_fonts":"","background_row":"#f0eae8","background_item":"#f8f4f2","separator_4":"","color_rating":"#ff8c00","font_size_rating":"","position_rating":"","margin_top_rating":"","margin_bottom_rating":"","separator_3":"","color_title":"#2c2c2c","position_title":"","font_size_title":"","line_height_title":"","margin_top_title":"","margin_bottom_title":"","separator_2":"","color_author":"#212529","position_author_name":"left","font_size_author":"","line_height_author":"","margin_top_author":"","margin_bottom_author":""}} /-->',
			);

			$post_id = wp_insert_post( $project_data, true );

			if ( ! is_wp_error( $post_id ) ) {
				update_option( '_iu_page_all_testimonials', $post_id, false );
			}
		}
	}

	public function add_item_in_bar_menu( $wp_admin_bar ) {
		if ( is_admin() ) {
			return;
		}

		global $post;
		$uid = '';

		if ( $custom_type_slug = get_option( '_iu_custom_type_slug' ) ) {
			$custom_type_slug = array_flip( $custom_type_slug );

			if ( isset( $post->post_type, $custom_type_slug[ $post->post_type ] ) && $custom_type_slug[ $post->post_type ] === null ) {
				return;
			}
		}

		if ( isset( $post->ID ) && $post->ID && ! $uid = get_post_meta( $post->ID, self::get_metabox_prefix() . 'uid', true ) ) {
			return;
		}

		$protocol          = '//';
		$whitelabel_domain = get_option( '_iu_whitelabel_domain' ) ?: 'app.instantuploader.com';

		$wp_admin_bar->add_node(
			array(
				'id'    => 'edit-iu',
				'title' => __( 'Edit with IU' ),
				'href'  => $protocol . $whitelabel_domain . '/content/' . $uid,
				'meta'  => array(
					'class'  => 'edit-post-iu',
					'target' => '_blank',
				),
			)
		);

	}

	public function webp_upload_mimes( $existing_mimes ) {
		$existing_mimes['webp'] = 'image/webp';

		return $existing_mimes;
	}

	public function iu_register_pattern_category() {
		if ( class_exists( 'WP_Block_Patterns_Registry' ) ) {

			register_block_pattern_category(
				'instantuploader',
				array( 'label' => 'InstantUploader' )
			);

		}
	}

	public function iu_register_block_pattern() {
		if ( class_exists( 'WP_Block_Patterns_Registry' ) ) {

			register_block_pattern(
				'instantuploader/new_project_map',
				array(
					'title'       => 'New project map pattern',
					'description' => 'description...',
					'content'     => '<!-- wp:columns {"className":"iu-column-page"} --><div class="wp-block-columns iu-column-page"><!-- wp:column {"layout":{"wideSize":"","contentSize":""}} --><div class="wp-block-column"><!-- wp:carbon-fields/iu-content-posts {"data":{"iu_output_type":["iu_project", "project"],"iu_posts_per_page":"","iu_main_separator":"","iu_background":"","iu_background_maine":"","iu_settings_columns":"2","iu_settings_bdrs":"16","iu_settings_height":"380","template_posts":"album","separator_realestate":"","iu_set_price":"","iu_set_item_title":"","iu_set_beds":"","iu_set_baths":"","iu_set_sqft":"","separator_priority":"","use_priority":true,"use_filters":true,"filter_template":"aside","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","separator_count":"","use_filter_count":true,"separator_map":"","use_map_block":true,"separator_location":"","use_filter_location":true,"location_size":"","location_height":"","location_color":"#50505a","separator_radius":"","use_filter_radius":true,"radius_font_size":"","radius_line_height":"","radius_title_color":"#50505a","separator_loc":"","use_location":true,"separator_cat":"","use_category":true,"separator_tags":"","use_tags_block":true,"separator_price":"","use_filter_price":true,"separator_sort":"","use_filter_sort":true,"separator_btn_status":"","use_style_btn_status":false,"separator_btn_compl_status":"","style_compl_color":"#212529","style_compl_bgc":"#61BD4F","separator_btn_open_status":"","style_open_color":"#212529","style_open_bgc":"#0079BF","separator_btn_reset_status":"","style_reset_color":"#ffffff","style_reset_bgc":"#343a40","separator_custon_filter":"","iu_custom_filter":[],"iu_show_post_title":true,"iu_post_title_color":"","iu_post_title_size":"14","iu_post_title_top":"","iu_post_title_right":"","iu_post_title_bottom":"","iu_post_title_left":"","iu_post_title_blur_use":false,"iu_post_title_blur_intensity":"","iu_pic_show":"yes","iu_pic_set_image":"","iu_pic_set_height":"100","iu_pic_set_size":"iu-medium","iu_show_loc_title":"yes","iu_loc_color":"","iu_location_option":"generalized","iu_loc_font":"","iu_loc_size":"11","iu_loc_top":"","iu_loc_right":"","iu_loc_bottom":"","iu_loc_left":"","iu_show_cat":false,"iu_cat_color":"","iu_cat_text_color":"","iu_cat_bdrs":"","iu_cat_font":"","iu_cat_weight":"","iu_cat_size":"14","iu_cat_top":"","iu_cat_right":"","iu_cat_bottom":"","iu_cat_left":"","iu_cat_p_top":"","iu_cat_p_right":"","iu_cat_p_bottom":"","iu_cat_p_left":"","iu_nav_bgc_current":"","iu_nav_color_current":"","iu_nav_bgc_all":"","iu_nav_color_all":"","iu_nav_bgc_all_hover":"","iu_nav_color_all_hover":"","iu_nav_width":"","iu_nav_height":"","iu_nav_size_current":"","iu_nav_size_all":"","iu_nav_weight_current":"","iu_nav_weight_all":"400","iu_nav_bdrs_current":"","iu_nav_bdrs_all":"","iu_nav_top":"","iu_nav_bottom":"","iu_margin_top":"","iu_margin_bottom":"","mob_btn_bottom_pos":"","active_color":""}} /--></div><!-- /wp:column --><!-- wp:column {"className":"iu-content-map-box d-none"} --><div class="wp-block-column iu-content-map-box d-none"><!-- wp:carbon-fields/iu-content-map {"data":{"iu_zoom_all_markers":"yes","iu_map_fullheight":"yes","iu_hide_info_window":false,"iu_hide_map":true,"iu_blue_icon":true,"iu_map_which_posts":"current_page","marker_image":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/realestate_map',
				array(
					'title'       => 'Realestate map pattern',
					'description' => 'description...',
					'content'     => '<!-- wp:columns --><div class="wp-block-columns"><!-- wp:column {"width":"55%","className":"test"} --><div class="wp-block-column" style="flex-basis:55%"><!-- wp:carbon-fields/iu-content-map {"data":{"iu_map":{"value":"34.0721827,-118.357061","lat":"34.0721827","lng":"-118.357061","zoom":10,"address":""},"iu_zoom_all_markers":"yes","iu_map_which_posts":"current_page","iu_map_fullheight":"yes","iu_hide_info_window":false,"marker_image":""}} /--></div><!-- /wp:column --><!-- wp:column {"width":"45%"} --><div class="wp-block-column" style="flex-basis:45%"><!-- wp:carbon-fields/iu-content-posts {"data":{"iu_output_type":["iu_project", "project"],"iu_posts_per_page":"","iu_main_separator":"","iu_background":"","iu_background_maine":"#f5f5fa","iu_settings_columns":"2","iu_settings_bdrs":"","template_posts":"realestate","separator_realestate":"","iu_set_price":"","iu_set_item_title":"","iu_set_beds":"","iu_set_baths":"","iu_set_sqft":"","separator_priority":"","use_priority":true,"use_filters":false,"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","separator_location":"","use_filter_location":false,"location_size":"","location_height":"","location_color":"#50505a","separator_radius":"","use_filter_radius":false,"radius_font_size":"","radius_line_height":"","radius_title_color":"#50505a","separator_price":"","use_filter_price":true,"separator_sort":"","use_filter_sort":true,"separator_count":"","use_filter_count":true,"separator_custon_filter":"","iu_custom_filter":[],"iu_show_post_title":"yes","iu_post_title_color":"","iu_post_title_size":"14","iu_post_title_top":"","iu_post_title_right":"","iu_post_title_bottom":"","iu_post_title_left":"","iu_pic_show":"yes","iu_pic_set_image":"","iu_pic_set_height":"100","iu_pic_set_size":"iu-medium","iu_show_loc_title":"yes","iu_loc_color":"","iu_location_option":"generalized","iu_loc_font":"","iu_loc_size":"11","iu_loc_top":"","iu_loc_right":"","iu_loc_bottom":"","iu_loc_left":"","iu_show_cat":"yes","iu_cat_color":"","iu_cat_text_color":"","iu_cat_bdrs":"","iu_cat_font":"","iu_cat_weight":"","iu_cat_size":"14","iu_cat_top":"","iu_cat_right":"","iu_cat_bottom":"","iu_cat_left":"","iu_cat_p_top":"","iu_cat_p_right":"","iu_cat_p_bottom":"","iu_cat_p_left":"","iu_nav_bgc_current":"","iu_nav_color_current":"","iu_nav_bgc_all":"","iu_nav_color_all":"","iu_nav_bgc_all_hover":"","iu_nav_color_all_hover":"","iu_nav_width":"","iu_nav_height":"","iu_nav_size_current":"","iu_nav_size_all":"","iu_nav_weight_current":"","iu_nav_weight_all":"400","iu_nav_bdrs_current":"","iu_nav_bdrs_all":"","iu_nav_top":"","iu_nav_bottom":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/realestate_posts',
				array(
					'title'       => 'Realestate posts pattern',
					'description' => 'description...',
					'content'     => '<!-- wp:carbon-fields/iu-realestation-one-header {"data":{"iu_get_price":"","iu_get_beds":"","iu_get_baths":"","iu_get_sqft":""}} /--><!-- wp:columns {"className":"\\\u0022wp-block-columns\\\u0022"} --><div class="wp-block-columns \&quot;wp-block-columns\&quot;"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-realestation-one-slider /--><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_size":"","block_width":"","position_txt":"left","line_height":"","margin_top":"","margin_bottom":""}} /--><!-- wp:carbon-fields/iu-location {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_location_option":"generalized","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"color_title":"#50505a","font_size":"","font_weight":"","line_height":"","margin_top":"","margin_bottom":"","iu_hide_icon_txt":false,"color_txt":"#5a5a64","font_size_txt":"","line_height_txt":"","margin_top_txt":"","margin_bottom_txt":"","position_location":"top"}} /--><!-- wp:carbon-fields/iu-post-nav /--></div><!-- /wp:column --><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-realestation-one-fields /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/ai_writeups',
				array(
					'title'       => 'AI writeups pattern',
					'description' => 'description...',
					'content'     => '<!-- wp:columns {"className":"\\\u0022wp-block-columns\\\u0022"} --><div class="wp-block-columns \&quot;wp-block-columns\&quot;"><!-- wp:column {"width":"75%","className":"\\\u0022wp-block-column\\\u0022"} -->
<div class="wp-block-column \&quot;wp-block-column\&quot;" style="flex-basis:75%"><!-- wp:columns {"className":"\\\u0022wp-block-columns"} -->
<div class="wp-block-columns \&quot;wp-block-columns"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} -->
<div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-title {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","title_color":"#50505a","font_size":"","font_weight":"","line_height":"","position_title":"left","margin_top":"","margin_bottom":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:carbon-fields/ai-writeups-content {"data":{"iu_show_featured_img":false,"iu_sort_items":"random","crb_facebook":"","border_item":"","bdrs_item":"","padding_item_top_bottom":"","padding_item_left_right":"","margin_item_bottom":"30","iu_hidden_tags":true,"color_tags":"#50505a","font_size_tags":"","font_weight_tags":"","margin_top_tags":"","margin_bottom_tags":"","iu_before_tags":"","iu_after_tags":"","iu_hide_items_title":false,"color_title":"#74BD43","font_size_title":"40","font_weight_title":"bold","line_height_title":"40","margin_top_title":"","margin_bottom_title":"","color_title_cnt":"#50505a","font_size_cnt":"16","font_weight_cnt":"normal","line_height_cnt":"18","margin_top_cnt":"","margin_bottom_cnt":""}} /--></div><!-- /wp:column --><!-- wp:column {"width":"25%","className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;" style="flex-basis:25%"><!-- wp:carbon-fields/iu-location {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_location_option":"generalized","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"color_title":"#50505a","font_size":"","font_weight":"","line_height":"","margin_top":"","margin_bottom":"","iu_hide_icon_txt":false,"color_txt":"#5a5a64","font_size_txt":"","line_height_txt":"","margin_top_txt":"","margin_bottom_txt":"","position_location":"top"}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_one',
				array(
					'title'       => 'Template One',
					'description' => 'description...',
					'content'     => '<!-- wp:columns {"className":"\\\u0022wp-block-columns\\\u0022"} --><div class="wp-block-columns \&quot;wp-block-columns\&quot;"><!-- wp:column {"width":"60%","className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;" style="flex-basis:60%"><!-- wp:carbon-fields/iu-before-after /--><!-- wp:columns {"className":"\\\u0022wp-block-columns"} --><div class="wp-block-columns \&quot;wp-block-columns"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-title /--></div><!-- /wp:column --><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_size":"","block_width":"","position_txt":"left","line_height":"","margin_top":"","margin_bottom":""}} /--><!-- wp:carbon-fields/iu-gallery {"data":{"iu_lazy_load":"yes","iu_image_size":"medium","iu_order_by":"","iu_link":"media_file","iu_columns":"2","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under"}} /--></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:carbon-fields/iu-post-nav /--></div><!-- /wp:column --><!-- wp:column {"width":"40%","className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;" style="flex-basis:40%"><!-- wp:carbon-fields/iu-location /--><!-- wp:carbon-fields/iu-tags /--><!-- wp:carbon-fields/iu-category /--><!-- wp:carbon-fields/iu-testimonial {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"title_main_color":"#2c2c2c","title_main_size":"","title_main_weight":"","title_main_lheight":"","title_main_mt":"","title_main_mb":"","title_color":"#2c2c2c","title_size":"","title_lheight":"","title_mt":"","title_mb":"","color_desc":"#212529","font_size_desc":"","position_desc":"","margin_top_desc":"","margin_bottom_desc":"","position_picture":"","width_size":"","height_size":"","border_radius_pic":"","color_author":"#212529","font_size_author":"","line_height_author":"","margin_top_author":"","margin_bottom_author":"","color_rating":"#ff8c00","font_size_rating":"","position_rating":"","margin_top_rating":"","margin_bottom_rating":"","position_btn_video":"left","btn_txt_video":"Watch Video","color_text_video":"#fafaff","background_btn_video":"#007bff","font_size_video":"","line_height_video":"","border_radius_video":"","margin_top_video":"","margin_bottom_video":"","padding_top_video":"","padding_bottom_video":"","padding_left_video":"","padding_right_video":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_two',
				array(
					'title'       => 'Template Two',
					'description' => 'description...',
					'content'     => '<!-- wp:carbon-fields/iu-cover {"data":{"use_title":false,"use_shadow":false,"use_thumbnail":"yes","use_img_post":false,"img_position_post":"","cover_image":false,"cover_text":"","cover_height":"","sep_pos_block":"","top_block":"","bottom_block":"","color_txt":"#ffffff","font_size_txt":"","line_height_txt":"","position_title":"left"}} /--><!-- wp:columns {"className":"\\\u0022wp-block-columns"} --><div class="wp-block-columns \&quot;wp-block-columns"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:columns {"className":"\\\u0022wp-block-columns\\\u0022"} --><div class="wp-block-columns \&quot;wp-block-columns\&quot;"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-cover /--></div><!-- /wp:column --><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-title /--><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_size":"","block_width":"","position_txt":"left","line_height":"","margin_top":"","margin_bottom":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:carbon-fields/iu-gallery {"data":{"iu_lazy_load":"yes","iu_image_size":"medium","iu_order_by":"","iu_link":"media_file","iu_columns":"3","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under"}} /--></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:carbon-fields/iu-post-nav /-->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_three',
				array(
					'title'       => 'Template Three',
					'description' => 'description...',
					'content'     => '<!-- wp:carbon-fields/iu-cover /--><!-- wp:columns {"className":"\\\u0022wp-block-columns"} --><div class="wp-block-columns \&quot;wp-block-columns"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-title {"data":{"iu_lazy_load":"yes","iu_image_size":"medium","iu_order_by":"","iu_link":"media_file","iu_columns":"3","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under"}} /--><!-- wp:carbon-fields/iu-content {"data":{"iu_lazy_load":"yes","iu_image_size":"medium","iu_order_by":"","iu_link":"media_file","iu_columns":"3","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under"}} /--><!-- wp:carbon-fields/iu-gallery {"data":{"iu_lazy_load":"yes","iu_image_size":"medium","iu_order_by":"","iu_link":"media_file","iu_columns":"3","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under"}} /--></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:carbon-fields/iu-post-nav /-->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_four',
				array(
					'title'       => 'Template Four',
					'description' => 'description...',
					'content'     => '<!-- wp:columns {"className":"\\\u0022wp-block-columns\\\u0022"} --><div class="wp-block-columns \&quot;wp-block-columns\&quot;"><!-- wp:column {"width":"75%","className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;" style="flex-basis:75%"><!-- wp:carbon-fields/iu-media-carousel {"data":{"iu_carousel_img_height":"","iu_carousel_spacing":"","iu_slides_per_view":"","iu_slides_to_scroll":"","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_hidden_title":false,"main_title":"","main_title_color":"#212529","main_title_size":"","main_title_lh":"","buttons_inside":false,"btn_transparent":false,"btn_color_inactive":"","btn_color_active":"#0274be","btn_width":"","btn_height":"","btn_font_size":"","btn_bdrs":"","iu_hidden_pagination":false}} /--><!-- wp:columns {"className":"\\\u0022wp-block-columns"} --><div class="wp-block-columns \&quot;wp-block-columns"><!-- wp:column {"className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;"><!-- wp:carbon-fields/iu-title {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","title_color":"#50505a","font_size":"","font_weight":"","line_height":"","position_title":"left","margin_top":"","margin_bottom":""}} /--><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_size":"","block_width":"","position_txt":"left","line_height":"","margin_top":"","margin_bottom":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:carbon-fields/iu-gallery {"data":{"iu_lazy_load":"yes","iu_image_size":"medium","iu_order_by":"","iu_link":"media_file","iu_columns":"3","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under"}} /--><!-- wp:carbon-fields/iu-post-nav /--></div><!-- /wp:column --><!-- wp:column {"width":"25%","className":"\\\u0022wp-block-column\\\u0022"} --><div class="wp-block-column \&quot;wp-block-column\&quot;" style="flex-basis:25%"><!-- wp:carbon-fields/iu-testimonial {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"title_main_color":"#2c2c2c","title_main_size":"","title_main_weight":"","title_main_lheight":"","title_main_mt":"","title_main_mb":"","title_color":"#2c2c2c","title_size":"","title_lheight":"","title_mt":"","title_mb":"","color_desc":"#212529","font_size_desc":"","position_desc":"","margin_top_desc":"","margin_bottom_desc":"","position_picture":"","width_size":"","height_size":"","border_radius_pic":"","color_author":"#212529","font_size_author":"","line_height_author":"","margin_top_author":"","margin_bottom_author":"","color_rating":"#ff8c00","font_size_rating":"","position_rating":"","margin_top_rating":"","margin_bottom_rating":"","position_btn_video":"left","btn_txt_video":"Watch Video","color_text_video":"#fafaff","background_btn_video":"#007bff","font_size_video":"","line_height_video":"","border_radius_video":"","margin_top_video":"","margin_bottom_video":"","padding_top_video":"","padding_bottom_video":"","padding_left_video":"","padding_right_video":""}} /--><!-- wp:carbon-fields/iu-location /--><!-- wp:carbon-fields/iu-tags /--><!-- wp:carbon-fields/iu-category {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"color_title":"#000","font_size":"","font_weight":"","line_height":"","margin_top":"","margin_bottom":"","color_title_link":"#ffffff","background_link":"#007bff","iu_bg_transparent":false,"font_size_link":"","font_weight_links":"normal","line_height_link":"","border_radius_link":"","margin_top_link":"","margin_bottom_link":"","separator_3":"","padding_top_link":"","padding_bottom_link":"","padding_left_link":"","padding_right_link":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_six',
				array(
					'title'       => 'Template Five',
					'description' => 'description...',
					'content'     => '<!-- wp:carbon-fields/iu-cover {"data":{"use_title":false,"use_shadow":false,"use_thumbnail":"yes","use_img_post":false,"img_position_post":"","cover_image":false,"cover_text":"","cover_height":"","sep_pos_block":"","top_block":"","bottom_block":"","border_radius":"16","iu_object_fit":"contain","color_txt":"#ffffff","font_size_txt":"","line_height_txt":"","position_title":"left"}} /--><!-- wp:carbon-fields/iu-title {"data":{"iu_full_screen":false,"iu_use_img_bgi":false,"iu_use_shadow_bgi":false,"iu_img_bgi":"","title_color":"#212121","title_background":"","title_gradient":"","font_size":"36","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_weight":"bold","position_title":"","padding_separator":"","padding_top":"20","padding_bottom":"","padding_units":"px","crb_separator":"","margin_top":"","margin_bottom":"","margin_units":"px"}} /--><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_size":"","block_width":"","position_txt":"left","line_height":"","margin_top":"","margin_bottom":"","iu_use_info":true,"bgc_info_block":"#DEEDFB","color_info_block":"#606060","bd_info_color":"","bdrs_info":"16"}} /--><!-- wp:carbon-fields/iu-gallery {"data":{"iu_lazy_load":"yes","iu_image_size":"large","iu_order_by":"","iu_link":"media_file","iu_columns":"3","iu_img_height":"","align_text":"","iu_spacing_between":false,"iu_spacing_bottom":false,"bcg_txt":"#fff","iu_show_title":true,"iu_gallery_title":"Gallery","gallery_content_color":"","gallery_select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","gallery_font_size":"34","gallery_block_width":"bold","gallery_position_txt":"left","gallery_line_height":"","gallery_margin_top":"50","gallery_margin_bottom":"","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_txt_position":"under","border_radius_items_pic":"16"}} /--><!-- wp:carbon-fields/iu-testimonial {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_hidden_title":false,"iu_hide_colon":true,"iu_hide_icon":true,"iu_underline_title":true,"title_main_color":"#2c2c2c","title_main_size":"34","title_main_weight":"bold","title_main_lheight":"42","title_main_mt":"","title_main_mb":"15","title_color":"#2c2c2c","title_size":"","title_lheight":"","title_mt":"","title_mb":"","color_desc":"#212529","font_size_desc":"","position_desc":"","margin_top_desc":"","margin_bottom_desc":"","position_picture":"","width_size":"","height_size":"","border_radius_pic":"","color_author":"#212529","font_size_author":"","line_height_author":"","margin_top_author":"","margin_bottom_author":"","color_rating":"#ff8c00","font_size_rating":"","position_rating":"","margin_top_rating":"","margin_bottom_rating":"","position_btn_video":"left","btn_txt_video":"Watch Video","color_text_video":"#fafaff","background_btn_video":"#007bff","font_size_video":"","line_height_video":"","border_radius_video":"","margin_top_video":"","margin_bottom_video":"","padding_top_video":"","padding_bottom_video":"","padding_left_video":"","padding_right_video":"","bgc_block":"#E0E0E0","border_radius":"16","padding_block":"0","select_style":"modern","iu_title_style_letters":"none","height_video":"500"}} /--><!-- wp:carbon-fields/iu-tags {"data":{"only_smart_tags":false,"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_style_block":"column","iu_hidden_title":false,"iu_hidden_title_txt":false,"iu_hide_colon":true,"iu_hide_icon":true,"iu_underline_title":true,"color_title":"#2C2C2C","title_txt":"","font_size":"34","font_weight":"bold","iu_style_letters":"none","line_height":"42","margin_top":"","margin_bottom":"15","color_title_link":"#8c8c93","font_size_link":"","font_weight_link":"normal","line_height_link":"","margin_top_link":"","margin_bottom_link":""}} /-->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_five',
				array(
					'title'       => 'New Template for Posts',
					'description' => 'description...',
					'content'     => '<!-- wp:carbon-fields/iu-title {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","title_color":"#000000","font_size":"48","font_weight":"bold","line_height":"64","position_title":"center","margin_top":"100","margin_bottom":"100","title_background":"#28a27c8e","title_gradient":"linear-gradient(108.48deg, #F6FBFF 46.62%, #F2FBF7 99.14%), #FFFFFF;"}} /--><!-- wp:carbon-fields/iu-tags {"data":{"only_smart_tags":false,"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_hidden_title":false,"iu_hide_colon":true,"iu_hide_icon":false,"iu_underline_title":false,"color_title":"#8c8c93","title_txt":"","font_size":"","font_weight":"","line_height":"","margin_top":"","margin_bottom":"","color_title_link":"#8c8c93","font_size_link":"","font_weight_link":"normal","line_height_link":"","margin_top_link":"","margin_bottom_link":"","vertical_row":true,"iu_hidden_title_txt":true}} /--><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","font_size":"","block_width":"","position_txt":"left","line_height":"","margin_top":"","margin_bottom":""}} /--><!-- wp:carbon-fields/iu-post-nav {"data":{"btn_size":"16","btn_height":"24","btn_color":"#ffffff","btn_bgc":"#0078FF","position_button":"center","btn_bdrs":"8","btn_txt_prev":"","btn_txt_next":"","iu_big_button":true}} /-->',
					'categories'  => array( 'instantuploader' ),
				)
			);

			register_block_pattern(
				'instantuploader/iu_template_cat_tag_one',
				array(
					'title'       => 'New Template for Category and Tag',
					'description' => 'description...',
					'content'     => '<!-- wp:carbon-fields/iu-title {"data":{"title_color":"#000000","font_size":"48","font_weight":"bold","line_height":"64","position_title":"center","margin_top":"100","margin_bottom":"100","title_background":"#28a27c8e","title_gradient":"linear-gradient(108.48deg, #F6FBFF 46.62%, #F2FBF7 99.14%), #FFFFFF;","iu_full_screen":true}} /--><!-- wp:carbon-fields/iu-category-and-tag {"data":{"iu_cat_tag_columns":"","iu_hide_loc":true,"iu_location_option":"generalized","iu_separator1":"","color_title":"#212529","font_size_title":"","line_height_title":"","iu_separator2":"","color_desc":"#212529","font_size_desc":"","line_height_desc":"","iu_separator3":"","iu_hide_shadow":true,"iu_hide_img":true,"background_card":"#fafaff00","color_item_title":"#50505a","font_size_card_title":"","line_height_card_title":"","items_bdrs":"8","iu_separator4":"","bg_item_nav_current":"#ff8c00","color_nav_current_txt":"#fafaff","bg_item_nav":"#f0f0fa","color_nav_txt":"#5a5a64","font_size_nav":"","line_height_nav":"","border_color_card":"#0078ffff","border_width_card":"1","iu_inline_style":true}} /-->',
					'categories'  => array( 'instantuploader' ),
				)
			);

		}
	}

	public function iu_get_content_firebase() {
		global $wp_rewrite;
		$wp_rewrite->flush_rules();
		flush_rewrite_rules();

		if ( ! isset( $_POST['apiKey'] ) || empty( $_POST['apiKey'] ) ) {
			wp_send_json( array(
					'success' => false,
					'message' => 'Empty apiKey',
				)
			);
		}

		$get_account     = (bool) ( $_POST['get_account'] ?? false );
		$get_content     = (bool) ( $_POST['get_content'] ?? false );
		$cleanup_content = (bool) ( $_POST['cleanup_content'] ?? false );
		$url             = IU_CLOUDFUNCTIONS_HOST . '/app/get-contents';
		$args            = array(
			'timeout'     => 30,
			'httpversion' => '1.1',
			'headers'     => array( 'Content-Type' => 'application/json' ),
		);
		$body            = array(
			'apiKey' => $_POST['apiKey'],
			'limit'  => 200,
		);

		if ( $get_account && !$cleanup_content ) {
			$body['limit'] = 0;
		}

        if ($cleanup_content){
	        $body['limit'] = 2000;
        }

		$args['body'] = wp_json_encode( $body );
		$response     = wp_remote_post( $url, $args );

		if ( ! is_wp_error( $response ) ) {
			$response = json_decode( $response['body'], true );

			if ( isset( $response['account'] ) && ! empty( $response['account'] ) ) {
				update_option( 'iu_data_account_seo',
					array(
						'email_address' => $response['account']['email'] ?? '',
						'business_name' => $response['account']['businessName'] ?? '',
						'location'      => $response['account']['location'] ?? '',
						'country'       => $response['account']['country'] ?? '',
						'state '        => $response['account']['state'] ?? '',
						'zip '          => $response['account']['zip'] ?? '',
						'phone_number'  => $response['account']['phone'] ?? '',
						'website'       => $response['account']['website'] ?? '',
						'logo'          => $response['account']['logo'] ?? '',
					),
					false );
			}

			if ( isset( $response['directionCnt'] ) ) {
				update_option( 'iu_direction_site', $response['directionCnt'], false );
			}
			if ( isset( $response['themeCustomiz'] ) && ! empty( $response['themeCustomiz'] ) ) {
				update_option( 'iu_theme_customiz', $response['themeCustomiz'], false );
			}

			if ( isset( $response['textOptions'] ) && ! empty( $response['textOptions'] ) ) {
				update_option( 'iu_text_options', $response['textOptions'], false );
			}

			if ( isset( $response['account']['whitelabelDomain'] ) && ! empty( $response['account']['whitelabelDomain'] ) ) {
				update_option(
					'_' . self::get_type_prefix() . '_whitelabel_domain',
					$response['account']['whitelabelDomain'],
					false );
			}

			if ( $cleanup_content ) {
				$result = $this->cleanup_content( $response['contents'] );
				wp_send_json( $result );
			}

			if ( $get_content && ! empty( $response ) ) {
				wp_send_json( array(
						'success' => true,
						'message' => '',
						'content' => $response,
					)
				);
			}

			if ( $get_account && ( ( isset( $response['account'] ) && ! empty( $response['account'] ) ) || ( isset( $response['user'] ) && ! empty( $response['user'] ) ) ) ) {
				wp_send_json( array(
						'success' => true,
						'message' => 'apiKey valid',
						'apiKye'  => $response['account'] ? $response['account']['apiKey'] : $_POST['apiKey'],
					)
				);
			}

		}

		wp_send_json( array(
				'success' => false,
				'message' => $response,
			)
		);
	}

	private function cleanup_content( $content ) {
		$count_deleted = 0;
		$query         = new WP_Query( array(
			'post_type'      => get_option( '_iu_custom_type_slug' ),
			'posts_per_page' => - 1,
		) );

		while ( $query->have_posts() ) {
			$query->the_post();
			$uid    = get_post_meta( get_the_ID(), self::get_metabox_prefix() . 'uid', true );
			$delete = true;

			foreach ( $content as $item ) {
				if ( $uid === $item['uid'] ) {
					$delete = false;
				}
			}

			if ( $delete ) {
				$count_deleted ++;
				wp_delete_post( get_the_ID(), false );
			}
		}

		return array(
			'success'       => true,
			'count_deleted' => $count_deleted,
		);
	}

	public function change_title( $title ) {
		if ( get_option( '_' . self::get_type_prefix() . '_enable_seo_meta' ) ) {
			global $post;

			if ( $seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true ) ) {
				$title['title'] = $seo_title;

				return $title;
			}
		}

		return $title;
	}

	public function get_description() {
		global $post;

		if ( ! $post ) {
			return '';
		}

		$seo_description = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_description', true );

		if ( empty( $seo_description ) ) {
			$seo_description = $post->post_content;
		}

		return wp_trim_words( $seo_description, 25 );
	}

	public function change_wp_head() {
		$this->customizing_layout();
		$this->set_seo_description();
		$this->set_og_tags();
	}

	public function set_seo_description() {
		if ( get_option( '_' . self::get_type_prefix() . '_enable_seo_meta' ) ) {
			echo '<meta name="description" content="' . $this->get_description() . '" />' . PHP_EOL;
		}
	}

	public function set_og_tags() {
		if ( get_option( '_' . self::get_type_prefix() . '_enable_seo_meta' ) ) {
			global $post;
			$type = is_singular() ? 'article' : 'object';

			if ( is_single() ) {
				$seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true );
				$title     = $seo_title ?: $post->post_title;
				$image     = get_the_post_thumbnail_url( $post->ID, 'large' );

				echo '<meta property="og:site_name" content="' . get_bloginfo( 'name' ) . '"/>' . PHP_EOL;
				echo '<meta property="og:type" content="' . $type . '" />' . PHP_EOL;
				echo '<meta property="og:title" content="' . $title . '" />' . PHP_EOL;
				echo '<meta property="og:description" content="' . $this->get_description() . '" />' . PHP_EOL;
				echo '<meta property="og:url" content="' . $post->guid . '" />' . PHP_EOL;
				echo '<meta property="og:image" content="' . $image . '" />' . PHP_EOL;
			}
		}
	}

	public function change_seo_meta_other_plugins() {
		//START rank_math
		add_filter( 'rank_math/frontend/title', function ( $title ) {
			if ( is_single() ) {
				global $post;

				if ( $seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true ) ) {
					return $seo_title;
				}
			}

			return $title;
		} );
		add_filter( 'rank_math/frontend/description', function ( $description ) {
			if ( is_single() ) {
				return $this->get_description();
			}

			return $description;
		} );
		//END rank_math


		//START Yoast
		add_filter( 'wpseo_opengraph_title', function ( $title ) {
			if ( is_single() ) {
				global $post;

				if ( $seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true ) ) {
					return $seo_title;
				}
			}

			return $title;
		} );
		add_filter( 'wpseo_metadesc', function ( $description ) {
			if ( is_single() ) {
				return $this->get_description();
			}

			return $description;
		} );
		add_filter( 'wpseo_opengraph_desc', function ( $description ) {
			if ( is_single() ) {
				return $this->get_description();
			}

			return $description;
		} );
		//END Yoast


		//START SEOPress
		add_filter( 'seopress_titles_title', function ( $title ) {
			if ( is_single() ) {
				global $post;

				if ( $seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true ) ) {
					return $seo_title;
				}
			}

			return $title;
		} );
		add_filter( 'seopress_titles_desc', function ( $description ) {
			if ( is_single() ) {
				return $this->get_description();
			}

			return $description;
		} );
		//END SEOPress


		//START The-SEO-Framework
		add_filter( 'the_seo_framework_title_from_custom_field', function ( $title ) {
			if ( is_single() ) {
				global $post;

				if ( $seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true ) ) {
					return $seo_title;
				}
			}

			return $title;
		} );
		add_filter( 'the_seo_framework_custom_field_description', function ( $description ) {
			if ( is_single() ) {
				return $this->get_description();
			}

			return $description;
		} );
		//END The-SEO-Framework


		//START All-in-One-SEO
		add_filter( 'aioseo_title', function ( $title ) {
			if ( is_single() ) {
				global $post;

				if ( $seo_title = get_post_meta( $post->ID, self::get_metabox_prefix() . 'seo_title', true ) ) {
					return $seo_title;
				}
			}

			return $title;
		} );

		add_filter( 'aioseo_description', function ( $description ) {
			if ( is_single() ) {
				return $this->get_description();
			}

			return $description;
		} );
		//END All-in-One-SEO
	}

	public function css_hide_page_title() {
		if ( get_post_meta( get_the_ID(), 'iu_hide_title', true ) ) { ?>
            <style>
                .entry-header,
                .entry-title {
                    display: none !important;
                }
            </style>
		<?php }
	}

	/**
	 * Add customizing layout.
	 */
	public function customizing_layout() {
		$set_tag         = '';
		$prefix          = $this->get_type_prefix();
		$custom_type_arr = get_option( '_iu_custom_type_slug' );


		if ( is_tax( array( $prefix . '_categories', $prefix . '_tags' ) ) ) {
			if ( $cat_top = get_option( '_iu_margin_top_cat' ) ) {
				$margin_top = 'margin-top: ' . $cat_top . 'px !important;';
			}
			if ( $cat_bottom = get_option( '_iu_margin_bottom_cat' ) ) {
				$margin_bottom = 'margin-bottom: ' . $cat_bottom . 'px !important;';
			}
			$set_tag = get_option( '_iu_set_for_tag_cat' );
		}

		if ( is_singular( $custom_type_arr ) ) {
			if ( $post_top = get_option( '_iu_margin_top_post' ) ) {
				if ( get_option( '_iu_use_padding_post' ) ) {
					$margin_top = 'padding-top: ' . $post_top . 'px !important;';
				} else {
					$margin_top = 'margin-top: ' . $post_top . 'px !important;';
				}
			}

			if ( $post_bottom = get_option( '_iu_margin_bottom_post' ) ) {
				if ( get_option( '_iu_use_padding_post' ) ) {
					$margin_bottom = 'padding-bottom: ' . $post_bottom . 'px !important;';
				} else {
					$margin_bottom = 'margin-bottom: ' . $post_bottom . 'px !important;';
				}
			}

			$set_tag = get_option( '_iu_set_for_tag_post' );
		}

		if ( $spec_posts = carbon_get_theme_option( 'iu_association_spec' ) ) {
			foreach ( $spec_posts as $index => $spec_post ) {
				if ( is_single( $spec_post['id'] ) || is_page( $spec_post['id'] ) ) {
					if ( $post_top = get_option( '_iu_margin_top_spec' ) ) {
						if ( get_option( '_iu_use_padding_spec' ) ) {
							$margin_top = 'padding-top: ' . $post_top . 'px !important;';
						} else {
							$margin_top = 'margin-top: ' . $post_top . 'px !important;';
						}
					}

					if ( $post_bottom = get_option( '_iu_margin_bottom_spec' ) ) {
						if ( get_option( '_iu_use_padding_spec' ) ) {
							$margin_bottom = 'padding-bottom: ' . $post_bottom . 'px !important;';
						} else {
							$margin_bottom = 'margin-bottom: ' . $post_bottom . 'px !important;';
						}
					}
				}
			}
		}

		if ( ( $all_top = get_option( '_iu_margin_top_all' ) ) || ( $all_bottom = get_option( '_iu_margin_bottom__all' ) ) ) {
			if ( $all_top = get_option( '_iu_margin_top_all' ) ) {
				$margin_top = 'margin-top: ' . $all_top . 'px !important;';
			}

			if ( $all_bottom = get_option( '_iu_margin_bottom__all' ) ) {
				$margin_bottom = 'margin-bottom: ' . $all_bottom . 'px;';
			}
			$set_tag = get_option( '_iu_set_for_tag__all' );
		}

		if ( ! empty( $margin_top ) || ! empty( $margin_bottom ) ):
			echo '<style>';
			echo ( $set_tag ?: '#content' ) . '{';
			echo $margin_top ?? '';
			echo $margin_bottom ?? '';
			echo '}';
			echo '</style>';
		endif;
	}

	public function write_log( $data, $file_name = 'temp.txt' ) {
		if ( ! is_dir( INSTANTUP_PATH . '/log/' ) ) {
			mkdir( INSTANTUP_PATH . '/log/', 0777, true );
		}

		$path = INSTANTUP_PATH . '/log/' . $file_name;

		if ( is_bool( $data ) ) {
			$new_data = (int) $data ? 'true' : 'false';

			file_put_contents( $path, $new_data . "\n\r", FILE_APPEND );

		} elseif ( is_string( $data ) ) {
			file_put_contents( $path, $data . "\n\r", FILE_APPEND );

		} else {
			file_put_contents( $path, json_encode( $data ) . "\n\r", FILE_APPEND );
		}
	}

	/**
	 * Get the prefix of the post type.
	 * @since  1.0.0
	 * @access public
	 */
	public static function get_type_prefix() {//iu
		return 'iu';
	}

	/**
	 * Get the short prefix of the metabox.
	 * @since  1.0.0
	 * @access public
	 */
	public static function prefix() {//iu-
		return self::get_metabox_prefix();
	}

	/**
	 * Get the prefix of the metabox.
	 * @since  1.0.0
	 * @access public
	 */
	public static function get_metabox_prefix() {
		return 'iu-';
	}

    public function startsWithIu($text) {
        $prefix = self::get_type_prefix() . '_';
        return substr($text, 0, strlen($prefix)) === $prefix;
    }

	/**
	 * Get the content type id according to the transmitted name.
	 * @since  1.0.0
	 * @access public
	 */
	public static function get_content_type( $val, $is_equal, $response = 'id' ) {
		$return = null;

		if ( $type_arr = get_option( '_iu_custom_type_posts' ) ) {
			foreach ( $type_arr as $item ) {
				if ( $val === $item[ $is_equal ] ) {
					$return = $item[ $response ];
				}
			}
		}

		return $return;
	}   

	public function clear_archive_title( $title ) {
		return preg_replace( '~^[^:]+: ~', '', $title );
	}

	public function my_add_theme_support() {
		add_theme_support( 'align-wide' );
	}

	public function add_submenu_link() {
		global $submenu;

		$submenu['crb_carbon_fields_container_instantuploader.php'][] = array(
			esc_html__( 'Settings', 'localseomap-for-elementor' ),
			'manage_options',
			home_url( 'wp-admin/admin.php?page=crb_carbon_fields_container_instantuploader.php' ),
		);

		$args = array(
			'post_type'  => 'page',
			'meta_key'   => '_wp_page_template',
			'meta_value' => $this->template,
		);

		$pages = get_posts( $args );

		if ( ! empty( $pages ) ) {
			$submenu['crb_carbon_fields_container_instantuploader.php'][] = array(
				$pages[0]->post_title,
				'manage_options',
				get_the_permalink( $pages[0]->ID ),
			);
		}

		wp_reset_postdata();
	}

	public function get_map_locations( $args = array(), $ids = array(), $parent_id = false ) {
		$prefix      = self::get_metabox_prefix();
		$locations   = array();
		$custom_type = '';
		$loc_option  = $parent_id !== false ? get_post_meta( $parent_id, self::get_type_prefix() . '_location_option', true ) : false;

		if ( ! isset( $args['post_type'] ) ) {
			$custom_type = get_option( '_iu_custom_type_slug' );
		}

		$defaults = array(
			'fields'         => 'ids',
			'posts_per_page' => 1000,
			'post_type'      => $custom_type,
			'meta_query'     => array(
				array(
					'key'     => '_thumbnail_id',
					'value'   => '',
					'compare' => '!=',
				),
			),
		);

		$args = wp_parse_args( $args, $defaults );

		if ( ! empty( $ids ) && is_array( $ids ) ) {
			$args['post__in'] = $ids;
		}

		$projects = new WP_Query( $args );

		if ( $projects->have_posts() ) {
			while ( $projects->have_posts() ) {
				$projects->the_post();

				$post_ID   = get_the_ID();
				$latitude  = get_post_meta( $post_ID, self::prefix() . 'latitude', true );
				$longitude = get_post_meta( $post_ID, self::prefix() . 'longitude', true );
				$image     = get_the_post_thumbnail( $post_ID, 'medium', array( 'class' => 'profolio-bg-img' ) );
				$image     = str_replace( array( 'src=', 'srcset=' ), array( 'data-src=', 'data-srcset=' ), $image );

				if ( empty( $latitude ) || empty( $longitude ) ) {
					continue;
				}

				if ( empty( $image ) ) {
					$image = '<img class="profolio-bg-img wp-post-image" alt="cover" loading="lazy" src="' . INSTANTUP_URL . 'data/assets/img/placeholder.png">';
				}

				if ( $loc_option === 'generalized' ) {
					$state   = get_post_meta( $post_ID, self::prefix() . 'state', true );
					$country = get_post_meta( $post_ID, self::prefix() . 'country', true );
					$county  = get_post_meta( $post_ID, self::prefix() . 'county', true );

					$state_out           = $state ? $state . ', ' : '';
					$generalized_address = $county ? $county : '' . $state_out . $country;
					$address             = preg_replace( "/[0-9]/", "", $generalized_address );

				} else {
					$address = get_post_meta( $post_ID, $prefix . 'address', true );
				}

				$locations[] = array(
					'title'   => get_the_title( $post_ID ),
					'link'    => get_the_permalink( $post_ID ),
					'lat'     => get_post_meta( $post_ID, $prefix . 'latitude', true ),
					'lng'     => get_post_meta( $post_ID, $prefix . 'longitude', true ),
					'address' => $address,
					'image'   => $image,
					'id'      => $post_ID,
				);

			}
		}
		wp_reset_postdata();

		return $locations;
	}

	public function init_carbon_fields() {
		require_once( INSTANTUP_PATH . 'vendor/autoload.php' );
		\Carbon_Fields\Carbon_Fields::boot();
	}

	public function get_one_location( $locations ) {
		$locations_length = count( $locations );
		$separator        = 2;
		$count            = 0;
		$result           = array(
			'39.8034993',
			'-100.5229836',
		);

		do {
			$center = round( $locations_length / ++ $separator );

			if ( isset( $locations[ $center ]['lat'] ) && isset( $locations[ $center ]['lng'] ) ) {
				return array(
					$locations[ $center ]['lat'],
					$locations[ $center ]['lng'],
				);
			}

			$count ++;

		} while ( $count < 5 );

		return $result;
	}


	public function remove_autocomplete() { ?>
        <input style="display:none">
        <input type="password" style="display:none">
		<?php
	}

	final public function creating_post_for_preview() {
		if ( ! get_option( '_temp_post_for_templates' ) ) {

			$prefix   = self::get_metabox_prefix();//iu-
			$prefix_t = self::get_type_prefix();   //iu

			$meta_input = array(
				$prefix . 'uid'          => 'temp_05c3ef4ff40349a504516a4df76a',
				$prefix . 'address'      => 'Ventura Blvd, Woodland Hills, California, USA',
				$prefix . 'city'         => 'Ventura Blvd',
				$prefix . 'county'       => 'Woodland Hills',
				$prefix . 'state'        => 'California',
				$prefix . 'country'      => 'USA',
				$prefix . 'customerName' => 'Poll',
				$prefix . 'updateDate'   => '1617622298',
				$prefix . 'latitude'     => '34.168152',
				$prefix . 'longitude'    => '-118.5989753',

				$prefix . 'stage'          => 'Published',
				$prefix . 'status_content' => 'inProgress',
				$prefix . 'status_publish' => 'notPublished',
				$prefix . 'status_service' => 'open',

				$prefix . 'testimonial_customerName'  => 'Joe M',
				$prefix . 'testimonial_customerTitle' => 'Home owner',
				$prefix . 'testimonial_des'           => 'description of testimonial. Testimonial-desc description of testimonial.',
				$prefix . 'testimonial_rating'        => 3,
				$prefix . 'testimonial_title'         => 'Testimonial title',

				$prefix . 'field_project_value' => 'field project value',
				$prefix . 'start_date'          => 'start date',
				$prefix . 'project_budget'      => 'project budget',
				$prefix . 'permit_number'       => 'permit number',
				$prefix . 'lot_size'            => 'lot size',
				$prefix . 'home_size'           => 'home size',
				$prefix . 'number_of_bedrooms'  => 'number of bedrooms',
				$prefix . 'year_built'          => 'year built',
			);

			$post_data = array(
				'post_type'      => $prefix_t . '_temp_post',
				'post_title'     => 'Temp data for templates',
				'post_content'   => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
				<h1>Headline H1</h1><h2>Headline H2</h2><h3>Headline H3</h3><h4>Headline H4</h4><h5>Headline H5</h5>',
				'post_status'    => 'private',
				'post_author'    => 1,
				'ping_status'    => 'closed',
				'comment_status' => 'closed',
				'meta_input'     => $meta_input,
			);

			if ( $post_id = wp_insert_post( $post_data ) ) {
				$media_arr = array(
					array(
						'name'     => 'temp_after.jpg',
						'tmp_name' => INSTANTUP_PATH . 'data/assets/img/temp_after.jpg',
						'error'    => 0,
						'size'     => filesize( INSTANTUP_PATH . 'data/assets/img/temp_after.jpg' ),
					),
					array(
						'name'     => 'temp_before.jpg',
						'tmp_name' => INSTANTUP_PATH . 'data/assets/img/temp_before.jpg',
						'error'    => 0,
						'size'     => filesize( INSTANTUP_PATH . 'data/assets/img/temp_before.jpg' ),
					),
					array(
						'name'     => 'temp_customer.jpg',
						'tmp_name' => INSTANTUP_PATH . 'data/assets/img/temp_customer.jpg',
						'error'    => 0,
						'size'     => filesize( INSTANTUP_PATH . 'data/assets/img/temp_customer.jpg' ),
					),
					array(
						'name'     => 'temp_pic.jpg',
						'tmp_name' => INSTANTUP_PATH . 'data/assets/img/temp_pic.jpg',
						'error'    => 0,
						'size'     => filesize( INSTANTUP_PATH . 'data/assets/img/temp_pic.jpg' ),
					),
					array(
						'name'     => 'temp_thumbnail.jpg',
						'tmp_name' => INSTANTUP_PATH . 'data/assets/img/temp_thumbnail.jpg',
						'error'    => 0,
						'size'     => filesize( INSTANTUP_PATH . 'data/assets/img/temp_thumbnail.jpg' ),
					),
					array(
						'name'     => 'temp_video.mp4',
						'tmp_name' => INSTANTUP_PATH . 'data/assets/img/temp_video.mp4',
						'error'    => 0,
						'size'     => filesize( INSTANTUP_PATH . 'data/assets/img/temp_video.mp4' ),
					),
				);

				$presentation_arr   = array();
				$testimonials_media = array();
				$pic_for_post       = array();

				foreach ( $media_arr as $media ) {
					$media_id = media_handle_sideload( $media, 0, $media['name'] );
					update_post_meta( $media_id, 'uid', '' );

					if ( $media['name'] === 'temp_thumbnail.jpg' ) {
						update_post_meta( $post_id, '_thumbnail_id', $media_id );
					}

					if ( $media['name'] === 'temp_pic.jpg' ) {
						$pic_for_post[] = $media_id;
					}

					if ( $media['name'] === 'temp_after.jpg' ) {
						$presentation_arr['after'] = $media_id;
					}
					if ( $media['name'] === 'temp_before.jpg' ) {
						$presentation_arr['before'] = $media_id;
					}

					if ( $media['name'] === 'temp_customer.jpg' ) {
						$testimonials_media['customerPhoto'] = $media_id;
					}
					if ( $media['name'] === 'temp_before.jpg' ) {
						$testimonials_media['cover'] = $media_id;
					}
					if ( $media['name'] === 'temp_video.mp4' ) {
						$testimonials_media['video'] = $media_id;
					}
				}

				for ( $i = 0; $i < 5; $i ++ ) {
					$pic_for_post[] = $pic_for_post[0];
				}

				update_post_meta( $post_id, $prefix . 'pic_for_post', $pic_for_post );
				update_post_meta( $post_id, $prefix . 'testimonial_media', $testimonials_media );
				update_post_meta( $post_id, $prefix . 'presentation', $presentation_arr );
				update_option( '_temp_post_for_templates', $post_id );
			}

		}
	}

	final public function creating_default_template_post() {
		if ( ! get_option( '_template_default_id' ) ) {

			$post_content = '<!-- wp:columns --><div class="wp-block-columns"><!-- wp:column {"width":"75%"} --><div class="wp-block-column" style="flex-basis:75%"><!-- wp:carbon-fields/iu-title /--><!-- wp:carbon-fields/iu-before-after /--><!-- wp:carbon-fields/iu-content /--><!-- wp:carbon-fields/iu-gallery {"data":{"iu_columns":"3","iu_img_height","iu_spacing_between","iu_spacing_bottom"}} /--><!-- wp:carbon-fields/iu-post-nav /--></div><!-- /wp:column --><!-- wp:column {"width":"25%"} --><div class="wp-block-column" style="flex-basis:25%"><!-- wp:carbon-fields/iu-testimonial /--><!-- wp:carbon-fields/iu-location /--><!-- wp:carbon-fields/iu-tags /--><!-- wp:carbon-fields/iu-category /--><!-- wp:carbon-fields/iu-social /--></div><!-- /wp:column --></div><!-- /wp:columns -->';

			$post_data = array(
				'post_type'    => 'iu_templates',
				'post_title'   => 'Default template for post',
				'post_content' => $post_content,
				'post_status'  => 'publish',
				'post_author'  => 1,
			);


			if ( $post_id = wp_insert_post( $post_data ) ) {
				update_option( '_template_default_id', $post_id );
			}
		}
	}

	final public function creating_default_template_cat_tag() {
		if ( ! get_option( '_iu_template_default_cat_tag' ) ) {
			$post_data = array(
				'post_type'    => 'iu_templates',
				'post_title'   => 'Default template for category and tags',
				'post_content' => '<!-- wp:carbon-fields/iu-title /--><!-- wp:carbon-fields/iu-category-and-tag /-->',
				'post_status'  => 'publish',
				'post_author'  => 1,
			);

			if ( $post_id = wp_insert_post( $post_data ) ) {
				update_option( '_iu_template_default_cat_tag', $post_id );
				update_option( '_template_for_cat_tag', array( 'all' => $post_id ) );
				update_post_meta( $post_id, '_template_for_cat_tag', array( 'all' => $post_id ) );
				update_post_meta( $post_id, 'iu_template_type', 'cat_tag' );
			}
		}
	}

	public function creating_template_citypage() {
		if ( ! get_option( '_template_citypage_id' ) ) {
			$post_data = array(
				'post_type'    => 'iu_templates',
				'post_title'   => 'Template for City Page',
				'post_content' => '<!-- wp:columns --><div class="wp-block-columns"><!-- wp:column {"width":"66.66%"} --><div class="wp-block-column" style="flex-basis:66.66%"><!-- wp:carbon-fields/iu-title {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","title_color":"#50505a","font_size":"","font_weight":"","line_height":"","position_title":"left","margin_top":"","margin_bottom":""}} /--><!-- wp:carbon-fields/iu-content {"data":{"iu_hide_full_txt":false,"content_color":"#212529","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","block_width":"","position_txt":"left","font_size":"","line_height":"","margin_top":"","margin_bottom":""}} /--><!-- wp:carbon-fields/iu-media-carousel {"data":{"iu_carousel_img_height":"","iu_carousel_spacing":"","iu_slides_per_view":"","iu_slides_to_scroll":"","iu_show_img_title":false,"iu_show_img_caption":false,"iu_show_img_desc":false,"iu_hidden_title":false,"main_title":"","main_title_color":"#212529","main_title_size":"","main_title_lh":"","buttons_inside":false,"btn_transparent":false,"btn_color_inactive":"","btn_color_active":"#0274be","btn_width":"","btn_height":"","btn_font_size":"","btn_bdrs":"","iu_hidden_pagination":false}} /--></div><!-- /wp:column --><!-- wp:column {"width":"33.33%"} --><div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:carbon-fields/iu-location {"data":{"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_location_option":"generalized","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"color_title":"#50505a","font_size":"","font_weight":"","line_height":"","margin_top":"","margin_bottom":"","iu_hide_icon_txt":false,"color_txt":"#5a5a64","font_size_txt":"","line_height_txt":"","margin_top_txt":"","margin_bottom_txt":"","position_location":"top"}} /--><!-- wp:carbon-fields/iu-tags {"data":{"only_smart_tags":false,"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","iu_hidden_title":false,"iu_hide_colon":false,"iu_hide_icon":false,"iu_underline_title":false,"color_title":"#8c8c93","font_size":"","font_weight":"normal","line_height":"","margin_top":"","margin_bottom":"","color_title_link":"#8c8c93","font_size_link":"","line_height_link":"","margin_top_link":"","margin_bottom_link":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->',
				'post_status'  => 'publish',
				'post_author'  => 1,
			);

			if ( $post_id = wp_insert_post( $post_data ) ) {
				update_option( '_template_citypage_id', $post_id, false );

				if ( $posts_type = get_option( '_iu_custom_type_slug' ) ) {
					if ( ! $template_arr = get_option( '_template_for_content' ) ) {
						$template_arr = array();
					}

					if ( ! $template_for_cnt = get_post_meta( $post_id, '_templhate_for_content', true ) ) {
						$template_for_cnt = array();
					}

					foreach ( $posts_type as $type ) {
						if ( $type === 'iu_city_page' ) {
							$template_for_cnt['iu_city_page'] = $post_id;
							$template_arr['iu_city_page']     = $post_id;
						}
					}

					update_option( '_template_for_content', $template_arr );
					update_post_meta( $post_id, '_template_for_content', $template_for_cnt );
				}
			}
		}
	}

    /**
     * @throws \JsonException
     */
    public function creating_page_map() {
		if ( ! get_option( '_page_map_project' ) ) {
            $iu_slugs = '["iu_project"]';
            if ($iu_post_type_slugs = get_option('_iu_custom_type_slug')){
                $iu_slugs = json_encode($iu_post_type_slugs, JSON_THROW_ON_ERROR);
            }
			$post_content = '<!-- wp:columns {"className":"iu-column-page"} --><div class="wp-block-columns iu-column-page"><!-- wp:column {"layout":{"wideSize":"","contentSize":""}} --><div class="wp-block-column"><!-- wp:carbon-fields/iu-content-posts {"data":{"iu_output_type":'.$iu_slugs.',"iu_posts_per_page":"","iu_main_separator":"","iu_background":"","iu_background_maine":"","iu_settings_columns":"2","iu_settings_bdrs":"16","iu_settings_height":"380","template_posts":"album","separator_realestate":"","iu_set_price":"","iu_set_item_title":"","iu_set_beds":"","iu_set_baths":"","iu_set_sqft":"","separator_priority":"","use_priority":true,"use_filters":true,"filter_template":"aside","select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","separator_count":"","use_filter_count":true,"separator_map":"","use_map_block":true,"separator_location":"","use_filter_location":true,"location_size":"","location_height":"","location_color":"#50505a","separator_radius":"","use_filter_radius":true,"radius_font_size":"","radius_line_height":"","radius_title_color":"#50505a","separator_loc":"","use_location":true,"separator_cat":"","use_category":true,"separator_tags":"","use_tags_block":true,"separator_price":"","use_filter_price":true,"separator_sort":"","use_filter_sort":true,"separator_btn_status":"","use_style_btn_status":false,"separator_btn_compl_status":"","style_compl_color":"#212529","style_compl_bgc":"#61BD4F","separator_btn_open_status":"","style_open_color":"#212529","style_open_bgc":"#0079BF","separator_btn_reset_status":"","style_reset_color":"#ffffff","style_reset_bgc":"#343a40","separator_custon_filter":"","iu_custom_filter":[],"iu_show_post_title":true,"iu_post_title_color":"","iu_post_title_size":"14","iu_post_title_top":"","iu_post_title_right":"","iu_post_title_bottom":"","iu_post_title_left":"","iu_post_title_blur_use":false,"iu_post_title_blur_intensity":"","iu_pic_show":"yes","iu_pic_set_image":"","iu_pic_set_height":"100","iu_pic_set_size":"iu-medium","iu_show_loc_title":"yes","iu_loc_color":"","iu_location_option":"generalized","iu_loc_font":"","iu_loc_size":"11","iu_loc_top":"","iu_loc_right":"","iu_loc_bottom":"","iu_loc_left":"","iu_show_cat":false,"iu_cat_color":"","iu_cat_text_color":"","iu_cat_bdrs":"","iu_cat_font":"","iu_cat_weight":"","iu_cat_size":"14","iu_cat_top":"","iu_cat_right":"","iu_cat_bottom":"","iu_cat_left":"","iu_cat_p_top":"","iu_cat_p_right":"","iu_cat_p_bottom":"","iu_cat_p_left":"","iu_nav_bgc_current":"","iu_nav_color_current":"","iu_nav_bgc_all":"","iu_nav_color_all":"","iu_nav_bgc_all_hover":"","iu_nav_color_all_hover":"","iu_nav_width":"","iu_nav_height":"","iu_nav_size_current":"","iu_nav_size_all":"","iu_nav_weight_current":"","iu_nav_weight_all":"400","iu_nav_bdrs_current":"","iu_nav_bdrs_all":"","iu_nav_top":"","iu_nav_bottom":"","iu_margin_top":"","iu_margin_bottom":"","mob_btn_bottom_pos":"","active_color":""}} /--></div><!-- /wp:column --><!-- wp:column {"className":"iu-content-map-box d-none"} --><div class="wp-block-column iu-content-map-box d-none"><!-- wp:carbon-fields/iu-content-map {"data":{"iu_zoom_all_markers":"yes","iu_map_fullheight":"yes","iu_hide_info_window":false,"iu_hide_map":true,"iu_blue_icon":true,"iu_map_which_posts":"current_page","marker_image":""}} /--></div><!-- /wp:column --></div><!-- /wp:columns -->';

			$post_data = array(
				'post_type'    => 'page',
				'post_title'   => 'Project map',
				'post_content' => $post_content,
				'post_status'  => 'publish',
				'post_author'  => 1,
			);

			if ( $post_id = wp_insert_post( $post_data ) ) {
				update_post_meta( $post_id, 'iu_content_width', 'full_width' );
				update_option( '_page_map_project', $post_id, false );
				update_post_meta( self::get_type_prefix() . '_location_option', $post_id, false );
			}

			# create old style page map
			$post_cnt_old = '<!-- wp:columns --><div class="wp-block-columns"><!-- wp:column {"width":"55%"} --><div class="wp-block-column" style="flex-basis:55%"><!-- wp:carbon-fields/iu-content-map {"data":{"iu_zoom_all_markers":"yes","iu_map_fullheight":"yes","iu_hide_info_window":false,"iu_map_which_posts":"current_page","marker_image":""}} /--></div><!-- /wp:column --><!-- wp:column {"width":"48%","className":"iu-project-map"} --><div class="wp-block-column iu-project-map" style="flex-basis:48%"><!-- wp:carbon-fields/iu-content-posts /--></div><!-- /wp:column --></div><!-- /wp:columns -->';

			$post_data_old = array(
				'post_type'    => 'page',
				'post_title'   => 'Old project map',
				'post_content' => $post_cnt_old,
				'post_status'  => 'draft',
				'post_author'  => 1,
			);

			if ( $post_id_old = wp_insert_post( $post_data_old ) ) {
				update_post_meta( $post_id_old, 'iu_content_width', 'full_width' );
				update_post_meta( self::get_type_prefix() . '_location_option', $post_id_old, false );
			}
		}
	}

	public function creating_old_page_map() {

	}

	public function creating_servicearea_map() {
		if ( ! get_option( '_page_map_servicearea' ) ) {

			$post_content = '<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"width":"60%"} -->
<div class="wp-block-column" style="flex-basis:60%"><!-- wp:carbon-fields/iu-content-map /--></div>
<!-- /wp:column -->
<!-- wp:column {"width":"40%"} -->
<div class="wp-block-column" style="flex-basis:40%"><!-- wp:carbon-fields/iu-content-posts {"data":{"iu_output_type":["iu_city_page"],"iu_posts_per_page":"","iu_main_separator":"","iu_background":"","iu_background_maine":"#f5f5fa","iu_settings_columns":"2","iu_settings_bdrs":"","template_posts":"album","separator_realestate":"","iu_set_price":"","iu_set_item_title":"","iu_set_beds":"","iu_set_baths":"","iu_set_sqft":"","separator_priority":"","use_priority":true,"use_filters":false,"select_fonts":"Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic","separator_location":"","use_filter_location":false,"location_size":"","location_height":"","location_color":"#50505a","separator_radius":"","use_filter_radius":false,"radius_font_size":"","radius_line_height":"","radius_title_color":"#50505a","separator_price":"","use_filter_price":true,"separator_sort":"","use_filter_sort":true,"separator_count":"","use_filter_count":true,"separator_custon_filter":"","iu_custom_filter":[],"iu_show_post_title":"yes","iu_post_title_color":"","iu_post_title_size":"14","iu_post_title_top":"","iu_post_title_right":"","iu_post_title_bottom":"","iu_post_title_left":"","iu_pic_show":"yes","iu_pic_set_image":"","iu_pic_set_height":"100","iu_pic_set_size":"iu-medium","iu_show_loc_title":"yes","iu_loc_color":"","iu_location_option":"generalized","iu_loc_font":"","iu_loc_size":"11","iu_loc_top":"","iu_loc_right":"","iu_loc_bottom":"","iu_loc_left":"","iu_show_cat":"yes","iu_cat_color":"","iu_cat_text_color":"","iu_cat_bdrs":"","iu_cat_font":"","iu_cat_weight":"","iu_cat_size":"14","iu_cat_top":"","iu_cat_right":"","iu_cat_bottom":"","iu_cat_left":"","iu_cat_p_top":"","iu_cat_p_right":"","iu_cat_p_bottom":"","iu_cat_p_left":"","iu_nav_bgc_current":"","iu_nav_color_current":"","iu_nav_bgc_all":"","iu_nav_color_all":"","iu_nav_bgc_all_hover":"","iu_nav_color_all_hover":"","iu_nav_width":"","iu_nav_height":"","iu_nav_size_current":"","iu_nav_size_all":"","iu_nav_weight_current":"","iu_nav_weight_all":"400","iu_nav_bdrs_current":"","iu_nav_bdrs_all":"","iu_nav_top":"","iu_nav_bottom":""}} /--></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->';

			$post_data = array(
				'post_type'    => 'page',
				'post_title'   => 'Service area map',
				'post_content' => $post_content,
				'post_status'  => 'publish',
				'post_author'  => 1,
			);

			if ( $post_id = wp_insert_post( $post_data ) ) {
				update_post_meta( $post_id, 'iu_content_width', 'full_width' );
				update_option( '_page_map_servicearea', $post_id, false );
			}
		}
	}

	public function get_list_fonts() {
		$list_fonts = array(
			'ABeeZee:regular,italic'                                                                                                                                   => 'ABeeZee',
			'Abel:regular'                                                                                                                                             => 'Abel',
			'Abhaya Libre:regular,500,600,700,800'                                                                                                                     => 'Abhaya Libre',
			'Abril Fatface:regular'                                                                                                                                    => 'Abril Fatface',
			'Aclonica:regular'                                                                                                                                         => 'Aclonica',
			'Acme:regular'                                                                                                                                             => 'Acme',
			'Actor:regular'                                                                                                                                            => 'Actor',
			'Adamina:regular'                                                                                                                                          => 'Adamina',
			'Advent Pro:100,200,300,regular,500,600,700'                                                                                                               => 'Advent Pro',
			'Aguafina Script:regular'                                                                                                                                  => 'Aguafina Script',
			'Akaya Kanadaka:regular'                                                                                                                                   => 'Akaya Kanadaka',
			'Akaya Telivigala:regular'                                                                                                                                 => 'Akaya Telivigala',
			'Akronim:regular'                                                                                                                                          => 'Akronim',
			'Aladin:regular'                                                                                                                                           => 'Aladin',
			'Alata:regular'                                                                                                                                            => 'Alata',
			'Alatsi:regular'                                                                                                                                           => 'Alatsi',
			'Aldrich:regular'                                                                                                                                          => 'Aldrich',
			'Alef:regular,700'                                                                                                                                         => 'Alef',
			'Alegreya:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic'                                                            => 'Alegreya',
			'Alegreya SC:regular,italic,500,500italic,700,700italic,800,800italic,900,900italic'                                                                       => 'Alegreya SC',
			'Alegreya Sans:100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,800,800italic,900,900italic'                                         => 'Alegreya Sans',
			'Alegreya Sans SC:100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,800,800italic,900,900italic'                                      => 'Alegreya Sans SC',
			'Aleo:300,300italic,regular,italic,700,700italic'                                                                                                          => 'Aleo',
			'Alex Brush:regular'                                                                                                                                       => 'Alex Brush',
			'Alfa Slab One:regular'                                                                                                                                    => 'Alfa Slab One',
			'Alice:regular'                                                                                                                                            => 'Alice',
			'Alike:regular'                                                                                                                                            => 'Alike',
			'Alike Angular:regular'                                                                                                                                    => 'Alike Angular',
			'Allan:regular,700'                                                                                                                                        => 'Allan',
			'Allerta:regular'                                                                                                                                          => 'Allerta',
			'Allerta Stencil:regular'                                                                                                                                  => 'Allerta Stencil',
			'Allura:regular'                                                                                                                                           => 'Allura',
			'Almarai:300,regular,700,800'                                                                                                                              => 'Almarai',
			'Almendra:regular,italic,700,700italic'                                                                                                                    => 'Almendra',
			'Almendra Display:regular'                                                                                                                                 => 'Almendra Display',
			'Almendra SC:regular'                                                                                                                                      => 'Almendra SC',
			'Amarante:regular'                                                                                                                                         => 'Amarante',
			'Amaranth:regular,italic,700,700italic'                                                                                                                    => 'Amaranth',
			'Amatic SC:regular,700'                                                                                                                                    => 'Amatic SC',
			'Amethysta:regular'                                                                                                                                        => 'Amethysta',
			'Amiko:regular,600,700'                                                                                                                                    => 'Amiko',
			'Amiri:regular,italic,700,700italic'                                                                                                                       => 'Amiri',
			'Amita:regular,700'                                                                                                                                        => 'Amita',
			'Anaheim:regular'                                                                                                                                          => 'Anaheim',
			'Andada:regular'                                                                                                                                           => 'Andada',
			'Andika:regular'                                                                                                                                           => 'Andika',
			'Andika New Basic:regular,italic,700,700italic'                                                                                                            => 'Andika New Basic',
			'Angkor:regular'                                                                                                                                           => 'Angkor',
			'Annie Use Your Telescope:regular'                                                                                                                         => 'Annie Use Your Telescope',
			'Anonymous Pro:regular,italic,700,700italic'                                                                                                               => 'Anonymous Pro',
			'Antic:regular'                                                                                                                                            => 'Antic',
			'Antic Didone:regular'                                                                                                                                     => 'Antic Didone',
			'Antic Slab:regular'                                                                                                                                       => 'Antic Slab',
			'Anton:regular'                                                                                                                                            => 'Anton',
			'Antonio:100,200,300,regular,500,600,700'                                                                                                                  => 'Antonio',
			'Arapey:regular,italic'                                                                                                                                    => 'Arapey',
			'Arbutus:regular'                                                                                                                                          => 'Arbutus',
			'Arbutus Slab:regular'                                                                                                                                     => 'Arbutus Slab',
			'Architects Daughter:regular'                                                                                                                              => 'Architects Daughter',
			'Archivo:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                   => 'Archivo',
			'Archivo Black:regular'                                                                                                                                    => 'Archivo Black',
			'Archivo Narrow:regular,italic,500,500italic,600,600italic,700,700italic'                                                                                  => 'Archivo Narrow',
			'Aref Ruqaa:regular,700'                                                                                                                                   => 'Aref Ruqaa',
			'Arima Madurai:100,200,300,regular,500,700,800,900'                                                                                                        => 'Arima Madurai',
			'Arimo:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                           => 'Arimo',
			'Arizonia:regular'                                                                                                                                         => 'Arizonia',
			'Armata:regular'                                                                                                                                           => 'Armata',
			'Arsenal:regular,italic,700,700italic'                                                                                                                     => 'Arsenal',
			'Artifika:regular'                                                                                                                                         => 'Artifika',
			'Arvo:regular,italic,700,700italic'                                                                                                                        => 'Arvo',
			'Arya:regular,700'                                                                                                                                         => 'Arya',
			'Asap:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                            => 'Asap',
			'Asap Condensed:regular,italic,500,500italic,600,600italic,700,700italic'                                                                                  => 'Asap Condensed',
			'Asar:regular'                                                                                                                                             => 'Asar',
			'Asset:regular'                                                                                                                                            => 'Asset',
			'Assistant:200,300,regular,500,600,700,800'                                                                                                                => 'Assistant',
			'Astloch:regular,700'                                                                                                                                      => 'Astloch',
			'Asul:regular,700'                                                                                                                                         => 'Asul',
			'Athiti:200,300,regular,500,600,700'                                                                                                                       => 'Athiti',
			'Atma:300,regular,500,600,700'                                                                                                                             => 'Atma',
			'Atomic Age:regular'                                                                                                                                       => 'Atomic Age',
			'Aubrey:regular'                                                                                                                                           => 'Aubrey',
			'Audiowide:regular'                                                                                                                                        => 'Audiowide',
			'Autour One:regular'                                                                                                                                       => 'Autour One',
			'Average:regular'                                                                                                                                          => 'Average',
			'Average Sans:regular'                                                                                                                                     => 'Average Sans',
			'Averia Gruesa Libre:regular'                                                                                                                              => 'Averia Gruesa Libre',
			'Averia Libre:300,300italic,regular,italic,700,700italic'                                                                                                  => 'Averia Libre',
			'Averia Sans Libre:300,300italic,regular,italic,700,700italic'                                                                                             => 'Averia Sans Libre',
			'Averia Serif Libre:300,300italic,regular,italic,700,700italic'                                                                                            => 'Averia Serif Libre',
			'B612:regular,italic,700,700italic'                                                                                                                        => 'B612',
			'B612 Mono:regular,italic,700,700italic'                                                                                                                   => 'B612 Mono',
			'Bad Script:regular'                                                                                                                                       => 'Bad Script',
			'Bahiana:regular'                                                                                                                                          => 'Bahiana',
			'Bahianita:regular'                                                                                                                                        => 'Bahianita',
			'Bai Jamjuree:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                        => 'Bai Jamjuree',
			'Ballet:regular'                                                                                                                                           => 'Ballet',
			'Baloo 2:regular,500,600,700,800'                                                                                                                          => 'Baloo 2',
			'Baloo Bhai 2:regular,500,600,700,800'                                                                                                                     => 'Baloo Bhai 2',
			'Baloo Bhaina 2:regular,500,600,700,800'                                                                                                                   => 'Baloo Bhaina 2',
			'Baloo Chettan 2:regular,500,600,700,800'                                                                                                                  => 'Baloo Chettan 2',
			'Baloo Da 2:regular,500,600,700,800'                                                                                                                       => 'Baloo Da 2',
			'Baloo Paaji 2:regular,500,600,700,800'                                                                                                                    => 'Baloo Paaji 2',
			'Baloo Tamma 2:regular,500,600,700,800'                                                                                                                    => 'Baloo Tamma 2',
			'Baloo Tammudu 2:regular,500,600,700,800'                                                                                                                  => 'Baloo Tammudu 2',
			'Baloo Thambi 2:regular,500,600,700,800'                                                                                                                   => 'Baloo Thambi 2',
			'Balsamiq Sans:regular,italic,700,700italic'                                                                                                               => 'Balsamiq Sans',
			'Balthazar:regular'                                                                                                                                        => 'Balthazar',
			'Bangers:regular'                                                                                                                                          => 'Bangers',
			'Barlow:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                    => 'Barlow',
			'Barlow Condensed:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'          => 'Barlow Condensed',
			'Barlow Semi Condensed:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'     => 'Barlow Semi Condensed',
			'Barriecito:regular'                                                                                                                                       => 'Barriecito',
			'Barrio:regular'                                                                                                                                           => 'Barrio',
			'Basic:regular'                                                                                                                                            => 'Basic',
			'Baskervville:regular,italic'                                                                                                                              => 'Baskervville',
			'Battambang:regular,700'                                                                                                                                   => 'Battambang',
			'Baumans:regular'                                                                                                                                          => 'Baumans',
			'Bayon:regular'                                                                                                                                            => 'Bayon',
			'Be Vietnam:100,100italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic'                                            => 'Be Vietnam',
			'Bebas Neue:regular'                                                                                                                                       => 'Bebas Neue',
			'Belgrano:regular'                                                                                                                                         => 'Belgrano',
			'Bellefair:regular'                                                                                                                                        => 'Bellefair',
			'Belleza:regular'                                                                                                                                          => 'Belleza',
			'Bellota:300,300italic,regular,italic,700,700italic'                                                                                                       => 'Bellota',
			'Bellota Text:300,300italic,regular,italic,700,700italic'                                                                                                  => 'Bellota Text',
			'BenchNine:300,regular,700'                                                                                                                                => 'BenchNine',
			'Benne:regular'                                                                                                                                            => 'Benne',
			'Bentham:regular'                                                                                                                                          => 'Bentham',
			'Berkshire Swash:regular'                                                                                                                                  => 'Berkshire Swash',
			'Beth Ellen:regular'                                                                                                                                       => 'Beth Ellen',
			'Bevan:regular'                                                                                                                                            => 'Bevan',
			'Big Shoulders Display:100,300,regular,500,600,700,800,900'                                                                                                => 'Big Shoulders Display',
			'Big Shoulders Inline Display:100,300,regular,500,600,700,800,900'                                                                                         => 'Big Shoulders Inline Display',
			'Big Shoulders Inline Text:100,300,regular,500,600,700,800,900'                                                                                            => 'Big Shoulders Inline Text',
			'Big Shoulders Stencil Display:100,300,regular,500,600,700,800,900'                                                                                        => 'Big Shoulders Stencil Display',
			'Big Shoulders Stencil Text:100,300,regular,500,600,700,800,900'                                                                                           => 'Big Shoulders Stencil Text',
			'Big Shoulders Text:100,300,regular,500,600,700,800,900'                                                                                                   => 'Big Shoulders Text',
			'Bigelow Rules:regular'                                                                                                                                    => 'Bigelow Rules',
			'Bigshot One:regular'                                                                                                                                      => 'Bigshot One',
			'Bilbo:regular'                                                                                                                                            => 'Bilbo',
			'Bilbo Swash Caps:regular'                                                                                                                                 => 'Bilbo Swash Caps',
			'BioRhyme:200,300,regular,700,800'                                                                                                                         => 'BioRhyme',
			'BioRhyme Expanded:200,300,regular,700,800'                                                                                                                => 'BioRhyme Expanded',
			'Biryani:200,300,regular,600,700,800,900'                                                                                                                  => 'Biryani',
			'Bitter:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                    => 'Bitter',
			'Black And White Picture:regular'                                                                                                                          => 'Black And White Picture',
			'Black Han Sans:regular'                                                                                                                                   => 'Black Han Sans',
			'Black Ops One:regular'                                                                                                                                    => 'Black Ops One',
			'Blinker:100,200,300,regular,600,700,800,900'                                                                                                              => 'Blinker',
			'Bodoni Moda:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic'                                                         => 'Bodoni Moda',
			'Bokor:regular'                                                                                                                                            => 'Bokor',
			'Bonbon:regular'                                                                                                                                           => 'Bonbon',
			'Boogaloo:regular'                                                                                                                                         => 'Boogaloo',
			'Bowlby One:regular'                                                                                                                                       => 'Bowlby One',
			'Bowlby One SC:regular'                                                                                                                                    => 'Bowlby One SC',
			'Brawler:regular'                                                                                                                                          => 'Brawler',
			'Bree Serif:regular'                                                                                                                                       => 'Bree Serif',
			'Brygada 1918:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                    => 'Brygada 1918',
			'Bubblegum Sans:regular'                                                                                                                                   => 'Bubblegum Sans',
			'Bubbler One:regular'                                                                                                                                      => 'Bubbler One',
			'Buda:300'                                                                                                                                                 => 'Buda',
			'Buenard:regular,700'                                                                                                                                      => 'Buenard',
			'Bungee:regular'                                                                                                                                           => 'Bungee',
			'Bungee Hairline:regular'                                                                                                                                  => 'Bungee Hairline',
			'Bungee Inline:regular'                                                                                                                                    => 'Bungee Inline',
			'Bungee Outline:regular'                                                                                                                                   => 'Bungee Outline',
			'Bungee Shade:regular'                                                                                                                                     => 'Bungee Shade',
			'Butcherman:regular'                                                                                                                                       => 'Butcherman',
			'Butterfly Kids:regular'                                                                                                                                   => 'Butterfly Kids',
			'Cabin:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                           => 'Cabin',
			'Cabin Condensed:regular,500,600,700'                                                                                                                      => 'Cabin Condensed',
			'Cabin Sketch:regular,700'                                                                                                                                 => 'Cabin Sketch',
			'Caesar Dressing:regular'                                                                                                                                  => 'Caesar Dressing',
			'Cagliostro:regular'                                                                                                                                       => 'Cagliostro',
			'Cairo:200,300,regular,600,700,900'                                                                                                                        => 'Cairo',
			'Caladea:regular,italic,700,700italic'                                                                                                                     => 'Caladea',
			'Calistoga:regular'                                                                                                                                        => 'Calistoga',
			'Calligraffitti:regular'                                                                                                                                   => 'Calligraffitti',
			'Cambay:regular,italic,700,700italic'                                                                                                                      => 'Cambay',
			'Cambo:regular'                                                                                                                                            => 'Cambo',
			'Candal:regular'                                                                                                                                           => 'Candal',
			'Cantarell:regular,italic,700,700italic'                                                                                                                   => 'Cantarell',
			'Cantata One:regular'                                                                                                                                      => 'Cantata One',
			'Cantora One:regular'                                                                                                                                      => 'Cantora One',
			'Capriola:regular'                                                                                                                                         => 'Capriola',
			'Cardo:regular,italic,700'                                                                                                                                 => 'Cardo',
			'Carme:regular'                                                                                                                                            => 'Carme',
			'Carrois Gothic:regular'                                                                                                                                   => 'Carrois Gothic',
			'Carrois Gothic SC:regular'                                                                                                                                => 'Carrois Gothic SC',
			'Carter One:regular'                                                                                                                                       => 'Carter One',
			'Castoro:regular,italic'                                                                                                                                   => 'Castoro',
			'Catamaran:100,200,300,regular,500,600,700,800,900'                                                                                                        => 'Catamaran',
			'Caudex:regular,italic,700,700italic'                                                                                                                      => 'Caudex',
			'Caveat:regular,500,600,700'                                                                                                                               => 'Caveat',
			'Caveat Brush:regular'                                                                                                                                     => 'Caveat Brush',
			'Cedarville Cursive:regular'                                                                                                                               => 'Cedarville Cursive',
			'Ceviche One:regular'                                                                                                                                      => 'Ceviche One',
			'Chakra Petch:300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                      => 'Chakra Petch',
			'Changa:200,300,regular,500,600,700,800'                                                                                                                   => 'Changa',
			'Changa One:regular,italic'                                                                                                                                => 'Changa One',
			'Chango:regular'                                                                                                                                           => 'Chango',
			'Charm:regular,700'                                                                                                                                        => 'Charm',
			'Charmonman:regular,700'                                                                                                                                   => 'Charmonman',
			'Chathura:100,300,regular,700,800'                                                                                                                         => 'Chathura',
			'Chau Philomene One:regular,italic'                                                                                                                        => 'Chau Philomene One',
			'Chela One:regular'                                                                                                                                        => 'Chela One',
			'Chelsea Market:regular'                                                                                                                                   => 'Chelsea Market',
			'Chenla:regular'                                                                                                                                           => 'Chenla',
			'Cherry Cream Soda:regular'                                                                                                                                => 'Cherry Cream Soda',
			'Cherry Swash:regular,700'                                                                                                                                 => 'Cherry Swash',
			'Chewy:regular'                                                                                                                                            => 'Chewy',
			'Chicle:regular'                                                                                                                                           => 'Chicle',
			'Chilanka:regular'                                                                                                                                         => 'Chilanka',
			'Chivo:300,300italic,regular,italic,700,700italic,900,900italic'                                                                                           => 'Chivo',
			'Chonburi:regular'                                                                                                                                         => 'Chonburi',
			'Cinzel:regular,500,600,700,800,900'                                                                                                                       => 'Cinzel',
			'Cinzel Decorative:regular,700,900'                                                                                                                        => 'Cinzel Decorative',
			'Clicker Script:regular'                                                                                                                                   => 'Clicker Script',
			'Coda:regular,800'                                                                                                                                         => 'Coda',
			'Coda Caption:800'                                                                                                                                         => 'Coda Caption',
			'Codystar:300,regular'                                                                                                                                     => 'Codystar',
			'Coiny:regular'                                                                                                                                            => 'Coiny',
			'Combo:regular'                                                                                                                                            => 'Combo',
			'Comfortaa:300,regular,500,600,700'                                                                                                                        => 'Comfortaa',
			'Comic Neue:300,300italic,regular,italic,700,700italic'                                                                                                    => 'Comic Neue',
			'Coming Soon:regular'                                                                                                                                      => 'Coming Soon',
			'Commissioner:100,200,300,regular,500,600,700,800,900'                                                                                                     => 'Commissioner',
			'Concert One:regular'                                                                                                                                      => 'Concert One',
			'Condiment:regular'                                                                                                                                        => 'Condiment',
			'Content:regular,700'                                                                                                                                      => 'Content',
			'Contrail One:regular'                                                                                                                                     => 'Contrail One',
			'Convergence:regular'                                                                                                                                      => 'Convergence',
			'Cookie:regular'                                                                                                                                           => 'Cookie',
			'Copse:regular'                                                                                                                                            => 'Copse',
			'Corben:regular,700'                                                                                                                                       => 'Corben',
			'Cormorant:300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                         => 'Cormorant',
			'Cormorant Garamond:300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                => 'Cormorant Garamond',
			'Cormorant Infant:300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                  => 'Cormorant Infant',
			'Cormorant SC:300,regular,500,600,700'                                                                                                                     => 'Cormorant SC',
			'Cormorant Unicase:300,regular,500,600,700'                                                                                                                => 'Cormorant Unicase',
			'Cormorant Upright:300,regular,500,600,700'                                                                                                                => 'Cormorant Upright',
			'Courgette:regular'                                                                                                                                        => 'Courgette',
			'Courier Prime:regular,italic,700,700italic'                                                                                                               => 'Courier Prime',
			'Cousine:regular,italic,700,700italic'                                                                                                                     => 'Cousine',
			'Coustard:regular,900'                                                                                                                                     => 'Coustard',
			'Covered By Your Grace:regular'                                                                                                                            => 'Covered By Your Grace',
			'Crafty Girls:regular'                                                                                                                                     => 'Crafty Girls',
			'Creepster:regular'                                                                                                                                        => 'Creepster',
			'Crete Round:regular,italic'                                                                                                                               => 'Crete Round',
			'Crimson Pro:200,300,regular,500,600,700,800,900,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                             => 'Crimson Pro',
			'Crimson Text:regular,italic,600,600italic,700,700italic'                                                                                                  => 'Crimson Text',
			'Croissant One:regular'                                                                                                                                    => 'Croissant One',
			'Crushed:regular'                                                                                                                                          => 'Crushed',
			'Cuprum:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                          => 'Cuprum',
			'Cute Font:regular'                                                                                                                                        => 'Cute Font',
			'Cutive:regular'                                                                                                                                           => 'Cutive',
			'Cutive Mono:regular'                                                                                                                                      => 'Cutive Mono',
			'DM Mono:300,300italic,regular,italic,500,500italic'                                                                                                       => 'DM Mono',
			'DM Sans:regular,italic,500,500italic,700,700italic'                                                                                                       => 'DM Sans',
			'DM Serif Display:regular,italic'                                                                                                                          => 'DM Serif Display',
			'DM Serif Text:regular,italic'                                                                                                                             => 'DM Serif Text',
			'Damion:regular'                                                                                                                                           => 'Damion',
			'Dancing Script:regular,500,600,700'                                                                                                                       => 'Dancing Script',
			'Dangrek:regular'                                                                                                                                          => 'Dangrek',
			'Darker Grotesque:300,regular,500,600,700,800,900'                                                                                                         => 'Darker Grotesque',
			'David Libre:regular,500,700'                                                                                                                              => 'David Libre',
			'Dawning of a New Day:regular'                                                                                                                             => 'Dawning of a New Day',
			'Days One:regular'                                                                                                                                         => 'Days One',
			'Dekko:regular'                                                                                                                                            => 'Dekko',
			'Dela Gothic One:regular'                                                                                                                                  => 'Dela Gothic One',
			'Delius:regular'                                                                                                                                           => 'Delius',
			'Delius Swash Caps:regular'                                                                                                                                => 'Delius Swash Caps',
			'Delius Unicase:regular,700'                                                                                                                               => 'Delius Unicase',
			'Della Respira:regular'                                                                                                                                    => 'Della Respira',
			'Denk One:regular'                                                                                                                                         => 'Denk One',
			'Devonshire:regular'                                                                                                                                       => 'Devonshire',
			'Dhurjati:regular'                                                                                                                                         => 'Dhurjati',
			'Didact Gothic:regular'                                                                                                                                    => 'Didact Gothic',
			'Diplomata:regular'                                                                                                                                        => 'Diplomata',
			'Diplomata SC:regular'                                                                                                                                     => 'Diplomata SC',
			'Do Hyeon:regular'                                                                                                                                         => 'Do Hyeon',
			'Dokdo:regular'                                                                                                                                            => 'Dokdo',
			'Domine:regular,500,600,700'                                                                                                                               => 'Domine',
			'Donegal One:regular'                                                                                                                                      => 'Donegal One',
			'Doppio One:regular'                                                                                                                                       => 'Doppio One',
			'Dorsa:regular'                                                                                                                                            => 'Dorsa',
			'Dosis:200,300,regular,500,600,700,800'                                                                                                                    => 'Dosis',
			'DotGothic16:regular'                                                                                                                                      => 'DotGothic16',
			'Dr Sugiyama:regular'                                                                                                                                      => 'Dr Sugiyama',
			'Duru Sans:regular'                                                                                                                                        => 'Duru Sans',
			'Dynalight:regular'                                                                                                                                        => 'Dynalight',
			'EB Garamond:regular,500,600,700,800,italic,500italic,600italic,700italic,800italic'                                                                       => 'EB Garamond',
			'Eagle Lake:regular'                                                                                                                                       => 'Eagle Lake',
			'East Sea Dokdo:regular'                                                                                                                                   => 'East Sea Dokdo',
			'Eater:regular'                                                                                                                                            => 'Eater',
			'Economica:regular,italic,700,700italic'                                                                                                                   => 'Economica',
			'Eczar:regular,500,600,700,800'                                                                                                                            => 'Eczar',
			'El Messiri:regular,500,600,700'                                                                                                                           => 'El Messiri',
			'Electrolize:regular'                                                                                                                                      => 'Electrolize',
			'Elsie:regular,900'                                                                                                                                        => 'Elsie',
			'Elsie Swash Caps:regular,900'                                                                                                                             => 'Elsie Swash Caps',
			'Emblema One:regular'                                                                                                                                      => 'Emblema One',
			'Emilys Candy:regular'                                                                                                                                     => 'Emilys Candy',
			'Encode Sans:100,200,300,regular,500,600,700,800,900'                                                                                                      => 'Encode Sans',
			'Encode Sans Condensed:100,200,300,regular,500,600,700,800,900'                                                                                            => 'Encode Sans Condensed',
			'Encode Sans Expanded:100,200,300,regular,500,600,700,800,900'                                                                                             => 'Encode Sans Expanded',
			'Encode Sans Semi Condensed:100,200,300,regular,500,600,700,800,900'                                                                                       => 'Encode Sans Semi Condensed',
			'Encode Sans Semi Expanded:100,200,300,regular,500,600,700,800,900'                                                                                        => 'Encode Sans Semi Expanded',
			'Engagement:regular'                                                                                                                                       => 'Engagement',
			'Englebert:regular'                                                                                                                                        => 'Englebert',
			'Enriqueta:regular,500,600,700'                                                                                                                            => 'Enriqueta',
			'Epilogue:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                  => 'Epilogue',
			'Erica One:regular'                                                                                                                                        => 'Erica One',
			'Esteban:regular'                                                                                                                                          => 'Esteban',
			'Euphoria Script:regular'                                                                                                                                  => 'Euphoria Script',
			'Ewert:regular'                                                                                                                                            => 'Ewert',
			'Exo:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                       => 'Exo',
			'Exo 2:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                     => 'Exo 2',
			'Expletus Sans:regular,italic,500,500italic,600,600italic,700,700italic'                                                                                   => 'Expletus Sans',
			'Fahkwang:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                            => 'Fahkwang',
			'Fanwood Text:regular,italic'                                                                                                                              => 'Fanwood Text',
			'Farro:300,regular,500,700'                                                                                                                                => 'Farro',
			'Farsan:regular'                                                                                                                                           => 'Farsan',
			'Fascinate:regular'                                                                                                                                        => 'Fascinate',
			'Fascinate Inline:regular'                                                                                                                                 => 'Fascinate Inline',
			'Faster One:regular'                                                                                                                                       => 'Faster One',
			'Fasthand:regular'                                                                                                                                         => 'Fasthand',
			'Fauna One:regular'                                                                                                                                        => 'Fauna One',
			'Faustina:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                        => 'Faustina',
			'Federant:regular'                                                                                                                                         => 'Federant',
			'Federo:regular'                                                                                                                                           => 'Federo',
			'Felipa:regular'                                                                                                                                           => 'Felipa',
			'Fenix:regular'                                                                                                                                            => 'Fenix',
			'Finger Paint:regular'                                                                                                                                     => 'Finger Paint',
			'Fira Code:300,regular,500,600,700'                                                                                                                        => 'Fira Code',
			'Fira Mono:regular,500,700'                                                                                                                                => 'Fira Mono',
			'Fira Sans:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                 => 'Fira Sans',
			'Fira Sans Condensed:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'       => 'Fira Sans Condensed',
			'Fira Sans Extra Condensed:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Fira Sans Extra Condensed',
			'Fjalla One:regular'                                                                                                                                       => 'Fjalla One',
			'Fjord One:regular'                                                                                                                                        => 'Fjord One',
			'Flamenco:300,regular'                                                                                                                                     => 'Flamenco',
			'Flavors:regular'                                                                                                                                          => 'Flavors',
			'Fondamento:regular,italic'                                                                                                                                => 'Fondamento',
			'Fontdiner Swanky:regular'                                                                                                                                 => 'Fontdiner Swanky',
			'Forum:regular'                                                                                                                                            => 'Forum',
			'Francois One:regular'                                                                                                                                     => 'Francois One',
			'Frank Ruhl Libre:300,regular,500,700,900'                                                                                                                 => 'Frank Ruhl Libre',
			'Fraunces:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                  => 'Fraunces',
			'Freckle Face:regular'                                                                                                                                     => 'Freckle Face',
			'Fredericka the Great:regular'                                                                                                                             => 'Fredericka the Great',
			'Fredoka One:regular'                                                                                                                                      => 'Fredoka One',
			'Freehand:regular'                                                                                                                                         => 'Freehand',
			'Fresca:regular'                                                                                                                                           => 'Fresca',
			'Frijole:regular'                                                                                                                                          => 'Frijole',
			'Fruktur:regular'                                                                                                                                          => 'Fruktur',
			'Fugaz One:regular'                                                                                                                                        => 'Fugaz One',
			'GFS Didot:regular'                                                                                                                                        => 'GFS Didot',
			'GFS Neohellenic:regular,italic,700,700italic'                                                                                                             => 'GFS Neohellenic',
			'Gabriela:regular'                                                                                                                                         => 'Gabriela',
			'Gaegu:300,regular,700'                                                                                                                                    => 'Gaegu',
			'Gafata:regular'                                                                                                                                           => 'Gafata',
			'Galada:regular'                                                                                                                                           => 'Galada',
			'Galdeano:regular'                                                                                                                                         => 'Galdeano',
			'Galindo:regular'                                                                                                                                          => 'Galindo',
			'Gamja Flower:regular'                                                                                                                                     => 'Gamja Flower',
			'Gayathri:100,regular,700'                                                                                                                                 => 'Gayathri',
			'Gelasio:regular,italic,500,500italic,600,600italic,700,700italic'                                                                                         => 'Gelasio',
			'Gentium Basic:regular,italic,700,700italic'                                                                                                               => 'Gentium Basic',
			'Gentium Book Basic:regular,italic,700,700italic'                                                                                                          => 'Gentium Book Basic',
			'Geo:regular,italic'                                                                                                                                       => 'Geo',
			'Geostar:regular'                                                                                                                                          => 'Geostar',
			'Geostar Fill:regular'                                                                                                                                     => 'Geostar Fill',
			'Germania One:regular'                                                                                                                                     => 'Germania One',
			'Gidugu:regular'                                                                                                                                           => 'Gidugu',
			'Gilda Display:regular'                                                                                                                                    => 'Gilda Display',
			'Girassol:regular'                                                                                                                                         => 'Girassol',
			'Give You Glory:regular'                                                                                                                                   => 'Give You Glory',
			'Glass Antiqua:regular'                                                                                                                                    => 'Glass Antiqua',
			'Glegoo:regular,700'                                                                                                                                       => 'Glegoo',
			'Gloria Hallelujah:regular'                                                                                                                                => 'Gloria Hallelujah',
			'Goblin One:regular'                                                                                                                                       => 'Goblin One',
			'Gochi Hand:regular'                                                                                                                                       => 'Gochi Hand',
			'Goldman:regular,700'                                                                                                                                      => 'Goldman',
			'Gorditas:regular,700'                                                                                                                                     => 'Gorditas',
			'Gothic A1:100,200,300,regular,500,600,700,800,900'                                                                                                        => 'Gothic A1',
			'Gotu:regular'                                                                                                                                             => 'Gotu',
			'Goudy Bookletter 1911:regular'                                                                                                                            => 'Goudy Bookletter 1911',
			'Graduate:regular'                                                                                                                                         => 'Graduate',
			'Grand Hotel:regular'                                                                                                                                      => 'Grand Hotel',
			'Grandstander:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'              => 'Grandstander',
			'Gravitas One:regular'                                                                                                                                     => 'Gravitas One',
			'Great Vibes:regular'                                                                                                                                      => 'Great Vibes',
			'Grenze:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                    => 'Grenze',
			'Grenze Gotisch:100,200,300,regular,500,600,700,800,900'                                                                                                   => 'Grenze Gotisch',
			'Griffy:regular'                                                                                                                                           => 'Griffy',
			'Gruppo:regular'                                                                                                                                           => 'Gruppo',
			'Gudea:regular,italic,700'                                                                                                                                 => 'Gudea',
			'Gugi:regular'                                                                                                                                             => 'Gugi',
			'Gupter:regular,500,700'                                                                                                                                   => 'Gupter',
			'Gurajada:regular'                                                                                                                                         => 'Gurajada',
			'Habibi:regular'                                                                                                                                           => 'Habibi',
			'Hachi Maru Pop:regular'                                                                                                                                   => 'Hachi Maru Pop',
			'Halant:300,regular,500,600,700'                                                                                                                           => 'Halant',
			'Hammersmith One:regular'                                                                                                                                  => 'Hammersmith One',
			'Hanalei:regular'                                                                                                                                          => 'Hanalei',
			'Hanalei Fill:regular'                                                                                                                                     => 'Hanalei Fill',
			'Handlee:regular'                                                                                                                                          => 'Handlee',
			'Hanuman:regular,700'                                                                                                                                      => 'Hanuman',
			'Happy Monkey:regular'                                                                                                                                     => 'Happy Monkey',
			'Harmattan:regular,700'                                                                                                                                    => 'Harmattan',
			'Headland One:regular'                                                                                                                                     => 'Headland One',
			'Heebo:100,200,300,regular,500,600,700,800,900'                                                                                                            => 'Heebo',
			'Henny Penny:regular'                                                                                                                                      => 'Henny Penny',
			'Hepta Slab:100,200,300,regular,500,600,700,800,900'                                                                                                       => 'Hepta Slab',
			'Herr Von Muellerhoff:regular'                                                                                                                             => 'Herr Von Muellerhoff',
			'Hi Melody:regular'                                                                                                                                        => 'Hi Melody',
			'Hind:300,regular,500,600,700'                                                                                                                             => 'Hind',
			'Hind Guntur:300,regular,500,600,700'                                                                                                                      => 'Hind Guntur',
			'Hind Madurai:300,regular,500,600,700'                                                                                                                     => 'Hind Madurai',
			'Hind Siliguri:300,regular,500,600,700'                                                                                                                    => 'Hind Siliguri',
			'Hind Vadodara:300,regular,500,600,700'                                                                                                                    => 'Hind Vadodara',
			'Holtwood One SC:regular'                                                                                                                                  => 'Holtwood One SC',
			'Homemade Apple:regular'                                                                                                                                   => 'Homemade Apple',
			'Homenaje:regular'                                                                                                                                         => 'Homenaje',
			'IBM Plex Mono:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                         => 'IBM Plex Mono',
			'IBM Plex Sans:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                         => 'IBM Plex Sans',
			'IBM Plex Sans Condensed:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                               => 'IBM Plex Sans Condensed',
			'IBM Plex Serif:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                        => 'IBM Plex Serif',
			'IM Fell DW Pica:regular,italic'                                                                                                                           => 'IM Fell DW Pica',
			'IM Fell DW Pica SC:regular'                                                                                                                               => 'IM Fell DW Pica SC',
			'IM Fell Double Pica:regular,italic'                                                                                                                       => 'IM Fell Double Pica',
			'IM Fell Double Pica SC:regular'                                                                                                                           => 'IM Fell Double Pica SC',
			'IM Fell English:regular,italic'                                                                                                                           => 'IM Fell English',
			'IM Fell English SC:regular'                                                                                                                               => 'IM Fell English SC',
			'IM Fell French Canon:regular,italic'                                                                                                                      => 'IM Fell French Canon',
			'IM Fell French Canon SC:regular'                                                                                                                          => 'IM Fell French Canon SC',
			'IM Fell Great Primer:regular,italic'                                                                                                                      => 'IM Fell Great Primer',
			'IM Fell Great Primer SC:regular'                                                                                                                          => 'IM Fell Great Primer SC',
			'Ibarra Real Nova:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                => 'Ibarra Real Nova',
			'Iceberg:regular'                                                                                                                                          => 'Iceberg',
			'Iceland:regular'                                                                                                                                          => 'Iceland',
			'Imbue:100,200,300,regular,500,600,700,800,900'                                                                                                            => 'Imbue',
			'Imprima:regular'                                                                                                                                          => 'Imprima',
			'Inconsolata:200,300,regular,500,600,700,800,900'                                                                                                          => 'Inconsolata',
			'Inder:regular'                                                                                                                                            => 'Inder',
			'Indie Flower:regular'                                                                                                                                     => 'Indie Flower',
			'Inika:regular,700'                                                                                                                                        => 'Inika',
			'Inknut Antiqua:300,regular,500,600,700,800,900'                                                                                                           => 'Inknut Antiqua',
			'Inria Sans:300,300italic,regular,italic,700,700italic'                                                                                                    => 'Inria Sans',
			'Inria Serif:300,300italic,regular,italic,700,700italic'                                                                                                   => 'Inria Serif',
			'Inter:100,200,300,regular,500,600,700,800,900'                                                                                                            => 'Inter',
			'Irish Grover:regular'                                                                                                                                     => 'Irish Grover',
			'Istok Web:regular,italic,700,700italic'                                                                                                                   => 'Istok Web',
			'Italiana:regular'                                                                                                                                         => 'Italiana',
			'Italianno:regular'                                                                                                                                        => 'Italianno',
			'Itim:regular'                                                                                                                                             => 'Itim',
			'Jacques Francois:regular'                                                                                                                                 => 'Jacques Francois',
			'Jacques Francois Shadow:regular'                                                                                                                          => 'Jacques Francois Shadow',
			'Jaldi:regular,700'                                                                                                                                        => 'Jaldi',
			'JetBrains Mono:100,200,300,regular,500,600,700,800,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic'                          => 'JetBrains Mono',
			'Jim Nightshade:regular'                                                                                                                                   => 'Jim Nightshade',
			'Jockey One:regular'                                                                                                                                       => 'Jockey One',
			'Jolly Lodger:regular'                                                                                                                                     => 'Jolly Lodger',
			'Jomhuria:regular'                                                                                                                                         => 'Jomhuria',
			'Jomolhari:regular'                                                                                                                                        => 'Jomolhari',
			'Josefin Sans:100,200,300,regular,500,600,700,100italic,200italic,300italic,italic,500italic,600italic,700italic'                                          => 'Josefin Sans',
			'Josefin Slab:100,200,300,regular,500,600,700,100italic,200italic,300italic,italic,500italic,600italic,700italic'                                          => 'Josefin Slab',
			'Jost:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                      => 'Jost',
			'Joti One:regular'                                                                                                                                         => 'Joti One',
			'Jua:regular'                                                                                                                                              => 'Jua',
			'Judson:regular,italic,700'                                                                                                                                => 'Judson',
			'Julee:regular'                                                                                                                                            => 'Julee',
			'Julius Sans One:regular'                                                                                                                                  => 'Julius Sans One',
			'Junge:regular'                                                                                                                                            => 'Junge',
			'Jura:300,regular,500,600,700'                                                                                                                             => 'Jura',
			'Just Another Hand:regular'                                                                                                                                => 'Just Another Hand',
			'Just Me Again Down Here:regular'                                                                                                                          => 'Just Me Again Down Here',
			'K2D:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic'                                     => 'K2D',
			'Kadwa:regular,700'                                                                                                                                        => 'Kadwa',
			'Kalam:300,regular,700'                                                                                                                                    => 'Kalam',
			'Kameron:regular,700'                                                                                                                                      => 'Kameron',
			'Kanit:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                     => 'Kanit',
			'Kantumruy:300,regular,700'                                                                                                                                => 'Kantumruy',
			'Karantina:300,regular,700'                                                                                                                                => 'Karantina',
			'Karla:200,300,regular,500,600,700,800,200italic,300italic,italic,500italic,600italic,700italic,800italic'                                                 => 'Karla',
			'Karma:300,regular,500,600,700'                                                                                                                            => 'Karma',
			'Katibeh:regular'                                                                                                                                          => 'Katibeh',
			'Kaushan Script:regular'                                                                                                                                   => 'Kaushan Script',
			'Kavivanar:regular'                                                                                                                                        => 'Kavivanar',
			'Kavoon:regular'                                                                                                                                           => 'Kavoon',
			'Kdam Thmor:regular'                                                                                                                                       => 'Kdam Thmor',
			'Keania One:regular'                                                                                                                                       => 'Keania One',
			'Kelly Slab:regular'                                                                                                                                       => 'Kelly Slab',
			'Kenia:regular'                                                                                                                                            => 'Kenia',
			'Khand:300,regular,500,600,700'                                                                                                                            => 'Khand',
			'Khmer:regular'                                                                                                                                            => 'Khmer',
			'Khula:300,regular,600,700,800'                                                                                                                            => 'Khula',
			'Kirang Haerang:regular'                                                                                                                                   => 'Kirang Haerang',
			'Kite One:regular'                                                                                                                                         => 'Kite One',
			'Kiwi Maru:300,regular,500'                                                                                                                                => 'Kiwi Maru',
			'Knewave:regular'                                                                                                                                          => 'Knewave',
			'KoHo:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                => 'KoHo',
			'Kodchasan:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                           => 'Kodchasan',
			'Kosugi:regular'                                                                                                                                           => 'Kosugi',
			'Kosugi Maru:regular'                                                                                                                                      => 'Kosugi Maru',
			'Kotta One:regular'                                                                                                                                        => 'Kotta One',
			'Koulen:regular'                                                                                                                                           => 'Koulen',
			'Kranky:regular'                                                                                                                                           => 'Kranky',
			'Kreon:300,regular,500,600,700'                                                                                                                            => 'Kreon',
			'Kristi:regular'                                                                                                                                           => 'Kristi',
			'Krona One:regular'                                                                                                                                        => 'Krona One',
			'Krub:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                => 'Krub',
			'Kufam:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic'                                                               => 'Kufam',
			'Kulim Park:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic'                                                                        => 'Kulim Park',
			'Kumar One:regular'                                                                                                                                        => 'Kumar One',
			'Kumar One Outline:regular'                                                                                                                                => 'Kumar One Outline',
			'Kumbh Sans:300,regular,700'                                                                                                                               => 'Kumbh Sans',
			'Kurale:regular'                                                                                                                                           => 'Kurale',
			'La Belle Aurore:regular'                                                                                                                                  => 'La Belle Aurore',
			'Lacquer:regular'                                                                                                                                          => 'Lacquer',
			'Laila:300,regular,500,600,700'                                                                                                                            => 'Laila',
			'Lakki Reddy:regular'                                                                                                                                      => 'Lakki Reddy',
			'Lalezar:regular'                                                                                                                                          => 'Lalezar',
			'Lancelot:regular'                                                                                                                                         => 'Lancelot',
			'Langar:regular'                                                                                                                                           => 'Langar',
			'Lateef:regular'                                                                                                                                           => 'Lateef',
			'Lato:100,100italic,300,300italic,regular,italic,700,700italic,900,900italic'                                                                              => 'Lato',
			'League Script:regular'                                                                                                                                    => 'League Script',
			'Leckerli One:regular'                                                                                                                                     => 'Leckerli One',
			'Ledger:regular'                                                                                                                                           => 'Ledger',
			'Lekton:regular,italic,700'                                                                                                                                => 'Lekton',
			'Lemon:regular'                                                                                                                                            => 'Lemon',
			'Lemonada:300,regular,500,600,700'                                                                                                                         => 'Lemonada',
			'Lexend:100,300,regular,500,600,700,800'                                                                                                                   => 'Lexend',
			'Lexend Deca:regular'                                                                                                                                      => 'Lexend Deca',
			'Lexend Exa:regular'                                                                                                                                       => 'Lexend Exa',
			'Lexend Giga:regular'                                                                                                                                      => 'Lexend Giga',
			'Lexend Mega:regular'                                                                                                                                      => 'Lexend Mega',
			'Lexend Peta:regular'                                                                                                                                      => 'Lexend Peta',
			'Lexend Tera:regular'                                                                                                                                      => 'Lexend Tera',
			'Lexend Zetta:regular'                                                                                                                                     => 'Lexend Zetta',
			'Libre Barcode 128:regular'                                                                                                                                => 'Libre Barcode 128',
			'Libre Barcode 128 Text:regular'                                                                                                                           => 'Libre Barcode 128 Text',
			'Libre Barcode 39:regular'                                                                                                                                 => 'Libre Barcode 39',
			'Libre Barcode 39 Extended:regular'                                                                                                                        => 'Libre Barcode 39 Extended',
			'Libre Barcode 39 Extended Text:regular'                                                                                                                   => 'Libre Barcode 39 Extended Text',
			'Libre Barcode 39 Text:regular'                                                                                                                            => 'Libre Barcode 39 Text',
			'Libre Barcode EAN13 Text:regular'                                                                                                                         => 'Libre Barcode EAN13 Text',
			'Libre Baskerville:regular,italic,700'                                                                                                                     => 'Libre Baskerville',
			'Libre Caslon Display:regular'                                                                                                                             => 'Libre Caslon Display',
			'Libre Caslon Text:regular,italic,700'                                                                                                                     => 'Libre Caslon Text',
			'Libre Franklin:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'            => 'Libre Franklin',
			'Life Savers:regular,700,800'                                                                                                                              => 'Life Savers',
			'Lilita One:regular'                                                                                                                                       => 'Lilita One',
			'Lily Script One:regular'                                                                                                                                  => 'Lily Script One',
			'Limelight:regular'                                                                                                                                        => 'Limelight',
			'Linden Hill:regular,italic'                                                                                                                               => 'Linden Hill',
			'Literata:200,300,regular,500,600,700,800,900,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                                => 'Literata',
			'Liu Jian Mao Cao:regular'                                                                                                                                 => 'Liu Jian Mao Cao',
			'Livvic:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,900,900italic'                                  => 'Livvic',
			'Lobster:regular'                                                                                                                                          => 'Lobster',
			'Lobster Two:regular,italic,700,700italic'                                                                                                                 => 'Lobster Two',
			'Londrina Outline:regular'                                                                                                                                 => 'Londrina Outline',
			'Londrina Shadow:regular'                                                                                                                                  => 'Londrina Shadow',
			'Londrina Sketch:regular'                                                                                                                                  => 'Londrina Sketch',
			'Londrina Solid:100,300,regular,900'                                                                                                                       => 'Londrina Solid',
			'Long Cang:regular'                                                                                                                                        => 'Long Cang',
			'Lora:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                            => 'Lora',
			'Love Ya Like A Sister:regular'                                                                                                                            => 'Love Ya Like A Sister',
			'Loved by the King:regular'                                                                                                                                => 'Loved by the King',
			'Lovers Quarrel:regular'                                                                                                                                   => 'Lovers Quarrel',
			'Luckiest Guy:regular'                                                                                                                                     => 'Luckiest Guy',
			'Lusitana:regular,700'                                                                                                                                     => 'Lusitana',
			'Lustria:regular'                                                                                                                                          => 'Lustria',
			'M PLUS 1p:100,300,regular,500,700,800,900'                                                                                                                => 'M PLUS 1p',
			'M PLUS Rounded 1c:100,300,regular,500,700,800,900'                                                                                                        => 'M PLUS Rounded 1c',
			'Ma Shan Zheng:regular'                                                                                                                                    => 'Ma Shan Zheng',
			'Macondo:regular'                                                                                                                                          => 'Macondo',
			'Macondo Swash Caps:regular'                                                                                                                               => 'Macondo Swash Caps',
			'Mada:200,300,regular,500,600,700,900'                                                                                                                     => 'Mada',
			'Magra:regular,700'                                                                                                                                        => 'Magra',
			'Maiden Orange:regular'                                                                                                                                    => 'Maiden Orange',
			'Maitree:200,300,regular,500,600,700'                                                                                                                      => 'Maitree',
			'Major Mono Display:regular'                                                                                                                               => 'Major Mono Display',
			'Mako:regular'                                                                                                                                             => 'Mako',
			'Mali:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                => 'Mali',
			'Mallanna:regular'                                                                                                                                         => 'Mallanna',
			'Mandali:regular'                                                                                                                                          => 'Mandali',
			'Manjari:100,regular,700'                                                                                                                                  => 'Manjari',
			'Manrope:200,300,regular,500,600,700,800'                                                                                                                  => 'Manrope',
			'Mansalva:regular'                                                                                                                                         => 'Mansalva',
			'Manuale:regular,500,600,700,italic,500italic,600italic,700italic'                                                                                         => 'Manuale',
			'Marcellus:regular'                                                                                                                                        => 'Marcellus',
			'Marcellus SC:regular'                                                                                                                                     => 'Marcellus SC',
			'Marck Script:regular'                                                                                                                                     => 'Marck Script',
			'Margarine:regular'                                                                                                                                        => 'Margarine',
			'Markazi Text:regular,500,600,700'                                                                                                                         => 'Markazi Text',
			'Marko One:regular'                                                                                                                                        => 'Marko One',
			'Marmelad:regular'                                                                                                                                         => 'Marmelad',
			'Martel:200,300,regular,600,700,800,900'                                                                                                                   => 'Martel',
			'Martel Sans:200,300,regular,600,700,800,900'                                                                                                              => 'Martel Sans',
			'Marvel:regular,italic,700,700italic'                                                                                                                      => 'Marvel',
			'Mate:regular,italic'                                                                                                                                      => 'Mate',
			'Mate SC:regular'                                                                                                                                          => 'Mate SC',
			'Maven Pro:regular,500,600,700,800,900'                                                                                                                    => 'Maven Pro',
			'McLaren:regular'                                                                                                                                          => 'McLaren',
			'Meddon:regular'                                                                                                                                           => 'Meddon',
			'MedievalSharp:regular'                                                                                                                                    => 'MedievalSharp',
			'Medula One:regular'                                                                                                                                       => 'Medula One',
			'Meera Inimai:regular'                                                                                                                                     => 'Meera Inimai',
			'Megrim:regular'                                                                                                                                           => 'Megrim',
			'Meie Script:regular'                                                                                                                                      => 'Meie Script',
			'Merienda:regular,700'                                                                                                                                     => 'Merienda',
			'Merienda One:regular'                                                                                                                                     => 'Merienda One',
			'Merriweather:300,300italic,regular,italic,700,700italic,900,900italic'                                                                                    => 'Merriweather',
			'Merriweather Sans:300,regular,500,600,700,800,300italic,italic,500italic,600italic,700italic,800italic'                                                   => 'Merriweather Sans',
			'Metal:regular'                                                                                                                                            => 'Metal',
			'Metal Mania:regular'                                                                                                                                      => 'Metal Mania',
			'Metamorphous:regular'                                                                                                                                     => 'Metamorphous',
			'Metrophobic:regular'                                                                                                                                      => 'Metrophobic',
			'Michroma:regular'                                                                                                                                         => 'Michroma',
			'Milonga:regular'                                                                                                                                          => 'Milonga',
			'Miltonian:regular'                                                                                                                                        => 'Miltonian',
			'Miltonian Tattoo:regular'                                                                                                                                 => 'Miltonian Tattoo',
			'Mina:regular,700'                                                                                                                                         => 'Mina',
			'Miniver:regular'                                                                                                                                          => 'Miniver',
			'Miriam Libre:regular,700'                                                                                                                                 => 'Miriam Libre',
			'Mirza:regular,500,600,700'                                                                                                                                => 'Mirza',
			'Miss Fajardose:regular'                                                                                                                                   => 'Miss Fajardose',
			'Mitr:200,300,regular,500,600,700'                                                                                                                         => 'Mitr',
			'Modak:regular'                                                                                                                                            => 'Modak',
			'Modern Antiqua:regular'                                                                                                                                   => 'Modern Antiqua',
			'Mogra:regular'                                                                                                                                            => 'Mogra',
			'Molengo:regular'                                                                                                                                          => 'Molengo',
			'Molle:italic'                                                                                                                                             => 'Molle',
			'Monda:regular,700'                                                                                                                                        => 'Monda',
			'Monofett:regular'                                                                                                                                         => 'Monofett',
			'Monoton:regular'                                                                                                                                          => 'Monoton',
			'Monsieur La Doulaise:regular'                                                                                                                             => 'Monsieur La Doulaise',
			'Montaga:regular'                                                                                                                                          => 'Montaga',
			'Montez:regular'                                                                                                                                           => 'Montez',
			'Montserrat:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                => 'Montserrat',
			'Montserrat Alternates:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'     => 'Montserrat Alternates',
			'Montserrat Subrayada:regular,700'                                                                                                                         => 'Montserrat Subrayada',
			'Moul:regular'                                                                                                                                             => 'Moul',
			'Moulpali:regular'                                                                                                                                         => 'Moulpali',
			'Mountains of Christmas:regular,700'                                                                                                                       => 'Mountains of Christmas',
			'Mouse Memoirs:regular'                                                                                                                                    => 'Mouse Memoirs',
			'Mr Bedfort:regular'                                                                                                                                       => 'Mr Bedfort',
			'Mr Dafoe:regular'                                                                                                                                         => 'Mr Dafoe',
			'Mr De Haviland:regular'                                                                                                                                   => 'Mr De Haviland',
			'Mrs Saint Delafield:regular'                                                                                                                              => 'Mrs Saint Delafield',
			'Mrs Sheppards:regular'                                                                                                                                    => 'Mrs Sheppards',
			'Mukta:200,300,regular,500,600,700,800'                                                                                                                    => 'Mukta',
			'Mukta Mahee:200,300,regular,500,600,700,800'                                                                                                              => 'Mukta Mahee',
			'Mukta Malar:200,300,regular,500,600,700,800'                                                                                                              => 'Mukta Malar',
			'Mukta Vaani:200,300,regular,500,600,700,800'                                                                                                              => 'Mukta Vaani',
			'Mulish:200,300,regular,500,600,700,800,900,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                                  => 'Mulish',
			'MuseoModerno:100,200,300,regular,500,600,700,800,900'                                                                                                     => 'MuseoModerno',
			'Mystery Quest:regular'                                                                                                                                    => 'Mystery Quest',
			'NTR:regular'                                                                                                                                              => 'NTR',
			'Nanum Brush Script:regular'                                                                                                                               => 'Nanum Brush Script',
			'Nanum Gothic:regular,700,800'                                                                                                                             => 'Nanum Gothic',
			'Nanum Gothic Coding:regular,700'                                                                                                                          => 'Nanum Gothic Coding',
			'Nanum Myeongjo:regular,700,800'                                                                                                                           => 'Nanum Myeongjo',
			'Nanum Pen Script:regular'                                                                                                                                 => 'Nanum Pen Script',
			'Nerko One:regular'                                                                                                                                        => 'Nerko One',
			'Neucha:regular'                                                                                                                                           => 'Neucha',
			'Neuton:200,300,regular,italic,700,800'                                                                                                                    => 'Neuton',
			'New Rocker:regular'                                                                                                                                       => 'New Rocker',
			'New Tegomin:regular'                                                                                                                                      => 'New Tegomin',
			'News Cycle:regular,700'                                                                                                                                   => 'News Cycle',
			'Newsreader:200,300,regular,500,600,700,800,200italic,300italic,italic,500italic,600italic,700italic,800italic'                                            => 'Newsreader',
			'Niconne:regular'                                                                                                                                          => 'Niconne',
			'Niramit:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                             => 'Niramit',
			'Nixie One:regular'                                                                                                                                        => 'Nixie One',
			'Nobile:regular,italic,500,500italic,700,700italic'                                                                                                        => 'Nobile',
			'Nokora:regular,700'                                                                                                                                       => 'Nokora',
			'Norican:regular'                                                                                                                                          => 'Norican',
			'Nosifer:regular'                                                                                                                                          => 'Nosifer',
			'Notable:regular'                                                                                                                                          => 'Notable',
			'Nothing You Could Do:regular'                                                                                                                             => 'Nothing You Could Do',
			'Noticia Text:regular,italic,700,700italic'                                                                                                                => 'Noticia Text',
			'Noto Sans:regular,italic,700,700italic'                                                                                                                   => 'Noto Sans',
			'Noto Sans HK:100,300,regular,500,700,900'                                                                                                                 => 'Noto Sans HK',
			'Noto Sans JP:100,300,regular,500,700,900'                                                                                                                 => 'Noto Sans JP',
			'Noto Sans KR:100,300,regular,500,700,900'                                                                                                                 => 'Noto Sans KR',
			'Noto Sans SC:100,300,regular,500,700,900'                                                                                                                 => 'Noto Sans SC',
			'Noto Sans TC:100,300,regular,500,700,900'                                                                                                                 => 'Noto Sans TC',
			'Noto Serif:regular,italic,700,700italic'                                                                                                                  => 'Noto Serif',
			'Noto Serif JP:200,300,regular,500,600,700,900'                                                                                                            => 'Noto Serif JP',
			'Noto Serif KR:200,300,regular,500,600,700,900'                                                                                                            => 'Noto Serif KR',
			'Noto Serif SC:200,300,regular,500,600,700,900'                                                                                                            => 'Noto Serif SC',
			'Noto Serif TC:200,300,regular,500,600,700,900'                                                                                                            => 'Noto Serif TC',
			'Nova Cut:regular'                                                                                                                                         => 'Nova Cut',
			'Nova Flat:regular'                                                                                                                                        => 'Nova Flat',
			'Nova Mono:regular'                                                                                                                                        => 'Nova Mono',
			'Nova Oval:regular'                                                                                                                                        => 'Nova Oval',
			'Nova Round:regular'                                                                                                                                       => 'Nova Round',
			'Nova Script:regular'                                                                                                                                      => 'Nova Script',
			'Nova Slim:regular'                                                                                                                                        => 'Nova Slim',
			'Nova Square:regular'                                                                                                                                      => 'Nova Square',
			'Numans:regular'                                                                                                                                           => 'Numans',
			'Nunito:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,800,800italic,900,900italic'                                                => 'Nunito',
			'Nunito Sans:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,800,800italic,900,900italic'                                           => 'Nunito Sans',
			'Odibee Sans:regular'                                                                                                                                      => 'Odibee Sans',
			'Odor Mean Chey:regular'                                                                                                                                   => 'Odor Mean Chey',
			'Offside:regular'                                                                                                                                          => 'Offside',
			'Oi:regular'                                                                                                                                               => 'Oi',
			'Old Standard TT:regular,italic,700'                                                                                                                       => 'Old Standard TT',
			'Oldenburg:regular'                                                                                                                                        => 'Oldenburg',
			'Oleo Script:regular,700'                                                                                                                                  => 'Oleo Script',
			'Oleo Script Swash Caps:regular,700'                                                                                                                       => 'Oleo Script Swash Caps',
			'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic'                                                                         => 'Open Sans',
			'Open Sans Condensed:300,300italic,700'                                                                                                                    => 'Open Sans Condensed',
			'Oranienbaum:regular'                                                                                                                                      => 'Oranienbaum',
			'Orbitron:regular,500,600,700,800,900'                                                                                                                     => 'Orbitron',
			'Oregano:regular,italic'                                                                                                                                   => 'Oregano',
			'Orelega One:regular'                                                                                                                                      => 'Orelega One',
			'Orienta:regular'                                                                                                                                          => 'Orienta',
			'Original Surfer:regular'                                                                                                                                  => 'Original Surfer',
			'Oswald:200,300,regular,500,600,700'                                                                                                                       => 'Oswald',
			'Over the Rainbow:regular'                                                                                                                                 => 'Over the Rainbow',
			'Overlock:regular,italic,700,700italic,900,900italic'                                                                                                      => 'Overlock',
			'Overlock SC:regular'                                                                                                                                      => 'Overlock SC',
			'Overpass:100,100italic,200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,800,800italic,900,900italic'                                => 'Overpass',
			'Overpass Mono:300,regular,600,700'                                                                                                                        => 'Overpass Mono',
			'Ovo:regular'                                                                                                                                              => 'Ovo',
			'Oxanium:200,300,regular,500,600,700,800'                                                                                                                  => 'Oxanium',
			'Oxygen:300,regular,700'                                                                                                                                   => 'Oxygen',
			'Oxygen Mono:regular'                                                                                                                                      => 'Oxygen Mono',
			'PT Mono:regular'                                                                                                                                          => 'PT Mono',
			'PT Sans:regular,italic,700,700italic'                                                                                                                     => 'PT Sans',
			'PT Sans Caption:regular,700'                                                                                                                              => 'PT Sans Caption',
			'PT Sans Narrow:regular,700'                                                                                                                               => 'PT Sans Narrow',
			'PT Serif:regular,italic,700,700italic'                                                                                                                    => 'PT Serif',
			'PT Serif Caption:regular,italic'                                                                                                                          => 'PT Serif Caption',
			'Pacifico:regular'                                                                                                                                         => 'Pacifico',
			'Padauk:regular,700'                                                                                                                                       => 'Padauk',
			'Palanquin:100,200,300,regular,500,600,700'                                                                                                                => 'Palanquin',
			'Palanquin Dark:regular,500,600,700'                                                                                                                       => 'Palanquin Dark',
			'Pangolin:regular'                                                                                                                                         => 'Pangolin',
			'Paprika:regular'                                                                                                                                          => 'Paprika',
			'Parisienne:regular'                                                                                                                                       => 'Parisienne',
			'Passero One:regular'                                                                                                                                      => 'Passero One',
			'Passion One:regular,700,900'                                                                                                                              => 'Passion One',
			'Pathway Gothic One:regular'                                                                                                                               => 'Pathway Gothic One',
			'Patrick Hand:regular'                                                                                                                                     => 'Patrick Hand',
			'Patrick Hand SC:regular'                                                                                                                                  => 'Patrick Hand SC',
			'Pattaya:regular'                                                                                                                                          => 'Pattaya',
			'Patua One:regular'                                                                                                                                        => 'Patua One',
			'Pavanam:regular'                                                                                                                                          => 'Pavanam',
			'Paytone One:regular'                                                                                                                                      => 'Paytone One',
			'Peddana:regular'                                                                                                                                          => 'Peddana',
			'Peralta:regular'                                                                                                                                          => 'Peralta',
			'Permanent Marker:regular'                                                                                                                                 => 'Permanent Marker',
			'Petit Formal Script:regular'                                                                                                                              => 'Petit Formal Script',
			'Petrona:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                   => 'Petrona',
			'Philosopher:regular,italic,700,700italic'                                                                                                                 => 'Philosopher',
			'Piazzolla:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                 => 'Piazzolla',
			'Piedra:regular'                                                                                                                                           => 'Piedra',
			'Pinyon Script:regular'                                                                                                                                    => 'Pinyon Script',
			'Pirata One:regular'                                                                                                                                       => 'Pirata One',
			'Plaster:regular'                                                                                                                                          => 'Plaster',
			'Play:regular,700'                                                                                                                                         => 'Play',
			'Playball:regular'                                                                                                                                         => 'Playball',
			'Playfair Display:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic'                                                    => 'Playfair Display',
			'Playfair Display SC:regular,italic,700,700italic,900,900italic'                                                                                           => 'Playfair Display SC',
			'Podkova:regular,500,600,700,800'                                                                                                                          => 'Podkova',
			'Poiret One:regular'                                                                                                                                       => 'Poiret One',
			'Poller One:regular'                                                                                                                                       => 'Poller One',
			'Poly:regular,italic'                                                                                                                                      => 'Poly',
			'Pompiere:regular'                                                                                                                                         => 'Pompiere',
			'Pontano Sans:regular'                                                                                                                                     => 'Pontano Sans',
			'Poor Story:regular'                                                                                                                                       => 'Poor Story',
			'Poppins:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                   => 'Poppins',
			'Port Lligat Sans:regular'                                                                                                                                 => 'Port Lligat Sans',
			'Port Lligat Slab:regular'                                                                                                                                 => 'Port Lligat Slab',
			'Potta One:regular'                                                                                                                                        => 'Potta One',
			'Pragati Narrow:regular,700'                                                                                                                               => 'Pragati Narrow',
			'Prata:regular'                                                                                                                                            => 'Prata',
			'Preahvihear:regular'                                                                                                                                      => 'Preahvihear',
			'Press Start 2P:regular'                                                                                                                                   => 'Press Start 2P',
			'Pridi:200,300,regular,500,600,700'                                                                                                                        => 'Pridi',
			'Princess Sofia:regular'                                                                                                                                   => 'Princess Sofia',
			'Prociono:regular'                                                                                                                                         => 'Prociono',
			'Prompt:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                    => 'Prompt',
			'Prosto One:regular'                                                                                                                                       => 'Prosto One',
			'Proza Libre:regular,italic,500,500italic,600,600italic,700,700italic,800,800italic'                                                                       => 'Proza Libre',
			'Public Sans:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'               => 'Public Sans',
			'Puritan:regular,italic,700,700italic'                                                                                                                     => 'Puritan',
			'Purple Purse:regular'                                                                                                                                     => 'Purple Purse',
			'Quando:regular'                                                                                                                                           => 'Quando',
			'Quantico:regular,italic,700,700italic'                                                                                                                    => 'Quantico',
			'Quattrocento:regular,700'                                                                                                                                 => 'Quattrocento',
			'Quattrocento Sans:regular,italic,700,700italic'                                                                                                           => 'Quattrocento Sans',
			'Questrial:regular'                                                                                                                                        => 'Questrial',
			'Quicksand:300,regular,500,600,700'                                                                                                                        => 'Quicksand',
			'Quintessential:regular'                                                                                                                                   => 'Quintessential',
			'Qwigley:regular'                                                                                                                                          => 'Qwigley',
			'Racing Sans One:regular'                                                                                                                                  => 'Racing Sans One',
			'Radley:regular,italic'                                                                                                                                    => 'Radley',
			'Rajdhani:300,regular,500,600,700'                                                                                                                         => 'Rajdhani',
			'Rakkas:regular'                                                                                                                                           => 'Rakkas',
			'Raleway:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                   => 'Raleway',
			'Raleway Dots:regular'                                                                                                                                     => 'Raleway Dots',
			'Ramabhadra:regular'                                                                                                                                       => 'Ramabhadra',
			'Ramaraja:regular'                                                                                                                                         => 'Ramaraja',
			'Rambla:regular,italic,700,700italic'                                                                                                                      => 'Rambla',
			'Rammetto One:regular'                                                                                                                                     => 'Rammetto One',
			'Ranchers:regular'                                                                                                                                         => 'Ranchers',
			'Rancho:regular'                                                                                                                                           => 'Rancho',
			'Ranga:regular,700'                                                                                                                                        => 'Ranga',
			'Rasa:300,regular,500,600,700'                                                                                                                             => 'Rasa',
			'Rationale:regular'                                                                                                                                        => 'Rationale',
			'Ravi Prakash:regular'                                                                                                                                     => 'Ravi Prakash',
			'Recursive:300,regular,500,600,700,800,900'                                                                                                                => 'Recursive',
			'Red Hat Display:regular,italic,500,500italic,700,700italic,900,900italic'                                                                                 => 'Red Hat Display',
			'Red Hat Text:regular,italic,500,500italic,700,700italic'                                                                                                  => 'Red Hat Text',
			'Red Rose:300,regular,500,600,700'                                                                                                                         => 'Red Rose',
			'Redressed:regular'                                                                                                                                        => 'Redressed',
			'Reem Kufi:regular'                                                                                                                                        => 'Reem Kufi',
			'Reenie Beanie:regular'                                                                                                                                    => 'Reenie Beanie',
			'Reggae One:regular'                                                                                                                                       => 'Reggae One',
			'Revalia:regular'                                                                                                                                          => 'Revalia',
			'Rhodium Libre:regular'                                                                                                                                    => 'Rhodium Libre',
			'Ribeye:regular'                                                                                                                                           => 'Ribeye',
			'Ribeye Marrow:regular'                                                                                                                                    => 'Ribeye Marrow',
			'Righteous:regular'                                                                                                                                        => 'Righteous',
			'Risque:regular'                                                                                                                                           => 'Risque',
			'Roboto:100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic'                                                              => 'Roboto',
			'Roboto Condensed:300,300italic,regular,italic,700,700italic'                                                                                              => 'Roboto Condensed',
			'Roboto Mono:100,200,300,regular,500,600,700,100italic,200italic,300italic,italic,500italic,600italic,700italic'                                           => 'Roboto Mono',
			'Roboto Slab:100,200,300,regular,500,600,700,800,900'                                                                                                      => 'Roboto Slab',
			'Rochester:regular'                                                                                                                                        => 'Rochester',
			'Rock Salt:regular'                                                                                                                                        => 'Rock Salt',
			'RocknRoll One:regular'                                                                                                                                    => 'RocknRoll One',
			'Rokkitt:100,200,300,regular,500,600,700,800,900'                                                                                                          => 'Rokkitt',
			'Romanesco:regular'                                                                                                                                        => 'Romanesco',
			'Ropa Sans:regular,italic'                                                                                                                                 => 'Ropa Sans',
			'Rosario:300,regular,500,600,700,300italic,italic,500italic,600italic,700italic'                                                                           => 'Rosario',
			'Rosarivo:regular,italic'                                                                                                                                  => 'Rosarivo',
			'Rouge Script:regular'                                                                                                                                     => 'Rouge Script',
			'Rowdies:300,regular,700'                                                                                                                                  => 'Rowdies',
			'Rozha One:regular'                                                                                                                                        => 'Rozha One',
			'Rubik:300,regular,500,600,700,800,900,300italic,italic,500italic,600italic,700italic,800italic,900italic'                                                 => 'Rubik',
			'Rubik Mono One:regular'                                                                                                                                   => 'Rubik Mono One',
			'Ruda:regular,500,600,700,800,900'                                                                                                                         => 'Ruda',
			'Rufina:regular,700'                                                                                                                                       => 'Rufina',
			'Ruge Boogie:regular'                                                                                                                                      => 'Ruge Boogie',
			'Ruluko:regular'                                                                                                                                           => 'Ruluko',
			'Rum Raisin:regular'                                                                                                                                       => 'Rum Raisin',
			'Ruslan Display:regular'                                                                                                                                   => 'Ruslan Display',
			'Russo One:regular'                                                                                                                                        => 'Russo One',
			'Ruthie:regular'                                                                                                                                           => 'Ruthie',
			'Rye:regular'                                                                                                                                              => 'Rye',
			'Sacramento:regular'                                                                                                                                       => 'Sacramento',
			'Sahitya:regular,700'                                                                                                                                      => 'Sahitya',
			'Sail:regular'                                                                                                                                             => 'Sail',
			'Saira:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                     => 'Saira',
			'Saira Condensed:100,200,300,regular,500,600,700,800,900'                                                                                                  => 'Saira Condensed',
			'Saira Extra Condensed:100,200,300,regular,500,600,700,800,900'                                                                                            => 'Saira Extra Condensed',
			'Saira Semi Condensed:100,200,300,regular,500,600,700,800,900'                                                                                             => 'Saira Semi Condensed',
			'Saira Stencil One:regular'                                                                                                                                => 'Saira Stencil One',
			'Salsa:regular'                                                                                                                                            => 'Salsa',
			'Sanchez:regular,italic'                                                                                                                                   => 'Sanchez',
			'Sancreek:regular'                                                                                                                                         => 'Sancreek',
			'Sansita:regular,italic,700,700italic,800,800italic,900,900italic'                                                                                         => 'Sansita',
			'Sansita Swashed:300,regular,500,600,700,800,900'                                                                                                          => 'Sansita Swashed',
			'Sarabun:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic'                                 => 'Sarabun',
			'Sarala:regular,700'                                                                                                                                       => 'Sarala',
			'Sarina:regular'                                                                                                                                           => 'Sarina',
			'Sarpanch:regular,500,600,700,800,900'                                                                                                                     => 'Sarpanch',
			'Satisfy:regular'                                                                                                                                          => 'Satisfy',
			'Sawarabi Gothic:regular'                                                                                                                                  => 'Sawarabi Gothic',
			'Sawarabi Mincho:regular'                                                                                                                                  => 'Sawarabi Mincho',
			'Scada:regular,italic,700,700italic'                                                                                                                       => 'Scada',
			'Scheherazade:regular,700'                                                                                                                                 => 'Scheherazade',
			'Schoolbell:regular'                                                                                                                                       => 'Schoolbell',
			'Scope One:regular'                                                                                                                                        => 'Scope One',
			'Seaweed Script:regular'                                                                                                                                   => 'Seaweed Script',
			'Secular One:regular'                                                                                                                                      => 'Secular One',
			'Sedgwick Ave:regular'                                                                                                                                     => 'Sedgwick Ave',
			'Sedgwick Ave Display:regular'                                                                                                                             => 'Sedgwick Ave Display',
			'Sen:regular,700,800'                                                                                                                                      => 'Sen',
			'Sevillana:regular'                                                                                                                                        => 'Sevillana',
			'Seymour One:regular'                                                                                                                                      => 'Seymour One',
			'Shadows Into Light:regular'                                                                                                                               => 'Shadows Into Light',
			'Shadows Into Light Two:regular'                                                                                                                           => 'Shadows Into Light Two',
			'Shanti:regular'                                                                                                                                           => 'Shanti',
			'Share:regular,italic,700,700italic'                                                                                                                       => 'Share',
			'Share Tech:regular'                                                                                                                                       => 'Share Tech',
			'Share Tech Mono:regular'                                                                                                                                  => 'Share Tech Mono',
			'Shippori Mincho:regular,500,600,700,800'                                                                                                                  => 'Shippori Mincho',
			'Shippori Mincho B1:regular,500,600,700,800'                                                                                                               => 'Shippori Mincho B1',
			'Shojumaru:regular'                                                                                                                                        => 'Shojumaru',
			'Short Stack:regular'                                                                                                                                      => 'Short Stack',
			'Shrikhand:regular'                                                                                                                                        => 'Shrikhand',
			'Siemreap:regular'                                                                                                                                         => 'Siemreap',
			'Sigmar One:regular'                                                                                                                                       => 'Sigmar One',
			'Signika:300,regular,500,600,700'                                                                                                                          => 'Signika',
			'Signika Negative:300,regular,600,700'                                                                                                                     => 'Signika Negative',
			'Simonetta:regular,italic,900,900italic'                                                                                                                   => 'Simonetta',
			'Single Day:regular'                                                                                                                                       => 'Single Day',
			'Sintony:regular,700'                                                                                                                                      => 'Sintony',
			'Sirin Stencil:regular'                                                                                                                                    => 'Sirin Stencil',
			'Six Caps:regular'                                                                                                                                         => 'Six Caps',
			'Skranji:regular,700'                                                                                                                                      => 'Skranji',
			'Slabo 13px:regular'                                                                                                                                       => 'Slabo 13px',
			'Slabo 27px:regular'                                                                                                                                       => 'Slabo 27px',
			'Slackey:regular'                                                                                                                                          => 'Slackey',
			'Smokum:regular'                                                                                                                                           => 'Smokum',
			'Smythe:regular'                                                                                                                                           => 'Smythe',
			'Sniglet:regular,800'                                                                                                                                      => 'Sniglet',
			'Snippet:regular'                                                                                                                                          => 'Snippet',
			'Snowburst One:regular'                                                                                                                                    => 'Snowburst One',
			'Sofadi One:regular'                                                                                                                                       => 'Sofadi One',
			'Sofia:regular'                                                                                                                                            => 'Sofia',
			'Solway:300,regular,500,700,800'                                                                                                                           => 'Solway',
			'Song Myung:regular'                                                                                                                                       => 'Song Myung',
			'Sonsie One:regular'                                                                                                                                       => 'Sonsie One',
			'Sora:100,200,300,regular,500,600,700,800'                                                                                                                 => 'Sora',
			'Sorts Mill Goudy:regular,italic'                                                                                                                          => 'Sorts Mill Goudy',
			'Source Code Pro:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,900,900italic'                                       => 'Source Code Pro',
			'Source Sans Pro:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,900,900italic'                                                     => 'Source Sans Pro',
			'Source Serif Pro:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,900,900italic'                                                    => 'Source Serif Pro',
			'Space Grotesk:300,regular,500,600,700'                                                                                                                    => 'Space Grotesk',
			'Space Mono:regular,italic,700,700italic'                                                                                                                  => 'Space Mono',
			'Spartan:100,200,300,regular,500,600,700,800,900'                                                                                                          => 'Spartan',
			'Special Elite:regular'                                                                                                                                    => 'Special Elite',
			'Spectral:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic'                                              => 'Spectral',
			'Spectral SC:200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic'                                           => 'Spectral SC',
			'Spicy Rice:regular'                                                                                                                                       => 'Spicy Rice',
			'Spinnaker:regular'                                                                                                                                        => 'Spinnaker',
			'Spirax:regular'                                                                                                                                           => 'Spirax',
			'Squada One:regular'                                                                                                                                       => 'Squada One',
			'Sree Krushnadevaraya:regular'                                                                                                                             => 'Sree Krushnadevaraya',
			'Sriracha:regular'                                                                                                                                         => 'Sriracha',
			'Srisakdi:regular,700'                                                                                                                                     => 'Srisakdi',
			'Staatliches:regular'                                                                                                                                      => 'Staatliches',
			'Stalemate:regular'                                                                                                                                        => 'Stalemate',
			'Stalinist One:regular'                                                                                                                                    => 'Stalinist One',
			'Stardos Stencil:regular,700'                                                                                                                              => 'Stardos Stencil',
			'Stick:regular'                                                                                                                                            => 'Stick',
			'Stint Ultra Condensed:regular'                                                                                                                            => 'Stint Ultra Condensed',
			'Stint Ultra Expanded:regular'                                                                                                                             => 'Stint Ultra Expanded',
			'Stoke:300,regular'                                                                                                                                        => 'Stoke',
			'Strait:regular'                                                                                                                                           => 'Strait',
			'Stylish:regular'                                                                                                                                          => 'Stylish',
			'Sue Ellen Francisco:regular'                                                                                                                              => 'Sue Ellen Francisco',
			'Suez One:regular'                                                                                                                                         => 'Suez One',
			'Sulphur Point:300,regular,700'                                                                                                                            => 'Sulphur Point',
			'Sumana:regular,700'                                                                                                                                       => 'Sumana',
			'Sunflower:300,500,700'                                                                                                                                    => 'Sunflower',
			'Sunshiney:regular'                                                                                                                                        => 'Sunshiney',
			'Supermercado One:regular'                                                                                                                                 => 'Supermercado One',
			'Sura:regular,700'                                                                                                                                         => 'Sura',
			'Suranna:regular'                                                                                                                                          => 'Suranna',
			'Suravaram:regular'                                                                                                                                        => 'Suravaram',
			'Suwannaphum:regular'                                                                                                                                      => 'Suwannaphum',
			'Swanky and Moo Moo:regular'                                                                                                                               => 'Swanky and Moo Moo',
			'Syncopate:regular,700'                                                                                                                                    => 'Syncopate',
			'Syne:regular,500,600,700,800'                                                                                                                             => 'Syne',
			'Syne Mono:regular'                                                                                                                                        => 'Syne Mono',
			'Syne Tactile:regular'                                                                                                                                     => 'Syne Tactile',
			'Tajawal:200,300,regular,500,700,800,900'                                                                                                                  => 'Tajawal',
			'Tangerine:regular,700'                                                                                                                                    => 'Tangerine',
			'Taprom:regular'                                                                                                                                           => 'Taprom',
			'Tauri:regular'                                                                                                                                            => 'Tauri',
			'Taviraj:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                   => 'Taviraj',
			'Teko:300,regular,500,600,700'                                                                                                                             => 'Teko',
			'Telex:regular'                                                                                                                                            => 'Telex',
			'Tenali Ramakrishna:regular'                                                                                                                               => 'Tenali Ramakrishna',
			'Tenor Sans:regular'                                                                                                                                       => 'Tenor Sans',
			'Text Me One:regular'                                                                                                                                      => 'Text Me One',
			'Texturina:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                 => 'Texturina',
			'Thasadith:regular,italic,700,700italic'                                                                                                                   => 'Thasadith',
			'The Girl Next Door:regular'                                                                                                                               => 'The Girl Next Door',
			'Tienne:regular,700,900'                                                                                                                                   => 'Tienne',
			'Tillana:regular,500,600,700,800'                                                                                                                          => 'Tillana',
			'Timmana:regular'                                                                                                                                          => 'Timmana',
			'Tinos:regular,italic,700,700italic'                                                                                                                       => 'Tinos',
			'Titan One:regular'                                                                                                                                        => 'Titan One',
			'Titillium Web:200,200italic,300,300italic,regular,italic,600,600italic,700,700italic,900'                                                                 => 'Titillium Web',
			'Tomorrow:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                  => 'Tomorrow',
			'Trade Winds:regular'                                                                                                                                      => 'Trade Winds',
			'Train One:regular'                                                                                                                                        => 'Train One',
			'Trirong:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic'                   => 'Trirong',
			'Trispace:100,200,300,regular,500,600,700,800'                                                                                                             => 'Trispace',
			'Trocchi:regular'                                                                                                                                          => 'Trocchi',
			'Trochut:regular,italic,700'                                                                                                                               => 'Trochut',
			'Truculenta:100,200,300,regular,500,600,700,800,900'                                                                                                       => 'Truculenta',
			'Trykker:regular'                                                                                                                                          => 'Trykker',
			'Tulpen One:regular'                                                                                                                                       => 'Tulpen One',
			'Turret Road:200,300,regular,500,700,800'                                                                                                                  => 'Turret Road',
			'Ubuntu:300,300italic,regular,italic,500,500italic,700,700italic'                                                                                          => 'Ubuntu',
			'Ubuntu Condensed:regular'                                                                                                                                 => 'Ubuntu Condensed',
			'Ubuntu Mono:regular,italic,700,700italic'                                                                                                                 => 'Ubuntu Mono',
			'Ultra:regular'                                                                                                                                            => 'Ultra',
			'Uncial Antiqua:regular'                                                                                                                                   => 'Uncial Antiqua',
			'Underdog:regular'                                                                                                                                         => 'Underdog',
			'Unica One:regular'                                                                                                                                        => 'Unica One',
			'UnifrakturCook:700'                                                                                                                                       => 'UnifrakturCook',
			'UnifrakturMaguntia:regular'                                                                                                                               => 'UnifrakturMaguntia',
			'Unkempt:regular,700'                                                                                                                                      => 'Unkempt',
			'Unlock:regular'                                                                                                                                           => 'Unlock',
			'Unna:regular,italic,700,700italic'                                                                                                                        => 'Unna',
			'VT323:regular'                                                                                                                                            => 'VT323',
			'Vampiro One:regular'                                                                                                                                      => 'Vampiro One',
			'Varela:regular'                                                                                                                                           => 'Varela',
			'Varela Round:regular'                                                                                                                                     => 'Varela Round',
			'Varta:300,regular,500,600,700'                                                                                                                            => 'Varta',
			'Vast Shadow:regular'                                                                                                                                      => 'Vast Shadow',
			'Vesper Libre:regular,500,700,900'                                                                                                                         => 'Vesper Libre',
			'Viaoda Libre:regular'                                                                                                                                     => 'Viaoda Libre',
			'Vibes:regular'                                                                                                                                            => 'Vibes',
			'Vibur:regular'                                                                                                                                            => 'Vibur',
			'Vidaloka:regular'                                                                                                                                         => 'Vidaloka',
			'Viga:regular'                                                                                                                                             => 'Viga',
			'Voces:regular'                                                                                                                                            => 'Voces',
			'Volkhov:regular,italic,700,700italic'                                                                                                                     => 'Volkhov',
			'Vollkorn:regular,500,600,700,800,900,italic,500italic,600italic,700italic,800italic,900italic'                                                            => 'Vollkorn',
			'Vollkorn SC:regular,600,700,900'                                                                                                                          => 'Vollkorn SC',
			'Voltaire:regular'                                                                                                                                         => 'Voltaire',
			'Waiting for the Sunrise:regular'                                                                                                                          => 'Waiting for the Sunrise',
			'Wallpoet:regular'                                                                                                                                         => 'Wallpoet',
			'Walter Turncoat:regular'                                                                                                                                  => 'Walter Turncoat',
			'Warnes:regular'                                                                                                                                           => 'Warnes',
			'Wellfleet:regular'                                                                                                                                        => 'Wellfleet',
			'Wendy One:regular'                                                                                                                                        => 'Wendy One',
			'Wire One:regular'                                                                                                                                         => 'Wire One',
			'Work Sans:100,200,300,regular,500,600,700,800,900,100italic,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic'                 => 'Work Sans',
			'Xanh Mono:regular,italic'                                                                                                                                 => 'Xanh Mono',
			'Yanone Kaffeesatz:200,300,regular,500,600,700'                                                                                                            => 'Yanone Kaffeesatz',
			'Yantramanav:100,300,regular,500,700,900'                                                                                                                  => 'Yantramanav',
			'Yatra One:regular'                                                                                                                                        => 'Yatra One',
			'Yellowtail:regular'                                                                                                                                       => 'Yellowtail',
			'Yeon Sung:regular'                                                                                                                                        => 'Yeon Sung',
			'Yeseva One:regular'                                                                                                                                       => 'Yeseva One',
			'Yesteryear:regular'                                                                                                                                       => 'Yesteryear',
			'Yrsa:300,regular,500,600,700'                                                                                                                             => 'Yrsa',
			'Yusei Magic:regular'                                                                                                                                      => 'Yusei Magic',
			'ZCOOL KuaiLe:regular'                                                                                                                                     => 'ZCOOL KuaiLe',
			'ZCOOL QingKe HuangYou:regular'                                                                                                                            => 'ZCOOL QingKe HuangYou',
			'ZCOOL XiaoWei:regular'                                                                                                                                    => 'ZCOOL XiaoWei',
			'Zen Dots:regular'                                                                                                                                         => 'Zen Dots',
			'Zeyada:regular'                                                                                                                                           => 'Zeyada',
			'Zhi Mang Xing:regular'                                                                                                                                    => 'Zhi Mang Xing',
			'Zilla Slab:300,300italic,regular,italic,500,500italic,600,600italic,700,700italic'                                                                        => 'Zilla Slab',
			'Zilla Slab Highlight:regular,700'                                                                                                                         => 'Zilla Slab Highlight',
		);

		return $list_fonts;
	}

	public function get_fields_for_block( $add_exclude = array() ) {
		global $wpdb;

//		if ( $add_exclude ) {
//
//		}
		$new_arr = array( '' => 'chouse fild', 'title' => 'title' );
		$exclude = array(
			'iu-uid'                          => 1,
			'iu-status_content'               => 1,
			'iu-status_publish'               => 1,
			'iu-status_service'               => 1,
			'iu-testimonial_customerName'     => 1,
			'iu-testimonial_customerTitle'    => 1,
			'iu-testimonial_des'              => 1,
			'iu-testimonial_rating'           => 1,
			'iu-testimonial_title'            => 1,
			'iu-field_project_value'          => 1,
			'iu-start_date'                   => 1,
			'iu-pic_for_post'                 => 1,
			'iu-testimonial_media'            => 1,
			'iu-presentation'                 => 1,
			'iu-seo_description'              => 1,
			'iu-customerName'                 => 1,
			'iu-updateDate'                   => 1,
			'iu-stage'                        => 1,
			'iu-pipelineId'                   => 1,
			'iu-tsetForRealestate'            => 1,
			'iu-latitude'                     => 1,
			'iu-longitude'                    => 1,
			'iu-createDate'                   => 1,
			'iu-accountId'                    => 1,
			'iu-businessCategories'           => 1,
			'iu-businessLabels'               => 1,
			'iu-businessServices'             => 1,
			'iu-businessTags'                 => 1,
			'iu-contentType'                  => 1,
			'iu-datetimeStamp'                => 1,
			'iu-description'                  => 1,
			'iu-destinations'                 => 1,
			'iu-internalNote'                 => 1,
			'iu-id'                           => 1,
			'iu-lock'                         => 1,
			'iu-media'                        => 1,
			'iu-neighborhood'                 => 1,
			'iu-permitNumber'                 => 1,
			'iu-notes'                        => 1,
			'iu-othersWhoWorkedOnThisProject' => 1,
			'iu-seo'                          => 1,
			'iu-smartTags'                    => 1,
			'iu-status'                       => 1,
			'iu-tasks'                        => 1,
			'iu-testimonial'                  => 1,
			'iu-title'                        => 1,
			'iu-userId'                       => 1,
			'iu-value'                        => 1,
			'iu-url'                          => 1,
		);

		$all_fields = $wpdb->get_results( "SELECT DISTINCT `meta_key` FROM $wpdb->postmeta WHERE `meta_key` LIKE 'iu-%'",
			ARRAY_A );

		foreach ( $all_fields as $field ) {
			if ( ! isset( $exclude[ $field['meta_key'] ] ) ) {
				$new_arr[ $field['meta_key'] ] = str_replace( array( 'iu-', '_' ), array( '', ' ' ),
					$field['meta_key'] );
			}
		}

		return $new_arr;
	}

	public function iu_ajax_filters() {
		$send_arr = array(
			'count_post' => '0',
			'all_post'   => '0',
			'max_pages'  => 0,
			'content'    => '<li class="profolio-col-12 no-found">' . esc_html__( 'No results. Please modify your filters',
					'instantup' ) . '</li>',
		);

		if ( empty( $_POST['parent_id'] ) || empty( $_POST['post_type'] ) || empty( $_POST['template'] ) ) {
			$send_arr['content'] = '<li class="profolio-col-12 no-found">' . esc_html__( 'Empty value',
					'instantup' ) . '</li>';

			wp_send_json( $send_arr );
		}

		$posts_per_page = (int) sanitize_text_field( $_POST['posts_per_page'] ?? 26 );

		if ( isset( $_POST['reset'] ) && $_POST['reset'] ) {
			$posts_per_page = 1000;
		}

		if ( ! empty( $_POST['lat'] ) && ! empty( $_POST['lng'] ) ) {
			global $wpdb;

			$lat = sanitize_text_field( $_POST['lat'] );
			$lng = sanitize_text_field( $_POST['lng'] );


			$radius = isset( $_POST['radius'] ) ? sanitize_text_field( (int) $_POST['radius'] ) : 100;

			$cache_key = 'instantup_filter_ids_' . md5( $lat . $lng . $radius );

			$posts_in = wp_cache_get( $cache_key );

			if ( false === $posts_in ) {

				$sql = $wpdb->prepare( "
                    SELECT pm1.post_id, (3959 *acos(cos(radians('%s'))*cos(radians(pm1.meta_value))*cos(radians(pm2.meta_value)-radians('%s'))+sin(radians('%s'))*sin(radians(pm1.meta_value)))) AS distance
                    FROM {$wpdb->postmeta} AS pm1
                    INNER JOIN {$wpdb->postmeta} AS pm2 ON pm1.post_id = pm2.post_id
                    WHERE pm1.meta_key = %s AND pm2.meta_key = %s
                    HAVING distance < %d
                    ORDER BY distance
                    LIMIT 0, 1000;
                ", $lat, $lng, $lat, 'iu-latitude', 'iu-longitude', $radius );

				$posts_in = $wpdb->get_col( $sql ) ?: array( 0 );
				wp_cache_set( $cache_key, $posts_in );
			}
		}

		$query_arr = array(
			'post_type'      => explode( ',', $_POST['post_type'] ),
			'posts_per_page' => $posts_per_page,
			'post_status'    => array( 'publish' ),
			'paged'          => (int) sanitize_text_field( $_POST['page'] ?? 1 ),
			'orderby'        => array( 'meta_value' => 'DESC', 'date' => 'DESC' ),
			'meta_query'     => array(
				array(
					'relation' => 'OR',
					array(
						'key'     => self::prefix() . 'status_featured',
						'compare' => 'NOT EXISTS',
					),
					array(
						'key'     => self::prefix() . 'status_featured',
						'compare' => 'EXISTS',
					),
				),
				array(
					array(
						'key'     => '_thumbnail_id',
						'compare' => 'EXISTS',
					),
				),
			),
		);

//		if ( isset( $_POST['order'] ) && ! empty( $_POST['order'] ) ) {
//			$query_arr['order'] = sanitize_text_field( $_POST['order'] );
//		}

		if ( isset( $posts_in ) && ! empty( $posts_in ) ) {
			$query_arr['post__in'] = $posts_in;
		}

		if ( isset( $_POST['tags']['ids'] ) && ! empty( $_POST['tags']['ids'] ) ) {
			$query_arr['tax_query'][] = array(
				array(
					'taxonomy' => sanitize_text_field( $_POST['tags']['term_type'] ),
					'terms'    => $_POST['tags']['ids'],
				),
			);
		}

		if ( isset( $_POST['categories']['ids'] ) && ! empty( $_POST['categories']['ids'] ) ) {
			$query_arr['tax_query'][] = array(
				'taxonomy' => sanitize_text_field( $_POST['categories']['term_type'] ),
				'terms'    => $_POST['categories']['ids'],
			);
		}

		if ( isset( $_POST['sort'] ) && ! empty( $_POST['sort'] ) ) {
			$sort_key = sanitize_text_field( $_POST['sort'] );

			$query_arr['order']   = 'ASC';
			$query_arr['orderby'] = 'meta_value_num';

			$query_arr['meta_query'] = array(
				array(
					'relation' => 'OR',
					array(
						'key'     => $sort_key,
						'compare' => 'NOT EXISTS',
					),
					array(
						'key'     => $sort_key,
						'compare' => 'EXISTS',
					),
				),
			);
		}

		if ( ! empty( $_POST['min_price'] ) && empty( $_POST['max_price'] ) ) {
			$query_arr['meta_query'][] = array(
				'key'     => self::prefix() . 'price',
				'value'   => (int) sanitize_text_field( $_POST['min_price'] ),
				'type'    => 'numeric',
				'compare' => '>=',
			);
		}

		if ( empty( $_POST['min_price'] ) && ! empty( $_POST['max_price'] ) ) {
			$query_arr['meta_query'][] = array(
				'key'     => self::prefix() . 'price',
				'value'   => (int) sanitize_text_field( $_POST['max_price'] ),
				'type'    => 'numeric',
				'compare' => '<=',
			);
		}

		if ( ! empty( $_POST['min_price'] ) && ! empty( $_POST['max_price'] ) ) {
			$query_arr['meta_query'][] = array(
				'key'     => self::prefix() . 'price',
				'value'   => array(
					(int) sanitize_text_field( $_POST['min_price'] ),
					(int) sanitize_text_field( $_POST['max_price'] ),
				),
				'type'    => 'numeric',
				'compare' => 'BETWEEN',
			);
		}

		if ( isset( $_POST['meta_query'] ) && ! empty( $_POST['meta_query'] ) ) {
			$query_arr['meta_query'][] = array(
				'key'   => 'iu-status_service',
				'value' => sanitize_text_field( $_POST['meta_query'] ),
			);
		}

		if ( isset( $_POST['more_filters'] ) && ! empty( $_POST['more_filters'] ) ) {
			$query_filters = array( 'relation' => 'OR' );

			foreach ( $_POST['more_filters'] as $item ) {
				$query_filters[] = array(
					'key'     => sanitize_text_field( $item['key'] ),
					'value'   => array(
						ucfirst( sanitize_text_field( $item['value'] ) ),
						lcfirst( sanitize_text_field( $item['value'] ) ),
					),
					'compare' => 'IN',
				);
			}

			$query_arr['meta_query'][] = $query_filters;
		}


		$query = new WP_Query( $query_arr );

		if ( empty( $query->posts ) ) {
			unset( $query_arr['meta_query'][ sanitize_text_field( $_POST['sort'] ) ], $query_arr['meta_key'], $query_arr['orderby'] );

			$query = new WP_Query( $query_arr );
		}

		if ( $query->have_posts() ) {
			$parent_post_id = (int) sanitize_text_field( $_POST['parent_id'] ?? 0 );
			$posts          = $query->posts;
			$ids_posts      = array();

			global $post;
			ob_start();

			foreach ( $posts as $kye => $post ) {
				setup_postdata( $post );
				$ids_posts[] = get_the_ID();

				include INSTANTUP_PATH . 'data/template/blocks/posts/' . sanitize_text_field( $_POST['template'] ) . '.php';
			}

			$html = ob_get_clean();
			wp_reset_postdata();

			$map_locations = $this->get_map_locations( array( 'post_type' => explode( ',', $_POST['post_type'] ), ),
				$ids_posts );
			$locations_arr = base64_encode( json_encode( $map_locations ) );
			$send_arr      = array(
				'success'    => true,
				'count_post' => $query->post_count,
				'all_post'   => $query->found_posts,
				'max_pages'  => $query->max_num_pages,
				'count_loc'  => count( $ids_posts ),
				'locations'  => $locations_arr,
				'content'    => $html,
				'query'      => $query_arr,
			);
		}

		wp_send_json( $send_arr );
	}

	public function iu_ajax_filters_post() {
		if ( $_SERVER['REQUEST_METHOD'] === 'POST' ) {
			$query_arr = array(
				'post_type'      => explode( ',', $_POST['post_type'] ),
				'posts_per_page' => (int) sanitize_text_field( $_POST['posts_per_page'] ?? 26 ),
				'post_status'    => array( 'publish' ),
				'paged'          => get_query_var( 'paged' ) ?: 1,
				'orderby'        => array( 'meta_value' => 'DESC', 'date' => 'DESC' ),
				'meta_query'     => array(
					array(
						'relation' => 'OR',
						array(
							'key'     => self::prefix() . 'status_featured',
							'compare' => 'NOT EXISTS',
						),
						array(
							'key'     => self::prefix() . 'status_featured',
							'compare' => 'EXISTS',
						),
					),
				),
			);

			if ( ! empty( $_POST['lat'] ) && ! empty( $_POST['lng'] ) ) {
				global $wpdb;

				$lat = sanitize_text_field( $_POST['lat'] );
				$lng = sanitize_text_field( $_POST['lng'] );


				$radius = isset( $_POST['radius'] ) ? sanitize_text_field( (int) $_POST['radius'] ) : 100;

				$cache_key = 'instantup_filter_ids_' . md5( $lat . $lng . $radius );

				$posts_in = wp_cache_get( $cache_key );

				if ( false === $posts_in ) {

					$sql = $wpdb->prepare( "
                    SELECT pm1.post_id, (3959 *acos(cos(radians('%s'))*cos(radians(pm1.meta_value))*cos(radians(pm2.meta_value)-radians('%s'))+sin(radians('%s'))*sin(radians(pm1.meta_value)))) AS distance
                    FROM {$wpdb->postmeta} AS pm1
                    INNER JOIN {$wpdb->postmeta} AS pm2 ON pm1.post_id = pm2.post_id
                    WHERE pm1.meta_key = %s AND pm2.meta_key = %s
                    HAVING distance < %d
                    ORDER BY distance
                    LIMIT 0, 1000;
                ", $lat, $lng, $lat, 'iu-latitude', 'iu-longitude', $radius );

					$posts_in = $wpdb->get_col( $sql ) ?: array( 0 );
					wp_cache_set( $cache_key, $posts_in );
				}
			}

			if ( isset( $posts_in ) && ! empty( $posts_in ) ) {
				$query_arr['post__in'] = $posts_in;
			}

			if ( $_POST['term_type'] && $_POST['term_id'] ) {
				$query_arr['tax_query'][] = array(
					'taxonomy' => sanitize_text_field( $_POST['term_type'] ),
					'terms'    => (int) $_POST['term_id'],
				);
			}

			if ( $_POST['meta_query'] ) {
				$query_arr['meta_query'][] = array(
					'key'   => 'iu-status_service',
					'value' => sanitize_text_field( $_POST['meta_query'] ),
				);
			}

			$query = new WP_Query( $query_arr );

			if ( $query->have_posts() ) {
				$parent_post_id = (int) sanitize_text_field( $_POST['parent_id'] );
				$posts          = $query->posts;
				$ids_posts      = array();

				global $post;

				ob_start();

				foreach ( $posts as $kye => $post ) {
					setup_postdata( $post );
					$ids_posts[] = get_the_ID();

					include INSTANTUP_PATH . 'data/template/blocks/posts/' . sanitize_text_field( $_POST['template'] ) . '.php';
				}

				$html = ob_get_clean();
				wp_reset_postdata();

				$map_locations = $this->get_map_locations( array( 'post_type' => explode( ',', $_POST['post_type'] ), ),
					$ids_posts );
				$locations_arr = base64_encode( json_encode( $map_locations ) );
				$send_arr      = array(
					'success'    => true,
					'count_post' => $query->post_count,
					'all_post'   => $query->found_posts,
					'max_pages'  => $query->max_num_pages,
					'count_loc'  => count( $ids_posts ),
					'locations'  => $locations_arr,
					'content'    => $html,
					'query'      => $query_arr,
				);

				wp_send_json( $send_arr );
			}

			wp_send_json_error();
		}
	}

	public function get_price_for_select( $_min, $_max ) {
		$min_length  = strlen( $_min );
		$max_length  = strlen( $_max );
		$html_option = '';

		if ( $_min === $_max ) {
			$html_option .= '<option value="' . $_min . '">' . $_min / $_max . "K</option>\n";
		}

		if ( $min_length === 5 && $max_length === 5 ) {
			//min 99 999
			//max 99 999

			foreach ( range( $_min, $_max, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}
		}
		if ( $min_length === 5 && $max_length === 6 ) {
			$_max += 10000;
			//min 99 999
			//max 999 999

			foreach ( range( $_min, 9000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, $_max, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}
		}
		if ( $min_length === 5 && $max_length === 7 ) {
			$_max += 250000;
			//min 99 999
			//max 9 999 999

			foreach ( range( $_min, 9000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, 99000, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 10000 . "K</option>\n";
			}

			foreach ( range( 100000, 999000, 50000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 100000 . "K</option>\n";
			}

			foreach ( range( 1000000, $_max, 250000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 100000 . "M</option>\n";
			}
		}
		if ( $min_length === 5 && $max_length === 8 ) {
			$_max += 5000000;
			//min 99 999
			//max 99 999 999

			foreach ( range( $_min, 9000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, 99000, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 100000, 900000, 50000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 1000000, 9000000, 2500000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 100000 . "M</option>\n";
			}

			foreach ( range( 10000000, $_max, 5000000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 100000 . "M</option>\n";
			}
		}


		if ( $min_length <= 4 && $max_length === 4 ) {
			//min 9 999
			//max 9 999

			foreach ( range( $_min, $_max, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}
		}
		if ( $min_length <= 4 && $max_length === 5 ) {
			$_max += 5000;
			//min 9 999
			//max 99 999

			foreach ( range( $_min, 9000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, $_max, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}
		}
		if ( $min_length <= 4 && $max_length === 6 ) {
			$_max += 10000;
			//min 9 999
			//max 999 999

			foreach ( range( $_min, 9000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, $_max, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}
		}
		if ( $min_length <= 4 && $max_length === 7 ) {
			$_max += 250000;
			//min 9 999
			//max 9 999 999

			foreach ( range( $_min, 9000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, 99000, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 100000, 990000, 50000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 1000000, $_max, 2500000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000000 . "M</option>\n";
			}
		}
		if ( $min_length <= 4 && $max_length === 8 ) {
			$_max += 5000000;
			//min 9 999
			//max 99 999 999

			foreach ( range( $_min, 10000, 2500 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 10000, 99000, 10000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 100000, 990000, 50000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000 . "K</option>\n";
			}

			foreach ( range( 1000000, 9000000, 2500000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000000 . "M</option>\n";
			}

			foreach ( range( 10000000, $_max, 5000000 ) as $num ) {
				$html_option .= '<option value="' . $num . '">' . $num / 1000000 . "M</option>\n";
			}
		}

		return $html_option;

	}

	public function filter_plugin_action_links( array $actions ) {
		$pattern       = '<a href="%s">%s</a>';
		$url           = admin_url( 'admin.php?page=crb_carbon_fields_container_instantuploader.php' );
		$name_url      = __( 'Settings', 'viator' );
		$link          = sprintf( $pattern, $url, $name_url );
		$settings_link = array( $link );

		return array_merge( $settings_link, $actions );
	}

	public function iu_export_templates() {
		if ( empty( $_POST['templates'] ) ) {
			status_header( 400 );
			exit;
		}

		$result = array();
		$posts  = get_posts( array(
			'numberposts'      => 100,
			'post_type'        => 'iu_templates',
			'include'          => $_POST['templates'],
			'suppress_filters' => true,
		) );

		foreach ( $posts as $key => $post ) {
			$result[ $key ] = array(
				'title'   => $post->post_title,
				'content' => $post->post_content,
				'type'    => $post->post_type,
			);

			if ( $for_cat_tag = get_post_meta( $post->ID, '_template_for_cat_tag', true ) ) {
				$result[ $key ]['meta']['_template_for_cat_tag'] = $for_cat_tag;
			}

			if ( $type = get_post_meta( $post->ID, 'iu_template_type', true ) ) {
				$result[ $key ]['meta']['iu_template_type'] = $type;
			}

			if ( $content_width = get_post_meta( $post->ID, 'iu_content_width', true ) ) {
				$result[ $key ]['meta']['iu_content_width'] = $content_width;
			}

			if ( $for_content = get_post_meta( $post->ID, '_template_for_content', true ) ) {
				$result[ $key ]['meta']['_template_for_content'] = $for_content;
			}
		}

		wp_send_json( $result );
	}

	public function iu_import_templates() {
		$response = array();
		$posts    = json_decode( file_get_contents( $_FILES['iu_import_file']['tmp_name'] ), true );

		foreach ( $posts as $post ) {
			$template_data = array(
				'post_status'  => 'publish',
				'post_type'    => $post['type'],
				'post_title'   => $post['title'],
				'post_content' => $post['content'],
			);

			foreach ( $post['meta'] as $key => $meta ) {
				$template_data['meta_input'][ $key ] = $meta;
			}

			$post_id = wp_insert_post( $template_data, true );

			if ( ! is_wp_error( $post_id ) ) {
				$response['ids'][] = $post_id;

			} else {
				++ $response['errors'];
				$response['errors_message'] = array();
				$error_message              = $post_id->get_error_message();

				if ( ! in_array( $error_message, $response['errors_message'] ) ) {
					$response['errors_message'][] = "<p class=\"errors-message\">{$error_message}</p>";
				}
			}
		}

		wp_send_json( $response );
	}

	public function custom_schedules() {
		$time = time();

		return array(
			$time + 60,    //ONE min
			$time + 120,   //TWO min
			$time + 300,   //FIVE min
			$time + 600,   //TEN min
			$time + 1200,  //TWENTY min
			$time + 2600,  //THIRTY min
			$time + 5200,  //ONE hour
			$time + 10400, //TWO hour
			$time + 43200, //HALF day
			$time + 86400, //FULL day
		);
	}

	public function iu_get_data_account_seo() {
		if ( ! $apiKey = get_option( '_firebase_auth' ) ) {
			wp_send_json( array( 'success' => false, 'message' => 'Not exist apiKey', ) );
		}

		$url  = IU_CLOUDFUNCTIONS_HOST . '/app/get-contents';
		$args = array(
			'timeout'     => 30,
			'httpversion' => '1.1',
			'headers'     => array( 'Content-Type' => 'application/json' ),
			'body'        => wp_json_encode( array(
				'apiKey' => $apiKey,
				'limit'  => 0,
			) ),
		);

		$response = wp_remote_post( $url, $args );

		if ( ! is_wp_error( $response ) ) {
			$response = json_decode( $response['body'], true );

			if ( isset( $response['account'] ) && ! empty( $response['account'] ) ) {
				$data = array(
					'email_address' => $response['account']['email'] ?? '',
					'business_name' => $response['account']['businessName'] ?? '',
					'location'      => $response['account']['location'] ?? '',
					'country'       => $response['account']['country'] ?? '',
					'state '        => $response['account']['state'] ?? '',
					'zip '          => $response['account']['zip'] ?? '',
					'phone_number'  => $response['account']['phone'] ?? '',
					'website'       => $response['account']['website'] ?? '',
					'logo'          => $response['account']['logo'] ?? '',
				);
				update_option( 'iu_data_account_seo', $data, false );

				if ( isset( $response['themeCustomiz'] ) && ! empty( $response['themeCustomiz'] ) ) {
					update_option( 'iu_theme_customiz', $response['themeCustomiz'], false );
				}

				if ( isset( $response['textOptions'] ) && ! empty( $response['textOptions'] ) ) {
					update_option( 'iu_text_options', $response['textOptions'], false );
				}

				wp_send_json( array(
						'success' => true,
						'data'    => $data,
					)
				);
			}

		}

		wp_send_json( array( 'success' => false, 'message' => $response, ) );
	}

	public function iu_data_account_output() {
		ob_start(); ?>
        <div class="iu-data-account-output-btn-group">
            <button class="button button-large iu-data-account-output-btn-show" type="button">
                <span>Show data</span>
            </button>

            <div class="iu-data-account-output-btn-js">
                <button id="iu_get_data_account_btn" class="button button-large button-primary" type="button">
                    Get data from saas
                </button>

                <img class="import_loader" style="display: none;vertical-align: bottom;" width="30"
                     src="<?php echo plugin_dir_url( __DIR__ ); ?>/data/assets/img/ajax-loader.gif" alt="">
                <span class="success" style="display: none;">Success</span>
                <span class="error" style="display: none;">Error</span>
            </div>
        </div>

        <div class="iu-data-account-output-table">
			<?php if ( $data_account = get_option( 'iu_data_account_seo' ) ): ?>
                <div class="divTable">
                    <div class="divTableBody">
						<?php foreach ( $data_account as $key => $item ) : ?>
							<?php if ( $key === 'logo' ): ?>
                                <div class="divTableRow">
                                    <div class="divTableCell">
										<?php echo ucfirst( str_replace( '_', ' ', $key ) ); ?>
                                    </div>
                                    <div class="divTableCell">
                                        <img src="<?php echo $item; ?>" alt="logo"
                                             style="object-fit: cover"
                                             width="32" height="32">
                                    </div>
                                </div>
							<?php else: ?>
                                <div class="divTableRow">
                                    <div class="divTableCell">
										<?php echo ucfirst( str_replace( '_', ' ', $key ) ); ?>
                                    </div>
                                    <div class="divTableCell"><?php echo $item; ?></div>
                                </div>
							<?php endif; ?>
						<?php endforeach; ?>
                    </div>
                </div>
                <a style="float: right;" href="https://app.instantuploader.com/settings/business-account"
                   target="_blank">Edit</a>
			<?php else: ?>
                <p style="display: inline-block; margin: 0;">No data, you can change the data</p>
                <a href="https://app.instantuploader.com/settings/business-account" target="_blank">here</a>
			<?php endif; ?>
        </div>

		<?php
		return ob_get_clean();
	}

	public function iu_test_api_button_html( $label, $class = '', $success_mess = '', $error_mass = '', $data = '' ) {
		if ( empty( $success_mess ) ) {
			$success_mess = esc_html__( 'Api key is valid', 'instantup' );
		}

		if ( empty( $error_mass ) ) {
			$error_mass = esc_html__( 'Api key is not valid', 'instantup' );
		}

		$data_html = '';
		if ( $data ) {
			$data_html = 'data-apikey = "' . $data . '"';
		}

		ob_start();

		if ( $class === 'profolio_js_api_test' ) { ?>
            <div class="cf-field__body iu_disable_maps_fantom">
                <input type="checkbox" id="cf-iu_disable_maps_fantom" name="iu_disable_maps_fantom"
                       class="cf-checkbox__input" <?php checked( (bool) get_option( '_iu_disable_maps' ) ) ?>>
                <label class="cf-checkbox__label" for="cf-iu_disable_maps_fantom">
                    Disable maps until API key is provided here
                </label>
            </div>
		<?php } ?>

        <p class="test_api_button_wrap">
            <a class="button button-primary <?php echo esc_attr( $class ); ?>" <?php echo $data_html; ?>>
				<?php echo esc_html( $label ); ?>
            </a>
            <img class="import_loader" style="display: none;vertical-align: bottom;" width="30"
                 src="<?php echo plugin_dir_url( __DIR__ ); ?>/data/assets/img/ajax-loader.gif" alt="">
            <span class="success" style="display: none;"><?php echo esc_html( $success_mess ); ?></span>

            <span class="profolio_message_count"></span>
            <span class="error" style="display: none;"
                  data-cache="<?php echo esc_html( $error_mass ); ?>"><?php echo esc_html( $error_mass ); ?></span>
        </p>
		<?php
		return ob_get_clean();
	}

	public function get_schema_localbusiness( $post_id = '', $type_cont = 'post' ) {
		$name      = '';
		$url       = '';
		$image     = '';
		$logo      = '';
		$telephone = '';
		$address   = '';
		$data_acc  = get_option( 'iu_data_account_seo' );

		if ( ! $post_id ) {
			$post_id = get_the_ID();
		}

		if ( $type_cont === 'category' ) {
			$name      = $data_acc['business_name'];
			$url       = $data_acc['website'];
			$logo      = $data_acc['logo'];
			$telephone = $data_acc['phone_number'];
			$address   = $data_acc['country'] . ' ' . $data_acc['location'];
		}

		if ( $type_cont === 'post' ) {
			$name      = get_the_title( $post_id );
			$url       = get_post_permalink( $post_id );
			$logo      = $data_acc['logo'];
			$telephone = $data_acc['phone_number'];
			$address   = get_post_meta( $post_id, 'iu-address', true );
		}

		ob_start();
		?>
        <meta itemprop="name" content="<?php echo $name; ?>"/>
        <meta itemprop="url" content="<?php echo $url; ?>"/>
        <meta itemprop="logo" content="<?php echo $logo; ?>"/>

        <meta itemprop="telephone" content="<?php echo $telephone; ?>"/>
        <meta itemprop="address" content="<?php echo $address; ?>"/>
		<?php
		return ob_get_clean();
	}

	public function get_schema_rating( $post_id ) {
		$customer_name  = get_post_meta( $post_id, self::prefix() . 'testimonial_customerName', true ) ?: 'anonymous';
		$customer_title = get_post_meta( $post_id, self::prefix() . 'testimonial_customerTitle', true );
		$t_des          = get_post_meta( $post_id, self::prefix() . 'testimonial_des', true );
		$t_rating       = get_post_meta( $post_id, self::prefix() . 'testimonial_rating', true );
		$presentation   = get_post_meta( $post_id, self::prefix() . 'presentation', true );
		$title          = get_the_title( $post_id );

		if ( isset( $presentation['cover'] ) && ! empty( $presentation['cover'] ) ) {
			$image = wp_get_attachment_image_url( $presentation['cover'] );

		} elseif ( has_post_thumbnail( $post_id ) ) {
			$image = get_the_post_thumbnail_url( $post_id, 'thumbnail' );

		} elseif ( $pic_for_post = get_post_meta( $post_id, self::prefix() . 'pic_for_post', true ) ) {
			$image = wp_get_attachment_image_url( $pic_for_post[0] );
		} else {
			$image = INSTANTUP_URL . 'data/assets/img/placeholder.png';
		}

		ob_start();
		?>
        <div class="d-none" style="display: none" itemprop="itemReviewed" itemtype="http://schema.org/Product" itemscope>
            <img itemprop="image" src="<?php echo $image; ?>" alt="<?php echo $title; ?>"/>
            <span itemprop="name"><?php echo $title; ?></span>
            <span itemprop="description"><?php echo get_the_excerpt( $post_id ); ?></span>

            <div itemprop="review" itemtype="http://schema.org/Review" itemscope>
                <div itemprop="author" itemtype="http://schema.org/Person" itemscope>
                    <meta itemprop="name" content="<?php echo $customer_name; ?>"/>
                </div>

                <meta itemprop="datePublished" content="<?php echo get_the_date( 'Y-m-d', $post_id ); ?>">
				<?php echo get_the_date( 'F j, Y', $post_id ); ?>

                <span itemprop="name"><?php echo $customer_title; ?></span>
                <span itemprop="reviewBody"><?php echo $t_des ?></span>

                <div itemprop="reviewRating" itemtype="http://schema.org/Rating" itemscope>
                    <meta itemprop="ratingValue" content="<?php echo $t_rating; ?>"/>
                    <meta itemprop="bestRating" content="5"/>
                    <meta itemprop="worstRating" content="1"/>
                </div>
            </div>
        </div>
		<?php
		return ob_get_clean();
	}

	public function get_postype_block( $post_id ) {
		$content        = get_the_content( '', '', (int) $post_id );
		$blocks_content = parse_blocks( $content );

		if ( $blocks_content ) {
			$post_type = array();

			foreach ( $blocks_content as $inner_block ) {
				if ( $inner_block['innerBlocks'] ) {
					foreach ( $inner_block['innerBlocks'] as $item ) {

						if ( count( $item['innerBlocks'] ) === 1 ) {
							if ( $item['innerBlocks'][0]['blockName'] === 'carbon-fields/iu-custom-posts' ||
							     $item['innerBlocks'][0]['blockName'] === 'carbon-fields/iu-content-posts' ) {
								if ( ! empty( $item['innerBlocks'][0]['attrs']['data']['iu_output_type'] ) ) {
									$post_type = $item['innerBlocks'][0]['attrs']['data']['iu_output_type'];
								}
								break 2;
							}
						} else {
							foreach ( $item['innerBlocks'] as $item2 ) {
								if ( $item2['blockName'] === 'carbon-fields/iu-custom-posts' ||
								     $item2['blockName'] === 'carbon-fields/iu-content-posts' ) {
									if ( ! empty( $item2['attrs']['data']['iu_output_type'] ) ) {
										$post_type = $item2['attrs']['data']['iu_output_type'];
									}
									break 3;
								}
							}
						}
					}
					break;
				}
			}

			if ( $post_type ) {
				return $post_type;
			}
		}

		return get_option( '_iu_custom_type_slug' );
	}

}