<?php

use Carbon_Fields\Block;
use Carbon_Fields\Field;

//$args_term = array(
//	'taxonomy'   => array( 'iu_tags' ),
//	'fields'     => 'names',
//	'meta_query' => array(
//		array(
//			'key'   => 'iu-ai_writeups_tag',
//			'value' => '1',
//		),
//	),
//);
//$terms     = get_terms( $args_term );
//
//$sorting_fields  = array();
//$settings_fields = array(
//
//);
//
//$sorting_conditional_logic = array(
//	array(
//		'field' => 'iu_sort_items',
//		'value' => 'custom',
//	),
//);
//
//foreach ( $terms as $index => $term ) {
//	if ( $term ) {
//		$sorting_fields[] = array(
//			'key'  => 'iu_position_tag_' . $index,
//			'name' => $term,
//		);
//
//		$settings_fields[] = Field::make( 'text', 'iu_position_tag_' . $index,
//			"{$term} order:" )->set_conditional_logic( $sorting_conditional_logic );
//	}
//}

Block::make( __( 'AI writeups content', 'instantup' ) )
	//Featured image
	 ->add_tab( __( 'General Settings' ), array(
		Field::make( 'checkbox', 'iu_show_featured_img', '' )
		     ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
		     ->set_option_value( 'yes' )
		     ->set_help_text( __( 'Show Featured Image?' ) ),

		Field::make( 'select', 'iu_sort_items', __( 'Sorting Items' ) )
		     ->set_default_value( 'asc' )
		     ->add_options( array(
			     'random' => __( 'Random' ),
			     'asc'    => __( 'ASC' ),
			     'desc'   => __( 'DESC' ),
//			     'custom' => __( 'Own choose' ),
		     ) ),
	) )
     ->add_tab( __( 'Settings Each Item' ), array(
	     Field::make( 'text', 'border_item', __( 'Border' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'bdrs_item', __( 'Border Radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'padding_item_top_bottom', __( 'Padding Top And Bottom' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type' => 'number',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'padding_item_left_right', __( 'Padding Left And Right' ) )
	          ->set_attributes( array(
		          'type' => 'number',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_item_bottom', __( 'Margin Bottom' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) ),
     ) )
     ->add_tab( __( 'Tags' ), array(
	     Field::make( 'checkbox', 'iu_hidden_tags', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Tags' ) ),
	     Field::make( 'color', 'color_tags', __( 'Color For Tags' ) )
	          ->set_default_value( '#50505a' ),
	     Field::make( 'text', 'font_size_tags', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 14',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'select', 'font_weight_tags', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_top_tags', __( 'Margin Top' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type' => 'number',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_tags', __( 'Margin Bottom' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 5',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'iu_before_tags', __( 'Text Before Tags' ) )
	          ->set_attribute( 'placeholder', 'some text' ),
	     Field::make( 'text', 'iu_after_tags', __( 'Text After Tags' ) )
	          ->set_attribute( 'placeholder', 'some text' ),

     ) )
     ->add_tab( __( 'Title' ), array(
	     Field::make( 'checkbox', 'iu_hide_items_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Items Title' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'color_title', __( 'Color For Title' ) )
	          ->set_default_value( '#50505a' ),

	     Field::make( 'text', 'font_size_title', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 14',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'select', 'font_weight_title', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_title', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) ),
	     Field::make( 'text', 'margin_top_title', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type' => 'number',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_title', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 5',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Content' ), array(
	     Field::make( 'color', 'color_title_cnt', __( 'Color For Content' ) )
	          ->set_default_value( '#50505a' ),

	     Field::make( 'text', 'font_size_cnt', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 14',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'select', 'font_weight_cnt', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_cnt', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) ),
	     Field::make( 'text', 'margin_top_cnt', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_cnt', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 12',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Map' ), array(
	     Field::make( 'checkbox', 'iu_show_map', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Show Map in Content?' ) ),

	     Field::make( 'select', 'iu_map_position', __( 'Map Position' ) )
	          ->add_options( array(
		          'top'    => __( 'Top' ),
		          'center' => __( 'Center' ),
		          'bottom' => __( 'Bottom' ),
	          ) )
	          ->set_default_value( 'bottom' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_show_map',
			          'value' => true,
		          ),
	          ) ),


     ) )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_mode( 'preview' )
     ->set_render_callback( function ( $fields ){
	     $temp_post   = get_option( '_temp_post_for_templates' );
	     $post_id     = get_the_ID();
	     $thumb_url   = '';
	     $ai_center   = 1;
	     $temp_cnt    = array();
	     $sorting_pos = array();
	     $ai_content  = array(
		     array(
			     'tags'    => array( 'Trust' ),
			     'title'   => 'Accusamus accusantium adipisci aliquam aliquid',
			     'content' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ab adipisci asperiores aut debitis distinctio dolores esse hic inventore ipsa ipsam laboriosam magni maxime mollitia, neque officiis optio quaerat quas qui similique sint? Adipisci amet dolor dolore ea eligendi eveniet fugit illum laborum omnis placeat quam, repellendus rerum ullam. Earum, explicabo.',
		     ),
		     array(
			     'tags'    => array( 'Worth it' ),
			     'title'   => 'A adipisci culpa ea eius, incidunt nulla',
			     'content' => 'Ab cumque dolor esse explicabo magnam molestias omnis quia veniam vitae? Commodi ex iure libero non quisquam. Accusamus, aliquid aut consequatur, debitis earum eligendi et incidunt molestiae nesciunt, nobis odio odit perspiciatis quasi quos sequi sit tempore vel voluptas! Accusantium enim, iste magni maxime nesciunt qui quo sit. ',
		     ),
		     array(
			     'tags'    => array( 'Incentives' ),
			     'title'   => 'istinctio harum impedit nobis, placeat sit',
			     'content' => 'Aspernatur blanditiis cum eligendi hic officiis quidem quos sapiente sunt! A consequuntur dolore in itaque laborum molestias mollitia numquam similique tempora unde! A accusantium ad, amet at, dignissimos dolore dolorem dolores ducimus excepturi ipsum labore magnam minus nihil recusandae, sint tempore temporibus? Sint, tempora?',
		     ),
	     );

	     if ( $post_id ) {
		     $ai_content = get_post_meta( $post_id, 'ai_content_fields', true );

		     if ( $parent_id = get_post_meta( $post_id, 'parent_id', true ) ) {
			     $thumb_url = get_the_post_thumbnail_url( $parent_id );
		     }
	     }

	     if ( $fields['iu_sort_items'] === 'random' ) {
		     shuffle( $ai_content );
	     }
	     if ( $fields['iu_sort_items'] === 'desc' ) {
		     arsort( $ai_content );
	     }
//	     if ( $fields['iu_sort_items'] === 'custom' ) {
//		     foreach ( $sorting_fields as $item ) {
//			     $sorting_pos[ $item['name'] ] = $fields[ $item['key'] ];
//		     }
//
//		     asort( $sorting_pos );
//
//		     foreach ( $sorting_pos as $key => $position ) {
//			     if ( ! $position ) {
//				     continue;
//			     }
//
//			     foreach ( $ai_content as $i => $cnt ) {
//				     if ( $cnt['tags'][0] === $key ) {
//					     $temp_cnt[] = $cnt;
//					     unset( $ai_content[ $i ] );
//				     }
//			     }
//		     }
//
//		     if ( $temp_cnt ) {
//			     $ai_content = array_merge( $temp_cnt, $ai_content );
//		     }
//	     }

	     if ( is_array( $ai_content ) ) {
		     $ai_center = (int) ceil( count( $ai_content ) / 2 );
	     }

	     if ( $fields['iu_show_map'] ) {
		     $map_block = '<div class="iu-ai-writeups-map-wrap"><img class="iu-right-side-map" src="' . INSTANTUP_URL . 'data/assets/img/test_map.jpg;" alt="Google map"></div>';

		     if ( ( $longitude = get_post_meta( $post_id, $this->prefix() . 'latitude', true ) ) &&
		          ( $latitude = get_post_meta( $post_id, $this->prefix() . 'longitude', true ) ) &&
		          ( $maps_api_key = get_option( '_pap_google_maps_api_key' ) ) ) {

			     $src       = "https://maps.googleapis.com/maps/api/staticmap?zoom=16&size=700x300&maptype=roadmap&markers={$longitude},{$latitude}&key={$maps_api_key}";
			     $map_block = '<div class="iu-ai-writeups-map-wrap"><img class="iu-right-side-map" src="' . $src . '" alt="map Google" 
			     onerror="this.src=' . INSTANTUP_URL . 'data/assets/img/test_map.jpg;"></div>';
		     }
	     }

	     ?>

         <style>
             .ai-writeups-item {
             <?php
                echo $fields['border_item'] ? "border: {$fields['border_item']}px solid #ccc;" : '';
                echo $fields['bdrs_item'] ? "border-radius: {$fields['bdrs_item']}px;" : '';
//                echo $fields['padding_item'] ? "padding: {$fields['padding_item']}px;" : '';
                echo $fields['margin_item_bottom'] ? "margin-bottom: {$fields['margin_item_bottom']}px;" : '';

                if ($fields['padding_item_top_bottom'] && $fields['padding_item_left_right']){
                    echo "padding: {$fields['padding_item_top_bottom']}px {$fields['padding_item_left_right']}px;";
                }
                if ($fields['padding_item_top_bottom'] && !$fields['padding_item_left_right']){
                    echo "padding: {$fields['padding_item_top_bottom']}px 0;";
                }
                if ($fields['padding_item_left_right'] && !$fields['padding_item_top_bottom']){
                    echo "padding: 0 {$fields['padding_item_left_right']}px;";
                }
             ?>
             }

             .ai-writeups-tags {
             <?php
                echo $fields['font_size_tags'] ? "font-size: {$fields['font_size_tags']}px !important;" : '';
                echo $fields['font_weight_tags'] ? "font-weight: {$fields['font_weight_tags']};" : '';
                echo $fields['color_tags'] ? "color: {$fields['color_tags']};" : '';
                echo $fields['margin_top_tags'] ? "margin-top: {$fields['margin_top_tags']}px;" : '';
                echo $fields['margin_bottom_tags'] ? "margin-bottom: {$fields['margin_bottom_tags']}px;" : '';
              ?>
             }

             .ai-writeups-title {
             <?php
                echo $fields['font_size_title'] ? "font-size: {$fields['font_size_title']}px;" : '';
                echo $fields['font_weight_title'] ? "font-weight: {$fields['font_weight_title']};" : '';
                echo $fields['line_height_title'] ? "line-height: {$fields['line_height_title']}px;" : '';
                echo $fields['color_title'] ? "color: {$fields['color_title']};" : '';
                echo $fields['margin_top_title'] ? "margin-top: {$fields['margin_top_title']}px;" : '';
                echo $fields['margin_bottom_title'] ? "margin-bottom: {$fields['margin_bottom_title']}px;" : '';
             ?>
             }

             .ai-writeups-cnt {
             <?php
                echo $fields['font_size_cnt'] ? "font-size: {$fields['font_size_cnt']}px;" : '';
                echo $fields['font_weight_cnt'] ? "font-weight: {$fields['font_weight_cnt']};" : '';
                echo $fields['line_height_cnt'] ? "line-height: {$fields['line_height_cnt']}px;" : '';
                echo $fields['color_title_cnt'] ? "color: {$fields['color_title_cnt']};" : '';
                echo $fields['margin_top_cnt'] ? "margin-top: {$fields['margin_top_cnt']}px;" : '';
                echo $fields['margin_bottom_cnt'] ? "margin-bottom: {$fields['margin_bottom_cnt']}px;" : '';
             ?>
             }
             .iu-ai-writeups-map-wrap {
                 width: 100%;
                 text-align: center;
             }
             .iu-ai-writeups-wrap .iu-right-side-map {
                 width: 100%;
                 max-width: 700px;
                 max-height: 325px;
                 object-fit: cover;
                 margin-bottom: 20px;
             }
         </style>

         <div class="block iu-ai-writeups-wrap">
		     <?php if ( $fields['iu_show_featured_img'] ): ?>
                 <div class="ai-writeups-featured_img">
                     <img src="<?php echo $thumb_url; ?>" alt="featured img"
                          onerror="this.src='<?php echo INSTANTUP_URL . 'data/assets/img/temp_pic.jpg' ?>';">
                 </div>
		     <?php endif; ?>

		     <?php if ( $fields['iu_show_map'] && $fields['iu_map_position'] === 'top' ) {
			     echo $map_block;
		     }

		     echo get_the_content( '', '', get_the_ID() ? : $temp_post );

		     if ( is_array( $ai_content ) ):
			     foreach ( $ai_content as $key => $ai_content_cnt ) :
				     if ( $fields['iu_show_map'] && $fields['iu_map_position'] === 'center' ) {
					     if ( $ai_center === $key ) {
						     echo $map_block;
					     }
				     }
				     ?>

                     <div class="ai-writeups-item">
					     <?php if ( ! $fields['iu_hidden_tags'] ): ?>
                             <h2 class="ai-writeups-tags">
							     <?php echo $fields['iu_before_tags'] ? : ''; ?>
							     <?php echo is_array( $ai_content_cnt['tags'] ) ? implode( ', ',
								     $ai_content_cnt['tags'] ) : $ai_content_cnt['tags']; ?>
							     <?php echo $fields['iu_after_tags'] ? : ''; ?>
                             </h2>
					     <?php endif; ?>

					     <?php if ( ! $fields['iu_hide_items_title'] ): ?>
                             <div class="ai-writeups-title">
							     <?php echo $ai_content_cnt['title']; ?>
                             </div>
					     <?php endif; ?>

                         <div class="ai-writeups-cnt">
						     <?php echo $ai_content_cnt['content']; ?>
                         </div>
                     </div>
			     <?php endforeach;
		     endif;
		     if ( $fields['iu_show_map'] && $fields['iu_map_position'] === 'bottom' ) {
			     echo $map_block;
		     } ?>

         </div><!-- .block -->

	     <?php
     } );