<?php
/**
 * map.php
 * create in 13.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make( __( 'IU Content Map' ) )
     ->add_fields( array(
	     Field::make( 'checkbox', 'iu_zoom_all_markers', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Zoom to fit all markers' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_map_fullheight', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Full height map' )
	          ->set_default_value( 'yes' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_hide_info_window', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Hide info window' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'checkbox', 'iu_blue_icon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use blue marker icon' )
	          ->set_default_value( false )
	          ->set_option_value( true ),

	     Field::make( 'checkbox', 'iu_hide_map', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( 'Use hide map' )
	          ->set_option_value( 'yes' ),

	     Field::make( 'text', 'top_block', __( 'Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_hide_map',
			          'value' => true,
		          ),
	          ) ),

	     Field::make( 'select', 'iu_map_which_posts', __( 'Get coordinates from' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_options( array(
		          'all_pages' => 'Display on map projects from all pages',
	          ) )
	          ->add_options( array(
		          'current_page' => 'Display on map same projects as on current pages',
	          ) )
	          ->set_default_value( 'current_page' )
	          ->add_options( function () {
		          $post_id = $_GET['post'] ?? $_POST['id'] ?? $_POST['post_ID'] ?? '';
		          update_option( 'current_post_ID', $post_id );
	          } ),

	     Field::make( 'image', 'marker_image', __( 'Marker Image' ) )
	          ->set_classes( 'iu-separator-margin' )
	          ->set_value_type( 'url' )
	          ->set_conditional_logic( array(
		          array(
			          'field' => 'iu_blue_icon',
			          'value' => false,
		          ),
	          ) ),
     ) )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'Map with markers' ) )
     ->set_icon( 'block-default' )
     ->set_mode( 'preview' )
     ->set_render_callback( function ( $fields ) {
	     $post_ID = get_option( 'current_post_ID' );

	     if ( ! get_option( '_pap_google_maps_api_key' ) && get_option( '_iu_disable_maps' ) === 'yes' ) {
		     echo '<div id="iu_no_map_api">No Google Map API</div>';

		     return;
	     }

	     $rand = random_int( 1, 50 );
	     $salt = substr( md5( $rand * 200 ), 0, 10 );

	     $atts = array(
		     'fullheight' => (string) $fields['iu_map_fullheight'],
		     'zoom'       => '7',
	     );

		 if (isset($fields['iu_map']['zoom'])){
			 $atts['zoom'] = (string) $fields['iu_map']['zoom'];
		 }

	     if ( $fields['marker_image'] ) {
		     $atts['marker'] = $fields['marker_image'];
	     }

	     if ( isset($fields['iu_blue_icon']) && $fields['iu_blue_icon'] ) {
		     $atts['marker'] = INSTANTUP_URL . 'data/assets/img/pin_fill.png';
	     }

	     if ( $fields['iu_map_which_posts'] === 'current_page' ) {
		     $atts['number_projects'] = 'current_page';

		     $post_type_arr = array(
			     'post_type' => $this->get_postype_block( $post_ID ),
		     );

		     $atts['locations'] = $this->get_map_locations( $post_type_arr, false, $post_ID );
	     } else {
		     $atts['number_projects'] = 'all_pages';
		     $atts['locations']       = $this->get_map_locations( false, false, $post_ID );
	     }

	     if ( $fields['iu_zoom_all_markers'] ) {
		     $atts['zoom_fit'] = true;
	     }

	     $atts['location'] = $this->get_one_location( $atts['locations'] );
	     ?>

         <script>
		     <?php if ($fields['iu_hide_info_window']): ?>
             window['iuHideInfoWindow'] = <?php echo $fields['iu_hide_info_window']?>;
		     <?php else:?>
             window['iuHideInfoWindow'] = 0;
		     <?php endif;?>

		     <?php if (is_numeric($atts['location'][0]) && is_numeric($atts['location'][1]) ):?>
             window['iuMapCenterLatLng'] = [
               <?php echo $atts['location'][0]?>,
               <?php echo $atts['location'][1]?>
             ];
		     <?php endif;?>

             window['iuMapOptions'] = '<?php echo base64_encode( json_encode( $atts ) ); ?>';
         </script>

         <style>
             .profolio_widget_map {
                 position: absolute;
                 top: 0;
                 width: 100%;
                 max-height: 100%;
                 height: 100vh;
             <?php
			 if ($fields['top_block']){
				 echo "top: {$fields['top_block']}px;";
			 } else{
				 echo 'top: 0;';
			 }
			 ?>
             }

             @media (max-width: 589px) {
                 .profolio_widget_map {
                     position: relative;
                     height: 50vh;
                 }
             }

             .profolio_widget_map.bottom {
                 position: absolute !important;
                 top: auto;
                 bottom: 0;
             }

             .profolio_widget_map.fixed {
                 position: fixed !important;
                 top: 0;
             }

             .profolio_widget_map .gm-style .gm-style-iw-d {
                 padding-bottom: 15px;
             }
             #profolio_widget_map_<?php echo esc_attr( $salt ); ?> {
                 background-image: url("<?php echo INSTANTUP_URL; ?>data/assets/img/local-seo-map-logo.png") !important;
                 position: absolute;
                 top: 0;
                 right: 0;
                 z-index: 1000;
                 width: 81px;
                 height: 20px;
                 background-size: contain;
                 background-repeat: no-repeat;
                 margin: 10px;
             }

             #profolio_widget_map_<?php echo esc_attr( $salt ); ?> a {
                 display: block;
                 position: absolute;
                 width: 100%;
                 height: 100%;
             }

             <?php if ( $fields['iu_hide_map'] ): ?>
             .iu-content-map-box {
                 flex-basis: 75% !important;
                 max-width: 75%;
             }
             <?php endif; ?>
         </style>

         <script type="text/template" class="hidden" id="tmpl-profolio-infowindow-template">
             <div class="profolio-map-pop">
                 <div class="profolio-card-image-frame">
                     <a href="{{{data.link}}}" class="profolio-card-cover-sm">
                         {{{data.image}}}
                     </a>
                 </div>
                 <div class="profolio-card-descr">
                     <a href="{{{data.link}}}" class="profolio-header-xxs">{{{data.title}}}</a>

                     <div class="profolio-text-xs">
                         <i class="pro_fa pro_fa-map-marker-alt"></i>
                         {{{data.address}}}
                     </div>
                 </div>
             </div>
         </script>

         <div class="block block-map-bottom">
		     <?php if ( ! empty( $atts['locations'] ) ): ?>
			     <?php if ( $this->is_admin() ): ?>
                     <div class="block-map-loading" style="text-align:center;">
                         <img src="<?php echo INSTANTUP_URL; ?>data/assets/img/ajax-loader.gif" alt="loader">
                         <p style="font-size: 18px;margin-bottom: 0;">Map loading</p>
                     </div>
			     <?php endif; ?>

                 <div class="block__content profolio-map-wrapper">

                     <div id="iu_map_locations" class="profolio_widget_map JS_profolio_map"></div>

				     <?php if ( $this->is_admin() ): ?>
                         <template>
                             <p data-iuHideInfoWindow="<?php echo $fields['iu_hide_info_window'] ? : 0; ?>"
                                data-iuMapCenterLatLng="<?php echo json_encode( $atts['location'] ); ?>"
                                data-iuMapOptions="<?php echo base64_encode( json_encode( $atts ) ); ?>"></p>
                         </template>
				     <?php endif; ?>
                 </div>

		     <?php else: ?>
                 <p>Map is empty</p>
		     <?php endif; ?>
         </div>

	     <?php
     } );