<?php
/**
 * iu-social.php
 * create in 26.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

Block::make( __( 'IU Social' ) )
     ->add_fields( array(
	     Field::make( 'select', 'position_social', __( 'Position Social' ) )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'center' => 'center',
		          'right'  => 'right',
		          'space-between'  => 'Full width',
	          ) ),

	     Field::make( 'color', 'color_text', __( 'Color' ) )
	          ->set_default_value( '#ffffff' ),
	     Field::make( 'color', 'background_btn', __( 'Background Button' ) )
	          ->set_default_value( '#e1e1e6' ),

	     Field::make( 'text', 'border_radius', __( 'Border radius (%)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 50',
	          ) ),

	     Field::make( 'text', 'font_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) ),

	     Field::make( 'text', 'width_size', __( 'Width (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'height_size', __( 'Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'separator', 'separator_1', __( 'Hover effect' ) )
	          ->set_classes( 'iu-separator-margin' ),
	     Field::make( 'color', 'color_text_hover', __( 'Color' ) )
	          ->set_default_value( '#ffffff' ),
	     Field::make( 'color', 'background_btn_hover', __( 'Background Button' ) )
	          ->set_default_value( 'darkorange' ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields, $attributes, $inner_blocks ) { ?>
         <style>
             .block__content .profolio-details-social{
             <?php if ( $fields['position_social'] ): ?>
                 justify-content: <?php echo $fields['position_social']?>;
             <?php endif; ?>
             }

             .profolio-details-social li a{
             <?php if ( $fields['font_size'] ): ?>
                 font-size: <?php echo $fields['font_size']?>px;
             <?php endif; ?>
             <?php if ( $fields['width_size'] ): ?>
                 width: <?php echo $fields['width_size']?>px;
             <?php endif; ?>
             <?php if ( $fields['height_size'] ): ?>
                 height: <?php echo $fields['height_size']?>px;
             <?php endif; ?>
             <?php if ( $fields['color_text'] ): ?>
                 color: <?php echo $fields['color_text']?>;
             <?php endif; ?>
             <?php if ( $fields['border_radius'] === '0' || (int)$fields['border_radius'] > 0 ): ?>
                 border-radius: <?php echo $fields['border_radius']?>%;
             <?php endif; ?>
             <?php if ( $fields['background_btn'] ): ?>
                 background-color: <?php echo $fields['background_btn']?> !important;
             <?php endif; ?>
             }

             .profolio-details-social li a:hover{
             <?php if ( $fields['color_text_hover'] ): ?>
                 color: <?php echo $fields['color_text_hover']?>;
             <?php endif; ?>
             <?php if ( $fields['background_btn_hover'] ): ?>
                 background-color: <?php echo $fields['background_btn_hover']?> !important;
             <?php endif; ?>
             }
         </style>
         <div class="block">
             <div class="block__content">
			     <?php
			     $url = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ?: get_option('_temp_post_for_templates') ) ); ?>
                 <ul class="profolio-details-social">
                     <li>
                         <a href="#" class="iu-social"
                            data-share="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&amp;t=<?php the_title(); ?>">
                             <i class="pro_fab pro_fa-facebook-f"></i>
                         </a>
                     </li>
                     <li>
                         <a href="#" class="iu-social"
                            data-share="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_attr( $url ); ?>">
                             <i class="pro_fab pro_fa-pinterest-p"></i>
                         </a>
                     </li>
                     <li>
                         <a href="#" class="iu-social"
                            data-share="http://twitter.com/home/?status=<?php the_title(); ?> - <?php the_permalink(); ?>">
                             <i class="pro_fab pro_fa-twitter"></i>
                         </a>
                     </li>
                 </ul>

             </div>
         </div>
	     <?php
     } );