<?php
/**
 * iu-testimonial.php
 * create in 26.04.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;


Block::make( __( 'IU Testimonial' ) )
     ->add_tab( __( 'Settings' ), array(
	     Field::make( 'select', 'select_fonts', __( 'Font Family' ) )
	          ->set_classes( 'select_font_block iu-blocks-margin_right' )
	          ->set_default_value( 'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' )
	          ->set_options( array(
		          'Open Sans:300,300italic,regular,italic,600,600italic,700,700italic,800,800italic' => 'Open Sans',
	          ) )
	          ->add_options( $this->get_list_fonts() )
	          ->set_width( 45 ),

	     Field::make( 'select', 'select_style', __( 'Choose Style' ) )
	          ->set_default_value( 'default' )
	          ->set_options( array(
		          'default' => 'Default',
		          'modern'  => 'Modern',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'color', 'bgc_block', __( 'Background For Block' ) ),

	     Field::make( 'text', 'border_radius', __( 'Border radius (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'padding_block', __( 'Padding (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),

     ) )
     ->add_tab( __( 'Main Title' ), array(
	     Field::make( 'checkbox', 'iu_hidden_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Title' ) ),
	     Field::make( 'checkbox', 'iu_hide_colon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Colon' ) )
	          ->set_option_value( 'yes' ),
	     Field::make( 'checkbox', 'iu_hide_icon', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Icon' ) )
	          ->set_option_value( 'yes' ),
	     Field::make( 'checkbox', 'iu_underline_title', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_help_text( __( 'Hide Underline' ) )
	          ->set_option_value( 'yes' ),

	     Field::make( 'color', 'title_main_color', __( 'Color Title' ) )
	          ->set_default_value( '#2c2c2c' ),


	     Field::make( 'text', 'title_main_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 11',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'select', 'title_main_weight', __( 'Font Weight' ) )
	          ->set_options( array(
		          'normal' => __( 'Normal' ),
	          ) )
	          ->add_options( array(
		          '300'    => __( 'light' ),
		          'normal' => __( 'Normal' ),
		          'bold'   => __( 'Bold' ),
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'select', 'iu_title_style_letters', __( 'Choose Style Letter' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_default_value( 'uppercase' )
	          ->set_options( array(
		          'none'      => 'Default',
		          'uppercase' => 'Uppercase',
		          'lowercase' => 'Lowercase',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'title_main_lheight', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 17',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'title_main_mt', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'title_main_mb', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 7',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Title For Description' ), array(
	     Field::make( 'checkbox', 'iu_hide_title_name', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Title' ) ),

	     Field::make( 'color', 'title_color', __( 'Color Title' ) )
	          ->set_default_value( '#2c2c2c' ),

	     Field::make( 'text', 'title_size', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'title_lheight', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 18',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'title_mt', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'title_mb', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 7',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Description' ), array(
	     Field::make( 'checkbox', 'iu_hide_desc', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Description' ) ),

	     Field::make( 'color', 'color_desc', __( 'Color Description' ) )
	          ->set_default_value( '#212529' ),

	     Field::make( 'text', 'font_size_desc', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 16',
	          ) ),
	     Field::make( 'select', 'position_desc', __( 'Position Description' ) )
	          ->set_width( 45 )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'center' => 'center',
		          'right'  => 'right',
	          ) ),

	     Field::make( 'text', 'margin_top_desc', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_desc', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Rating' ), array(
	     Field::make( 'checkbox', 'iu_hide_rating', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Rating' ) ),

	     Field::make( 'color', 'color_rating', __( 'Color Rating' ) )
	          ->set_default_value( '#ff8c00' ),

	     Field::make( 'text', 'font_size_rating', __( 'Font Size (px)' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 13',
	          ) ),
	     Field::make( 'select', 'position_rating', __( 'Position Rating' ) )
	          ->set_width( 45 )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'left'   => 'Left',
		          'center' => 'center',
		          'right'  => 'right',
	          ) ),

	     Field::make( 'text', 'margin_top_rating', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'margin_bottom_rating', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Author Photo' ), array(
	     Field::make( 'checkbox', 'iu_hide_author_img', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Photo' ) ),

	     Field::make( 'select', 'position_picture', __( 'Position Picture' ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_options( array(
		          'left' => 'Left',
	          ) )
	          ->add_options( array(
		          'left'   => 'Left',
		          'center' => 'Center',
		          'right'  => 'Right',
	          ) )
	          ->set_width( 45 ),
	     Field::make( 'text', 'border_radius_pic', __( 'Border radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'width_size', __( 'Width (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 60',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'height_size', __( 'Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 100',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_top_author_img', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom_author_img', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),

     ) )
     ->add_tab( __( 'Author Name' ), array(
	     Field::make( 'checkbox', 'iu_hide_author_name', '' )
	          ->set_classes( 'iu-toggle-checked iu_block_checkbox' )
	          ->set_default_value( false )
	          ->set_option_value( 'yes' )
	          ->set_help_text( __( 'Hide Author Name' ) ),

	     Field::make( 'select', 'position_name', __( 'Position Name' ) )
	          ->set_default_value( 'bottom' )
	          ->set_options( array(
		          'top'    => 'Top',
		          'bottom' => 'Bottom',
	          ) ),

	     Field::make( 'color', 'color_author', __( 'Color' ) )
	          ->set_default_value( '#212529' ),

	     Field::make( 'text', 'font_size_author', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 15',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_author', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 23',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_top_author', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 40',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom_author', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_width( 45 ),
     ) )
     ->add_tab( __( 'Video' ), array(
	     Field::make( 'select', 'position_btn_video', __( 'Position Button' ) )
	          ->set_options( array(
		          'left' => __( 'Left' ),
	          ) )
	          ->add_options( array(
		          'center' => __( 'center' ),
		          'right'  => __( 'right' ),
	          ) ),

	     Field::make( 'text', 'btn_txt_video', __( 'Text' ) )
	          ->set_default_value( 'Watch Video' ),

	     Field::make( 'color', 'color_text_video', __( 'Color' ) )
	          ->set_default_value( '#fafaff' ),
	     Field::make( 'color', 'background_btn_video', __( 'Background Button' ) )
	          ->set_default_value( '#007bff' ),

	     Field::make( 'text', 'font_size_video', __( 'Font Size (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 12',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),
	     Field::make( 'text', 'line_height_video', __( 'Line Height (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 25',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'height_video', __( 'Block Height' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default auto',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'border_radius_video', __( 'Border radius' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 3',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_top_video', __( 'Margin Top (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 0',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right' )
	          ->set_width( 45 ),

	     Field::make( 'text', 'margin_bottom_video', __( 'Margin Bottom (px)' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => 'default 30',
	          ) )
	          ->set_width( 45 ),

	     Field::make( 'text', 'padding_top_video', __( 'Top' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '7',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right_4' )
	          ->set_width( 23 ),
	     Field::make( 'text', 'padding_bottom_video', __( 'Bottom' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '7',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right_4' )
	          ->set_width( 23 ),
	     Field::make( 'text', 'padding_left_video', __( 'Left' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '15',
	          ) )
	          ->set_classes( 'iu-blocks-margin_right_4' )
	          ->set_width( 23 ),
	     Field::make( 'text', 'padding_right_video', __( 'Right' ) )
	          ->set_attributes( array(
		          'type'        => 'number',
		          'placeholder' => '15',
	          ) )
	          ->set_width( 23 ),
     ) )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'description...' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $post_id       = get_the_ID() ? : get_option( '_temp_post_for_templates' );
	     $related_from  = get_post_meta( $post_id, $this->prefix() . 'relatedFrom', true );
	     $get_font      = isset( $fields['select_fonts'] ) ? explode( ':', $fields['select_fonts'] ) : false;
	     $heat_title    = get_post_meta( $post_id, $this->prefix() . 'testimonial_title', true );
	     $head_cname    = get_post_meta( $post_id, $this->prefix() . 'testimonial_customerName', true );
	     $head_ctitle   = get_post_meta( $post_id, $this->prefix() . 'testimonial_customerTitle', true );
	     $heat_rating   = get_post_meta( $post_id, $this->prefix() . 'testimonial_rating', true );
	     $head_des      = get_post_meta( $post_id, $this->prefix() . 'testimonial_des', true );
	     $head_media    = get_post_meta( $post_id, $this->prefix() . 'testimonial_media', true );
	     $head_video_id = $head_media['video'] ?? '';
	     $head_cover_id = $head_media['cover'] ?? '';
	     $cname_block   = '';

	     if ( $related_from ) {
		     $related_query = new WP_Query( array(
			     'post_type'  => get_option( '_iu_custom_type_slug' ),
			     'fields'     => 'ids',
			     'meta_query' => array(
				     array(
					     'key'     => $this->prefix() . 'uid',
					     'compare' => 'IN',
					     'value'   => $related_from,
				     ),
			     ),
		     ) );
		     wp_reset_query();
	     }

	     ?>
	     <style>
		     <?php
			 if ($get_font){
				 echo 'body .iu-testimonial-block .iu-testimonial-title,
				  body .iu-testimonial-block .iu-testimonial-subtitle,
				  body .iu-testimonial-block .iu-testimonial-desc,
				  body .iu-testimonial-block .iu-testimonial-customer-name {';
				 echo "font-family: '{$get_font[0]}', Sans-serif !important;";
				 echo '}';
			 }


			 echo '.iu-testimonial-block .iu-testimonial-title {';
			 if ($fields['title_main_size']){
					 echo "font-size: {$fields['title_main_size']}px;";
				 }
			 if ($fields['title_main_weight']){
					 echo "font-weight: {$fields['title_main_weight']};";
				 }
			 if ($fields['title_main_lheight']){
					 echo "line-height: {$fields['title_main_lheight']}px;";
				 }
			 if ($fields['title_main_color']){
					 echo "color: {$fields['title_main_color']};";
				 }
			 if ($fields['title_main_mt']){
					 echo "margin-top: {$fields['title_main_mt']}px;";
				 }
			 if ($fields['title_main_mb']){
					 echo "margin-bottom: {$fields['title_main_mb']}px;";
				 }
			 if ($fields['iu_title_style_letters']){
				 echo "text-transform: {$fields['iu_title_style_letters']};";
			 }
			 echo '}';

			 echo '.iu-testimonial-block .profolio-reviewer-photo {';
			 if ($fields['width_size']){
					 echo "width: {$fields['width_size']}px;";
				 }
			 if ($fields['height_size']){
					 echo "height: {$fields['height_size']}px;";
				 }
			 if ($fields['border_radius_pic']){
					 echo "border-radius: {$fields['border_radius_pic']}px;";
			 }
			 if ($fields['position_picture'] === 'left' ){
					 echo 'margin-right: auto;';
			 }
			 if ($fields['position_picture'] === 'center' ){
					 echo 'margin-left: auto;';
					 echo 'margin-right: auto;';
			 }
			 if ($fields['position_picture'] === 'right' ){
					 echo 'margin-left: auto;';
			 }
			 if ($fields['margin_top_author_img']){
					 echo "margin-top: {$fields['margin_top_author_img']}px;";
			 }
			 if ($fields['margin_bottom_author_img']){
					 echo "margin-bottom: {$fields['margin_bottom_author_img']}px;";
			 }

			 echo '}';

			 echo '.profolio-reviewer-photo .iu-testimonial-author-img {';
			 echo "border-radius: {$fields['border_radius_pic']}px;";
			 echo '}';

			 echo '.iu-testimonial-block .iu-testimonial-customer-name,
				  .iu-testimonial-block .iu-testimonial-separator,
				  .iu-testimonial-block .iu-testimonial-customer-title {';
			 if ( $fields['font_size_author'] ){
					 echo "font-size: {$fields['font_size_author']}px !important;";
				 }
			 if ( $fields['line_height_author'] ){
					 echo "line-height: {$fields['line_height_author']}px !important;";
				 }
			 if ( $fields['color_author'] ){
					 echo "color: {$fields['color_author']} !important;";
				 }
			 if ( $fields['margin_top_author'] === '0' || (int)$fields['margin_top_author'] > 0 ){
					 echo "margin-top: {$fields['margin_top_author']}px !important;";
				 }
			 if ( $fields['margin_bottom_author'] ){
					 echo "margin-bottom: {$fields['margin_bottom_author']}px !important;";
				 }
			 echo '}';

			 echo '.iu-testimonial-block .iu-testimonial-subtitle {';
			 if ($fields['title_size']){
					 echo "font-size: {$fields['title_size']}px !important;";
				 }
			 if ($fields['title_lheight']){
					 echo "line-height: {$fields['title_lheight']}px !important;";
				 }
			 if ($fields['title_color']){
					 echo "color: {$fields['title_color']} !important;";
				 }
			 if ($fields['title_mt'] === '0' || (int)$fields['title_mt'] > 0){
					 echo "margin-top: {$fields['title_mt']}px !important;";
				 }
			 if ($fields['title_mb'] === '0' || (int)$fields['title_mb'] > 0){
					 echo "margin-bottom: {$fields['title_mb']}px !important;";
				 }
			 echo '}';

			 echo '.iu-testimonial-block .profolio-card-rating {';
			 if ($fields['position_rating']){
					 echo "text-align: {$fields['position_rating']};";
				 }
			 if ($fields['margin_top_rating']){
					 echo "margin-top: {$fields['margin_top_rating']}px !important;";
				 }
			 if ($fields['margin_bottom_rating']){
					 echo "margin-bottom: {$fields['margin_bottom_rating']}px !important;";
				 }
			 echo '}';

			 echo '.block__content .profolio-card-rating li {';
			 if ($fields['font_size_rating']){
					 echo "font-size: {$fields['font_size_rating']}px;";
				 }
			 if ($fields['color_rating']){
					 echo "color: {$fields['color_rating']};";
				 }
			 echo '}';

			 echo '.iu-testimonial-block .iu-testimonial-desc {';
			 if ($fields['font_size_desc']){
					 echo "font-size: {$fields['font_size_desc']}px;";
				 }
			 if ($fields['color_desc']){
					 echo "color: {$fields['color_desc']};";
				 }
			 if ($fields['position_desc']){
					 echo "text-align: {$fields['position_desc']};";
				 }
			 if ($fields['margin_top_desc'] === '0' || (int)$fields['margin_top_desc'] > 0){
					 echo "margin-top: {$fields['margin_top_desc']}px !important;";
				 }
			 if ($fields['margin_bottom_desc'] === '0' || (int)$fields['margin_bottom_desc'] > 0){
					 echo "margin-bottom: {$fields['margin_bottom_desc']}px !important;";
				 }
			 echo '}';


			 #video
			 echo '.profolio-default-button {';
			 if ( $fields['font_size_video'] ):
				echo "font-size: {$fields['font_size_video']}px !important;";
			 endif;

			 if ( $fields['line_height_video'] ):
			 echo "line-height: {$fields['line_height_video']}px !important;";
			 endif;

			 if ( $fields['color_text_video'] ):
			 echo "color: {$fields['color_text_video']} !important;";
			 endif;

			 if ( $fields['margin_top_video'] ):
			 echo "margin-top: {$fields['margin_top_video']}px !important;";
			 endif;

			 if ( $fields['margin_bottom_video'] === '0' || (int)$fields['margin_bottom_video'] > 0  ):
			 echo "margin-bottom: {$fields['margin_bottom_video']}px !important;";
			 endif;

			 if ( $fields['padding_top_video'] === '0' || (int)$fields['padding_top_video'] > 0 ):
			 echo "padding-top: {$fields['padding_top_video']}px !important;";
			 endif;

			 if ( $fields['padding_bottom_video'] === '0' || (int)$fields['padding_bottom_video'] > 0 ):
			 echo "padding-bottom: {$fields['padding_bottom_video']}px !important;";
			 endif;

			 if ( $fields['padding_left_video'] === '0' || (int)$fields['padding_left_video'] > 0 ):
			 echo "padding-left: {$fields['padding_left_video']}px !important;";
			 endif;

			 if ( $fields['padding_right_video'] === '0' || (int)$fields['padding_right_video'] > 0 ):
			 echo "padding-right: {$fields['padding_right_video']}px !important;";
			 endif;

			 if ( $fields['border_radius_video'] === '0' || (int)$fields['border_radius_video'] > 0 ):
			 echo "border-radius: {$fields['border_radius_video']}px !important;";
			 endif;

			 if ( $fields['background_btn_video'] ):
				echo "background-color: {$fields['background_btn_video']} !important;";
			 endif;
			 echo '}';


			 echo '.iu-video-gallery {';
				if ( isset($fields['position_button_video']) ):
					echo "text-align: {$fields['position_button_video']};";
				endif;
			 echo '}';

			 echo '.iu-video-gallery .profolio-video-preview {';
				if ( $this->is_admin() ) :
					echo 'width: 100%;';
					echo 'margin-bottom: 0;';
				endif;

				if ($fields['height_video']):
					echo "height: {$fields['height_video']}px;";
				endif;
				if ( $fields['select_style'] === 'modern' && $fields['border_radius'] ):
					echo "border-top-right-radius: {$fields['border_radius']}px;";
					echo "border-bottom-right-radius: {$fields['border_radius']}px;";
				endif;
			 echo '}';

			 if ( $this->is_admin() ) :
				echo '.iu-video-gallery .profolio-video-preview img{';
				if ( $fields['select_style'] === 'modern' && $fields['border_radius'] ):
					echo "border-top-right-radius: {$fields['border_radius']}px;";
					echo "border-bottom-right-radius: {$fields['border_radius']}px;";
				endif;
				echo '}';
			 endif;

			 echo '.iu-testimonial-block .iu-testimonial-item {';
			 if ($fields['bgc_block']):
				 echo "background-color: {$fields['bgc_block']};";
			 endif;
			 if ($fields['border_radius']):
				 echo "border-radius: {$fields['border_radius']}px;";
			 endif;
			 if ($fields['padding_block'] === '0' || $fields['padding_block']):
				 echo "padding: {$fields['padding_block']}px !important;";
			 endif;
			 if ( $fields['select_style'] === 'modern' ):
				 echo 'display: flex;';
				 echo 'align-items: center;';
			 endif;
			 echo '}';

			 if ( $fields['select_style'] === 'modern' ):
				echo '.iu-testimonial-block .iu-testimonial-item .profolio-col-6:last-child {';
				echo 'padding-right:0;';
				echo '}';
			 endif;


			 ?>
	     </style>

	     <div class="block iu-testimonial-block">
		     <?php if ( $heat_title || $head_cname || $head_des || $heat_rating || isset($related_query->posts) ) { ?>
			     <div class="block__content mb30">
				     <!-- Start Block Name -->
				     <?php if ( ! $fields['iu_hidden_title'] ) : ?>
					     <div class="iu-testimonial-title profolio-text-sm">
						     <?php if ( ! $fields['iu_hide_icon'] ) : ?>
							     <i class="pro_fa pro_fa-list"></i>
						     <?php endif; ?>
						     <?php echo $fields['iu_hide_colon'] ? esc_html__( 'Testimonial',
							     'instantup' ) : esc_html__( 'Testimonial:', 'instantup' ); ?>
					     </div>
				     <?php endif;
				     if ( ! $fields['iu_underline_title'] ) : ?>
					     <hr>
				     <?php endif; ?>
				     <!-- End Block Name -->

				     <?php if ( $head_cname || $head_ctitle ):
					     $cname_block = '<div class="iu-testimonial-author-row">';
					     if ( ! empty( $head_cname ) && ! $fields['iu_hide_author_name'] ) :
						     $cname_block .= '<div class="iu-testimonial-customer-name profolio-elm-title profolio-reviewer-author">';
						     $cname_block .= esc_html( $head_cname );
						     $cname_block .= '</div>';
					     endif;

					     if ( ! empty( $head_cname ) && ! empty( $head_ctitle ) && ! $fields['iu_hide_author_name'] ) :
						     $cname_block .= '<span class="iu-testimonial-separator"> - </span>';
					     endif;

					     if ( ! empty( $head_ctitle ) && ! $fields['iu_hide_author_name'] ) :
						     $cname_block .= '<div class="iu-testimonial-customer-title profolio-elm-title profolio-reviewer-author">';
						     $cname_block .= esc_html( $head_ctitle );
						     $cname_block .= '</div>';
					     endif;
					     $cname_block .= '</div>';
				     endif; ?>


				     <!-- Start Head Testimonial -->
				     <?php if ( $heat_title || $head_cname || $head_des || $heat_rating ): ?>
					     <div class="iu-testimonial-item first">
						     <?php if ( $fields['select_style'] === 'modern' ):
							     echo '<div class="profolio-col-6">';
						     endif; ?>

						     <?php if ( ! empty( $heat_rating ) && ! $fields['iu_hide_rating'] ) { ?>
							     <ul class="iu-testimonial-rating profolio-card-rating">
								     <?php
								     echo $this->get_schema_rating( $post_id );

								     for ( $i = 1; $i <= 5; $i ++ ) {
									     if ( $heat_rating >= 1 ) { ?>
										     <li><i class="pro_fa pro_fa-star"></i></li>
										     <?php $heat_rating --;
									     } else { ?>
										     <li><i class="pro_far pro_fa-star"></i></li>
									     <?php }
								     } ?>
							     </ul>
						     <?php } ?>

						     <?php if ( ! empty( $heat_title ) && ! $fields['iu_hide_title_name'] ) { ?>
							     <h2 class="iu-testimonial-subtitle"><?php echo esc_html( $heat_title ); ?></h2>
						     <?php } ?>

						     <?php if ( ! empty( $head_des ) && ! $fields['iu_hide_desc'] ) : ?>
							     <p class="iu-testimonial-desc"><?php echo esc_html( $head_des ); ?></p>
						     <?php endif; ?>


						     <?php if ( $fields['position_name'] === 'top' ) :
							     echo $cname_block;
						     endif; ?>

						     <?php if ( ! $fields['iu_hide_author_img'] && isset( $head_media['customerPhoto'] ) &&
						                $customer_photo = wp_get_attachment_image_url( $head_media['customerPhoto'] ) ) : ?>
							     <div class="profolio-reviewer-photo">
								     <img src="<?php echo $customer_photo; ?>"
								          alt="author" class="iu-testimonial-author-img">
							     </div>
						     <?php endif; ?>

						     <?php if ( $fields['position_name'] === 'bottom' ) :
							     echo $cname_block;
						     endif; ?>

						     <?php if ( $fields['select_style'] === 'modern' ):
							     echo '</div>';
						     endif; ?>


						     <?php if ( $fields['select_style'] === 'modern' ):
							     echo '<div class="profolio-col-6">';
						     endif; ?>
						     <?php if ( ! empty( $head_video_id ) ):
							     if ( empty( $head_cover_id ) ) {
								     $head_cover_id = (int) get_post_meta( $head_video_id, 'iu-thumb', true );
							     } ?>
							     <div style="display:none;" id="testimonial_video_head">
								     <video class="lg-video-object lg-html5" controls preload="none">
									     <?php if ( get_the_ID() && ! empty( $head_video_id ) ): ?>
										     <source src="<?php echo wp_get_attachment_url( $head_video_id ); ?>" type="video/mp4">
									     <?php endif; ?>
								     </video>
							     </div>

							     <div class="iu-video-gallery video-gallery">
								     <?php if ( ! empty( $head_cover_id ) ): ?>
									     <div class="profolio-video-preview s-back-switch"
									          data-html="#testimonial_video_head"
									          data-sub-html="<?php echo implode( ' ', str_split( $heat_title ) ); ?>">
										     <?php echo wp_get_attachment_image( $head_cover_id, 'large', '',
											     array( 'class' => 'profolio-bg-img' ) ); ?>
										     <i class="pro_far pro_fa-play-circle"></i>
									     </div>
								     <?php else: ?>
									     <div data-html="#testimonial_video_head"
									          data-sub-html="<?php echo implode( ' ', str_split( $heat_title ) ); ?>"
									          class="iu-video-button profolio-default-button mb30">
										     <i class="pro_fab pro_fa-youtube"></i>
										     <span><?php echo $fields['btn_txt_video'] ?? 'Watch Video'; ?></span>
									     </div>
								     <?php endif; ?>
							     </div>
						     <?php endif; ?>

						     <?php if ( $fields['select_style'] === 'modern' ):
							     echo '</div>';
						     endif; ?>

					     </div>
				     <?php endif; ?>
				     <!-- ENd Head Testimonial -->


				     <!-- Start Related testimonials -->
				     <?php if ( $related_query->posts ) {
					     foreach ( $related_query->posts as $key => $post ) :
						     $title = get_post_meta( $post, $this->prefix() . 'testimonial_title', true );
						     $c_name = get_post_meta( $post, $this->prefix() . 'testimonial_customerName', true );
						     $c_title = get_post_meta( $post, $this->prefix() . 'testimonial_customerTitle',
							     true ) ? : get_the_title( $post );
						     $rating = get_post_meta( $post, $this->prefix() . 'testimonial_rating', true );
						     $description = get_post_meta( $post, $this->prefix() . 'testimonial_des', true );
						     $media = get_post_meta( $post, $this->prefix() . 'testimonial_media', true );
						     $video_id = $media['video'] ?? '';
						     $cover_id = $media['cover'] ?? ''; ?>

						     <div class="iu-testimonial-item related">
							     <?php if ( ! empty( $rating ) ) { ?>
								     <ul class="iu-testimonial-rating profolio-card-rating">
									     <?php
									     echo $this->get_schema_rating( $post_id );

									     for ( $i = 1; $i <= 5; $i ++ ) {
										     if ( $rating >= 1 ) { ?>
											     <li><i class="pro_fa pro_fa-star"></i></li>
											     <?php $rating --;
										     } else { ?>
											     <li><i class="pro_far pro_fa-star"></i></li>
										     <?php }
									     } ?>
								     </ul>
							     <?php } ?>

							     <?php if ( ! empty( $c_title ) ) { ?>
								     <h2 class="iu-testimonial-subtitle"><?php echo esc_html( $c_title ); ?></h2>
							     <?php } ?>

							     <?php if ( ! empty( $description ) ) : ?>
								     <p class="iu-testimonial-desc"><?php echo esc_html( $description ); ?></p>
							     <?php endif; ?>

							     <?php if ( isset( $media['customerPhoto'] ) &&
							                $customer_photo = wp_get_attachment_image_url( $media['customerPhoto'] ) ) : ?>
								     <div class="profolio-reviewer-photo">
									     <img src="<?php echo $customer_photo; ?>"
									          alt="author" class="iu-testimonial-author-img">
								     </div>
							     <?php endif; ?>

							     <div class="iu-testimonial-author-row">
								     <?php if ( ! empty( $c_name ) ) : ?>
									     <div class="iu-testimonial-customer-name profolio-elm-title profolio-reviewer-author">
										     <?php echo esc_html( $c_name ); ?>
									     </div>
								     <?php endif; ?>

								     <?php if ( ! empty( $c_name ) && ! empty( $c_title ) ) : ?>
									     <span class="iu-testimonial-separator"> - </span>
								     <?php endif; ?>

								     <?php if ( ! empty( $c_title ) ) : ?>
									     <div class="iu-testimonial-customer-title profolio-elm-title profolio-reviewer-author">
										     <?php echo esc_html( $c_title ); ?>
									     </div>
								     <?php endif; ?>
							     </div>

							     <?php if ( ! empty( $video_id ) ):
								     if ( empty( $cover_id ) ) {
									     $cover_id = (int) get_post_meta( $video_id, 'iu-thumb', true );
								     } ?>
								     <div style="display:none;" id="testimonial_video_<?php echo $key; ?>">
									     <video class="lg-video-object lg-html5" controls preload="none">
										     <?php if ( get_the_ID() && ! empty( $video_id ) ): ?>
											     <source src="<?php echo wp_get_attachment_url( $video_id ); ?>" type="video/mp4">
										     <?php endif; ?>
									     </video>
								     </div>

								     <div class="iu-video-gallery video-gallery">
									     <?php if ( ! empty( $cover_id ) ): ?>
										     <div class="profolio-video-preview s-back-switch"
										          data-html="#testimonial_video_<?php echo $key; ?>"
										          data-sub-html="<?php echo implode( ' ', str_split( $title ) ); ?>">
											     <?php echo wp_get_attachment_image( $cover_id, 'large', '',
												     array( 'class' => 'profolio-bg-img' ) ); ?>
											     <i class="pro_far pro_fa-play-circle"></i>
										     </div>
									     <?php else: ?>
										     <div data-html="#testimonial_video_<?php echo $key; ?>"
										          data-sub-html="<?php echo implode( ' ', str_split( $title ) ); ?>"
										          class="iu-video-button profolio-default-button mb30">
											     <i class="pro_fab pro_fa-youtube"></i>
											     <span><?php echo $fields['btn_txt_video'] ?? 'Watch Video'; ?></span>
										     </div>
									     <?php endif; ?>
								     </div>
							     <?php endif; ?>

						     </div>
					     <?php endforeach;
				     } ?>

			     </div>
		     <?php } ?>
	     </div>
	     <?php
     } );