<?php
/**
 * slider.php
 * create in 27.07.2021
 * SAYri
 *
 */

use Carbon_Fields\Block;
use Carbon_Fields\Field;
use InstantUploader\Admin;

Block::make( __( 'IU Realestation One Slider' ) )
     ->add_fields( array() )
     ->set_mode( 'preview' )
     ->set_category( $this->set_cat_slug(), $this->set_cat_name(), $this->set_cat_icon() )
     ->set_description( __( 'Slider tempplate for realestation one' ) )
     ->set_icon( 'block-default' )
     ->set_render_callback( function ( $fields ) {
	     $entropy      = uniqid();
	     $post_id      = get_the_ID() ? : get_option( '_temp_post_for_templates' );
	     $pic_for_post = get_post_meta( $post_id, $this->prefix() . 'pic_for_post', true );
	     $pic_count    = count( $pic_for_post );

	     if ( $pic_for_post ) : ?>
             <div class="block">
                 <div class="block__content iu-realestate-one">
				     <?php
					     $file_cover     = INSTANTUP_URL . 'data/assets/img/video_cover.png';
					     $thumb_html     = '';
					     $view_pics_html = '';
					     $count          = 0;
					     $media_list     = array();


					     foreach ( $pic_for_post as $index => $pic ) {
						     $id_pic     = $pic['id'] ?? $pic;
						     $post_img   = get_post( $id_pic, ARRAY_A );
						     $alt_text   = get_post_meta( $id_pic, '_wp_attachment_image_alt', true ) ? : $post_img['post_title'];
						     $this_img   = wp_get_attachment_image_url( $id_pic, 'large' ) ? : $file_cover;
						     $thumb_html .= "<div class='swiper-slide'><img src='{$this_img}' alt=''/></div>";

						     $view_pics_html .= "<div data-id='{$count}' class='swiper-slide profolio-slctr'>
                            <img src='{$this_img}' alt='{$alt_text}'></div>";

						     $media_list[] = array(
							     'src'   => wp_get_attachment_image_url( $id_pic, 'full' ),
							     'thumb' => wp_get_attachment_image_url( $id_pic ),
						     );

						     if ( $fields['iu_show_img_title'] && $post_img['post_title'] ) {
							     $media_list[ $index ]['subHtml'] .= "<p class='iu-carousel-title2'>{$post_img['post_title']}</p>";

						     }
						     if ( $fields['iu_show_img_caption'] && $post_img['post_excerpt'] ) {
							     $media_list[ $index ]['subHtml'] .= "<p class='iu-carousel-info'>{$post_img['post_excerpt']}</p>";

						     }
						     if ( $fields['iu_show_img_desc'] && $post_img['post_content'] ) {
							     $media_list[ $index ]['subHtml'] .= "<p class='iu-carousel-info'>{$post_img['post_content']}</p>";

						     }

						     $count ++;
					     }
					     ?>
                         <div class="profolio-container">

                             <div class="profolio-row iu-realestate-slider-row">
                                 <div class="swiper-container realestateSlider2" data-media-ogj="iu_r_carousel_<?php echo $entropy ?>">
                                     <div class="swiper-wrapper iu_use_lightGallery"><?php echo $view_pics_html ?></div>

								     <?php if ( $pic_count > 1 ): ?>
                                         <div class="swiper-button-next realestate-one-btn-next"></div>
                                         <div class="swiper-button-prev realestate-one-btn-prev"></div>
								     <?php endif; ?>
                                 </div>

							     <?php if ( $pic_count > 1 ): ?>
                                     <div thumbsSlider="" class="swiper-container realestateSlider">
                                         <div class="swiper-wrapper">
										     <?php echo $thumb_html ?>
                                         </div>
                                     </div>
							     <?php endif; ?>
                             </div>
                         </div>

                 </div>
             </div>

		     <?php if ( $media_list ) {
			     wp_localize_script(
				     'iu-main-script',
				     "iu_r_carousel_{$entropy}",
				     array( 'media_list' => json_encode( $media_list ) )
			     );
		     }

	     endif;
     } );