<?php

namespace InstantUploader;


if ( ! defined( 'WPINC' ) ) {
	die;
}

class filters_for_media {

	public function __construct() { }

	public function init() {
		add_action( 'restrict_manage_posts', array( $this, 'add_filter_for_media' ) );
		add_action( 'pre_get_posts', array( $this, 'add_event_table_filters_handler' ) );
		//add_filter( 'ajax_query_attachments_args', array( $this, 'filter_function_name_TEST' ) );
	}


	public function add_filter_for_media( $post_type ) {
		if ( $post_type !== 'attachment' ) {
			return;
		}

		echo '
	<select name="iu_media">
		<option value="-1">All media</option>
		<option value="with_iu" ' . selected( 'with_iu', $_GET['iu_media'], 0 ) . '>IU Media</option>
		<option value="without_iu"' . selected( 'without_iu', $_GET['iu_media'], 0 ) . '>Media</option>
	</select>
	<a href="/wp-admin/upload.php" class="button">Clear</a>
	';
	}

	public function add_event_table_filters_handler( $query ) {
		$cs = function_exists( 'get_current_screen' ) ? get_current_screen() : null;

		if ( $cs && $cs->post_type !== 'attachment' ) {
			return;
		}


		if ( isset($_GET['iu_media']) && $_GET['iu_media'] === 'with_iu' ) {
			$query->set( 'meta_query', array(
					array(
						'key'         => 'uid',
						'compare_key' => '=',
					),
				)
			);
		}

		if ( isset($_GET['iu_media']) && $_GET['iu_media'] === 'without_iu' ) {
			$query->set( 'meta_query', array(
					array(
						'key'         => 'uid',
						'compare_key' => '!=',
					),
				)
			);
		}

	}

	public function filter_function_name_TEST( $query ) {

		if ( isset( $_POST['query']['iu_filter']['iu_media'] ) && ! empty( $_POST['query']['iu_filter']['iu_media'] ) ) {
			$iu_media = $_POST['query']['iu_filter']['iu_media'];

			if ( $iu_media === 'with_iu' ) {
				$query['meta_query'] = array(
					array(
						'key'         => 'uid',
						'compare_key' => '=',
					),
				);
			}

			if ( $iu_media === 'without_iu' ) {
				$query['meta_query'] = array(
					array(
						'key'         => 'uid',
						'compare_key' => '!=',
					),
				);
			}

			return $query;
			//$admin = new Admin();
			//$admin->write_log( $_POST['query']['iu_filter'] );
		}

		return $query;
	}


}